<?php
/**
 * Template for displaying user groups
 *
 * Zoph is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Zoph is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with Zoph; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @author Jeroen Roos
 * @package ZophTemplates
 */
if (!defined("ZOPH")) {
    die("Illegal call");
}
?>
<h1>
    <?= $this->getActionlinks($tpl_actionlinks) ?>
    <?= $tpl_title ?>
</h1>
<div class="main">
    <dl class="groups">
        <?php foreach ($tpl_groups as $group): ?>
            <dt><?= $group->getName() ?></dt>
            <dd>
                <?= $group->get("description") ?><br>
                <?= implode("&nbsp;", $group->getMemberLinks()) ?>
            </dd>
            <ul class="actionlink">
              <li><a href="group.php?group_id=<?= $group->getId() ?>">
                <?php echo translate("display") ?>
              </a></li>
            </ul>
        <?php endforeach; ?>
    </dl>
    <br>
</div>
