// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UADDW_4S_TRACE_AARCH64_H_
#define VIXL_SIM_UADDW_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_uaddw_4S[] = {
  0x00007e7e, 0x00007f7f, 0x00803033, 0x00005555,
  0x00007e7f, 0x0000b233, 0x00805255, 0x00007ffd,
  0x0000b133, 0x0000d455, 0x00807cfd, 0x00007ffe,
  0x0000d355, 0x0000fefd, 0x00807cfe, 0x00007fff,
  0x0000fdfd, 0x0000fefe, 0x00807cff, 0x00000000,
  0x0000fdfe, 0x0000feff, 0x007ffd00, 0x00000001,
  0x0000fdff, 0x00007f00, 0x007ffd01, 0x00000002,
  0x00007e00, 0x00007f01, 0x007ffd02, 0x00000010,
  0x00007e01, 0x00007f02, 0x007ffd10, 0x0000007d,
  0x00007e02, 0x00007f10, 0x007ffd7d, 0x0000007e,
  0x00007e10, 0x00007f7d, 0x007ffd7e, 0x0000007f,
  0x00007e7d, 0x00007f7e, 0x007ffd7f, 0x00003333,
  0x00007e7e, 0x00007f7f, 0x00803033, 0x00005555,
  0x00007e7f, 0x0000b233, 0x00805255, 0x00007ffd,
  0x0000b133, 0x0000d455, 0x00807cfd, 0x00007ffe,
  0x0000d355, 0x0000fefd, 0x00807cfe, 0x00007fff,
  0x0000fdfd, 0x0000fefe, 0x00807cff, 0x00008000,
  0x0000fdfe, 0x0000feff, 0x00807d00, 0x00008001,
  0x0000fdff, 0x0000ff00, 0x00807d01, 0x0000aaaa,
  0x0000fe00, 0x0000ff01, 0x0080a7aa, 0x0000cccc,
  0x0000fe01, 0x000129aa, 0x0080c9cc, 0x0000ff80,
  0x000128aa, 0x00014bcc, 0x0080fc80, 0x0000ff81,
  0x00014acc, 0x00017e80, 0x0080fc81, 0x0000ff82,
  0x00017d80, 0x00017e81, 0x0080fc82, 0x0000ff83,
  0x00017e81, 0x0080fc82, 0x0000ff83, 0x0000fff1,
  0x00017e82, 0x0080fc83, 0x0000fff0, 0x0000fffe,
  0x00017e83, 0x0080fcf0, 0x0000fffd, 0x0000ffff,
  0x00017ef0, 0x0080fcfd, 0x0000fffe, 0x00010000,
  0x00017efd, 0x0080fcfe, 0x0000ffff, 0x00000001,
  0x00017efe, 0x0080fcff, 0x00000000, 0x00000002,
  0x00017eff, 0x007ffd00, 0x00000001, 0x00000003,
  0x00007f00, 0x007ffd01, 0x00000002, 0x00000011,
  0x00007f01, 0x007ffd02, 0x00000010, 0x0000007e,
  0x00007f02, 0x007ffd10, 0x0000007d, 0x0000007f,
  0x00007f10, 0x007ffd7d, 0x0000007e, 0x00000080,
  0x00007f7d, 0x007ffd7e, 0x0000007f, 0x00003334,
  0x00007f7e, 0x007ffd7f, 0x00003333, 0x00005556,
  0x00007f7f, 0x00803033, 0x00005555, 0x00007ffe,
  0x0000b233, 0x00805255, 0x00007ffd, 0x00007fff,
  0x0000d455, 0x00807cfd, 0x00007ffe, 0x00008000,
  0x0000fefd, 0x00807cfe, 0x00007fff, 0x00008001,
  0x0000fefe, 0x00807cff, 0x00008000, 0x00008002,
  0x0000feff, 0x00807d00, 0x00008001, 0x0000aaab,
  0x0000ff00, 0x00807d01, 0x0000aaaa, 0x0000cccd,
  0x0000ff01, 0x0080a7aa, 0x0000cccc, 0x0000ff81,
  0x000129aa, 0x0080c9cc, 0x0000ff80, 0x0000ff82,
  0x00014bcc, 0x0080fc80, 0x0000ff81, 0x0000ff83,
  0x00017e80, 0x0080fc81, 0x0000ff82, 0x0000ff84,
  0x0080fc81, 0x0000ff82, 0x0000ff84, 0x0000fff2,
  0x0080fc82, 0x0000ff83, 0x0000fff1, 0x0000ffff,
  0x0080fc83, 0x0000fff0, 0x0000fffe, 0x00010000,
  0x0080fcf0, 0x0000fffd, 0x0000ffff, 0x00010001,
  0x0080fcfd, 0x0000fffe, 0x00010000, 0x00000002,
  0x0080fcfe, 0x0000ffff, 0x00000001, 0x00000003,
  0x0080fcff, 0x00000000, 0x00000002, 0x00000004,
  0x007ffd00, 0x00000001, 0x00000003, 0x00000012,
  0x007ffd01, 0x00000002, 0x00000011, 0x0000007f,
  0x007ffd02, 0x00000010, 0x0000007e, 0x00000080,
  0x007ffd10, 0x0000007d, 0x0000007f, 0x00000081,
  0x007ffd7d, 0x0000007e, 0x00000080, 0x00003335,
  0x007ffd7e, 0x0000007f, 0x00003334, 0x00005557,
  0x007ffd7f, 0x00003333, 0x00005556, 0x00007fff,
  0x00803033, 0x00005555, 0x00007ffe, 0x00008000,
  0x00805255, 0x00007ffd, 0x00007fff, 0x00008001,
  0x00807cfd, 0x00007ffe, 0x00008000, 0x00008002,
  0x00807cfe, 0x00007fff, 0x00008001, 0x00008003,
  0x00807cff, 0x00008000, 0x00008002, 0x0000aaac,
  0x00807d00, 0x00008001, 0x0000aaab, 0x0000ccce,
  0x00807d01, 0x0000aaaa, 0x0000cccd, 0x0000ff82,
  0x0080a7aa, 0x0000cccc, 0x0000ff81, 0x0000ff83,
  0x0080c9cc, 0x0000ff80, 0x0000ff82, 0x0000ff84,
  0x0080fc80, 0x0000ff81, 0x0000ff83, 0x0000ff85,
  0x0000ff81, 0x0000ff83, 0x0000ff85, 0x00010010,
  0x0000ff82, 0x0000ff84, 0x0000fff2, 0x0001001d,
  0x0000ff83, 0x0000fff1, 0x0000ffff, 0x0001001e,
  0x0000fff0, 0x0000fffe, 0x00010000, 0x0001001f,
  0x0000fffd, 0x0000ffff, 0x00010001, 0x00000020,
  0x0000fffe, 0x00010000, 0x00000002, 0x00000021,
  0x0000ffff, 0x00000001, 0x00000003, 0x00000022,
  0x00000000, 0x00000002, 0x00000004, 0x00000030,
  0x00000001, 0x00000003, 0x00000012, 0x0000009d,
  0x00000002, 0x00000011, 0x0000007f, 0x0000009e,
  0x00000010, 0x0000007e, 0x00000080, 0x0000009f,
  0x0000007d, 0x0000007f, 0x00000081, 0x00003353,
  0x0000007e, 0x00000080, 0x00003335, 0x00005575,
  0x0000007f, 0x00003334, 0x00005557, 0x0000801d,
  0x00003333, 0x00005556, 0x00007fff, 0x0000801e,
  0x00005555, 0x00007ffe, 0x00008000, 0x0000801f,
  0x00007ffd, 0x00007fff, 0x00008001, 0x00008020,
  0x00007ffe, 0x00008000, 0x00008002, 0x00008021,
  0x00007fff, 0x00008001, 0x00008003, 0x0000aaca,
  0x00008000, 0x00008002, 0x0000aaac, 0x0000ccec,
  0x00008001, 0x0000aaab, 0x0000ccce, 0x0000ffa0,
  0x0000aaaa, 0x0000cccd, 0x0000ff82, 0x0000ffa1,
  0x0000cccc, 0x0000ff81, 0x0000ff83, 0x0000ffa2,
  0x0000ff80, 0x0000ff82, 0x0000ff84, 0x0000ffa3,
  0x0000ff82, 0x0000ff84, 0x0000ffa3, 0x0001006d,
  0x0000ff83, 0x0000ff85, 0x00010010, 0x0001007a,
  0x0000ff84, 0x0000fff2, 0x0001001d, 0x0001007b,
  0x0000fff1, 0x0000ffff, 0x0001001e, 0x0001007c,
  0x0000fffe, 0x00010000, 0x0001001f, 0x0000007d,
  0x0000ffff, 0x00010001, 0x00000020, 0x0000007e,
  0x00010000, 0x00000002, 0x00000021, 0x0000007f,
  0x00000001, 0x00000003, 0x00000022, 0x0000008d,
  0x00000002, 0x00000004, 0x00000030, 0x000000fa,
  0x00000003, 0x00000012, 0x0000009d, 0x000000fb,
  0x00000011, 0x0000007f, 0x0000009e, 0x000000fc,
  0x0000007e, 0x00000080, 0x0000009f, 0x000033b0,
  0x0000007f, 0x00000081, 0x00003353, 0x000055d2,
  0x00000080, 0x00003335, 0x00005575, 0x0000807a,
  0x00003334, 0x00005557, 0x0000801d, 0x0000807b,
  0x00005556, 0x00007fff, 0x0000801e, 0x0000807c,
  0x00007ffe, 0x00008000, 0x0000801f, 0x0000807d,
  0x00007fff, 0x00008001, 0x00008020, 0x0000807e,
  0x00008000, 0x00008002, 0x00008021, 0x0000ab27,
  0x00008001, 0x00008003, 0x0000aaca, 0x0000cd49,
  0x00008002, 0x0000aaac, 0x0000ccec, 0x0000fffd,
  0x0000aaab, 0x0000ccce, 0x0000ffa0, 0x0000fffe,
  0x0000cccd, 0x0000ff82, 0x0000ffa1, 0x0000ffff,
  0x0000ff81, 0x0000ff83, 0x0000ffa2, 0x00010000,
  0x0000ff83, 0x0000ffa2, 0x00010000, 0x0001006e,
  0x0000ff84, 0x0000ffa3, 0x0001006d, 0x0001007b,
  0x0000ff85, 0x00010010, 0x0001007a, 0x0001007c,
  0x0000fff2, 0x0001001d, 0x0001007b, 0x0001007d,
  0x0000ffff, 0x0001001e, 0x0001007c, 0x0000007e,
  0x00010000, 0x0001001f, 0x0000007d, 0x0000007f,
  0x00010001, 0x00000020, 0x0000007e, 0x00000080,
  0x00000002, 0x00000021, 0x0000007f, 0x0000008e,
  0x00000003, 0x00000022, 0x0000008d, 0x000000fb,
  0x00000004, 0x00000030, 0x000000fa, 0x000000fc,
  0x00000012, 0x0000009d, 0x000000fb, 0x000000fd,
  0x0000007f, 0x0000009e, 0x000000fc, 0x000033b1,
  0x00000080, 0x0000009f, 0x000033b0, 0x000055d3,
  0x00000081, 0x00003353, 0x000055d2, 0x0000807b,
  0x00003335, 0x00005575, 0x0000807a, 0x0000807c,
  0x00005557, 0x0000801d, 0x0000807b, 0x0000807d,
  0x00007fff, 0x0000801e, 0x0000807c, 0x0000807e,
  0x00008000, 0x0000801f, 0x0000807d, 0x0000807f,
  0x00008001, 0x00008020, 0x0000807e, 0x0000ab28,
  0x00008002, 0x00008021, 0x0000ab27, 0x0000cd4a,
  0x00008003, 0x0000aaca, 0x0000cd49, 0x0000fffe,
  0x0000aaac, 0x0000ccec, 0x0000fffd, 0x0000ffff,
  0x0000ccce, 0x0000ffa0, 0x0000fffe, 0x00010000,
  0x0000ff82, 0x0000ffa1, 0x0000ffff, 0x00010001,
  0x0000ffa1, 0x0000ffff, 0x00010001, 0x0001006f,
  0x0000ffa2, 0x00010000, 0x0001006e, 0x0001007c,
  0x0000ffa3, 0x0001006d, 0x0001007b, 0x0001007d,
  0x00010010, 0x0001007a, 0x0001007c, 0x0001007e,
  0x0001001d, 0x0001007b, 0x0001007d, 0x0000007f,
  0x0001001e, 0x0001007c, 0x0000007e, 0x00000080,
  0x0001001f, 0x0000007d, 0x0000007f, 0x00000081,
  0x00000020, 0x0000007e, 0x00000080, 0x0000008f,
  0x00000021, 0x0000007f, 0x0000008e, 0x000000fc,
  0x00000022, 0x0000008d, 0x000000fb, 0x000000fd,
  0x00000030, 0x000000fa, 0x000000fc, 0x000000fe,
  0x0000009d, 0x000000fb, 0x000000fd, 0x000033b2,
  0x0000009e, 0x000000fc, 0x000033b1, 0x000055d4,
  0x0000009f, 0x000033b0, 0x000055d3, 0x0000807c,
  0x00003353, 0x000055d2, 0x0000807b, 0x0000807d,
  0x00005575, 0x0000807a, 0x0000807c, 0x0000807e,
  0x0000801d, 0x0000807b, 0x0000807d, 0x0000807f,
  0x0000801e, 0x0000807c, 0x0000807e, 0x00008080,
  0x0000801f, 0x0000807d, 0x0000807f, 0x0000ab29,
  0x00008020, 0x0000807e, 0x0000ab28, 0x0000cd4b,
  0x00008021, 0x0000ab27, 0x0000cd4a, 0x0000ffff,
  0x0000aaca, 0x0000cd49, 0x0000fffe, 0x00010000,
  0x0000ccec, 0x0000fffd, 0x0000ffff, 0x00010001,
  0x0000ffa0, 0x0000fffe, 0x00010000, 0x00010002,
  0x0000fffe, 0x00010000, 0x00010002, 0x00017fed,
  0x0000ffff, 0x00010001, 0x0001006f, 0x00017ffa,
  0x00010000, 0x0001006e, 0x0001007c, 0x00017ffb,
  0x0001006d, 0x0001007b, 0x0001007d, 0x00017ffc,
  0x0001007a, 0x0001007c, 0x0001007e, 0x00007ffd,
  0x0001007b, 0x0001007d, 0x0000007f, 0x00007ffe,
  0x0001007c, 0x0000007e, 0x00000080, 0x00007fff,
  0x0000007d, 0x0000007f, 0x00000081, 0x0000800d,
  0x0000007e, 0x00000080, 0x0000008f, 0x0000807a,
  0x0000007f, 0x0000008e, 0x000000fc, 0x0000807b,
  0x0000008d, 0x000000fb, 0x000000fd, 0x0000807c,
  0x000000fa, 0x000000fc, 0x000000fe, 0x0000b330,
  0x000000fb, 0x000000fd, 0x000033b2, 0x0000d552,
  0x000000fc, 0x000033b1, 0x000055d4, 0x0000fffa,
  0x000033b0, 0x000055d3, 0x0000807c, 0x0000fffb,
  0x000055d2, 0x0000807b, 0x0000807d, 0x0000fffc,
  0x0000807a, 0x0000807c, 0x0000807e, 0x0000fffd,
  0x0000807b, 0x0000807d, 0x0000807f, 0x0000fffe,
  0x0000807c, 0x0000807e, 0x00008080, 0x00012aa7,
  0x0000807d, 0x0000807f, 0x0000ab29, 0x00014cc9,
  0x0000807e, 0x0000ab28, 0x0000cd4b, 0x00017f7d,
  0x0000ab27, 0x0000cd4a, 0x0000ffff, 0x00017f7e,
  0x0000cd49, 0x0000fffe, 0x00010000, 0x00017f7f,
  0x0000fffd, 0x0000ffff, 0x00010001, 0x00017f80,
  0x0000ffff, 0x00010001, 0x00017f80, 0x00017fee,
  0x00010000, 0x00010002, 0x00017fed, 0x00017ffb,
  0x00010001, 0x0001006f, 0x00017ffa, 0x00017ffc,
  0x0001006e, 0x0001007c, 0x00017ffb, 0x00017ffd,
  0x0001007b, 0x0001007d, 0x00017ffc, 0x00007ffe,
  0x0001007c, 0x0001007e, 0x00007ffd, 0x00007fff,
  0x0001007d, 0x0000007f, 0x00007ffe, 0x00008000,
  0x0000007e, 0x00000080, 0x00007fff, 0x0000800e,
  0x0000007f, 0x00000081, 0x0000800d, 0x0000807b,
  0x00000080, 0x0000008f, 0x0000807a, 0x0000807c,
  0x0000008e, 0x000000fc, 0x0000807b, 0x0000807d,
  0x000000fb, 0x000000fd, 0x0000807c, 0x0000b331,
  0x000000fc, 0x000000fe, 0x0000b330, 0x0000d553,
  0x000000fd, 0x000033b2, 0x0000d552, 0x0000fffb,
  0x000033b1, 0x000055d4, 0x0000fffa, 0x0000fffc,
  0x000055d3, 0x0000807c, 0x0000fffb, 0x0000fffd,
  0x0000807b, 0x0000807d, 0x0000fffc, 0x0000fffe,
  0x0000807c, 0x0000807e, 0x0000fffd, 0x0000ffff,
  0x0000807d, 0x0000807f, 0x0000fffe, 0x00012aa8,
  0x0000807e, 0x00008080, 0x00012aa7, 0x00014cca,
  0x0000807f, 0x0000ab29, 0x00014cc9, 0x00017f7e,
  0x0000ab28, 0x0000cd4b, 0x00017f7d, 0x00017f7f,
  0x0000cd4a, 0x0000ffff, 0x00017f7e, 0x00017f80,
  0x0000fffe, 0x00010000, 0x00017f7f, 0x00017f81,
  0x00010000, 0x00017f7f, 0x00017f81, 0x00017fef,
  0x00010001, 0x00017f80, 0x00017fee, 0x00017ffc,
  0x00010002, 0x00017fed, 0x00017ffb, 0x00017ffd,
  0x0001006f, 0x00017ffa, 0x00017ffc, 0x00017ffe,
  0x0001007c, 0x00017ffb, 0x00017ffd, 0x00007fff,
  0x0001007d, 0x00017ffc, 0x00007ffe, 0x00008000,
  0x0001007e, 0x00007ffd, 0x00007fff, 0x00008001,
  0x0000007f, 0x00007ffe, 0x00008000, 0x0000800f,
  0x00000080, 0x00007fff, 0x0000800e, 0x0000807c,
  0x00000081, 0x0000800d, 0x0000807b, 0x0000807d,
  0x0000008f, 0x0000807a, 0x0000807c, 0x0000807e,
  0x000000fc, 0x0000807b, 0x0000807d, 0x0000b332,
  0x000000fd, 0x0000807c, 0x0000b331, 0x0000d554,
  0x000000fe, 0x0000b330, 0x0000d553, 0x0000fffc,
  0x000033b2, 0x0000d552, 0x0000fffb, 0x0000fffd,
  0x000055d4, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x0000807c, 0x0000fffb, 0x0000fffd, 0x0000ffff,
  0x0000807d, 0x0000fffc, 0x0000fffe, 0x00010000,
  0x0000807e, 0x0000fffd, 0x0000ffff, 0x00012aa9,
  0x0000807f, 0x0000fffe, 0x00012aa8, 0x00014ccb,
  0x00008080, 0x00012aa7, 0x00014cca, 0x00017f7f,
  0x0000ab29, 0x00014cc9, 0x00017f7e, 0x00017f80,
  0x0000cd4b, 0x00017f7d, 0x00017f7f, 0x00017f81,
  0x0000ffff, 0x00017f7e, 0x00017f80, 0x00017f82,
  0x00017f7e, 0x00017f80, 0x00017f82, 0x33343323,
  0x00017f7f, 0x00017f81, 0x00017fef, 0x33343330,
  0x00017f80, 0x00017fee, 0x00017ffc, 0x33343331,
  0x00017fed, 0x00017ffb, 0x00017ffd, 0x33343332,
  0x00017ffa, 0x00017ffc, 0x00017ffe, 0x33333333,
  0x00017ffb, 0x00017ffd, 0x00007fff, 0x33333334,
  0x00017ffc, 0x00007ffe, 0x00008000, 0x33333335,
  0x00007ffd, 0x00007fff, 0x00008001, 0x33333343,
  0x00007ffe, 0x00008000, 0x0000800f, 0x333333b0,
  0x00007fff, 0x0000800e, 0x0000807c, 0x333333b1,
  0x0000800d, 0x0000807b, 0x0000807d, 0x333333b2,
  0x0000807a, 0x0000807c, 0x0000807e, 0x33336666,
  0x0000807b, 0x0000807d, 0x0000b332, 0x33338888,
  0x0000807c, 0x0000b331, 0x0000d554, 0x3333b330,
  0x0000b330, 0x0000d553, 0x0000fffc, 0x3333b331,
  0x0000d552, 0x0000fffb, 0x0000fffd, 0x3333b332,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0x3333b333,
  0x0000fffb, 0x0000fffd, 0x0000ffff, 0x3333b334,
  0x0000fffc, 0x0000fffe, 0x00010000, 0x3333dddd,
  0x0000fffd, 0x0000ffff, 0x00012aa9, 0x3333ffff,
  0x0000fffe, 0x00012aa8, 0x00014ccb, 0x333432b3,
  0x00012aa7, 0x00014cca, 0x00017f7f, 0x333432b4,
  0x00014cc9, 0x00017f7e, 0x00017f80, 0x333432b5,
  0x00017f7d, 0x00017f7f, 0x00017f81, 0x333432b6,
  0x00017f7f, 0x00017f81, 0x333432b6, 0x55565545,
  0x00017f80, 0x00017f82, 0x33343323, 0x55565552,
  0x00017f81, 0x00017fef, 0x33343330, 0x55565553,
  0x00017fee, 0x00017ffc, 0x33343331, 0x55565554,
  0x00017ffb, 0x00017ffd, 0x33343332, 0x55555555,
  0x00017ffc, 0x00017ffe, 0x33333333, 0x55555556,
  0x00017ffd, 0x00007fff, 0x33333334, 0x55555557,
  0x00007ffe, 0x00008000, 0x33333335, 0x55555565,
  0x00007fff, 0x00008001, 0x33333343, 0x555555d2,
  0x00008000, 0x0000800f, 0x333333b0, 0x555555d3,
  0x0000800e, 0x0000807c, 0x333333b1, 0x555555d4,
  0x0000807b, 0x0000807d, 0x333333b2, 0x55558888,
  0x0000807c, 0x0000807e, 0x33336666, 0x5555aaaa,
  0x0000807d, 0x0000b332, 0x33338888, 0x5555d552,
  0x0000b331, 0x0000d554, 0x3333b330, 0x5555d553,
  0x0000d553, 0x0000fffc, 0x3333b331, 0x5555d554,
  0x0000fffb, 0x0000fffd, 0x3333b332, 0x5555d555,
  0x0000fffc, 0x0000fffe, 0x3333b333, 0x5555d556,
  0x0000fffd, 0x0000ffff, 0x3333b334, 0x5555ffff,
  0x0000fffe, 0x00010000, 0x3333dddd, 0x55562221,
  0x0000ffff, 0x00012aa9, 0x3333ffff, 0x555654d5,
  0x00012aa8, 0x00014ccb, 0x333432b3, 0x555654d6,
  0x00014cca, 0x00017f7f, 0x333432b4, 0x555654d7,
  0x00017f7e, 0x00017f80, 0x333432b5, 0x555654d8,
  0x00017f80, 0x333432b5, 0x555654d8, 0x8000ffed,
  0x00017f81, 0x333432b6, 0x55565545, 0x8000fffa,
  0x00017f82, 0x33343323, 0x55565552, 0x8000fffb,
  0x00017fef, 0x33343330, 0x55565553, 0x8000fffc,
  0x00017ffc, 0x33343331, 0x55565554, 0x7ffffffd,
  0x00017ffd, 0x33343332, 0x55555555, 0x7ffffffe,
  0x00017ffe, 0x33333333, 0x55555556, 0x7fffffff,
  0x00007fff, 0x33333334, 0x55555557, 0x8000000d,
  0x00008000, 0x33333335, 0x55555565, 0x8000007a,
  0x00008001, 0x33333343, 0x555555d2, 0x8000007b,
  0x0000800f, 0x333333b0, 0x555555d3, 0x8000007c,
  0x0000807c, 0x333333b1, 0x555555d4, 0x80003330,
  0x0000807d, 0x333333b2, 0x55558888, 0x80005552,
  0x0000807e, 0x33336666, 0x5555aaaa, 0x80007ffa,
  0x0000b332, 0x33338888, 0x5555d552, 0x80007ffb,
  0x0000d554, 0x3333b330, 0x5555d553, 0x80007ffc,
  0x0000fffc, 0x3333b331, 0x5555d554, 0x80007ffd,
  0x0000fffd, 0x3333b332, 0x5555d555, 0x80007ffe,
  0x0000fffe, 0x3333b333, 0x5555d556, 0x8000aaa7,
  0x0000ffff, 0x3333b334, 0x5555ffff, 0x8000ccc9,
  0x00010000, 0x3333dddd, 0x55562221, 0x8000ff7d,
  0x00012aa9, 0x3333ffff, 0x555654d5, 0x8000ff7e,
  0x00014ccb, 0x333432b3, 0x555654d6, 0x8000ff7f,
  0x00017f7f, 0x333432b4, 0x555654d7, 0x8000ff80,
  0x333432b4, 0x555654d7, 0x8000ff80, 0x8000ffee,
  0x333432b5, 0x555654d8, 0x8000ffed, 0x8000fffb,
  0x333432b6, 0x55565545, 0x8000fffa, 0x8000fffc,
  0x33343323, 0x55565552, 0x8000fffb, 0x8000fffd,
  0x33343330, 0x55565553, 0x8000fffc, 0x7ffffffe,
  0x33343331, 0x55565554, 0x7ffffffd, 0x7fffffff,
  0x33343332, 0x55555555, 0x7ffffffe, 0x80000000,
  0x33333333, 0x55555556, 0x7fffffff, 0x8000000e,
  0x33333334, 0x55555557, 0x8000000d, 0x8000007b,
  0x33333335, 0x55555565, 0x8000007a, 0x8000007c,
  0x33333343, 0x555555d2, 0x8000007b, 0x8000007d,
  0x333333b0, 0x555555d3, 0x8000007c, 0x80003331,
  0x333333b1, 0x555555d4, 0x80003330, 0x80005553,
  0x333333b2, 0x55558888, 0x80005552, 0x80007ffb,
  0x33336666, 0x5555aaaa, 0x80007ffa, 0x80007ffc,
  0x33338888, 0x5555d552, 0x80007ffb, 0x80007ffd,
  0x3333b330, 0x5555d553, 0x80007ffc, 0x80007ffe,
  0x3333b331, 0x5555d554, 0x80007ffd, 0x80007fff,
  0x3333b332, 0x5555d555, 0x80007ffe, 0x8000aaa8,
  0x3333b333, 0x5555d556, 0x8000aaa7, 0x8000ccca,
  0x3333b334, 0x5555ffff, 0x8000ccc9, 0x8000ff7e,
  0x3333dddd, 0x55562221, 0x8000ff7d, 0x8000ff7f,
  0x3333ffff, 0x555654d5, 0x8000ff7e, 0x8000ff80,
  0x333432b3, 0x555654d6, 0x8000ff7f, 0x8000ff81,
  0x555654d6, 0x8000ff7f, 0x8000ff81, 0x8000ffef,
  0x555654d7, 0x8000ff80, 0x8000ffee, 0x8000fffc,
  0x555654d8, 0x8000ffed, 0x8000fffb, 0x8000fffd,
  0x55565545, 0x8000fffa, 0x8000fffc, 0x8000fffe,
  0x55565552, 0x8000fffb, 0x8000fffd, 0x7fffffff,
  0x55565553, 0x8000fffc, 0x7ffffffe, 0x80000000,
  0x55565554, 0x7ffffffd, 0x7fffffff, 0x80000001,
  0x55555555, 0x7ffffffe, 0x80000000, 0x8000000f,
  0x55555556, 0x7fffffff, 0x8000000e, 0x8000007c,
  0x55555557, 0x8000000d, 0x8000007b, 0x8000007d,
  0x55555565, 0x8000007a, 0x8000007c, 0x8000007e,
  0x555555d2, 0x8000007b, 0x8000007d, 0x80003332,
  0x555555d3, 0x8000007c, 0x80003331, 0x80005554,
  0x555555d4, 0x80003330, 0x80005553, 0x80007ffc,
  0x55558888, 0x80005552, 0x80007ffb, 0x80007ffd,
  0x5555aaaa, 0x80007ffa, 0x80007ffc, 0x80007ffe,
  0x5555d552, 0x80007ffb, 0x80007ffd, 0x80007fff,
  0x5555d553, 0x80007ffc, 0x80007ffe, 0x80008000,
  0x5555d554, 0x80007ffd, 0x80007fff, 0x8000aaa9,
  0x5555d555, 0x80007ffe, 0x8000aaa8, 0x8000cccb,
  0x5555d556, 0x8000aaa7, 0x8000ccca, 0x8000ff7f,
  0x5555ffff, 0x8000ccc9, 0x8000ff7e, 0x8000ff80,
  0x55562221, 0x8000ff7d, 0x8000ff7f, 0x8000ff81,
  0x555654d5, 0x8000ff7e, 0x8000ff80, 0x8000ff82,
  0x8000ff7e, 0x8000ff80, 0x8000ff82, 0x8000fff0,
  0x8000ff7f, 0x8000ff81, 0x8000ffef, 0x8000fffd,
  0x8000ff80, 0x8000ffee, 0x8000fffc, 0x8000fffe,
  0x8000ffed, 0x8000fffb, 0x8000fffd, 0x8000ffff,
  0x8000fffa, 0x8000fffc, 0x8000fffe, 0x80000000,
  0x8000fffb, 0x8000fffd, 0x7fffffff, 0x80000001,
  0x8000fffc, 0x7ffffffe, 0x80000000, 0x80000002,
  0x7ffffffd, 0x7fffffff, 0x80000001, 0x80000010,
  0x7ffffffe, 0x80000000, 0x8000000f, 0x8000007d,
  0x7fffffff, 0x8000000e, 0x8000007c, 0x8000007e,
  0x8000000d, 0x8000007b, 0x8000007d, 0x8000007f,
  0x8000007a, 0x8000007c, 0x8000007e, 0x80003333,
  0x8000007b, 0x8000007d, 0x80003332, 0x80005555,
  0x8000007c, 0x80003331, 0x80005554, 0x80007ffd,
  0x80003330, 0x80005553, 0x80007ffc, 0x80007ffe,
  0x80005552, 0x80007ffb, 0x80007ffd, 0x80007fff,
  0x80007ffa, 0x80007ffc, 0x80007ffe, 0x80008000,
  0x80007ffb, 0x80007ffd, 0x80007fff, 0x80008001,
  0x80007ffc, 0x80007ffe, 0x80008000, 0x8000aaaa,
  0x80007ffd, 0x80007fff, 0x8000aaa9, 0x8000cccc,
  0x80007ffe, 0x8000aaa8, 0x8000cccb, 0x8000ff80,
  0x8000aaa7, 0x8000ccca, 0x8000ff7f, 0x8000ff81,
  0x8000ccc9, 0x8000ff7e, 0x8000ff80, 0x8000ff82,
  0x8000ff7d, 0x8000ff7f, 0x8000ff81, 0x8000ff83,
  0x8000ff7f, 0x8000ff81, 0x8000ff83, 0x8000fff1,
  0x8000ff80, 0x8000ff82, 0x8000fff0, 0x8000fffe,
  0x8000ff81, 0x8000ffef, 0x8000fffd, 0x8000ffff,
  0x8000ffee, 0x8000fffc, 0x8000fffe, 0x80010000,
  0x8000fffb, 0x8000fffd, 0x8000ffff, 0x80000001,
  0x8000fffc, 0x8000fffe, 0x80000000, 0x80000002,
  0x8000fffd, 0x7fffffff, 0x80000001, 0x80000003,
  0x7ffffffe, 0x80000000, 0x80000002, 0x80000011,
  0x7fffffff, 0x80000001, 0x80000010, 0x8000007e,
  0x80000000, 0x8000000f, 0x8000007d, 0x8000007f,
  0x8000000e, 0x8000007c, 0x8000007e, 0x80000080,
  0x8000007b, 0x8000007d, 0x8000007f, 0x80003334,
  0x8000007c, 0x8000007e, 0x80003333, 0x80005556,
  0x8000007d, 0x80003332, 0x80005555, 0x80007ffe,
  0x80003331, 0x80005554, 0x80007ffd, 0x80007fff,
  0x80005553, 0x80007ffc, 0x80007ffe, 0x80008000,
  0x80007ffb, 0x80007ffd, 0x80007fff, 0x80008001,
  0x80007ffc, 0x80007ffe, 0x80008000, 0x80008002,
  0x80007ffd, 0x80007fff, 0x80008001, 0x8000aaab,
  0x80007ffe, 0x80008000, 0x8000aaaa, 0x8000cccd,
  0x80007fff, 0x8000aaa9, 0x8000cccc, 0x8000ff81,
  0x8000aaa8, 0x8000cccb, 0x8000ff80, 0x8000ff82,
  0x8000ccca, 0x8000ff7f, 0x8000ff81, 0x8000ff83,
  0x8000ff7e, 0x8000ff80, 0x8000ff82, 0x8000ff84,
  0x8000ff80, 0x8000ff82, 0x8000ff84, 0xaaabaa9a,
  0x8000ff81, 0x8000ff83, 0x8000fff1, 0xaaabaaa7,
  0x8000ff82, 0x8000fff0, 0x8000fffe, 0xaaabaaa8,
  0x8000ffef, 0x8000fffd, 0x8000ffff, 0xaaabaaa9,
  0x8000fffc, 0x8000fffe, 0x80010000, 0xaaaaaaaa,
  0x8000fffd, 0x8000ffff, 0x80000001, 0xaaaaaaab,
  0x8000fffe, 0x80000000, 0x80000002, 0xaaaaaaac,
  0x7fffffff, 0x80000001, 0x80000003, 0xaaaaaaba,
  0x80000000, 0x80000002, 0x80000011, 0xaaaaab27,
  0x80000001, 0x80000010, 0x8000007e, 0xaaaaab28,
  0x8000000f, 0x8000007d, 0x8000007f, 0xaaaaab29,
  0x8000007c, 0x8000007e, 0x80000080, 0xaaaadddd,
  0x8000007d, 0x8000007f, 0x80003334, 0xaaaaffff,
  0x8000007e, 0x80003333, 0x80005556, 0xaaab2aa7,
  0x80003332, 0x80005555, 0x80007ffe, 0xaaab2aa8,
  0x80005554, 0x80007ffd, 0x80007fff, 0xaaab2aa9,
  0x80007ffc, 0x80007ffe, 0x80008000, 0xaaab2aaa,
  0x80007ffd, 0x80007fff, 0x80008001, 0xaaab2aab,
  0x80007ffe, 0x80008000, 0x80008002, 0xaaab5554,
  0x80007fff, 0x80008001, 0x8000aaab, 0xaaab7776,
  0x80008000, 0x8000aaaa, 0x8000cccd, 0xaaabaa2a,
  0x8000aaa9, 0x8000cccc, 0x8000ff81, 0xaaabaa2b,
  0x8000cccb, 0x8000ff80, 0x8000ff82, 0xaaabaa2c,
  0x8000ff7f, 0x8000ff81, 0x8000ff83, 0xaaabaa2d,
  0x8000ff81, 0x8000ff83, 0xaaabaa2d, 0xcccdccbc,
  0x8000ff82, 0x8000ff84, 0xaaabaa9a, 0xcccdccc9,
  0x8000ff83, 0x8000fff1, 0xaaabaaa7, 0xcccdccca,
  0x8000fff0, 0x8000fffe, 0xaaabaaa8, 0xcccdcccb,
  0x8000fffd, 0x8000ffff, 0xaaabaaa9, 0xcccccccc,
  0x8000fffe, 0x80010000, 0xaaaaaaaa, 0xcccccccd,
  0x8000ffff, 0x80000001, 0xaaaaaaab, 0xccccccce,
  0x80000000, 0x80000002, 0xaaaaaaac, 0xccccccdc,
  0x80000001, 0x80000003, 0xaaaaaaba, 0xcccccd49,
  0x80000002, 0x80000011, 0xaaaaab27, 0xcccccd4a,
  0x80000010, 0x8000007e, 0xaaaaab28, 0xcccccd4b,
  0x8000007d, 0x8000007f, 0xaaaaab29, 0xccccffff,
  0x8000007e, 0x80000080, 0xaaaadddd, 0xcccd2221,
  0x8000007f, 0x80003334, 0xaaaaffff, 0xcccd4cc9,
  0x80003333, 0x80005556, 0xaaab2aa7, 0xcccd4cca,
  0x80005555, 0x80007ffe, 0xaaab2aa8, 0xcccd4ccb,
  0x80007ffd, 0x80007fff, 0xaaab2aa9, 0xcccd4ccc,
  0x80007ffe, 0x80008000, 0xaaab2aaa, 0xcccd4ccd,
  0x80007fff, 0x80008001, 0xaaab2aab, 0xcccd7776,
  0x80008000, 0x80008002, 0xaaab5554, 0xcccd9998,
  0x80008001, 0x8000aaab, 0xaaab7776, 0xcccdcc4c,
  0x8000aaaa, 0x8000cccd, 0xaaabaa2a, 0xcccdcc4d,
  0x8000cccc, 0x8000ff81, 0xaaabaa2b, 0xcccdcc4e,
  0x8000ff80, 0x8000ff82, 0xaaabaa2c, 0xcccdcc4f,
  0x8000ff82, 0xaaabaa2c, 0xcccdcc4f, 0x00007ff0,
  0x8000ff83, 0xaaabaa2d, 0xcccdccbc, 0x00007ffd,
  0x8000ff84, 0xaaabaa9a, 0xcccdccc9, 0x00007ffe,
  0x8000fff1, 0xaaabaaa7, 0xcccdccca, 0x00007fff,
  0x8000fffe, 0xaaabaaa8, 0xcccdcccb, 0xffff8000,
  0x8000ffff, 0xaaabaaa9, 0xcccccccc, 0xffff8001,
  0x80010000, 0xaaaaaaaa, 0xcccccccd, 0xffff8002,
  0x80000001, 0xaaaaaaab, 0xccccccce, 0xffff8010,
  0x80000002, 0xaaaaaaac, 0xccccccdc, 0xffff807d,
  0x80000003, 0xaaaaaaba, 0xcccccd49, 0xffff807e,
  0x80000011, 0xaaaaab27, 0xcccccd4a, 0xffff807f,
  0x8000007e, 0xaaaaab28, 0xcccccd4b, 0xffffb333,
  0x8000007f, 0xaaaaab29, 0xccccffff, 0xffffd555,
  0x80000080, 0xaaaadddd, 0xcccd2221, 0xfffffffd,
  0x80003334, 0xaaaaffff, 0xcccd4cc9, 0xfffffffe,
  0x80005556, 0xaaab2aa7, 0xcccd4cca, 0xffffffff,
  0x80007ffe, 0xaaab2aa8, 0xcccd4ccb, 0x00000000,
  0x80007fff, 0xaaab2aa9, 0xcccd4ccc, 0x00000001,
  0x80008000, 0xaaab2aaa, 0xcccd4ccd, 0x00002aaa,
  0x80008001, 0xaaab2aab, 0xcccd7776, 0x00004ccc,
  0x80008002, 0xaaab5554, 0xcccd9998, 0x00007f80,
  0x8000aaab, 0xaaab7776, 0xcccdcc4c, 0x00007f81,
  0x8000cccd, 0xaaabaa2a, 0xcccdcc4d, 0x00007f82,
  0x8000ff81, 0xaaabaa2b, 0xcccdcc4e, 0x00007f83,
  0xaaabaa2b, 0xcccdcc4e, 0x00007f83, 0x00007ff1,
  0xaaabaa2c, 0xcccdcc4f, 0x00007ff0, 0x00007ffe,
  0xaaabaa2d, 0xcccdccbc, 0x00007ffd, 0x00007fff,
  0xaaabaa9a, 0xcccdccc9, 0x00007ffe, 0x00008000,
  0xaaabaaa7, 0xcccdccca, 0x00007fff, 0xffff8001,
  0xaaabaaa8, 0xcccdcccb, 0xffff8000, 0xffff8002,
  0xaaabaaa9, 0xcccccccc, 0xffff8001, 0xffff8003,
  0xaaaaaaaa, 0xcccccccd, 0xffff8002, 0xffff8011,
  0xaaaaaaab, 0xccccccce, 0xffff8010, 0xffff807e,
  0xaaaaaaac, 0xccccccdc, 0xffff807d, 0xffff807f,
  0xaaaaaaba, 0xcccccd49, 0xffff807e, 0xffff8080,
  0xaaaaab27, 0xcccccd4a, 0xffff807f, 0xffffb334,
  0xaaaaab28, 0xcccccd4b, 0xffffb333, 0xffffd556,
  0xaaaaab29, 0xccccffff, 0xffffd555, 0xfffffffe,
  0xaaaadddd, 0xcccd2221, 0xfffffffd, 0xffffffff,
  0xaaaaffff, 0xcccd4cc9, 0xfffffffe, 0x00000000,
  0xaaab2aa7, 0xcccd4cca, 0xffffffff, 0x00000001,
  0xaaab2aa8, 0xcccd4ccb, 0x00000000, 0x00000002,
  0xaaab2aa9, 0xcccd4ccc, 0x00000001, 0x00002aab,
  0xaaab2aaa, 0xcccd4ccd, 0x00002aaa, 0x00004ccd,
  0xaaab2aab, 0xcccd7776, 0x00004ccc, 0x00007f81,
  0xaaab5554, 0xcccd9998, 0x00007f80, 0x00007f82,
  0xaaab7776, 0xcccdcc4c, 0x00007f81, 0x00007f83,
  0xaaabaa2a, 0xcccdcc4d, 0x00007f82, 0x00007f84,
  0xcccdcc4d, 0x00007f82, 0x00007f84, 0x00007ff2,
  0xcccdcc4e, 0x00007f83, 0x00007ff1, 0x00007fff,
  0xcccdcc4f, 0x00007ff0, 0x00007ffe, 0x00008000,
  0xcccdccbc, 0x00007ffd, 0x00007fff, 0x00008001,
  0xcccdccc9, 0x00007ffe, 0x00008000, 0xffff8002,
  0xcccdccca, 0x00007fff, 0xffff8001, 0xffff8003,
  0xcccdcccb, 0xffff8000, 0xffff8002, 0xffff8004,
  0xcccccccc, 0xffff8001, 0xffff8003, 0xffff8012,
  0xcccccccd, 0xffff8002, 0xffff8011, 0xffff807f,
  0xccccccce, 0xffff8010, 0xffff807e, 0xffff8080,
  0xccccccdc, 0xffff807d, 0xffff807f, 0xffff8081,
  0xcccccd49, 0xffff807e, 0xffff8080, 0xffffb335,
  0xcccccd4a, 0xffff807f, 0xffffb334, 0xffffd557,
  0xcccccd4b, 0xffffb333, 0xffffd556, 0xffffffff,
  0xccccffff, 0xffffd555, 0xfffffffe, 0x00000000,
  0xcccd2221, 0xfffffffd, 0xffffffff, 0x00000001,
  0xcccd4cc9, 0xfffffffe, 0x00000000, 0x00000002,
  0xcccd4cca, 0xffffffff, 0x00000001, 0x00000003,
  0xcccd4ccb, 0x00000000, 0x00000002, 0x00002aac,
  0xcccd4ccc, 0x00000001, 0x00002aab, 0x00004cce,
  0xcccd4ccd, 0x00002aaa, 0x00004ccd, 0x00007f82,
  0xcccd7776, 0x00004ccc, 0x00007f81, 0x00007f83,
  0xcccd9998, 0x00007f80, 0x00007f82, 0x00007f84,
  0xcccdcc4c, 0x00007f81, 0x00007f83, 0x00007f85,
  0x00007f81, 0x00007f83, 0x00007f85, 0x00007ff3,
  0x00007f82, 0x00007f84, 0x00007ff2, 0x00008000,
  0x00007f83, 0x00007ff1, 0x00007fff, 0x00008001,
  0x00007ff0, 0x00007ffe, 0x00008000, 0x00008002,
  0x00007ffd, 0x00007fff, 0x00008001, 0xffff8003,
  0x00007ffe, 0x00008000, 0xffff8002, 0xffff8004,
  0x00007fff, 0xffff8001, 0xffff8003, 0xffff8005,
  0xffff8000, 0xffff8002, 0xffff8004, 0xffff8013,
  0xffff8001, 0xffff8003, 0xffff8012, 0xffff8080,
  0xffff8002, 0xffff8011, 0xffff807f, 0xffff8081,
  0xffff8010, 0xffff807e, 0xffff8080, 0xffff8082,
  0xffff807d, 0xffff807f, 0xffff8081, 0xffffb336,
  0xffff807e, 0xffff8080, 0xffffb335, 0xffffd558,
  0xffff807f, 0xffffb334, 0xffffd557, 0x00000000,
  0xffffb333, 0xffffd556, 0xffffffff, 0x00000001,
  0xffffd555, 0xfffffffe, 0x00000000, 0x00000002,
  0xfffffffd, 0xffffffff, 0x00000001, 0x00000003,
  0xfffffffe, 0x00000000, 0x00000002, 0x00000004,
  0xffffffff, 0x00000001, 0x00000003, 0x00002aad,
  0x00000000, 0x00000002, 0x00002aac, 0x00004ccf,
  0x00000001, 0x00002aab, 0x00004cce, 0x00007f83,
  0x00002aaa, 0x00004ccd, 0x00007f82, 0x00007f84,
  0x00004ccc, 0x00007f81, 0x00007f83, 0x00007f85,
  0x00007f80, 0x00007f82, 0x00007f84, 0x00007f86,
  0x00007f82, 0x00007f84, 0x00007f86, 0x0000ff70,
  0x00007f83, 0x00007f85, 0x00007ff3, 0x0000ff7d,
  0x00007f84, 0x00007ff2, 0x00008000, 0x0000ff7e,
  0x00007ff1, 0x00007fff, 0x00008001, 0x0000ff7f,
  0x00007ffe, 0x00008000, 0x00008002, 0xffffff80,
  0x00007fff, 0x00008001, 0xffff8003, 0xffffff81,
  0x00008000, 0xffff8002, 0xffff8004, 0xffffff82,
  0xffff8001, 0xffff8003, 0xffff8005, 0xffffff90,
  0xffff8002, 0xffff8004, 0xffff8013, 0xfffffffd,
  0xffff8003, 0xffff8012, 0xffff8080, 0xfffffffe,
  0xffff8011, 0xffff807f, 0xffff8081, 0xffffffff,
  0xffff807e, 0xffff8080, 0xffff8082, 0x000032b3,
  0xffff807f, 0xffff8081, 0xffffb336, 0x000054d5,
  0xffff8080, 0xffffb335, 0xffffd558, 0x00007f7d,
  0xffffb334, 0xffffd557, 0x00000000, 0x00007f7e,
  0xffffd556, 0xffffffff, 0x00000001, 0x00007f7f,
  0xfffffffe, 0x00000000, 0x00000002, 0x00007f80,
  0xffffffff, 0x00000001, 0x00000003, 0x00007f81,
  0x00000000, 0x00000002, 0x00000004, 0x0000aa2a,
  0x00000001, 0x00000003, 0x00002aad, 0x0000cc4c,
  0x00000002, 0x00002aac, 0x00004ccf, 0x0000ff00,
  0x00002aab, 0x00004cce, 0x00007f83, 0x0000ff01,
  0x00004ccd, 0x00007f82, 0x00007f84, 0x0000ff02,
  0x00007f81, 0x00007f83, 0x00007f85, 0x0000ff03,
  0x00007f83, 0x00007f85, 0x0000ff03, 0x0000ff71,
  0x00007f84, 0x00007f86, 0x0000ff70, 0x0000ff7e,
  0x00007f85, 0x00007ff3, 0x0000ff7d, 0x0000ff7f,
  0x00007ff2, 0x00008000, 0x0000ff7e, 0x0000ff80,
  0x00007fff, 0x00008001, 0x0000ff7f, 0xffffff81,
  0x00008000, 0x00008002, 0xffffff80, 0xffffff82,
  0x00008001, 0xffff8003, 0xffffff81, 0xffffff83,
  0xffff8002, 0xffff8004, 0xffffff82, 0xffffff91,
  0xffff8003, 0xffff8005, 0xffffff90, 0xfffffffe,
  0xffff8004, 0xffff8013, 0xfffffffd, 0xffffffff,
  0xffff8012, 0xffff8080, 0xfffffffe, 0x00000000,
  0xffff807f, 0xffff8081, 0xffffffff, 0x000032b4,
  0xffff8080, 0xffff8082, 0x000032b3, 0x000054d6,
  0xffff8081, 0xffffb336, 0x000054d5, 0x00007f7e,
  0xffffb335, 0xffffd558, 0x00007f7d, 0x00007f7f,
  0xffffd557, 0x00000000, 0x00007f7e, 0x00007f80,
  0xffffffff, 0x00000001, 0x00007f7f, 0x00007f81,
  0x00000000, 0x00000002, 0x00007f80, 0x00007f82,
  0x00000001, 0x00000003, 0x00007f81, 0x0000aa2b,
  0x00000002, 0x00000004, 0x0000aa2a, 0x0000cc4d,
  0x00000003, 0x00002aad, 0x0000cc4c, 0x0000ff01,
  0x00002aac, 0x00004ccf, 0x0000ff00, 0x0000ff02,
  0x00004cce, 0x00007f83, 0x0000ff01, 0x0000ff03,
  0x00007f82, 0x00007f84, 0x0000ff02, 0x0000ff04,
  0x00007f84, 0x0000ff02, 0x0000ff04, 0x0000ff72,
  0x00007f85, 0x0000ff03, 0x0000ff71, 0x0000ff7f,
  0x00007f86, 0x0000ff70, 0x0000ff7e, 0x0000ff80,
  0x00007ff3, 0x0000ff7d, 0x0000ff7f, 0x0000ff81,
  0x00008000, 0x0000ff7e, 0x0000ff80, 0xffffff82,
  0x00008001, 0x0000ff7f, 0xffffff81, 0xffffff83,
  0x00008002, 0xffffff80, 0xffffff82, 0xffffff84,
  0xffff8003, 0xffffff81, 0xffffff83, 0xffffff92,
  0xffff8004, 0xffffff82, 0xffffff91, 0xffffffff,
  0xffff8005, 0xffffff90, 0xfffffffe, 0x00000000,
  0xffff8013, 0xfffffffd, 0xffffffff, 0x00000001,
  0xffff8080, 0xfffffffe, 0x00000000, 0x000032b5,
  0xffff8081, 0xffffffff, 0x000032b4, 0x000054d7,
  0xffff8082, 0x000032b3, 0x000054d6, 0x00007f7f,
  0xffffb336, 0x000054d5, 0x00007f7e, 0x00007f80,
  0xffffd558, 0x00007f7d, 0x00007f7f, 0x00007f81,
  0x00000000, 0x00007f7e, 0x00007f80, 0x00007f82,
  0x00000001, 0x00007f7f, 0x00007f81, 0x00007f83,
  0x00000002, 0x00007f80, 0x00007f82, 0x0000aa2c,
  0x00000003, 0x00007f81, 0x0000aa2b, 0x0000cc4e,
  0x00000004, 0x0000aa2a, 0x0000cc4d, 0x0000ff02,
  0x00002aad, 0x0000cc4c, 0x0000ff01, 0x0000ff03,
  0x00004ccf, 0x0000ff00, 0x0000ff02, 0x0000ff04,
  0x00007f83, 0x0000ff01, 0x0000ff03, 0x0000ff05,
  0x0000ff01, 0x0000ff03, 0x0000ff05, 0x0000ff73,
  0x0000ff02, 0x0000ff04, 0x0000ff72, 0x0000ff80,
  0x0000ff03, 0x0000ff71, 0x0000ff7f, 0x0000ff81,
  0x0000ff70, 0x0000ff7e, 0x0000ff80, 0x0000ff82,
  0x0000ff7d, 0x0000ff7f, 0x0000ff81, 0xffffff83,
  0x0000ff7e, 0x0000ff80, 0xffffff82, 0xffffff84,
  0x0000ff7f, 0xffffff81, 0xffffff83, 0xffffff85,
  0xffffff80, 0xffffff82, 0xffffff84, 0xffffff93,
  0xffffff81, 0xffffff83, 0xffffff92, 0x00000000,
  0xffffff82, 0xffffff91, 0xffffffff, 0x00000001,
  0xffffff90, 0xfffffffe, 0x00000000, 0x00000002,
  0xfffffffd, 0xffffffff, 0x00000001, 0x000032b6,
  0xfffffffe, 0x00000000, 0x000032b5, 0x000054d8,
  0xffffffff, 0x000032b4, 0x000054d7, 0x00007f80,
  0x000032b3, 0x000054d6, 0x00007f7f, 0x00007f81,
  0x000054d5, 0x00007f7e, 0x00007f80, 0x00007f82,
  0x00007f7d, 0x00007f7f, 0x00007f81, 0x00007f83,
  0x00007f7e, 0x00007f80, 0x00007f82, 0x00007f84,
  0x00007f7f, 0x00007f81, 0x00007f83, 0x0000aa2d,
  0x00007f80, 0x00007f82, 0x0000aa2c, 0x0000cc4f,
  0x00007f81, 0x0000aa2b, 0x0000cc4e, 0x0000ff03,
  0x0000aa2a, 0x0000cc4d, 0x0000ff02, 0x0000ff04,
  0x0000cc4c, 0x0000ff01, 0x0000ff03, 0x0000ff05,
  0x0000ff00, 0x0000ff02, 0x0000ff04, 0x0000ff06,
  0x0000ff02, 0x0000ff04, 0x0000ff06, 0x0000ffd0,
  0x0000ff03, 0x0000ff05, 0x0000ff73, 0x0000ffdd,
  0x0000ff04, 0x0000ff72, 0x0000ff80, 0x0000ffde,
  0x0000ff71, 0x0000ff7f, 0x0000ff81, 0x0000ffdf,
  0x0000ff7e, 0x0000ff80, 0x0000ff82, 0xffffffe0,
  0x0000ff7f, 0x0000ff81, 0xffffff83, 0xffffffe1,
  0x0000ff80, 0xffffff82, 0xffffff84, 0xffffffe2,
  0xffffff81, 0xffffff83, 0xffffff85, 0xfffffff0,
  0xffffff82, 0xffffff84, 0xffffff93, 0x0000005d,
  0xffffff83, 0xffffff92, 0x00000000, 0x0000005e,
  0xffffff91, 0xffffffff, 0x00000001, 0x0000005f,
  0xfffffffe, 0x00000000, 0x00000002, 0x00003313,
  0xffffffff, 0x00000001, 0x000032b6, 0x00005535,
  0x00000000, 0x000032b5, 0x000054d8, 0x00007fdd,
  0x000032b4, 0x000054d7, 0x00007f80, 0x00007fde,
  0x000054d6, 0x00007f7f, 0x00007f81, 0x00007fdf,
  0x00007f7e, 0x00007f80, 0x00007f82, 0x00007fe0,
  0x00007f7f, 0x00007f81, 0x00007f83, 0x00007fe1,
  0x00007f80, 0x00007f82, 0x00007f84, 0x0000aa8a,
  0x00007f81, 0x00007f83, 0x0000aa2d, 0x0000ccac,
  0x00007f82, 0x0000aa2c, 0x0000cc4f, 0x0000ff60,
  0x0000aa2b, 0x0000cc4e, 0x0000ff03, 0x0000ff61,
  0x0000cc4d, 0x0000ff02, 0x0000ff04, 0x0000ff62,
  0x0000ff01, 0x0000ff03, 0x0000ff05, 0x0000ff63,
  0x0000ff03, 0x0000ff05, 0x0000ff63, 0x0000ffed,
  0x0000ff04, 0x0000ff06, 0x0000ffd0, 0x0000fffa,
  0x0000ff05, 0x0000ff73, 0x0000ffdd, 0x0000fffb,
  0x0000ff72, 0x0000ff80, 0x0000ffde, 0x0000fffc,
  0x0000ff7f, 0x0000ff81, 0x0000ffdf, 0xfffffffd,
  0x0000ff80, 0x0000ff82, 0xffffffe0, 0xfffffffe,
  0x0000ff81, 0xffffff83, 0xffffffe1, 0xffffffff,
  0xffffff82, 0xffffff84, 0xffffffe2, 0x0000000d,
  0xffffff83, 0xffffff85, 0xfffffff0, 0x0000007a,
  0xffffff84, 0xffffff93, 0x0000005d, 0x0000007b,
  0xffffff92, 0x00000000, 0x0000005e, 0x0000007c,
  0xffffffff, 0x00000001, 0x0000005f, 0x00003330,
  0x00000000, 0x00000002, 0x00003313, 0x00005552,
  0x00000001, 0x000032b6, 0x00005535, 0x00007ffa,
  0x000032b5, 0x000054d8, 0x00007fdd, 0x00007ffb,
  0x000054d7, 0x00007f80, 0x00007fde, 0x00007ffc,
  0x00007f7f, 0x00007f81, 0x00007fdf, 0x00007ffd,
  0x00007f80, 0x00007f82, 0x00007fe0, 0x00007ffe,
  0x00007f81, 0x00007f83, 0x00007fe1, 0x0000aaa7,
  0x00007f82, 0x00007f84, 0x0000aa8a, 0x0000ccc9,
  0x00007f83, 0x0000aa2d, 0x0000ccac, 0x0000ff7d,
  0x0000aa2c, 0x0000cc4f, 0x0000ff60, 0x0000ff7e,
  0x0000cc4e, 0x0000ff03, 0x0000ff61, 0x0000ff7f,
  0x0000ff02, 0x0000ff04, 0x0000ff62, 0x0000ff80,
  0x0000ff04, 0x0000ff62, 0x0000ff80, 0x0000ffee,
  0x0000ff05, 0x0000ff63, 0x0000ffed, 0x0000fffb,
  0x0000ff06, 0x0000ffd0, 0x0000fffa, 0x0000fffc,
  0x0000ff73, 0x0000ffdd, 0x0000fffb, 0x0000fffd,
  0x0000ff80, 0x0000ffde, 0x0000fffc, 0xfffffffe,
  0x0000ff81, 0x0000ffdf, 0xfffffffd, 0xffffffff,
  0x0000ff82, 0xffffffe0, 0xfffffffe, 0x00000000,
  0xffffff83, 0xffffffe1, 0xffffffff, 0x0000000e,
  0xffffff84, 0xffffffe2, 0x0000000d, 0x0000007b,
  0xffffff85, 0xfffffff0, 0x0000007a, 0x0000007c,
  0xffffff93, 0x0000005d, 0x0000007b, 0x0000007d,
  0x00000000, 0x0000005e, 0x0000007c, 0x00003331,
  0x00000001, 0x0000005f, 0x00003330, 0x00005553,
  0x00000002, 0x00003313, 0x00005552, 0x00007ffb,
  0x000032b6, 0x00005535, 0x00007ffa, 0x00007ffc,
  0x000054d8, 0x00007fdd, 0x00007ffb, 0x00007ffd,
  0x00007f80, 0x00007fde, 0x00007ffc, 0x00007ffe,
  0x00007f81, 0x00007fdf, 0x00007ffd, 0x00007fff,
  0x00007f82, 0x00007fe0, 0x00007ffe, 0x0000aaa8,
  0x00007f83, 0x00007fe1, 0x0000aaa7, 0x0000ccca,
  0x00007f84, 0x0000aa8a, 0x0000ccc9, 0x0000ff7e,
  0x0000aa2d, 0x0000ccac, 0x0000ff7d, 0x0000ff7f,
  0x0000cc4f, 0x0000ff60, 0x0000ff7e, 0x0000ff80,
  0x0000ff03, 0x0000ff61, 0x0000ff7f, 0x0000ff81,
  0x0000ff61, 0x0000ff7f, 0x0000ff81, 0x0000ffef,
  0x0000ff62, 0x0000ff80, 0x0000ffee, 0x0000fffc,
  0x0000ff63, 0x0000ffed, 0x0000fffb, 0x0000fffd,
  0x0000ffd0, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x0000ffdd, 0x0000fffb, 0x0000fffd, 0xffffffff,
  0x0000ffde, 0x0000fffc, 0xfffffffe, 0x00000000,
  0x0000ffdf, 0xfffffffd, 0xffffffff, 0x00000001,
  0xffffffe0, 0xfffffffe, 0x00000000, 0x0000000f,
  0xffffffe1, 0xffffffff, 0x0000000e, 0x0000007c,
  0xffffffe2, 0x0000000d, 0x0000007b, 0x0000007d,
  0xfffffff0, 0x0000007a, 0x0000007c, 0x0000007e,
  0x0000005d, 0x0000007b, 0x0000007d, 0x00003332,
  0x0000005e, 0x0000007c, 0x00003331, 0x00005554,
  0x0000005f, 0x00003330, 0x00005553, 0x00007ffc,
  0x00003313, 0x00005552, 0x00007ffb, 0x00007ffd,
  0x00005535, 0x00007ffa, 0x00007ffc, 0x00007ffe,
  0x00007fdd, 0x00007ffb, 0x00007ffd, 0x00007fff,
  0x00007fde, 0x00007ffc, 0x00007ffe, 0x00008000,
  0x00007fdf, 0x00007ffd, 0x00007fff, 0x0000aaa9,
  0x00007fe0, 0x00007ffe, 0x0000aaa8, 0x0000cccb,
  0x00007fe1, 0x0000aaa7, 0x0000ccca, 0x0000ff7f,
  0x0000aa8a, 0x0000ccc9, 0x0000ff7e, 0x0000ff80,
  0x0000ccac, 0x0000ff7d, 0x0000ff7f, 0x0000ff81,
  0x0000ff60, 0x0000ff7e, 0x0000ff80, 0x0000ff82,
};
const unsigned kExpectedCount_NEON_uaddw_4S = 744;

#endif  // VIXL_SIM_UADDW_4S_TRACE_AARCH64_H_
