// Code generated by smithy-go-codegen DO NOT EDIT.

package ssooidc

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Registers a public client with IAM Identity Center. This allows clients to
// perform authorization using the authorization code grant with Proof Key for Code
// Exchange (PKCE) or the device code grant.
func (c *Client) RegisterClient(ctx context.Context, params *RegisterClientInput, optFns ...func(*Options)) (*RegisterClientOutput, error) {
	if params == nil {
		params = &RegisterClientInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RegisterClient", params, optFns, c.addOperationRegisterClientMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RegisterClientOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type RegisterClientInput struct {

	// The friendly name of the client.
	//
	// This member is required.
	ClientName *string

	// The type of client. The service supports only public as a client type. Anything
	// other than public will be rejected by the service.
	//
	// This member is required.
	ClientType *string

	// This IAM Identity Center application ARN is used to define
	// administrator-managed configuration for public client access to resources. At
	// authorization, the scopes, grants, and redirect URI available to this client
	// will be restricted by this application resource.
	EntitledApplicationArn *string

	// The list of OAuth 2.0 grant types that are defined by the client. This list is
	// used to restrict the token granting flows available to the client. Supports the
	// following OAuth 2.0 grant types: Authorization Code, Device Code, and Refresh
	// Token.
	//
	// * Authorization Code - authorization_code
	//
	// * Device Code - urn:ietf:params:oauth:grant-type:device_code
	//
	// * Refresh Token - refresh_token
	GrantTypes []string

	// The IAM Identity Center Issuer URL associated with an instance of IAM Identity
	// Center. This value is needed for user access to resources through the client.
	IssuerUrl *string

	// The list of redirect URI that are defined by the client. At completion of
	// authorization, this list is used to restrict what locations the user agent can
	// be redirected back to.
	RedirectUris []string

	// The list of scopes that are defined by the client. Upon authorization, this
	// list is used to restrict permissions when granting an access token.
	Scopes []string

	noSmithyDocumentSerde
}

type RegisterClientOutput struct {

	// An endpoint that the client can use to request authorization.
	AuthorizationEndpoint *string

	// The unique identifier string for each client. This client uses this identifier
	// to get authenticated by the service in subsequent calls.
	ClientId *string

	// Indicates the time at which the clientId and clientSecret were issued.
	ClientIdIssuedAt int64

	// A secret string generated for the client. The client will use this string to
	// get authenticated by the service in subsequent calls.
	ClientSecret *string

	// Indicates the time at which the clientId and clientSecret will become invalid.
	ClientSecretExpiresAt int64

	// An endpoint that the client can use to create tokens.
	TokenEndpoint *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRegisterClientMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpRegisterClient{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpRegisterClient{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "RegisterClient"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpRegisterClientValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRegisterClient(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRegisterClient(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "RegisterClient",
	}
}
