// @HEADER
// *****************************************************************************
//        MueLu: A package for multigrid based preconditioning
//
// Copyright 2012 NTESS and the MueLu contributors.
// SPDX-License-Identifier: BSD-3-Clause
// *****************************************************************************
// @HEADER

#ifndef MUELU_DOXYGEN_DOCUMENTATION_HPP
#define MUELU_DOXYGEN_DOCUMENTATION_HPP

/*!

\mainpage

@image html muelu.png

\section muelu_index Table of Contents

- \ref muelu_overview
- \ref muelu_documentation
- \ref muelu_developers
- \ref muelu_authors
- \ref muelu_copyright
- \ref muelu_questions

\section muelu_overview MueLu Overview

MueLu is a flexible and extensible multigrid solver framework.  It is intended for the research and
development of new multigrid preconditioning techniques.
More information can be found at https://trilinos.org/packages/muelu.

\section muelu_documentation Documentation

Useful views of the Doxygen documentation are:
  - Browsing the entire class documentation. Choose the <a href="classes.html">Class Index subtab</a>.
  - Browsing the class documentation organized by logical groups.  Choose the <a href="modules.html">Modules tab</a>.

The MueLu User's Guide is located in muelu/doc/UsersGuide and at the
<a href=https://trilinos.org/packages/muelu/muelu-documentation>MueLu home page</a>.

\section muelu_developers Current Developers

  - Jonathan Hu, Sandia National Labs
  - Matthias Mayr, University of the Bundeswehr Munich
  - Chris Siefert, Sandia National Labs
  - Ray Tuminaro, Sandia National Labs
  - Christian Glusa, Sandia National Labs
  - Luc Berger-Vergiat, Sandia National Labs
  - Graham Harper, Sandia National Labs

\section muelu_authors Authors and Contributors

  - Tom Benson, LLNL
  - Emily Furst, University of Washington (summer intern, 2015)
  - Jeremie Gaidamour, INRIA (Nancy, France)
  - Axel Gerstenberger, Rolls Royce
  - Brian Kelley, Texas A&M (summer intern, 2015)
  - Andrey Prokopenko, Sandia National Labs
  - Paul Tsuji, LLNL
  - Tobias Wiesner, Sandia National Labs
  - Peter Ohm, RIKEN (Japan)

\section muelu_copyright Copyright and License

\verbinclude COPYRIGHT_AND_LICENSE

\section muelu_questions For All Questions and Comments...

   Please contact the authors listed in the License above, or use one of the
   <a href=https://trilinos.org/packages/muelu/muelu-contact-us>MueLu mailing lists</a>.

*/

/* ************************************************************************ */
/* ************************************************************************ */

#endif  // ifndef MUELU_DOXYGEN_DOCUMENTATION_HPP
