#! /usr/bin/tclsh
#
#   Copyright (C) 1987-2015 by Jeffery P. Hansen
#   Copyright (C) 2015-2018 by Andrey V. Skvortsov
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along
#   with this program; if not, write to the Free Software Foundation, Inc.,
#   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
########################################################################
#
# Parse string of the messages file
# State machine with state variables currentKey and currentValue
# \param line: text line to parse
# \param sourceLine
# \param msgHash: Hash id to use
#
proc parseString {line sourceLine msgHash} {

	global messagesHash
	global messagesLine2Key
	global currentKey
	global currentValue

	# New key found
	if {[string equal $currentKey ""]} {
		set start [string first "\t" $line]
		set stop [string last "\t" $line]
		if {$start > 0} {
			set currentKey [string range $line 0 [expr {$start-1}]]
			lappend messagesLine2Key($msgHash) [list $sourceLine $currentKey]
			set value [string trim [string range $line $stop [string length $line]]]
			if {([string equal $value "-fillbegin-"] == 0) &&
			    ([string equal $value "-begin-"] == 0)} {
				set currentValue $value
				set messagesHash($currentKey,$msgHash) $currentValue
				set currentKey ""
			} else {
				set currentValue ""
			}
		}
	# Next line of the current value
	} else {
		if {[string equal $line "-end-"]} {
			set messagesHash($currentKey,$msgHash) $currentValue
			set currentKey ""
			set currentValue ""
		} else {
			if {[string length $currentValue] > 0} {
				set currentValue "$currentValue\n"
			}
			set currentValue "$currentValue$line"
		}
	}
}

proc parseFile {msgFile msgHash} {
	set sourceLine 1

	while {1} {
		set line [gets $msgFile]
		if {[eof $msgFile]} {
			close $msgFile
			break
		}
		# trim line and reject of the comment and service lines
		set line [string trim $line]
		if {([string index $line 0] != "#") &&
		    ([string index $line 0] != "@") &&
		    ([string index $line 0] != "\\") &&
		    ([string length $line] > 0)} {
			parseString $line $sourceLine $msgHash
		}
		incr sourceLine
	}
}

global messagesHash
global messagesLine2Key
global currentKey
global currentValue
global options_m
global options_pot

set options_m "en/messages"
set options_pot "messages.pot"

set currentKey ""
set currentValue ""

# try to open original (english) messages file
set f [open $options_m r]
puts "Messages file '$options_m' opened"

# try to open template output file
set f0 [open $options_pot w]
puts "Gettext template file '$options_pot' opened"

parseFile $f m

puts $f0 "# This file is part of TkGate project"
puts $f0 "# Copyright (C) 1987-2015 by Jeffery P. Hansen"
puts $f0 "# Copyright (C) 2015-2018 by Andrey V. Skvortsov"
puts $f0 "# This file is distributed under the same license as the TkGate package."
puts $f0 "#"
puts $f0 "# ##############################################################################"
puts $f0 "# Generated by messages2po script"
puts $f0 "# ##############################################################################"
puts $f0 "#"
puts $f0 "#, fuzzy"
puts $f0 "msgid \"\""
puts $f0 "msgstr \"\""
puts $f0 "\"Project-Id-Version: tkgate\\n\""
puts $f0 "\"Report-Msgid-Bugs-To: \\n\""
puts $f0 "\"POT-Creation-Date: [clock format [clock seconds] -format {%Y-%m-%d %H:%M}]\+0300\\n\""
puts $f0 "\"PO-Revision-Date: YEAR-MO-DA HO:MI+ZONE\\n\""
puts $f0 "\"Last-Translator: FULL NAME <EMAIL@ADDRESS>\\n\""
puts $f0 "\"Language-Team: LANGUAGE <LL@li.org>\\n\""
puts $f0 "\"Language: \\n\""
puts $f0 "\"MIME-Version: 1.0\\n\""
puts $f0 "\"Content-Type: text/plain; charset=UTF-8\\n\""
puts $f0 "\"Content-Transfer-Encoding: 8bit\\n\""

foreach pair $messagesLine2Key(m) {
	set str [lindex $pair 0]
	set keyName [lindex $pair 1]
	set msgVal $messagesHash($keyName,m)
	regsub -all "\"" $msgVal "\\\"" msgVal
	if {([string index $msgVal 0] != "`") &&
	    ([string equal $msgVal "-empty-"] == 0)} {
		puts $f0 ""
		puts $f0 "#: $options_m:$str"
		puts $f0 "msgctxt \"$keyName\""
		set line "msgid "
		set strList [split $msgVal "\n"]
		if {[llength $strList] > 1} {
			set line "$line\"\"\n\"[join $strList \\n\"\n\"]\""
		} else {
			set line "$line\"[lindex $strList 0]\""
		}
		puts $f0 $line
		puts $f0 "msgstr \"\""
    }
}

close $f0
