---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, paragraphes, indentation, retrait d'indentation, 
              absence d'indentation
---

# Comment obtenir des paragraphes sans indentation ?

Par convention, le texte courant se compose sans séparation 
entre les paragraphes et la première ligne de chaque paragraphe est 
en retrait. Cependant, il n'est pas rare de trouver 
une convention alternative dans laquelle il n'y a aucune mise en retrait
de la première ligne des paragraphes : ce style s'observe 
dans des manuels techniques ou des documents avec des chartes graphiques 
spécifiques.

En l'absence de retrait de la première ligne, il est nécessaire que
les paragraphes soient séparés par un espace vide. Sans cela, il serait
parfois impossible de voir les changements de paragraphes.

Si jamais votre besoin se limite à retrancher l'indentation 
d'un unique paragraphe, vous pouvez consulter la question 
"[](supprimer_l_indentation_des_paragraphes)".


## Avec les commandes de base

Une approche pour obtenir ce format est de redéfinir certains paramètres 
de LaTeX :
- `\parindent`, la taille de l'indentation de début de paragraphe ;
- `\parskip`, la taille de l'espace vertical après une fin de paragraphe.

La redéfinition sera la suivante :

```{noedit}
\setlength{\parindent}{0pt}  
\setlength{\parskip}{\baselineskip} 
```

En voici un exemple.

::::{tab-set}

:::{tab-item} Indentation initiale
```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte
  \pagestyle{empty}           % N'affiche pas de numéro de page




\begin{document}
\lipsum[1-4] % Le faux texte
\end{document}
```
:::

:::{tab-item} Indentation corrigée

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \setlength{\parindent}{0pt}  
  \setlength{\parskip}{\baselineskip} 

\begin{document}
\lipsum[1-4] % Le faux texte
\end{document}
```
:::

::::

Notez que vous pouvez limiter l'effet de cette commande à une série 
de paragraphes, en mettant ces paragraphes entre accolades 
et en insérant les deux commandes ci-dessus après l'accolade ouvrante.


## Avec l'extension <ctanpkg:parskip>

Dans les cas simples, la solution ci-dessus est assez pratique. 
Cependant, la commande `\parskip` interfère avec la présentation 
des listes et environnements similaires. Cela peut faciliment conduire
à un résultat peu esthétique. L'extension <ctanpkg:parskip> corrige 
la plupart des problèmes de cette méthode (mais n'est pas parfaite).
Dans le principe, elle supprime le retrait de tous les paragraphes 
et elle ajoute bien un petit espace vertical entre les paragraphes 
(de hauteur `.5\baselineskip plus 2pt`). 

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{parskip}

\begin{document}
\lipsum[1-4] % Le faux texte
\end{document}
```

Elle a d'autres fonctions si vous lui passez des options 
lors de son chargement :

- `[indent=1cm]` indentera les paragraphes de `1 cm` ;
- `[skip=1.5\baselineskip plus .33ex]` ajoutera un espace de `1,5 ex`
  (extensible à `1,83 ex`) entre les paragraphes;
- `[parfill=6em]` imposera que la dernière ligne de chaque paragraphe 
  se termine par au moins `6 em` d'espace vide (là encore, cette méthode
  permet d'identifier visuellement les sauts de paragraphe en l'absence
  de renfoncement à gauche).


## Avec les classes [artikel3](ctanpkg:ntgclass) et [rapport3](ctanpkg:ntgclass)

Les classes définies par le [NTG](http://www.ntg.nl/), le TUG 
néerlandais, incluent deux classes qui proposent un retrait 
de paragraphe nul et un saut de paragraphe différent de zéro :

- un équivalent de la classe <ctanpkg:article> : [artikel3](ctanpkg:ntgclass) ;
- un équivalent de la classe <ctanpkg:report> : [rapport3](ctanpkg:ntgclass).

```
\documentclass[french]{artikel3}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\lipsum[1-4] % Le faux texte
\end{document}
```


:::{sources}
[Zero paragraph indent](faquk:FAQ-parskip)
:::