---
myst:
  html_meta:
    keywords: composition, texte, mots, espaces, espaces visibles
---

# Comment visualiser des espaces ?

## Avec l'environnement `verbatim*`

L'environnement `verbatim*` et la commande `\verb*` permettent de visualiser les espaces insérés 
dans un texte. Ils les remplacent par un caractère spécial, `␣`, comme dans l'exemple suivant :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\begin{verbatim*}
Voici des espaces   bien   visibles.
\end{verbatim*}
Voici\verb*+ d'autres espaces +plus ciblés.
\end{document}
```


## Avec des commandes de base

LaTeX propose la commande `\textvisiblespace`.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Je mange\textvisiblespace une\textvisiblespace pomme.
\end{document}
```

En TeX, ce `␣` est le caractère 32 de la fonte *Computer Modern Typewriter* (`cmtt`).
Il est défini dans le source du TeX​book par :

```{noedit}
\def\]{\leavevmode\hbox{\tt\char`\ }}
```

Vous pouvez donc, pour LaTeX, définir une commande `\espacev` pour obtenir ce fameux caractère.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \newcommand{\espacev}{\leavevmode\hbox{\tt\char`\ }}

\begin{document}
Je mange\espacev une\espacev pomme.
\end{document}
```