; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686--| FileCheck %s --check-prefixes=X86
; RUN: llc < %s -mtriple=x86_64--| FileCheck %s --check-prefixes=X64

;
; PR35202
;

declare void @on_less()
declare void @on_equal()
declare void @on_greater()

define void @eq_first(i32 %0, i32 %1) {
; X86-LABEL: eq_first:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    jge .LBB0_1
; X86-NEXT:  # %bb.3:
; X86-NEXT:    jmp on_less@PLT # TAILCALL
; X86-NEXT:  .LBB0_1:
; X86-NEXT:    jne .LBB0_2
; X86-NEXT:  # %bb.4:
; X86-NEXT:    jmp on_equal@PLT # TAILCALL
; X86-NEXT:  .LBB0_2:
; X86-NEXT:    jmp on_greater@PLT # TAILCALL
;
; X64-LABEL: eq_first:
; X64:       # %bb.0:
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    jge .LBB0_1
; X64-NEXT:  # %bb.3:
; X64-NEXT:    jmp on_less@PLT # TAILCALL
; X64-NEXT:  .LBB0_1:
; X64-NEXT:    jne .LBB0_2
; X64-NEXT:  # %bb.4:
; X64-NEXT:    jmp on_equal@PLT # TAILCALL
; X64-NEXT:  .LBB0_2:
; X64-NEXT:    jmp on_greater@PLT # TAILCALL
  %3 = icmp slt i32 %0, %1
  br i1 %3, label %4, label %5
4:
  tail call void @on_less()
  br label %9
5:
  %6 = icmp eq i32 %0, %1
  br i1 %6, label %7, label %8
7:
  tail call void @on_equal()
  br label %9
8:
  tail call void @on_greater()
  br label %9
9:
  ret void
}

define void @gt_first(i32 %0, i32 %1) {
; X86-LABEL: gt_first:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmpl %eax, %ecx
; X86-NEXT:    jge .LBB1_1
; X86-NEXT:  # %bb.3:
; X86-NEXT:    jmp on_less@PLT # TAILCALL
; X86-NEXT:  .LBB1_1:
; X86-NEXT:    jle .LBB1_2
; X86-NEXT:  # %bb.4:
; X86-NEXT:    jmp on_greater@PLT # TAILCALL
; X86-NEXT:  .LBB1_2:
; X86-NEXT:    jmp on_equal@PLT # TAILCALL
;
; X64-LABEL: gt_first:
; X64:       # %bb.0:
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    jge .LBB1_1
; X64-NEXT:  # %bb.3:
; X64-NEXT:    jmp on_less@PLT # TAILCALL
; X64-NEXT:  .LBB1_1:
; X64-NEXT:    jle .LBB1_2
; X64-NEXT:  # %bb.4:
; X64-NEXT:    jmp on_greater@PLT # TAILCALL
; X64-NEXT:  .LBB1_2:
; X64-NEXT:    jmp on_equal@PLT # TAILCALL
  %3 = icmp slt i32 %0, %1
  br i1 %3, label %4, label %5
4:
  tail call void @on_less()
  br label %9
5:
  %6 = icmp slt i32 %1, %0
  br i1 %6, label %7, label %8
7:
  tail call void @on_greater()
  br label %9
8:
  tail call void @on_equal()
  br label %9
9:
  ret void
}
