---
title: 2020 Tutorial
---

This tutorial showcases turn lanes, routeSampler.py, defining counting data in netedit, taxi/DRT, and more!

# Files

- [sumo2020_tutorial.zip](https://sumo.dlr.de/daily/sumo2020_tutorial.zip)

# Video
<a class="no-arrow-link" data-youtube href="https://www.youtube.com/watch?v=aiOQbaB-pWo">Watch the 2020 Tutorial</a>


# Transcription

## Intro
Welcome to this year's conference tutorial. I'm pretty excited. I'm thrilled to see so many familiar names in the participants list. I'd be happy to see you in person but, well, we have to make do with the opportunities present. So in this year's tutorial I will try to do a split between sharing simple introductory things for the participants that have had little experience with SUMO and then in the second part I will go over to new kinds of features which should be of interest to all the users that are more familiar with SUMO. And of course this is only a very tiny slice of all the things that we could talk about but if there are things missing then I encourage you to just look at the tutorials of the past year, where many more features are explained.

And of course you will find us in other venues for asking your questions. So let's start. What do you need if you want to follow this tutorial? Which may be difficult when it's running fast but of course you will need the latest release of SUMO or, even better, the latest development version. You will need python to run some of the tools that are part of the tutorial, a text editor, for editing configuration files, xml files and you will probably need the tutorial files prepared beforehand if you want to follow all the steps. So just a quick way where you can get those files if you go to the main SUMO page you will find the documentation. This is sumo.dlr.de - then you can go to the tutorials and, well then it's also a link here, and then you have here the link for the [SUMO 2020 tutorial files](https://sumo.dlr.de/daily/sumo2020_tutorial.zip) which you can download. All right. Now the first thing I want to talk about is the OSM web wizard or in short how to get a simulation running in a few clicks.

## osmWebWizard
As you may know traffic simulation is a complex beast with many moving parts, no pun intended, and it can be daunting to get started, but with the wizard tool that is included in SUMO it's easy to get started, at least. So what you need to do, to run this, is if you have installed SUMO, just click on the icon in your start menu, which should be there, or you could also find the Wizard tool in the SUMO tools folder, I'm going to run it the old-fashioned way on a command line window, so wherever `$SUMO_HOME` is, there is a "tools" folder, and this holds the osmWebWizard. And then what you get is this kind of screen, where you can select an area of interest, select traffic modes and some other things such as satellite background, public transport, and then you can generate your scenario and off you go. And you get something like this.

So this is actually a new feature, the satellite background. As you can see there are a few artifacts but it may help you to to get a good look of the area you're simulating. All right, back to the slides. So this works by using the awesome OpenStreetMap database. It pulls all the network data from their database. And then it puts random traffic on that network because there is no data source, no open data source for traffic data as of yet. And you can configure all these things and it will show up in the folder on your computer with lots and lots of files which I'll explain in a little bit. But then when you run the scenario, actually I'm going to run the one that has been included with the tutorial files, you'll see the cars. So I'll run the one that you can find in the `01_wizard` folder. And of course if SUMO is installed on your computer you can just double click the sumoconfig file. And you will get something like this.
And when you zoom in by holding down the right mouse button, you will see the cars moving. And if you want to get an overview over all the things that are moving in the simulation, there are plenty of things that you can configure here. And right now I'm going to make the cars a little bigger. So you can see the network is filled with stuff, even trains and persons. If you look really closely, then you will see not only are there cars moving in the network but also persons moving around and even riding the cars. All right.

## osmWebWizard - Generated Files
What happened in the background with this wizard? It downloaded, as I said, lots and lots of files. And ran a number of programs to process these files and give you the simulation that you are seeing. Most now go over all these files. So to give you a reference. The most important one is the sumoconfig file. It's the configuration that ties all the other files together and tells sumo what to load. The most important input is the network file. The customary ending is `.net.xml` - and these are all xml files. And then there are several files that define the traffic running in the network. And to restate it, these are where randomly generated. So we have a file for the passenger cars, a file for the person, another file for the public transport. And then we have some files that are... Well, let's say this is infrastructure. So we have a file that defines the location of public transport stops, which are used by the public transport.
And we have a file that is for visualization. It defines all these building outlines and points of interest, trees and land use, all that stuff. And there is a file that defines what the visualization is supposed to look like. Colors for things, shapes and sizes, which are already shown briefly by enlarging the cars. So this is all you need to run the simulation. But Web Wizard gives you a bunch of other files, which you will need to rebuild the scenario. Because doing a simulation is less of a single task, but more of a process pipeline. You run lots of programs after each other, and from time to time you repeat these steps of some input changes. So the most important input is the raw data from the OSM servers. There's a configuration for building the network, a configuration for building the background shapes, the configuration, or rather an executable for the randomly generated traffic, and some intermediate data for the public transport network.
All right. So all this is working in the background to give you this simulation. And well, are we happy with this? Maybe, but it's just the start. First of all, the traffic is random, which is usually not what we want. And also, the data is still pretty raw. As you may know, the OpenStreetMap database depends on voluntary contributions. And if these people did not get every part correct in your city, then there are errors in the network. So, a typical step is to do some post-processing, manual post-processing on the network, to fix issues, and since this is such a very basic task, we'll go over these steps in the tutorial as well. 

## Network Editing - Delete Roads
So, if you are following the tutorial on the computer, now or later, this takes place in a new folder. It's in the `02_netedit` folder, there's the raw network - and we'll do our edits there. And then there is a folder for the final stuff. So, let's go over the tutorial files real quick. This is what you get when you unzip the tutorial files. So, for some of the slides, some parts of the tutorial just get one folder. For other parts of the tutorial, you get a folder that shows the step before doing the work and a folder that shows the final work.
All right. So, let's do some network editing. The first thing that you may want to do is edit the network by deleting some things. Because you don't want a rectangle, but just a smaller part of that. So... Let's do this. The netedit application is also in your start menu, or you can find it in the folder where the SUMO binaries are. So, wherever you install SUMO, there's a "bin" folder with the netedit application. And in that application, you can open your network, and the next thing we'll open are the stops. So, we'll go here to the menu load additional files. And we'll load the stops. And why is this?
When we edit the network and delete some things, we want to automatically delete the accompanying stops as well. So, how do we do this? We go to the edge selection mode by pressing <kbd>S</kbd>. And then we hold down the <kbd>Shift</kbd> key and do a selection on the network. If you do this repeatedly, the selection will be increased, enlarged. So, we just select these things here. And then by pressing the <kbd>Delete</kbd> key, boom, everything is gone. Everything that was selected. So, that is step one. And now we can simply save the network. And we also save the additional files. Because now there are fewer stops. So, this is one step of network editing. And important, when you do this, when you really change the network, you have to rebuild all the random traffic because now some parts of the network that may have had traffic are gone. So, that traffic would be invalid. And for that, there is a batch file in the web wizard folder, which you can run. It also works on Linux. And it basically holds some directives for rebuilding the scenario by running various programs. So, you just run that again. On Windows, you would just double click. And then you have an updated scenario with a different network.
All right. Oh, yes, and if you're on Windows, make sure that you close sumo-gui because it will hold the files locked and you cannot rebuild the scenario while the files are still locked. All right.

## Network Editing - Add Turn Lane
Next step of network editing. We'll add a turn lane. This is actually a pretty typical issue with networks from OpenStreetMap. The lane numbers, in particular, the lane numbers at large intersections are wrong. You can guess why. It's a lot of work to get all those details right at every intersection and people miss things or they just never get around to doing it. So, what you typically would do is either you work from your own personal knowledge of an area or you look at satellite imagery and you conclude that there is an error in the network, and you fix it. So, let's see how we can change the number of turn lanes. All right. So, let's go to one particular part of the network. And actually, let's confirm from the satellite imagery that there's an issue here.
So, I'll just right click somewhere in the network and I select "copy cursor geo position to the clipboard". And now I can go to some kind of online map service. And I just paste the coordinates here. And let's see if that is working. And if you look closely, there should be three lanes here. One for turning left. Whereas our simulation has two lanes here. So, the easiest thing to do is to go to a different kind of editing mode, the inspect mode- you can press the letter <kbd>I</kbd> to go there - then click on this network element called "edge" and change the number of lanes from 3 to 4. Three because the sidewalk is also included in the count, so, let's do this.
As you can see, the geometry looks a bit strange. This is because it's not been updated yet. So, let's recompute the geometry. And here we go. Now we have a lane that's for turning. And another thing that we want to do is we want to adjust the geometry. This is another mode, the move mode - letter <kbd>M</kbd> - and let's just move this point here backwards, so the turning lane is longer. And we can move it even further back here. All right. I'll recompute the geometry again - that's <kbd>F5</kbd>. And I can save the network. And now I can also load this directly in sumo-gui to see how that would look in the simulation view. So, that would look like this. And you may notice something strange. The bus stop was turned into a small sliver. Either because it's... Well, probably because it's on some... It's in this part or in this part. So, we could change this, but we'll leave this as an exercise for later. All right.
I see there is a question whether you can have satellite images in netedit. Yes, you can. You can load the imagery that goes into sumo-gui into netedit as well, with the same kind of configuration. All right. Well, actually, if you are using version 1.7.0, there's a small bug where pedestrian crossings may disappear when you change lane numbers. The short answer is don't worry about it. Just go to the latest... Upgrade to the latest development version. But if you're dealing with these issues, I'll show you real quick how to edit crossings. This is another mode. This one here with the little zebra bar. And then you click on an intersection. And if a crossing is missing, let's see. Let's assume this is missing. Then you click on the edge that should be crossed. You create a crossing and everything is fine again. All right.

## Network Editing - Change traffic light type
Then one more part of netedit. And of course, this is not everything there is to it, but we'll have to make a cut somewhere. So... Let's talk about traffic lights. There are various traffic light algorithms that are part of SUMO. So they are available for selection. And when you look at traffic lights in the real world, then there are two important kinds. The static kind. So you have a fixed cycle of phases with a fixed length and all the same on every cycle. And the other kind is traffic actuation. So you have some kind of sensors, maybe induction loops or radar detectors. And depending on those detections, the duration of the phases and sometimes also the ordering of the phases are changed. When we download this network data from OpenStreetMap, there is no information regarding the type of algorithm that is actually running out there on the road. So we do something optimistic. Our web wizard does something optimistic. It sets every traffic light in the network to type actuated. So let's look at traffic lights here. With this button, you can see all the traffic lights in the network highlighted with this little symbol. And when you click on it here, you can see some properties of the traffic light. But actually, we want to see some other properties. And this is here.
So we go to use the inspect mode, inspect the intersection, and here we see the type of the traffic light. It's actuated. Which means that in the simulation, there are little detectors. And whenever there's a long queue of cars waiting here, then the phase will basically be kept open long enough to clear the queue. We can actually see these detectors in SUMO by right-clicking on the traffic lights, click on any part of these colored bars. The red is standard for the red light, the green for the green light obviously. And when you select "show detectors", you can see all these yellow rectangles here. These are automatically generated when you define actuated traffic lights. And they control the workings of the traffic light. There's actually a little color code. The green ones are active, the red ones define that there has been a request in the last red period. There's no red thing on the other one visible. All right, so having an actuated traffic light is very appropriate at a large intersection. It makes the traffic run smoothly and since we don't know the exact cycle for any of these traffic lights, they're all heuristically generated, this works much better than having a predetermined static cycle because then the phase durations are never going to work out or they're typically an ill fit.
So for here, for this intersection, we are happy with an actuated traffic light, but there are other traffic light controlled intersections like this pedestrian crossing here. So there is no real intersection here, it's just the footpath that crosses the road. And arguably this is a bug. I guess this will be fixed in the later version, but right now all the traffic lights are actuated, even this footpath, and this means if there is no foot traffic here, the light will still keep switching red very often when the queue of cars has been cleared. So this works badly here. So the thing that we want to change is we change this to static. And that's it. So a lot of talk for a single click, but at least now you know why that would be useful. Similar here, let's switch this to static and save the network.

Oh yes, and I wanted to look at signal plans really quick. What does a signal plan look like? Going to the traffic light mode. So what do we have here? A list of the phases that this traffic light is using. And we can click here or use the arrow keys to cycle through the phases of the traffic light. Obviously there's a long green phase where this direction gets the green light and a yellow phase in order for the cars to slow down or brake. Then we have the green phase for the pedestrians. And this is followed by a clearance phase because pedestrians that have entered here while the light was green still need some time to cross the road before the cars are allowed to drive again. So this looks good. And for the more complex intersections, you have more complex cycle plans. And you can edit those. For example, by changing the timings. Let's have a longer pedestrian phase here. Or by changing the lights. For example, changing the colors of the light in some particular phase. All right. So this is what I wanted to show you about network editing. Again, there are many more things. You'll have to refer to the documentation or the other tutorials to learn more about them. Then we move on to the next part of the tutorial.

## Traffic
So this concerns the traffic because for now we only talked about the network. Now let's talk about traffic. The scenario that was generated by the wizard had those random cars that were using the fastest route from a random origin to random destination. We had some public transport in the scenario where the routes and the stops and even the interval between buses or trains was loaded from OpenStreetMap. But the schedule, the actual timings, when does the train stop? Those are random and generated. Random means the one part of the timing is random and the second part where is the, well, the first stop is random and the timing of the second stop is determined by small background simulation when you run the web wizard. So you get a schedule that works out, but that is not, well, the different parts of the schedule, they don't fit together in any particular way. So it's not ideal and where you will probably want to import better public transport timings, if you can, for example, from GTFS for which there is some tooling. All right.
And for the persons, they also have a random origin and a random destination, but they were right here in this web wizard configured to use the fastest intermodal route, which means they can walk, but they can also use the public transport and even switch between modes. So for example, walk to the bus stop, ride the bus, then exit, walk to the train, stop, ride the train, get out and walk to the final destination. This is all part of the intermodal routing that was running in the background. And if you look closely at the simulation, you will notice that some persons don't make it to the end of their ride. This is because they missed the bus. And in the small scenario, the bus only runs for one hour. So if they miss that, there's no next bus. Of course, this is fixed in the larger scenario where the buses keep running and running in a cycle. But we are not going to worry about buses right now. We will do two things to get a different kind of traffic scenario. We will regenerate the cars based on counting data. And we will replace the public transport that runs on a fixed schedule with demand-responsive transport. These are two new features that I'm excited to show you.

## Traffic From Counts
So traffic from counting data. That could be counts on roads. It could also be turning counts, for example, you know that in this or that hour, so many cars turned left at a given intersection. And there are different tools that are part of SUMO to create traffic scenarios from counting data. There's the very dusty dfrouter. And there's the flowrouter tool. And what I'm going to show you is the new routeSampler tool. And its main distinction is that it works with a wide list of candidate routes to build the scenario, which can be very useful in urban scenarios because the problem of obtaining routes that fit a given, that match a given set of counts has a very, very large solution space. And it's easy to get a solution with implausible routes. And it's very hard to get these tools to avoid these implausible routes. So here I'll show you a new tool that works with a wide list. And the first thing we need to do to get this running is to get a list of routes that we deem permissible for the scenario. And then we'll select a multi-set of those routes to match our counts. And plausible routes are those that appear in a busy network. So what we can do is we just run our random traffic simulation. And we record all the routes that are used in that simulation. Most likely, the traffic that we are seeing is wrong because it's random. But the routes we are seeing, they are plausible because they are fastest routes in the traffic-filled network. So if you run this on the command line, then you will get this file `vehroutes.xml`. And this is what we'll use in the next step.

## Traffic - Fastest routes w/o traffic
And just some quick eye candy. If you look at routes in the traffic-filled network on the right and routes that are the fastest route in an empty network, you will see some changes typically for a given network. Here the key is according to the number of cars that were on each of these edges. And you can see there's some traffic. Some cars that would drive here if the network were empty. They actually use this route instead if the network is full presumably because it's difficult to pass this intersection, which is realistic in this network because it's an area we know. It's where the DLR is. And there's always a jam in this area. If you ever get to Berlin, the DLR is here.

## Netedit - Define Edge Counts
All right. So let's be quick about this. Working with the traffic folder, let's, I'll show you how to create the network data. So you entre the data mode, this is a new mode for netedit, which is pretty much built to do the kinds of things I want to show you. So let's define counts on edges. For this, we use the edgeData mode. This button here. We create a new dataSet. And we define the time range in which this dataSet is valid. And then we define data for this dataSet. And this is all very generic. So you can define all kinds of data. But right now we'll define the number of cars that have entered this edge. And then just, let's just click on some edges to set this data.
Now we have defined a count of 500 cars for each of this edges in the time from 0 to 3600, and we save the data to a file. I'll do this provisionally here, because you will find all the generated files in a different place.

## routeSampler.py
And now let's use that data to get a traffic scenario. So this again shows you how to define this. Now we run a new tool that works with the routes and the counts that we just defined to generate the set of routes that match these counts. So this is the command line for running this. Actually, you can even use a configuration file for routeSampler. So what you will find in your scenario files here is a routeSampler config file that defines this command. And if you run this, then you get a new traffic scenario. And let's see how that looks. All right. So as you probably imagined, there is traffic on these roads, but not only on these roads, but in many other parts of the simulation because, well, we used routes that cover the whole network and we selected some that were running on these edges so that each of these edges matches the count of 500. So we get traffic upstream and downstream of the definition area. All right. We can do a similar thing for turning counts. This is a different editing mode. So here, turn counts. And here, actually, the parameter is little different.
We'll define a count here. And then instead of clicking once, we have to click twice to define these counts. And using the inspect mode here, of course, we can later edit the defined values. All right. And then we run the routeSampler again. And with the new turn counts, actually, we can load both kinds of files, the edge counts and the turn counts to get traffic that obeys both types of constraints. And we get another simulation. And this time, we'll see traffic that's a bit different. As you can see now, we have traffic from different sides. Actually, I defined for the simulation, I defined the turn counts in all directions here on this intersection. So now you get traffic that matches these turn counts. Well, this is one new tool that I wanted to showcase. I hope you can make good use of it. Let's move to the second advanced part.

## Taxis (Demand Responsive Transport)
It's demand responsive transport. And here in the SUMO context, I'll just talk about taxis because this is what it technically is. It's a fleet of taxis that work with varying algorithms, including ride sharing. And so they are a way to express all kinds of demand responsive transport topics, virtual stations, real stations, pickup from door to door, all kinds of things. SUMO includes multiple algorithms for controlling such a taxi fleet. These are right now meant as an example, each of these algorithms, one algorithm for very simple driving, one for ride sharing and so on, to give you a basis for your own algorithms, which you can either add as a module in SUMO or connect via TraCI. The whole taxi complex is brand new and it's still under development. Even while doing this tutorial, I found some more issues, but you will be able to run this with 1.7.0 except for one example where you already need the development version to make it run. All right, so let's define a taxi fleet. You can actually do all this in netedit, generate all these files. Yes, I'll show you real quick how to do this. There's still a little bit of time, we'll just cut into the next section. So for this, there's the demand mode where you can define vehicle types. Let's define a taxi type. Where is it? Here. And let's define some attributes. So first of all, make sure that it has enough capacity to carry lots of persons. And then let's define the important thing that makes this into a taxi. It has a taxi device. This is the technical term for making this a taxi. And now you can define vehicles that use this type. Of course, you have to save this to a file. And so you get this kind of type definition. And then you get vehicles with this type. And you can just put them into the simulation anywhere, let them stop someplace, and then the taxi algorithm will pick up from there and make them service requests. You can find all these files in the tutorial dataset.

## Taxis Users
We also need to define persons that are allowed to ride a taxi. In the scenario so far, we generated persons that were permitted to walk and to use public transport. Walking is implicit. Persons are always allowed to do this. Now we define them with an allowed mode, intermodal-routing-mode taxi. So, you find this also in the batch file. No need to type this out. So, we generate random origin/destinations of persons that are allowed to use the taxi fleet. And now let's see what that looks like. Well, one more thing.

## Intermodal Routing
We have to make some decisions on the algorithm and the constraints. So, for example, where are the taxis allowed to pick-up and drop-off customers? And one popular choice, for demand response transport, is to use existing infrastructure. So, to have the taxis drive on demand, but let them pick up and drop off persons at the public transport stops. To reflect this choice, we run our intermodal routing with these options, we restrict the transfers to the public transport stops for pickup and for drop-off. And then we get one example that works without ride sharing. So let's look at that. So what do we have? We have the taxis, which were all entering the network here. And now they're going around and delivering persons. And the persons in blue, as you can see here, they are riding in a taxi. The persons in green are walking from or to a bus stop. And the persons in yellow are waiting at the infrastructure. So it's all running nicely. Unfortunately, it's taking quite a bit of time to get everybody to their destination with 50 taxis and 1800 persons that want to ride within the span of half an hour. And if you do the math, it just doesn't work out. There's not enough taxi fleet to serve so many persons. But they do. They do their best. And even though every person has to wait for quite a long time, they all get delivered eventually. So if you look at the statistics, they wait for more than one hour. This is bad. So there's another configuration that uses 100 taxis instead. So the waiting time is cut down to less than half an hour. No, a little more than half an hour, but it's still not good. So there's another configuration that shows you how to use another algorithm that allows ride sharing with up to two persons. And again, the waiting time is reduced. So hence also the total travel time. And if you use the development version, you can also successfully run a version with even more ride sharing, which further reduces the waiting time per person. But you'll probably have to use more taxis to service this much demand, or you have to reconfigure the persons to accept longer walks to get fewer taxi users. But all this you can do now with SUMO and I'm very excited about the future of taxi simulation.

## Taxi - Outlook
Because we do want to establish SUMO as a platform for this kind of algorithm test. And SUMO already gives you baseline algorithms now that you run your own algorithms in comparison to. There are one feature that is currently lacking is to re-dispatch taxis while they're already on route to service as a request. Right now, the ride sharing has to happen before the request is started. Also, what we want to do is we want to extend the behavior of idle taxis. Right now, you have the choice of letting them stop or having them circle the network at random. But maybe it would be good to have them drive to some dedicated service station instead, which would be configurable somehow. So we plan more options. And of course, there are lots of nitty gritty details in regard to timing. There's the time where a person reserves the ride, the time where it wants to be picked up, and the time where it's actually on the road to be picked up. And right now, we only have a single time for all these three, which we want to differentiate in the future. All right.

There are some bloopers. There is a bonus. But you'll have to look at the tutorial file to find those, because right now, we're out of time, at least if we still want to answer some questions. So thanks for listening, and talk to you right now. 

## QUESTIONS from the audience

- Can the taxi be combined with other public transport? Yes, it can. If you allow both modes, taxi and public transport, then the intermodal routing will be able to compute this kind of route.
- Can you add right-turn lanes in the left-hand traffic network? Yes. You can customize all the connections in the network. So if the automatically generated connections are not to your liking, you can change them in that area.
- Is it possible to control the matching strategy of taxis and customers? Yes. But in this case, you would hook up your own matching algorithm. So there are some TraCI calls that make this easy. But there's currently no way to combine an existing dispatch strategy with your own. You either use a SUMO algorithm or you hook up your own dispatcher.
- Which time should be written in the work hour script in the statistics file? Oh, this is a question for ActivityGen, which I would prefer to not go into detail here. Write me an email.
- If I use flow to generate vehicles, such as defining 500 vehicles per hour, does this generate uniformly or follow the Poisson distribution? So it depends. You can have both ways. If you use the attribute vehicles per hour, then you get even spacing. But you can define a probabilistic flow that will have an expected number of 500 vehicles. And it will have a certain probability in each second to generate a vehicle, which will give you something very close to the Poisson distribution.
- Is there any special tool to simulate autonomous vehicles? If so, is it a mesoscopic scale? Well, good question. I think that is asked often. Well, in a way, all cars in SUMO are autonomous because no one is driving them. The question is just, is that realistic autonomous behavior? And this is very hard to answer because there are still no standards for autonomous vehicles. Some people say they will drive with lower gaps because they have the techniques to do so. Others would argue they drive more conservative than human drivers because they have to be very safety-conscious, and maybe it will depend on the situation, whether they drive more aggressively or more conservatively, so it's very hard to have "that" autonomous vehicle, but you have various configuration parameters, where you can explore the different assumptions on how autonomous vehicles will differ from the human driver, but you will not find this in the mesoscopic simulation because it's too coarse for that. There you can drive, specify the expected flow rates, but the differences will be probably, between human autonomous drivers, will probably be on a more, on a smaller scale, on a more microscopic scale.
- Is it possible to use the same lane in both directions? If one direction has priority to pass this lane, yes. Opposite direction driving, as it's called, is one possible thing that can be activated in SUMO. Just be aware that it is not compatible with the sub-lane model at the moment, something which I'm promising to fix for years now.
- Somebody mentioned that there is counting data for the German Autobahn. Yes, I think we should look into integrating this in the wizard, but then it still won't work for all the international users that generate a scenario somewhere in Australia and would like to get real world traffic data. So it's very hard to get a global standard for this kind of counting data.

All right, I think we should move to the next session because we will still have some space to answer questions there.
