//                     usage.cc

#include "main.ih"

namespace {

char const usage1[] = R"( [options] [crontab]
Where:
   [options] - optional arguments (short options between parentheses,
               option descriptions starting with (C) can only be used
               on the command-line and are ignored when specified in the
               configuration file (see also option --config):

      --agent agent    - absolute path to the agent program providing
                         the ssh-keys (default
                         ')";

char const usage2[] = R"(')
      --config (-c) path - (C) config file containing long option 
                         specifications (default `$HOME/)";

char const usage3[] = R"(')
      --foreground     - (C) do not run as a daemon"
      --help (-h)      - (C) provide this help"
      --list (-l)      - list the currently defined cron-commands in the
                         crontab file to the standard output stream
      --log (-L) path  - log messages are appended to `path'. If "path
                         does not exist, it is created
      --mailer (-m) command - `command' is the command mailing the\n"
                         output of executed commands. Specify command a "" to
                         suppress sending e-mail (default 
                         `)";

char const usage4[] = R"(')
      --reload (-r)    - (C) reload a running )";

char const usage5[] = R"( daemon
                         with the specifications in the crontab-file
      --stdout (-s)    - (C) logged messages are also written to stdout
                         (only in combination with --foreground)
      --syslog         - write syslog messages
      --syslog-facility fac  - fac: syslog facility to use (default `)";

char const usage6[] = R"(')
      --syslog-priority pri  - pri: syslog priority to use (default `)";

char const usage7[] = R"(')
      --syslog-tag id  - id: identifier prefixed to syslog messages
                         (default `)";

char const usage8[] = R"(')
      --terminate (-t) - (C) terminate a running )";

char const usage9[] = R"(program
                         (the `crontab' file is only used to specify options)
      --uds (-u) path  - `path' is the path-name of the unix domain socket
                         (uds) file (default `$HOME/)";

char const usage10[] = R"(')
      --verbose (-V)   - logs additional information. Implies --syslog
      --version (-v)   - (C) show version information and terminate

   crontab     - crontab-like file specifying crontab commands and
                 (optional) environment variable definitions

)";

} // namespace

    // by main/argconfig

void usage(std::string const &progname)
{
    cout << "\n" <<
    progname << " by " << Icmbuild::author << "\n" <<
    progname << " V" << Icmbuild::version << " " << Icmbuild::years << "\n"
    "\n"
    "Usage: " << progname << 
                usage1  << Options::defaultAgent()          << 
                usage2  << Options::defaultConfigFile()     << 
                usage3  << Options::defaultMailer()         << 
                usage4  << progname                         <<
                usage5  << Options::defaultSyslogFacility() << 
                usage6  << Options::defaultSyslogPriority() << 
                usage7  << Options::defaultSyslogIdent()    << 
                usage8  << progname                         << 
                usage9  << Options::defaultUDS()            << 
                usage10;
}









