9.1 Fondamentaux du Codage en 'live'

# Codage en "live"

Maintenant nous en avons suffisamment appris pour commencer réellement 
à prendre du plaisir. Dans cette section, nous allons mettre en 
pratique toutes les sections précédentes et vous montrer comment 
commencer à faire vos compositions musicales en "live" et les 
transformer en interprétations. Pour cela, nous aurons besoin de trois 
ingrédients principaux :

* Une capacité à écrire du code qui produit des sons - C'est fait !
* Une capacité à écrire des fonctions - C'est fait !
* Une capacité à utiliser des threads (nommés) - C'est fait !

D'accord, allons-y. Codons en "live" nos premiers sons. En premier 
lieu, nous avons besoin d'une fonction contenant le code que nous 
voulons jouer. Commençons simple. Nous voulons aussi une boucle 
d'appels à cette fonction dans un thread :

```
define :my_loop do
  play 50
  sleep 1
end

in_thread(name: :looper) do
  loop do
    my_loop
  end
end
```

Si ça vous semble un petit peu trop compliqué, revenez en arrière et 
relisez les sections sur les fonctions et les threads. Ce n'est pas 
trop compliqué si vous avez déjà emmagasiné ces choses dans votre tête.

Ce que nous avons ici est une définition de fonction qui joue juste la 
note 50 et qui dort pendant un temps musical. Nous définissons ensuite un 
thread nommé `:looper` qui simplement boucle en appelant `my_loop` de 
manière répétitive.

Si vous exécutez ce code, vous entendrez la note 50 répétée encore 
et encore...

## Modifions-le


Maintenant, c'est là que le plaisir commence. Pendant que le code est 
*encore en cours d'exécution* changez 50 en un autre nombre, disons 55, 
ensuite pressez le bouton "Run" une nouvelle fois. Woah ! C'est modifié !
En "live" !

Une nouvelle couche n'a pas été ajoutée parce que nous avons utilisé 
des threads nommés et que seul un thread est permis pour chaque nom. En 
outre, le son a changé parce que nous *avons redéfini* la fonction. 
Nous avons donné à `:my_loop` une nouvelle définition. Quand le thread 
`:looper` a rebouclé, il a simplement appelé la nouvelle définition.

Essayez de le modifier encore, changez la note, changer la durée de 
sleep. Comment faire pour ajouter un ordre `use_synth` ? Par exemple, 
changez-le en :

```
define :my_loop do
  use_synth :tb303
  play 50, release: 0.3
  sleep 0.25
end
```

Maintenant, ça sonne plutôt intéressant, mais on peut le pimenter un 
peu plus. Au lieu de jouer la même note encore et encore, essayez de 
jouer un accord :

```
define :my_loop do
  use_synth :tb303
  play chord(:e3, :minor), release: 0.3
  sleep 0.5
end
```

Comment faire pour jouer des notes de l'accord aléatoirement :

```
define :my_loop do
  use_synth :tb303
  play choose(chord(:e3, :minor)), release: 0.3
  sleep 0.25
end
```

Ou utiliser une valeur de cutoff aléatoire :

```
define :my_loop do
  use_synth :tb303
  play choose(chord(:e3, :minor)), release: 0.2, cutoff: rrand(60, 130)
  sleep 0.25
end
```

Finalement, ajoutons quelques notes de batterie :

```
define :my_loop do
  use_synth :tb303
  sample :drum_bass_hard, rate: rrand(0.5, 2)
  play choose(chord(:e3, :minor)), release: 0.2, cutoff: rrand(60, 130)
  sleep 0.25
end
```

Maintenant, les choses commencent à devenir passionnantes !

Toutefois, avant que vous bondissiez et que vous vous lanciez dans le 
codage en "live" avec des fonctions et des threads, arrêtez ce que vous 
êtes en train de faire et lisez la section suivante sur `live_loop` qui 
va vous changer à jamais votre façon de coder dans Sonic Pi...
