1.2 Exploration de l'interface

# L'Interface de Sonic Pi 

Sonic Pi a une interface très simple pour coder de la musique. Passons
un peu de temps à l'explorer.
![Sonic Pi Interface](../images/tutorial/GUI.png)


* *A* - Contrôles de jeu
* *B* - Contrôles d'édition
* *C* - Info, Help et Prefs
* *D* - Éditeur de code
* *E* - Panneau des préférences
* *F* - Visualisateur de la trace
* *G* - Système d'aide


## A. Contrôles de jeu

Ces boutons roses sont les principaux contrôles pour démarrer et
arrêter les sons. Il y a le bouton *Run* pour exécuter le code présent
dans l'éditeur, *Stop* pour arrêter tous les codes en cours d'exécution,
*Save* pour sauvegarder le code dans un fichier externe et *Record* pour
créer un enregistrement du son (un fichier WAV) en cours de jeu.

## B. Contrôles d'édition

Ces boutons oranges vous permettent de piloter l'éditeur de code. Les
boutons *Size +* et *Size -* vous permettent d'agrandir ou de rétrécir
le texte. Le bouton *Align* vous arrangera votre code pour lui donner
une présentation plus professionnelle. 

## C. Info, Help et Prefs

Ces boutons bleus vous donnent accès à l'information, à l'aide et aux
préférences. Le bouton *Info* ouvre la fenêtre d'information qui contient
de l'information sur Sonic Pi lui-même - le noyau de l'équipe, l'historique,
les contributeurs, et la communauté. Le bouton *Help* active le système
d'aide (*G*) et le bouton *Prefs* active la fenêtre des préférences
qui vous permet de contrôler quelques paramètres systèmes basiques.

## D. Éditeur de code

C'est une zone dans laquelle vous écrirez votre code et composerez /
interpréterez de la musique. C'est un simple éditeur de texte où vous
pourrez écrire votre code, l'effacer, couper et coller, etc. Pensez
à lui comme à une version très basique de Word ou de Google Docs.
L'éditeur coloriera automatiquement les mots selon leur signification
dans le code. Ceci peut paraître étrange au début, mais vous le
trouverez vite très utile. Par exemple, vous saurez que quelque chose
est un nombre parce qu'elle sera bleue.

## E. Panneau des préférences

Sonic Pi supporte quelques préférences ajustables qui peuvent être
accédées en pressant le bouton *Prefs* à droite des boutons Info et Help.
Cela activera l'affichage du panneau des préférences qui inclut un
nombre d'options modifiables. Par exemple pour forcer le mode mono,
inverser la stéréo, activer le mode verbeux de la trace et aussi régler
un curseur de volume et le sélecteur audio du Raspberry Pi (par défaut,
il est sur "auto". Si vous n'entendez plus le son de votre Pi en étant 
branchés sur la prise jack, modifiez ce paramètre).

## F. Visualisateur de la trace

Quand vous exécutez votre code, l'information sur ce que le programme est
en train de faire est affichée dans le visualisateur de la trace. Par défaut,
vous verrez un message pour chaque son que vous créez avec l'heure exacte à
laquelle le son a été déclenché. C'est très utile pour déboguer votre code
et comprendre ce qu'il fait.

## G. Système d'aide

Finalement, un des aspects les plus importants de l'interface de Sonic Pi
est le système d'aide qui apparaît au bas de la fenêtre. Il peut être activé
ou désactivé en cliquant sur le bouton *Help* bleu. Le système d'aide
contient de l'aide et de l'information sur tous les aspects de Sonic Pi,
y compris ce tutoriel, une liste des synthétiseurs, des échantillons 
("samples"), des exemples, et des effets ("FX") disponibles, et une liste 
complète de toutes les fonctions que Sonic Pi fournit pour coder de la musique.
