6.1 Añadiendo efectos FX

# Añadiendo efectos FX

En esta sección veremos los efectos: reverberación y eco. Veremos 
cómo usarlos, controlar sus operandos y encadenarlos. Llamaremos
"FX" a los efectos.

El sistema de efectos de Sonic Pi, utiliza bloques. Así que si no
has leído la sección 5.1, deberías.

## Reverberación

Si queremos usar reverberación, escribimos `with_fx :reverb` como el
código especial para nuestro bloque, así:


```
with_fx :reverb do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

Cuando tocas este código tendrá reverberación. ¿suena bien, no?
todo suena mejor con reverberación.

Ahora veamos qué sucede si dejamos código fuera del bloque do/end:

```
with_fx :reverb do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end

sleep 1
play 55
```

Nota que el  lay `play 55` no se ejecutó con reberveración. Esto es porque
está *fuera* del bloque do/end, así que no es capturado por el FX reverberación.

Similarmente, si haces sonidos *antes* del bloque do/end, tampoco los capturará:

```
play 55
sleep 1

with_fx :reverb do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end

sleep 1
play 55
```

## Echo

Hay muchos FX (efectos) para escoger. ¿probamos con eco?

```
with_fx :echo do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

Uno de los aspectos más sobresalientes de Sonic Pi es que los bloques de 
efectos operan con parámetros similares a los utilizados con `play` y
`sample`. Por ejemplo, un parámetro interesante es `phase:` que representa
la duración de un eco dado en pulsos. Hagamos el eco más lento:


```
with_fx :echo, phase: 0.5 do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

Ahora hagamos el eco más rápido:

```
with_fx :echo, phase: 0.125 do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

Hagamos que al eco le tome 8 pulsos en desvanecerse, gracias a
`decay:`

```
with_fx :echo, phase: 0.5, decay: 8 do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

## Anidando FX

Uno de los más poderosos aspectos de los bloques de FX es que puedes
anidarlos, con lo que logramos encadenarlos con facilidad. Por ejemplo,
si quisieras tocar código con eco y después reverberación, fácilmente
pones un Fx dentro de otro:


```
with_fx :reverb do
  with_fx :echo, phase: 0.5, decay: 8 do
    play 50
    sleep 0.5
    sample :elec_blup
    sleep 0.5
    play 62
  end
end
```


Piensa en el audio fluir desde adentro. El sonido de todo el códido
dentro del bloque interno do/end como `play 50` es primero enviado
al FX de eco y a su vez, éste es enviado al FX reverberación.

Podemos hacer uso de anidados muy profundos para resultados extremos.
Sin embargo, ten presente que los Fx consumen muchos recursos y que
al anidarlos estás de hecho corriendo muchos FX simultáneamente. Así
que sé consciente de su uso, especialmente en plataformas de bajo 
rendimiento como la Raspberry Pi.


## Descubriendo FX

Sonic Pi tiene muchos efectos con los cuales jugar. Para verlos, cliquea
en FX a la izquierda de este sistema de Ayuda y verás el listado. Aquí te 
deja algunos de mis favoritos:

* wobble,
* reverb,
* echo,
* distortion,
* slicer

¡Ahora haz locuras con los FX, añadiéndolos en todas partes para crear
nuevos sonidos!
