/*
_________________________________________________________________________________________________________________________

    SDLengine core of sdlBasic



    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU Library General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Library General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    __vroby__
    __vroby__@libero.it

_________________________________________________________________________________________________________________________

*/

#include "SDLengine.h"


//_______________________________________________________________________________________________________________________

// PRINT SCREEN
//_________________________________________________________________________________________________________________________

//pen(c)								: set prints color (with -1 parameter return the current color)
//*
int pen(int c)
{
    int p2p[]={1,2,4,8,16,32,64,128,256,512};
    Uint16 i;
    int x,y;
    SDL_Color oldc;
    unsigned char z[256*14]={
0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,8,8,8,8,8,0,0,8,0,0,
0,0,0,20,20,20,0,0,0,0,0,0,0,
0,0,0,40,36,126,20,20,63,10,10,0,0,
0,0,0,8,60,10,10,28,40,40,30,8,8,
0,0,0,12,18,18,44,24,54,80,112,0,0,
0,0,0,28,4,4,12,74,82,34,92,0,0,
0,0,0,8,8,8,0,0,0,0,0,0,0,
0,0,0,8,8,4,4,4,4,4,4,8,8,
0,0,0,4,4,8,8,8,8,8,8,4,4,
0,0,0,8,42,28,62,8,0,0,0,0,0,
0,0,0,0,0,4,4,4,63,4,4,0,0,
0,0,0,0,0,0,0,0,0,8,8,4,0,
0,0,0,0,0,0,0,0,28,0,0,0,0,
0,0,0,0,0,0,0,0,0,8,8,0,0,
0,0,0,16,16,16,8,8,4,4,2,2,0,
0,0,0,28,50,34,42,34,34,50,28,0,0,
0,0,0,14,8,8,8,8,8,8,30,0,0,
0,0,0,30,32,32,48,16,8,4,62,0,0,
0,0,0,30,32,32,24,32,32,32,30,0,0,
0,0,0,24,24,20,18,18,62,16,16,0,0,
0,0,0,30,2,2,14,16,16,16,14,0,0,
0,0,0,60,6,2,30,34,34,34,28,0,0,
0,0,0,62,32,16,16,8,8,8,4,0,0,
0,0,0,28,34,34,28,34,34,34,28,0,0,
0,0,0,28,50,34,50,44,32,48,28,0,0,
0,0,0,0,0,8,8,0,0,8,8,0,0,
0,0,0,0,0,8,8,0,0,8,8,4,0,
0,0,0,0,0,32,28,3,14,48,0,0,0,
0,0,0,0,0,0,63,0,63,0,0,0,0,
0,0,0,0,0,1,14,48,28,3,0,0,0,
0,0,0,28,32,32,16,8,8,0,8,0,0,
0,0,0,0,56,68,114,74,74,74,114,4,56,
0,0,0,12,12,20,20,18,62,34,33,0,0,
0,0,0,30,34,34,30,34,34,34,30,0,0,
0,0,0,60,6,2,2,2,2,6,60,0,0,
0,0,0,14,18,34,34,34,34,18,30,0,0,
0,0,0,62,2,2,30,2,2,2,62,0,0,
0,0,0,30,2,2,30,2,2,2,2,0,0,
0,0,0,60,6,2,2,50,34,34,60,0,0,
0,0,0,34,34,34,62,34,34,34,34,0,0,
0,0,0,30,8,8,8,8,8,8,30,0,0,
0,0,0,28,16,16,16,16,16,17,15,0,0,
0,0,0,34,18,10,14,10,18,50,34,0,0,
0,0,0,2,2,2,2,2,2,2,62,0,0,
0,0,0,102,102,86,90,90,66,66,66,0,0,
0,0,0,34,38,38,42,42,42,50,50,0,0,
0,0,0,28,34,34,34,34,34,50,28,0,0,
0,0,0,30,34,34,34,30,2,2,2,0,0,
0,0,0,28,34,34,34,34,34,50,28,16,0,
0,0,0,30,34,34,34,30,18,34,98,0,0,
0,0,0,60,2,2,14,48,32,32,30,0,0,
0,0,0,63,8,8,8,8,8,8,8,0,0,
0,0,0,34,34,34,34,34,34,34,28,0,0,
0,0,0,35,34,18,18,20,20,12,12,0,0,
0,0,0,33,33,41,45,46,54,54,18,0,0,
0,0,0,34,18,20,8,12,20,18,35,0,0,
0,0,0,34,50,20,12,8,8,8,8,0,0,
0,0,0,62,48,16,8,8,4,6,62,0,0,
0,0,0,24,8,8,8,8,8,8,8,8,24,
0,0,0,2,2,4,4,8,8,16,16,16,0,
0,0,0,12,8,8,8,8,8,8,8,8,12,
0,0,0,12,20,34,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,255,
0,0,4,8,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,30,32,60,34,50,62,0,0,
0,0,0,2,2,30,34,34,34,34,30,0,0,
0,0,0,0,0,60,2,2,2,2,60,0,0,
0,0,0,32,32,60,34,34,34,34,60,0,0,
0,0,0,0,0,28,34,62,2,2,60,0,0,
0,0,0,56,8,62,8,8,8,8,8,0,0,
0,0,0,0,0,60,34,34,34,34,60,32,28,
0,0,0,2,2,30,34,34,34,34,34,0,0,
0,0,0,8,0,14,8,8,8,8,62,0,0,
0,0,0,8,0,14,8,8,8,8,8,8,6,
0,0,0,2,2,18,10,6,10,18,50,0,0,
0,0,0,7,4,4,4,4,4,4,28,0,0,
0,0,0,0,0,62,42,42,42,42,42,0,0,
0,0,0,0,0,30,34,34,34,34,34,0,0,
0,0,0,0,0,28,34,34,34,34,28,0,0,
0,0,0,0,0,30,34,34,34,34,30,2,2,
0,0,0,0,0,60,34,34,34,34,60,32,32,
0,0,0,0,0,60,4,4,4,4,4,0,0,
0,0,0,0,0,30,2,6,24,16,14,0,0,
0,0,0,8,8,62,8,8,8,8,56,0,0,
0,0,0,0,0,34,34,34,34,34,60,0,0,
0,0,0,0,0,34,18,18,20,12,12,0,0,
0,0,0,0,0,33,33,41,46,30,18,0,0,
0,0,0,0,0,50,20,12,12,20,34,0,0,
0,0,0,0,0,34,18,20,20,12,8,8,6,
0,0,0,0,0,30,16,8,4,2,30,0,0,
0,0,0,56,8,8,8,6,8,8,8,8,56,
0,0,0,8,8,8,8,8,8,8,8,8,8,
0,0,0,6,8,8,8,48,8,8,8,8,6,
0,0,0,0,0,0,6,24,0,0,0,0,0,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,126,66,66,66,66,66,66,66,66,126,
0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,8,0,0,8,8,8,8,8,0,0,
0,0,0,8,8,28,10,10,10,10,28,8,0,
0,0,0,56,4,4,4,30,4,4,62,0,0,
0,0,0,0,0,0,60,36,36,60,0,0,0,
0,0,0,34,34,20,54,62,8,8,8,0,0,
0,0,0,0,8,8,8,8,0,8,8,8,8,
0,0,0,14,2,4,10,18,20,8,16,14,0,
0,0,0,20,0,0,0,0,0,0,0,0,0,
0,0,0,0,56,124,134,134,186,68,56,0,0,
0,0,0,28,32,60,36,60,60,0,0,0,0,
0,0,0,0,0,0,36,26,18,36,0,0,0,
0,0,0,0,0,0,63,32,32,0,0,0,0,
0,0,0,0,0,0,0,0,28,0,0,0,0,
0,0,0,0,56,124,170,154,170,68,56,0,0,
0,0,0,28,0,0,0,0,0,0,0,0,0,
0,0,0,12,20,20,12,0,0,0,0,0,0,
0,0,0,0,0,4,4,63,4,0,63,0,0,
0,0,0,28,16,8,4,28,0,0,0,0,0,
0,0,0,28,16,8,16,12,0,0,0,0,0,
0,0,16,8,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,34,34,34,34,34,62,2,2,
0,0,0,60,46,46,46,40,40,40,40,40,0,
0,0,0,0,0,0,8,8,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,16,28,
0,0,0,12,8,8,8,28,0,0,0,0,0,
0,0,0,12,18,18,18,12,30,0,0,0,0,
0,0,0,0,0,0,10,52,20,10,0,0,0,
0,0,4,4,4,4,14,24,38,48,40,56,32,
0,0,4,4,4,4,14,28,24,32,16,8,56,
0,0,6,8,4,8,6,28,35,48,40,56,32,
0,0,0,8,0,8,8,4,2,2,30,0,0,
0,0,0,12,12,20,20,18,62,34,33,0,0,
0,8,0,12,12,20,20,18,62,34,33,0,0,
0,12,0,12,12,20,20,18,62,34,33,0,0,
0,40,20,24,24,28,36,36,62,66,66,0,0,
0,20,0,8,12,20,20,18,62,34,34,0,0,
0,12,20,8,12,20,20,22,62,34,35,0,0,
0,0,0,120,20,20,116,18,30,18,114,0,0,
0,0,0,60,6,2,2,2,2,6,60,16,28,
0,0,0,62,2,2,30,2,2,2,62,0,0,
0,8,0,62,2,2,30,2,2,2,62,0,0,
0,12,0,62,2,2,30,2,2,2,62,0,0,
0,20,0,62,2,2,30,2,2,2,62,0,0,
0,8,0,30,8,8,8,8,8,8,30,0,0,
0,8,0,30,8,8,8,8,8,8,30,0,0,
0,12,0,30,8,8,8,8,8,8,30,0,0,
0,20,0,30,8,8,8,8,8,8,30,0,0,
0,0,0,14,18,34,39,34,34,18,30,0,0,
0,16,28,38,38,46,42,42,58,50,50,0,0,
0,8,0,28,34,34,34,34,34,50,28,0,0,
0,8,0,28,34,34,34,34,34,50,28,0,0,
0,12,0,28,34,34,34,34,34,50,28,0,0,
40,20,0,28,34,34,34,34,34,50,28,0,0,
0,20,0,28,34,34,34,34,34,34,28,0,0,
0,0,0,0,0,2,22,12,20,50,0,0,0,
0,0,0,60,34,50,42,38,38,50,28,0,0,
0,8,0,34,34,34,34,34,34,34,28,0,0,
0,8,0,34,34,34,34,34,34,34,28,0,0,
0,28,0,34,34,34,34,34,34,34,28,0,0,
0,20,0,34,34,34,34,34,34,34,28,0,0,
0,8,0,34,50,20,12,8,8,8,8,0,0,
0,0,0,2,2,30,34,34,30,2,2,0,0,
0,0,0,14,18,10,10,10,50,34,30,0,0,
0,0,4,8,0,30,32,60,34,34,62,0,0,
0,0,16,8,0,30,32,60,34,50,62,0,0,
0,0,8,20,0,30,32,60,34,50,62,0,0,
0,0,0,28,0,30,32,60,34,50,46,0,0,
0,0,0,20,0,30,32,60,34,50,46,0,0,
0,12,20,20,8,30,32,60,34,50,46,0,0,
0,0,0,0,0,110,80,124,18,18,110,0,0,
0,0,0,0,0,60,2,2,2,2,60,16,28,
0,0,4,8,0,28,34,62,2,2,60,0,0,
0,0,16,8,0,28,34,62,2,2,60,0,0,
0,0,8,20,0,28,34,62,2,2,60,0,0,
0,0,0,20,0,28,34,62,2,2,60,0,0,
0,0,4,8,0,14,8,8,8,8,62,0,0,
0,0,16,8,0,14,8,8,8,8,62,0,0,
0,0,8,20,0,14,8,8,8,8,62,0,0,
0,0,0,20,0,14,8,8,8,8,62,0,0,
0,0,0,20,8,28,34,34,34,34,28,0,0,
0,0,0,30,0,30,34,34,34,34,34,0,0,
0,0,4,8,0,28,34,34,34,34,28,0,0,
0,0,16,8,0,28,34,34,34,34,28,0,0,
0,0,8,20,0,28,34,34,34,34,28,0,0,
0,0,0,28,0,28,34,34,34,34,28,0,0,
0,0,0,20,0,28,34,34,34,34,28,0,0,
0,0,0,0,0,4,0,63,0,4,0,0,0,
0,0,0,0,0,60,50,42,38,38,30,0,0,
0,0,6,8,0,34,34,34,34,34,60,0,0,
0,0,16,8,0,34,34,34,34,34,60,0,0,
0,0,8,20,0,34,34,34,34,34,60,0,0,
0,0,0,20,0,34,34,34,34,34,60,0,0,
0,0,16,8,0,34,18,20,20,12,8,8,6,
0,0,0,2,2,30,34,34,34,34,30,2,2,
0,0,0,0,0,0,0,0,0,0,0,0,0
	};

    if(c!=-1){
	oldc=SDLcol;
	ink(c);
	pen_color=c;


	for (i=0; i<0xff;i++){
	    SDL_FreeSurface(SDLfont_mono[i]);
	    SDLfont_mono[i]=SDL_CreateRGBSurface(SDL_HWSURFACE, 10, 13,displaybpp(),0,0,0,0);
	    SDL_FillRect(SDLfont_mono[i],NULL,paper_color);
	    Image_colorkey(SDLfont_mono[i]);

	    if (SDL_MUSTLOCK(SDLfont_mono[i]))
		SDL_LockSurface(SDLfont_mono[i]);

	    for(y=0;y<13;y++){
		for(x=0; x<10;x++){
		   if (z[i*13+y] & (1*p2p[x])){
			putpixel(SDLfont_mono[i],x,y,pen_color);
		   }
	       }
	   }
	    if (SDL_MUSTLOCK(SDLfont_mono[i]))
		SDL_UnlockSurface(SDLfont_mono[i]);
	}

	SDLcol=oldc;
	return 0;
    }
    else{
	    return pen_color;
    }
}
//*/

/*
int pen(int c)
{
    Uint16 i;
    SDL_Color oldc;


    if(c!=-1){

	oldc=SDLcol;
	ink(c);
	pen_color=c;

	font_mono = TTF_OpenFont(fontPathMono,PRINT_SIZE-1);
	if (font_mono ==0) {
	    error_description="SDLengine error - pen: Can't open monospace font. Please verify installation";
	    error_type=1;
	    SDLerr(stderr,"SDLengine error - pen: Can't open monospace font. Please verify installation.  %s\n",SDL_GetError());
	    return -1;
	}

	for (i=0; i<0xff;i++){
	    SDL_FreeSurface(SDLfont_mono[i]);
	    //SDLfont_mono[i] = TTF_RenderGlyph_Solid(font_mono,i,SDLcol); //make a problem with vertical collocation of charackters
	    SDLfont_mono[i] = TTF_RenderText_Blend(font_mono,(unsigned char *) &i,SDLcol);//solid does not work :-(

	}

	TTF_CloseFont(font_mono);
	SDLcol=oldc;
	return 0;
    }
    else{
	    return pen_color;
    }
}
//*/
//_______________________________________________________________________________________________________________________

//paper(c)								: set caractere back color (with -1 parameter return the current color)
int paper(int c)
{
	if (c!=-1){
		paper_color=c;
		return 0;
	}
	else
	{
		return paper_color;
	}
}
//_______________________________________________________________________________________________________________________

//fprints(text)								: print a text monospace without cariage return
int fprints(char *testo)
{
	int flag_cursore;
	unsigned int i,i1;
	i=0;
	flag_cursore=cursore_state[c_screen];
    	if (flag_cursore!=0)cursoff();
	for (i=0;i<strlen(testo);i++){
	    if (testo[i]==9){
		for(i1=0;i1<8;i1++){
		    put_char(32);
		}
	    }
	    else{
		put_char(testo[i]);
	    }
	}
	if (flag_cursore!=0)curson();

	if (autotimer()!=0)return -1;
	return 0;
}
//_______________________________________________________________________________________________________________________

//prints(text)								: print a text monospace
int prints(char *testo)
{
	int flag_cursore;
	unsigned int i,i1;
	i=0;
	flag_cursore=cursore_state[c_screen];
    	if (flag_cursore!=0)cursoff();
	for (i=0;i<strlen(testo);i++){
	    if (testo[i]==9){
		for(i1=0;i1<8;i1++){
		    put_char(32);
		}
	    }
	    else{
		put_char(testo[i]);
	    }
	}
	put_char(13);
	if (flag_cursore!=0)curson();

	if (autotimer()!=0)return -1;
	return 0;

}
//_______________________________________________________________________________________________________________________

//locate(x,y)								: move the cursor at x y
int locate(int x,int y)
{
	stx[c_screen]=x;
	sty[c_screen]=y;
	while(stx[c_screen]+1>(screenwidth()/XPRINT_SIZE))
	{
		if (stx[c_screen]+1>(screenwidth()/XPRINT_SIZE)){
			sty[c_screen]++;
			stx[c_screen]=stx[c_screen]-(screenwidth()/XPRINT_SIZE);
		}
	}

	while (sty[c_screen]+1>(screenheight()/(PRINT_SIZE))){
		screenswap();
		screencopy(c_screen,0,PRINT_SIZE,screenwidth(),screenheight()-(PRINT_SIZE),c_screen,0,0);
		ink(paper_color);
		bar(0,screenheight()-(PRINT_SIZE),screenwidth(),screenheight());

		sty[c_screen]=sty[c_screen]-1;
		screenswap();
	}


	if (autotimer()!=0)return -1;
	return 0;
}
//_______________________________________________________________________________________________________________________

//atx									: return x of cursor
int atx()
{
	return stx[c_screen];
}
//_______________________________________________________________________________________________________________________

//aty									: return y of cursor
int aty()
{
	return sty[c_screen];
}
//_______________________________________________________________________________________________________________________

//curson								: show the text cursor on screen at(atx,aty)
int curson()
{
    if (cursore_state[c_screen]==0){
	cursore_state[c_screen]=1;
	cursore_anim[c_screen]=0;
    }
    screenswap();
    if (autotimer()!=0)return -1;
    return 0;
}
//_______________________________________________________________________________________________________________________

//cursoff								: hide the text cursor
int cursoff()
{
    if (cursore_state[c_screen]==2){
	cursore_state[c_screen]=3;
	cursore_anim[c_screen]=0;
    }
    screenswap();
    if (autotimer()!=0)return -1;
    return 0;
}
//_______________________________________________________________________________________________________________________

//inputs(prompt,defs)							: return the string insert to keyboard(default is default text)
int inputs(char *request,char *defs)
{
    int oldautoback;
    oldautoback=autoback(-1);
    autoback(25);

	if (cursore_state[c_screen]>1)
	{
	while ((sty[c_screen]+1)>(screenheight()/(PRINT_SIZE)))
		{
			screenswap();
			screencopy(c_screen,0,PRINT_SIZE,screenwidth(),screenheight()-(PRINT_SIZE),c_screen,0,0);
			ink(paper_color);
			//bar(0,screenheight()-(PRINT_SIZE),screenwidth(),screenheight());

			sty[c_screen]=sty[c_screen]-1;
			//screenswap();
		}
		fprints(request);
		_input(defs,stx[c_screen],sty[c_screen],255);//screenwidth()/XPRINT_SIZE
		put_char(13);
	}
	else
	{
		while ((sty[c_screen]+1)>(screenheight()/(PRINT_SIZE)))
		{
			screenswap();
			screencopy(c_screen,0,PRINT_SIZE,screenwidth(),screenheight()-(PRINT_SIZE),c_screen,0,0);
			ink(paper_color);
			bar(0,screenheight()-(PRINT_SIZE),screenwidth(),screenheight());

			sty[c_screen]=sty[c_screen]-1;
			//screenswap();
		}
		fprints(request);
		curson();
		_input(defs,stx[c_screen],sty[c_screen],255);//screenwidth()/XPRINT_SIZE
		put_char(13);
		cursoff();
	}

	autoback(oldautoback);
	if (autotimer()!=0)return -1;
	return 0;
}
//_______________________________________________________________________________________________________________________

//zoneinputs(x,y,l,default)						: return the string insert to keyboard in  x,y coordinates with l lenght
int zoneinputs(int x,int y,int l,char defs[255])
{


	if (cursore_state[c_screen]==2)
	{
		_input(defs,x,y,l);
		put_char(13);
	}
	else
	{
		locate(x,y);
		curson();
		_input(defs,x,y,l);
		put_char(13);
		cursoff();
	}
	if (autotimer()!=0)return -1;
	return 0;
}
