# The Rust Edition Guide

[Introduction](introduction.md)

## What are editions?

- [What are editions?](editions/index.md)
  - [Creating a new project](editions/creating-a-new-project.md)
  - [Transitioning an existing project to a new edition](editions/transitioning-an-existing-project-to-a-new-edition.md)
  - [Advanced migrations](editions/advanced-migrations.md)

## Rust 2015

- [Rust 2015](rust-2015/index.md)

## Rust 2018

- [Rust 2018](rust-2018/index.md)
  - [Path and module system changes](rust-2018/path-changes.md)
  - [Anonymous trait function parameters deprecated](rust-2018/trait-fn-parameters.md)
  - [New keywords](rust-2018/new-keywords.md)
  - [Method dispatch for raw pointers to inference variables](rust-2018/tyvar-behind-raw-pointer.md)
  - [Cargo changes](rust-2018/cargo.md)

## Rust 2021

- [Rust 2021](rust-2021/index.md)
  - [Additions to the prelude](rust-2021/prelude.md)
  - [Default Cargo feature resolver](rust-2021/default-cargo-resolver.md)
  - [IntoIterator for arrays](rust-2021/IntoIterator-for-arrays.md)
  - [Disjoint capture in closures](rust-2021/disjoint-capture-in-closures.md)
  - [Panic macro consistency](rust-2021/panic-macro-consistency.md)
  - [Reserving syntax](rust-2021/reserving-syntax.md)
  - [Warnings promoted to errors](rust-2021/warnings-promoted-to-error.md)
  - [Or patterns in macro-rules](rust-2021/or-patterns-macro-rules.md)
  - [C-string literals](rust-2021/c-string-literals.md)
