///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// check that field::field(const& space) freeze space
//
#include "rheolef/rheolef.h"
using namespace rheolef;
using namespace std;

int
main(int argc, char** argv)
{
    if (argc != 4) {
	cerr << "usage: space_block_tst approx mesh[.geo[.gz]] domain\n";
	cerr << "ex.:   space_block_tst P1 ../data/carre top\n";
	exit(1);
    }
    geo geom(argv[2]);

    space V = space(geom, argv[1]);
    V.block(argv[3]);

    field u(V);
    if (u.u.size() == 0) {
	cerr << "space_block_tst: space may be froozen after field constructor.\n";
	exit(1);
    }
    return 0;
}
