///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
namespace rheolef { 

// get elem(i): return (i,xi) or (-1, 0.0)
// NOTE: suppose row is sorted by increasing indexes
template <class T>
pair<csr<T>::size_type,T> 
csr<T>::const_row::operator() (size_type i) const
{
    csr<T>::const_row::const_iterator iter = csr<T>::const_row::begin();
    csr<T>::const_row::const_iterator last = csr<T>::const_row::end();
    while (iter != last && (*iter).first <= i) {
	if ((*iter).first == i) return *iter;
        ++iter;
    }
    return pair<size_type,T>(size_type(-1),T());
}
template <class T>
void
csr<T>::row::reset ()
{
    csr<T>::row::iterator iter = begin();
    csr<T>::row::iterator last = end();
    while (iter != last) {
	insert  (iter, pair<size_type,T>((*iter).first, T()));
	++iter;
    }
}
}// namespace rheolef
