// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2024 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from ServiceAuthorization.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.security {
  public class ServiceAuthorization : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("security.ServiceAuthorization:1.0.0", null);

    public ServiceAuthorization(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public ServiceAuthorization(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new ServiceAuthorization StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new ServiceAuthorization(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_PASSWORD_INVALID = 1;

    public class SetPasswordResult {
      public int _ret_;
    }

    public SetPasswordResult setPassword(string service, string password) {
      var _parameters = new LightJson.JsonObject();
      _parameters["service"] = service;
      _parameters["password"] = password;

      var _result = RpcCall("setPassword", _parameters);
      var _ret = new SetPasswordResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setPassword(string service, string password, AsyncRpcResponse<SetPasswordResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setPassword(service, password, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setPassword(string service, string password, AsyncRpcResponse<SetPasswordResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["service"] = service;
        _parameters["password"] = password;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setPassword", _parameters,
        _result => {
          try {
            var _ret = new SetPasswordResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
