#lang typed/racket

(: convert-it (Any -> (HashTable Symbol Number)))
(define (convert-it a)
  (if (hash? a)
      (begin
        (hash-ref a 3)
        (hash-has-key? a 3)
        (ann (hash-remove a 3) HashTableTop)
        (hash-remove! a 3)
        (length (hash-map a (lambda: ([x : Any] [y : Any]) x)))
        (hash-for-each a (lambda: ([x : Any] [y : Any]) (display x)))
        (add1 (hash-count a))
        (length (hash-keys a))
        (length (hash-values a))
        (length (hash->list a))
        (for ([(k v) (in-hash a)])
          (display k))
        (for/hash: : (HashTable Symbol Number) ([v (in-hash-values a)])
          (values 'x 1))
        (for/hash: : (HashTable Symbol Number) ([k (in-hash-keys a)])
          (values 'x 1)))
      (error 'convert-it "not a hash ~s" a)))
