% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/httpbin.R
\name{httpbin_app}
\alias{httpbin_app}
\title{Generic web app for testing HTTP clients}
\usage{
httpbin_app(log = interactive())
}
\arguments{
\item{log}{Whether to log requests to the standard output.}
}
\value{
A \code{webfakes_app}.
}
\description{
A web app similar to \url{https://httpbin.org}.
See \href{https://webfakes.r-lib.org/httpbin.html}{its specific docs}.
You can also see these docs locally, by starting the app:\if{html}{\out{<div class="r">}}\preformatted{httpbin <- new_app_process(httpbin_app())
browseURL(httpbin$url())
}\if{html}{\out{</div>}}
}
\examples{
app <- httpbin_app()
proc <- new_app_process(app)
url <- proc$url("/get")
resp <- curl::curl_fetch_memory(url)
curl::parse_headers_list(resp$headers)
cat(rawToChar(resp$content))
proc$stop()
}
