% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{set_unitizer}
\alias{set_unitizer}
\alias{get_unitizer}
\alias{get_unitizer.character}
\alias{get_unitizer.default}
\alias{get_unitizer.unitizer_result}
\alias{get_unitizer.unitizer_results}
\title{Set and Retrieve Store Contents}
\usage{
set_unitizer(store.id, unitizer)

get_unitizer(store.id)

\method{get_unitizer}{character}(store.id)

\method{get_unitizer}{default}(store.id)

\method{get_unitizer}{unitizer_result}(store.id)

\method{get_unitizer}{unitizer_results}(store.id)
}
\arguments{
\item{store.id}{a filesystem path to the store (an .rds file)}

\item{unitizer}{a \code{unitizer-class} object containing the store
data}
}
\value{
\itemize{
    \item set_unitizer TRUE if unitizer storing worked, error otherwise
    \item get_unitizer a \code{unitizer-class} object, FALSE
      if \code{store.id} doesn't exist yet, or error otherwise; note that
      the \code{unitizer_results} method returns a list
  }
}
\description{
These functions are not used directly; rather, they are used by
\code{\link{unitize}} to get and set the \code{unitizer} objects.
You should only need to understand these functions if you are
looking to implement a special storage mechanism for the \code{unitizer}
objects.
}
\details{
By default, only a character method is defined, which will interpret
its inputs as a filesystem path to the \code{unitizer} folder.  RDSes of
serialization type 2 will be stored and retrieved from there.  The
serialization format may change in the future, but if R maintains
facilities to read/write type 2, we will provide the option to use
that format.  At this time there is no API to change the serialization
format.

You may write your own methods for special storage situations (
e.g SQL database, ftp server, etc) with the understanding that the
getting method may only accept one argument, the \code{store.id}, and
the setting method only two arguments, the \code{store.id} and the
\code{unitizer}.

S3 dispatch will be on \code{store.id}, and \code{store.id} may
be any R object that identifies the unitizer.  For example, a potential
SQL implementation where the unitizers get stored in blobs may look
like so:
\preformatted{
my.sql.store.id <- structure(
  list(
    server="myunitizerserver.mydomain.com:3306",
    database="unitizers",
    table="project1",
    id="cornercasetests"
  ),
  class="sql_unitizer"
)
get_unitizer.sql_unitizer <- function(store.id) { # FUNCTION BODY }
set_unitizer.sql_unitizer <- function(store.id, unitizer) { # FUNCTION BODY }

unitize("unitizer/cornertestcases.R", my.sql.store.id)
}
Make sure you also define an \code{as.character} method for your object to
produce a human readable identifying string.

For inspirations for the bodies of the _store functions look at the source
code for \code{unitizer:::get_unitizer.character} and
\code{unitizer:::set_unitizer.character}.
Expectations for the functions are as follows.  \code{get_unitizer} must:
\itemize{
  \item return a \code{unitizer-class} object if \code{store.id}
     exists and contains a valid object
  \item return FALSE if the object doesn't exist (e.g. first time
    run-through, so reference copy doesn't exist yet)
  \item \code{\link{stop}} on error
}
\code{set_unitizer} must:
\itemize{
  \item return TRUE on success
  \item \code{\link{stop}} on error
}
}
\seealso{
\code{\link{saveRDS}}
}
