% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_clusterprop.R
\name{collection_clusterprop}
\alias{collection_clusterprop}
\title{Add, edit, delete a cluster-wide property}
\usage{
collection_clusterprop(conn, name, val, raw = FALSE, callopts = list())
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{name}{(character) Name of the core or collection}

\item{val}{(character) Required. The value of the property. If the value is
empty or null, the property is unset.}

\item{raw}{(logical) If \code{TRUE}, returns raw data in format specified by
\code{wt} param}

\item{callopts}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Important: whether add, edit, or delete is used is determined
by the value passed to the \code{val} parameter. If the property name is
new, it will be added. If the property name exists, and the value is
different, it will be edited. If the property name exists, and the value
is \code{NULL} or empty the property is deleted (unset).
}
\examples{
\dontrun{
(conn <- SolrClient$new())

# add the value https to the property urlScheme
collection_clusterprop(conn, name = "urlScheme", val = "https")

# status again
collection_clusterstatus(conn)$cluster$properties

# delete the property urlScheme by setting val to NULL or a 0 length string
collection_clusterprop(conn, name = "urlScheme", val = "")
}
}
