% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdal_utils.R
\name{gdal_utils}
\alias{gdal_utils}
\title{Native interface to gdal utils}
\usage{
gdal_utils(util = "info", source, destination, options = character(0),
  quiet = FALSE, processing = character(0),
  colorfilename = character(0))
}
\arguments{
\item{util}{character; one of \code{info}, \code{warp}, \code{rasterize}, \code{translate}, \code{vectortranslate}, \code{buildvrt}, \code{demprocessing}, \code{nearblack}, \code{grid}}

\item{source}{character; name of input layer(s); for \code{warp} or \code{buidvrt} this can be more than one}

\item{destination}{character; name of output layer}

\item{options}{character; raster layer read options}

\item{quiet}{logical; if \code{TRUE}, suppress printing of output for \code{info}}

\item{processing}{character; processing options for \code{demprocessing}}

\item{colorfilename}{character; name of color file for \code{demprocessing} (mandatory if \code{processing="color-relief"})}
}
\value{
\code{info} returns a character vector with the raster metadata; all other utils return (invisibly) a logical indicating success (i.e., \code{TRUE}); in case of failure, an error is raised.
}
\description{
Native interface to gdal utils
}
