% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{NNPlot}
\alias{NNPlot}
\title{Highlight Neighbors in DimPlot}
\usage{
NNPlot(
  object,
  reduction,
  nn.idx,
  query.cells,
  dims = 1:2,
  label = FALSE,
  label.size = 4,
  repel = FALSE,
  sizes.highlight = 2,
  pt.size = 1,
  cols.highlight = c("#377eb8", "#e41a1c"),
  na.value = "#bdbdbd",
  order = c("self", "neighbors", "other"),
  show.all.cells = TRUE,
  ...
)
}
\arguments{
\item{object}{Seurat object}

\item{reduction}{Which dimensionality reduction to use. If not specified, first searches for umap, then tsne, then pca}

\item{nn.idx}{the neighbor index of all cells}

\item{query.cells}{cells used to find their neighbors}

\item{dims}{Dimensions to plot, must be a two-length numeric vector specifying x- and y-dimensions}

\item{label}{Whether to label the clusters}

\item{label.size}{Sets size of labels}

\item{repel}{Repel labels}

\item{sizes.highlight}{Size of highlighted cells; will repeat to the length
groups in cells.highlight}

\item{pt.size}{Adjust point size for plotting}

\item{cols.highlight}{A vector of colors to highlight the cells as; will
repeat to the length groups in cells.highlight}

\item{na.value}{Color value for NA points when using custom scale}

\item{order}{Specify the order of plotting for the idents. This can be
useful for crowded plots if points of interest are being buried. Provide
either a full list of valid idents or a subset to be plotted last (on top)}

\item{show.all.cells}{Show all cells or only query and neighbor cells}

\item{...}{Extra parameters passed to \code{DimPlot}}
}
\value{
A \code{\link[patchwork]{patchwork}ed} ggplot object if
\code{combine = TRUE}; otherwise, a list of ggplot objects
}
\description{
It will color the query cells and the neighbors of the query cells in the
DimPlot
}
\concept{visualization}
