% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-pvalue.R
\name{label_pvalue}
\alias{label_pvalue}
\alias{pvalue_format}
\alias{pvalue}
\title{Label p-values (e.g. <0.001, 0.25, p >= 0.99)}
\usage{
label_pvalue(accuracy = 0.001, decimal.mark = ".", prefix = NULL,
  add_p = FALSE)

pvalue_format(accuracy = 0.001, decimal.mark = ".", prefix = NULL,
  add_p = FALSE)

pvalue(x, accuracy = 0.001, decimal.mark = ".", prefix = NULL,
  add_p = FALSE)
}
\arguments{
\item{accuracy}{A number to round to. Use (e.g.) \code{0.01} to show 2 decimal
places of precision. If \code{NULL}, the default, uses a heuristic that should
ensure breaks have the minimum number of digits needed to show the
difference between adjacent values.

Applied to rescaled data.}

\item{decimal.mark}{The character to be used to indicate the numeric
decimal point.}

\item{prefix}{A character vector of length 3 giving the prefixes to
put in front of numbers. The default values are \code{c("<", "", ">")}
if \code{add_p} is \code{TRUE} and \code{c("p<", "p=", "p>")} if \code{FALSE}.}

\item{add_p}{Add "p=" before the value?}

\item{x}{A numeric vector to format.}
}
\value{
All \code{label_()} functions return a "labelling" function, i.e. a function that
takes a vector \code{x} and returns a character vector of \code{length(x)} giving a
label for each input value.

Labelling functions are designed to be used with the \code{labels} argument of
ggplot2 scales. The examples demonstrate their use with x scales, but
they work similarly for all scales, including those that generate legends
rather than axes.
}
\description{
Formatter for p-values, using "<" and ">" for p-values close to 0 and 1.
}
\section{Old interface}{

\code{pvalue()} and \code{pvalue_dollar()} are retired; please use \code{label_pvalue()}
instead.
}

\examples{
demo_continuous(c(0, 1))
demo_continuous(c(0, 1), labels = label_pvalue())
demo_continuous(c(0, 1), labels = label_pvalue(accuracy = 0.1))
demo_continuous(c(0, 1), labels = label_pvalue(add_p = TRUE))

# Or provide your own prefixes
prefix <- c("p < ", "p = ", "p > ")
demo_continuous(c(0, 1), labels = label_pvalue(prefix = prefix))
}
\seealso{
Other labels for continuous scales: \code{\link{label_bytes}},
  \code{\link{label_dollar}},
  \code{\link{label_number_auto}},
  \code{\link{label_number_si}},
  \code{\link{label_ordinal}}, \code{\link{label_parse}},
  \code{\link{label_percent}},
  \code{\link{label_scientific}}
}
\concept{labels for continuous scales}
