% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statuses.R
\name{lookup_tweets}
\alias{lookup_tweets}
\alias{lookup_statuses}
\title{Get tweets data for given statuses (status IDs).}
\usage{
lookup_tweets(
  statuses,
  parse = TRUE,
  token = NULL,
  retryonratelimit = NULL,
  verbose = TRUE
)
}
\arguments{
\item{statuses}{User id or screen name of target user.}

\item{parse}{If \code{TRUE}, the default, returns a tidy data frame. Use \code{FALSE}
to return the "raw" list corresponding to the JSON returned from the
Twitter API.}

\item{token}{Use this to override authentication for
a single API call. In many cases you are better off changing the
default for all calls. See \code{\link[=auth_as]{auth_as()}} for details.}

\item{retryonratelimit}{If \code{TRUE}, and a rate limit is exhausted, will wait
until it refreshes. Most Twitter rate limits refresh every 15 minutes.
If \code{FALSE}, and the rate limit is exceeded, the function will terminate
early with a warning; you'll still get back all results received up to
that point. The default value, \code{NULL}, consults the option
\code{rtweet.retryonratelimit} so that you can globally set it to \code{TRUE},
if desired.

If you expect a query to take hours or days to perform, you should not
rely solely on \code{retryonratelimit} because it does not handle other common
failure modes like temporarily losing your internet connection.}

\item{verbose}{Show progress bars and other messages indicating current
progress?}
}
\value{
A tibble of tweets data.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\references{
\url{https://developer.twitter.com/en/docs/twitter-api/v1/tweets/post-and-engage/api-reference/get-statuses-lookup}
}
\seealso{
\code{\link[=tweet_search_recent]{tweet_search_recent()}}, \code{\link{rtweet-deprecated}}

Other tweets: 
\code{\link{get_favorites}()},
\code{\link{get_mentions}()},
\code{\link{get_timeline}()},
\code{\link{lists_statuses}()},
\code{\link{search_tweets}()}
}
\concept{tweets}
