% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{collapseCategoricalCells}
\alias{collapseCategoricalCells}
\title{Collapse small sample size categorical frequency counts}
\usage{
collapseCategoricalCells(observed, expected, minExpected = 1)
}
\arguments{
\item{observed}{the observed frequency table}

\item{expected}{the expected frequency table}

\item{minExpected}{the minimum expected cell frequency

Pearson's X^2 test requires some minimum frequency per cell to
avoid an inflated false positive rate. This function will merge
cells with the lowest frequency counts until all the counts are
above the minimum threshold. Cells that have been merged are filled
with NAs. The resulting tables and number of merged cells is
returned.}
}
\description{
Collapse small sample size categorical frequency counts
}
\examples{
O = matrix(c(7,31,42,20,0), 1,5)
E = matrix(c(3,39,50,8,0), 1,5)
collapseCategoricalCells(O,E,9)
}
