% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reprex-locale.R
\name{reprex_locale}
\alias{reprex_locale}
\title{Render a reprex in a specific locale}
\usage{
reprex_locale(..., language = "en", locale = NULL)
}
\arguments{
\item{...}{Inputs passed through to \code{\link[=reprex]{reprex()}}.}

\item{language}{A string specifying the preferred language for messages. It
is enacted via the \code{LANGUAGE} environment variable, for the duration of the
\code{reprex()} call. Examples: \code{"en"} for English and \code{"fr"} for French. See
Details for more.}

\item{locale}{A named character vector, specifying aspects of the locale, in
the \code{\link[=Sys.setlocale]{Sys.setlocale()}} sense. It is enacted by setting one or more
environment variables, for the duration of the \code{reprex()} call. See Details
for more.}
}
\value{
Character vector of rendered reprex, invisibly.
}
\description{
Render a \code{\link[=reprex]{reprex()}}, with control over the localization of error messages and
aspects of the locale. Note that these are related but distinct issues!
Typical usage is for someone on a Spanish system to create a reprex that is
easier for an English-speaking audience to follow.
}
\section{\code{language}}{

Use the \code{language} argument to express the preferred language of error
messages. The output of \code{dir(system.file(package = "translations"))} may
provide some helpful ideas. The \code{language} should generally follow "XPG
syntax": a two-letter language code, optionally followed by other modifiers.

Examples: \code{"en"}, \code{"de"}, \code{"en_GB"}, \code{"pt_BR"}.
}

\section{\code{locale}}{

Use the \code{locale} argument only if you want to affect something like how
day-of-the-week or month is converted to character. You are less likely to
need to set this than the \code{language} argument. You may have more success
setting specific categories, such as \code{"LC_TIME"}, than multi-category
shortcuts like \code{"LC_ALL"} or \code{"LANG"}. The \code{locale} values must follow the
format dictated by your operating system and the requested locale must be
installed. On *nix systems, \code{locale -a} is a good way to see which locales
are installed. Note that the format for \code{locale} and \code{language} are different
from each other on Windows.

Examples: \code{"en_CA.UTF-8"} (macOS), \code{"French_France.1252"} (Windows).
}

\examples{
\dontrun{

# if all you want to do is make sure messages are in English
reprex_locale("a" / 2)

# change messages to a specific language
reprex_locale({
  "a" / 2
}, language = "it")

reprex_locale({
  "a" / 2
}, language = "fr_CA")

reprex_locale({
  "a" / 2
}, language = "pt_BR")

# get day-of-week and month to print in French (not Windows)
reprex_locale({
  format(as.Date(c("2019-01-01", "2019-02-01")), "\%a \%b \%d")
}, locale = c(LC_TIME = "fr_FR"))

# get day-of-week and month to print in French (Windows)
# assumes that the relevant language is installed on the system
# LC_TIME can also be specified as "French" or "French_France" here
 reprex_locale({
   format(as.Date(c("2019-01-01", "2019-02-01")), "\%a \%b \%d")
 }, locale = c(LC_TIME = "French_France.1252"))
}
}
\seealso{
\itemize{
\item The \href{https://www.gnu.org/software/libc/manual/html_node/Locale-Names.html}{Locale Names}
section of the GNU C docs, for more about XPG syntax
\item The \href{https://cran.r-project.org/doc/manuals/r-patched/R-admin.html#Internationalization}{Internationalization and Localization}
section of the R Installation and Administration manual
}
}
