% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaries.R
\name{print.mvr}
\alias{print.mvr}
\alias{summary.mvr}
\alias{print.mvrVal}
\title{Summary and Print Methods for PLSR and PCR objects}
\usage{
\method{print}{mvr}(x, ...)

\method{summary}{mvr}(
  object,
  what = c("all", "validation", "training"),
  digits = 4,
  print.gap = 2,
  ...
)

\method{print}{mvrVal}(x, digits = 4, print.gap = 2, ...)
}
\arguments{
\item{x, object}{an \code{mvr} object}

\item{\dots}{Other arguments sent to underlying methods.}

\item{what}{one of \code{"all"}, \code{"validation"} or \code{"training"}}

\item{digits}{integer.  Minimum number of significant digits in the output.
Default is 4.}

\item{print.gap}{Integer.  Gap between coloumns of the printed tables.}
}
\value{
\code{print.mvr} and \code{print.mvrVal} return the object
invisibly.
}
\description{
Summary and print methods for \code{mvr} and \code{mvrVal} objects.
}
\details{
If \code{what} is \code{"training"}, the explained variances are given; if
it is \code{"validation"}, the cross-validated RMSEPs (if available) are
given; if it is \code{"all"}, both are given.
}
\examples{

data(yarn)
nir.mvr <- mvr(density ~ NIR, ncomp = 8, validation = "LOO", data = yarn)
nir.mvr
summary(nir.mvr)
RMSEP(nir.mvr)

}
\seealso{
\code{\link{mvr}}, \code{\link{pcr}}, \code{\link{plsr}},
\code{\link{RMSEP}}, \code{\link{MSEP}}
}
\author{
Ron Wehrens and Bjørn-Helge Mevik
}
\keyword{multivariate}
\keyword{regression}
