##' Run SAS code like in the following:
##'
##' ODS CSVALL BODY="myest.csv";
##' proc nlmixed data=aj qpoints=2 dampstep=0.5;
##' ...
##' run;
##' ODS CSVALL Close;
##'
##' and read results into R with:
##'
##' \code{getsas("myest.csv","Parameter Estimates")}
##'
##' @title Read SAS output
##' @param infile file (csv file generated by ODS)
##' @param entry Name of entry to capture
##' @param \dots additional arguments to lower level functions
##' @author Klaus K. Holst
##' @export
##' @seealso getMplus
getSAS <- function(infile,entry="Parameter Estimates",...) {
  con <- file(infile, blocking = FALSE)
  inp <- readLines(con)
  close(con)
  nullstring <- 0
  linestart <- 1; lineend <- length(inp)
  ##  mycmd1 <- paste0("grep -n \"",entry,"\" ", csvfile);  a1 <- system(mycmd1,intern=TRUE);
  ##  linestart <- char2num(strsplit(a1,":")[[1]][1])
  idx <- sapply(inp,function(x) length(grep(entry, x))>0)
  if (sum(idx)==1) {
    linestart <- which(idx)
    for (i in seq(linestart,length(inp))) {
      lineend <- i-1
      ##      if (inp[i]==inp[i-1]) break;
      if (inp[i]=="") break;
    }
  } else {
    stop("No match or duplicate entries!")
  }
  subinp <- inp[(linestart+1):(lineend)]
  con <- textConnection(subinp)
  res <- read.csv(con,header=TRUE)
  close(con)
  return(res)
}
