% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R
\name{sample_gnp}
\alias{sample_gnp}
\alias{gnp}
\title{Generate random graphs according to the \eqn{G(n,p)} Erdős-Rényi model}
\usage{
sample_gnp(n, p, directed = FALSE, loops = FALSE)

gnp(...)
}
\arguments{
\item{n}{The number of vertices in the graph.}

\item{p}{The probability for drawing an edge between two
arbitrary vertices (\eqn{G(n,p)} graph).}

\item{directed}{Logical, whether the graph will be directed, defaults to
\code{FALSE}.}

\item{loops}{Logical, whether to add loop edges, defaults to \code{FALSE}.}

\item{...}{Passed to \code{sample_gnp()}.}
}
\value{
A graph object.
}
\description{
Every possible edge is created independently with the same probability \code{p}.
This model is also referred to as a Bernoulli random graph since the
connectivity status of vertex pairs follows a Bernoulli distribution.
}
\details{
The graph has \code{n} vertices and each pair of vertices is connected
with the same probability \code{p}. The \code{loops} parameter controls whether
self-connections are also considered. This model effectively constrains
the average number of edges, \eqn{p m_\text{max}}, where \eqn{m_\text{max}}
is the largest possible number of edges, which depends on whether the
graph is directed or undirected and whether self-loops are allowed.
}
\examples{

g <- sample_gnp(1000, 1 / 1000)
degree_distribution(g)
}
\references{
Erdős, P. and Rényi, A., On random graphs, \emph{Publicationes
Mathematicae} 6, 290--297 (1959).
}
\seealso{
Random graph models (games)
\code{\link{erdos.renyi.game}()},
\code{\link{sample_bipartite}()},
\code{\link{sample_correlated_gnp_pair}()},
\code{\link{sample_correlated_gnp}()},
\code{\link{sample_degseq}()},
\code{\link{sample_dot_product}()},
\code{\link{sample_fitness_pl}()},
\code{\link{sample_fitness}()},
\code{\link{sample_forestfire}()},
\code{\link{sample_gnm}()},
\code{\link{sample_grg}()},
\code{\link{sample_growing}()},
\code{\link{sample_hierarchical_sbm}()},
\code{\link{sample_islands}()},
\code{\link{sample_k_regular}()},
\code{\link{sample_last_cit}()},
\code{\link{sample_pa_age}()},
\code{\link{sample_pa}()},
\code{\link{sample_pref}()},
\code{\link{sample_sbm}()},
\code{\link{sample_smallworld}()},
\code{\link{sample_traits_callaway}()},
\code{\link{sample_tree}()},
\code{\link{sample_}()}

Random graph models (games)
\code{\link{erdos.renyi.game}()},
\code{\link{sample_bipartite}()},
\code{\link{sample_correlated_gnp_pair}()},
\code{\link{sample_correlated_gnp}()},
\code{\link{sample_degseq}()},
\code{\link{sample_dot_product}()},
\code{\link{sample_fitness_pl}()},
\code{\link{sample_fitness}()},
\code{\link{sample_forestfire}()},
\code{\link{sample_gnm}()},
\code{\link{sample_grg}()},
\code{\link{sample_growing}()},
\code{\link{sample_hierarchical_sbm}()},
\code{\link{sample_islands}()},
\code{\link{sample_k_regular}()},
\code{\link{sample_last_cit}()},
\code{\link{sample_pa_age}()},
\code{\link{sample_pa}()},
\code{\link{sample_pref}()},
\code{\link{sample_sbm}()},
\code{\link{sample_smallworld}()},
\code{\link{sample_traits_callaway}()},
\code{\link{sample_tree}()},
\code{\link{sample_}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{games}
\keyword{graphs}
