% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-whole-number.R
\name{chk_whole_number}
\alias{chk_whole_number}
\alias{vld_whole_number}
\title{Check Whole Number}
\usage{
chk_whole_number(x, x_name = NULL)

vld_whole_number(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if non-missing integer scalar or double equivalent using

\code{vld_number(x) && (is.integer(x) || vld_true(all.equal(x, trunc(x))))}

\strong{Pass}: \code{1}, \code{2L}, \code{1e10}, \code{-Inf}

\strong{Fail}: \code{"a"}, \code{1:3}, \code{NA_integer_}, \code{log(10)}
}
\section{Functions}{
\itemize{
\item \code{vld_whole_number()}: Validate Whole Number

}}
\examples{
# chk_whole_number
chk_whole_number(2)
try(chk_whole_number(1.1))
# vld_whole_number
vld_whole_number(2)
}
\seealso{
Other chk_scalars: 
\code{\link{chk_date_time}()},
\code{\link{chk_date}()},
\code{\link{chk_number}()},
\code{\link{chk_scalar}()},
\code{\link{chk_string}()},
\code{\link{chk_tz}()}
}
\concept{chk_scalars}
