"procuste.randtest" <- function(df1, df2, nrepet=999) {
    if (!is.data.frame(df1)) 
        stop("data.frame expected")
    if (!is.data.frame(df2)) 
        stop("data.frame expected")
    l1 <- nrow(df1)
    if (nrow(df2) != l1) 
        stop("Row numbers are different")
    if (any(row.names(df2) != row.names(df1))) 
        stop("row names are different")
    X <- scale(df1, scale = FALSE)
    Y <- scale(df2, scale = FALSE)
    var1 <- apply(X, 2, function(x) sum(x^2))
    var2 <- apply(Y, 2, function(x) sum(x^2))
    tra1 <- sum(var1)
    tra2 <- sum(var2)
    X <- X/sqrt(tra1)
    Y <- Y/sqrt(tra2)
    lig<-nrow(X)
    c1<-ncol(X)
    c2<-ncol(Y)
    isim<-testprocuste(nrepet, lig, c1, c2, as.matrix(X), as.matrix(Y))
    obs<-isim[1]
    return(as.randtest(isim[-1],obs,call=match.call()))
}
