% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringConvenience.R
\name{buildCodesetAnnotation}
\alias{buildCodesetAnnotation}
\title{Build NanoString codeset annotation}
\usage{
buildCodesetAnnotation(rlf = NULL, cdrDesignData = NULL,
  removeRedundantCols = TRUE, addEgAnnotations = FALSE)
}
\arguments{
\item{rlf}{Path to the RLF file}

\item{cdrDesignData}{Path to a manually prepared .CSV export of the
"Design Data" tab of the CDR file (optional;
see 'details' section below for how the export
should be prepared)}

\item{removeRedundantCols}{Logical. If TRUE, cols in the CDR that are redundant
with those in the RLF will be omitted from the output.}

\item{addEgAnnotations}{Logical indicating whether or not to add
EntrezGene IDs and HGNC symbols from the
org.Hs.eg.db package.}
}
\value{
A data frame whose content is the combination of the NanoString-provided
codeset annotation with gene annotation in the org.Hs.eg.db package.
}
\description{
This function returns a data frame whose content is the combination of
                the NanoString-provided codeset annotation (.RLF file and the
                "Design Data" tab of the CDR spreadsheet) with gene annotation in the
                org.Hs.eg.db package.
}
\details{
The original NanoString provided .RLF file is expected as input. This
file is the master (i.e. only probes listed here will be annotated;
any extra ones in the CDR export will be dropped). If
the CDR "Design Data" .CSV is specified, the function expects this .CSV
file to be generated from the "Design Data" tab of the original NanoString
provided Excel CDR file. This tab needs to be trimmed by skipping the
NanoString header and first column containing only integers;
the resulting .CSV should contain the actual table (including its header
-- beginning with "Customer Identifier"). The function will match and
join the .RLF and CDR .CSV using their "ProbeID" and "NSID" fields, and
then it will add gene annotation (EntrezGene ID, HGNC symbol, and
chromosomal position) by doing lookups in the org.Hs.eg.db package using
the RefSeq accessions from the RLF.
}
\examples{
rlf <- system.file("extdata", "RLF", "NQCP_example.rlf", package="NanoStringQCPro")
cdrDesignData <- system.file("extdata", "CDR", "CDR-DesignData.csv", package="NanoStringQCPro")
annot <- buildCodesetAnnotation(rlf, cdrDesignData)

}
\author{
Dorothee Nickles, Robert Ziman
}
