% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colRanks.R, R/rowRanks.R
\name{colRanks,DelayedMatrix-method}
\alias{colRanks,DelayedMatrix-method}
\alias{rowRanks,DelayedMatrix-method}
\title{Calculates the rank of the elements for each row (column) of a matrix-like
object}
\usage{
\S4method{colRanks}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  ties.method = c("max", "average", "first", "last", "random", "max", "min", "dense"),
  preserveShape = FALSE,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)

\S4method{rowRanks}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  ties.method = c("max", "average", "first", "last", "random", "max", "min", "dense"),
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)
}
\arguments{
\item{x}{A NxK \linkS4class{DelayedMatrix}.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{ties.method}{A character string specifying how ties are treated. Note
that the default specifies fewer options than the original matrixStats
package.}

\item{preserveShape}{If \code{TRUE} the output matrix has the same shape as the
input x. Note, that this is not a generic argument and not all
implementation of this function have to provide it.}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set.}
}
\value{
a matrix of type \code{\link{integer}} is returned unless
\code{ties.method = "average"}. Ithas dimensions` \code{NxJ} (\code{KxJ})
\code{\link{matrix}}, where N (K) is the number of rows (columns) of the
input x.
}
\description{
Calculates the rank of the elements for each row (column) of a matrix-like
object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowRanks}} /
\code{matrixStats::\link[matrixStats]{colRanks}}.

The \code{matrixStats::rowRanks()} function can handle a lot of different
values for the \code{ties.method} argument. Users of the generic function
should however only rely on \code{max} and \code{average} because the other ones
are not guaranteed to be implemented:
\describe{
\item{\code{max}}{for values with identical values the maximum rank is
returned}
\item{\code{average}}{for values with identical values the average of the
ranks they cover is returned. Note, that in this case the return
value is of type \code{numeric}.}
}
}
\examples{
# A DelayedMatrix with a 'Matrix' seed
dm_Matrix <- DelayedArray(Matrix::Matrix(c(rep(1L, 5),
                                           as.integer((0:4) ^ 2),
                                           seq(-5L, -1L, 1L)),
                                         ncol = 3))

colRanks(dm_Matrix)

rowRanks(dm_Matrix)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowRanks}()} and
\code{matrixStats::\link[matrixStats:rowRanks]{colRanks}()} which are used
when the input is a \code{matrix} or \code{numeric} vector.
\item \link[base:rank]{base::rank}
}
}
\author{
Peter Hickey
}
