import rcScheduler
import node
node = node.Node()
node.options.cron = True

def test_schedules():
    tests = [
        ("", "2015-02-27 10:00", False),
        ("@0", "2015-02-27 10:00", False),
        ("*@0", "2015-02-27 10:00", False),
        ("*", "2015-02-27 10:00", True),
        ("*@61", "2015-02-27 10:00", True),
        ("09:00-09:20", "2015-02-27 10:00", False),
        ("09:00-09:20@31", "2015-02-27 10:00", False),
        ("09:00-09:00", "2015-02-27 10:00", False),
        ("09:20-09:00", "2015-02-27 10:00", False),
        ("09:00", "2015-02-27 10:00", False),
        ("09:00-09:20", "2015-02-27 09:09", True),
        ("09:00-09:20@31", "2015-02-27 09:09", True),
        ("09:00-09:00", "2015-02-27 09:09", True),
        ("09:20-09:00", "2015-02-27 09:09", True),
        ("09:00", "2015-02-27 09:09", True),
        ("* fri", "2015-10-09 10:00", True),
        ("* fri", "2015-10-08 10:00", False),
        ("* *:last", "2015-01-30 10:00", True),
        ("* *:last", "2015-01-31 10:00", True),
        ("* *:-1", "2015-01-31 10:00", True),
        ("* *:-1", "2015-01-24 10:00", False),
        ("* *:-2", "2015-01-31 10:00", False),
        ("* :last", "2015-01-30 10:00", False),
        ("* :last", "2015-01-31 10:00", True),
        ("* :-1", "2015-01-31 10:00", True),
        ("* :-2", "2015-01-30 10:00", True),
        ("* :-2", "2015-01-31 10:00", False),
        ("* :-2", "2015-01-05 10:00", False),
        ("* :5", "2015-01-05 10:00", True),
        ("* :+5", "2015-01-05 10:00", True),
        ("* :fifth", "2015-01-05 10:00", True),
        ("* :5", "2015-01-06 10:00", False),
        ("* :+5", "2015-01-06 10:00", False),
        ("* :fifth", "2015-01-06 10:00", False),
        ("* * * jan", "2015-01-06 10:00", True),
        ("* * * jan-feb", "2015-01-06 10:00", True),
        ("* * * %2", "2015-01-06 10:00", False),
        ("* * * %2+1", "2015-01-06 10:00", True),
        ("* * * jan-feb%2", "2015-01-06 10:00", False),
        ("* * * jan-feb%2+1", "2015-01-06 10:00", True),
        ("18:00-18:59@60 wed", "2016-08-31 18:00", True),
        ("18:00-18:59@60 wed", "2016-08-30 18:00", False),
        ("23:00-23:59@61 *:first", "2016-09-01 23:00", True),
        # syntax errors
        ("23:00-23:59@61 *:first:*", "2016-09-01 23:00", None),
        ("23:00-23:59@61 *:", "2016-09-01 23:00", None),
        ("23:00-23:59@61 *:*", "2016-09-01 23:00", None),
        ("23:00-23:59@61 * * %2%3", "2016-09-01 23:00", None),
        ("23:00-23:59@61 * * %2+1+2", "2016-09-01 23:00", None),
        ("23:00-23:59@61 * * %foo", "2016-09-01 23:00", None),
        ("23:00-23:59@61 * * %2+foo", "2016-09-01 23:00", None),
        ("23:00-23:59@61 freday", "2016-09-01 23:00", None),
        ("23:00-23:59@61 * * junuary", "2016-09-01 23:00", None),
        ("23:00-23:59@61 * * %2%3", "2016-09-01 23:00", None),
        ("23:00-23:59-01:00@61", "2016-09-01 23:00", None),
        ("23:00-23:59:00@61 * * %2%3", "2016-09-01 23:00", None),
        ("23:00-23:59@61@10", "2016-09-01 23:00", None),
        ("23:00-23:59 * * * * *", "2016-09-01 23:00", None),
    ]
    sched = rcScheduler.Scheduler()
    for test in tests:
        assert sched.test_schedule(*test)

def test_fork():
    def dummy(*args, **kwargs):
        return 0
    rcScheduler.fork(dummy, args=[node], kwargs={}, serialize=True, delay=0)
    rcScheduler.fork(dummy, args=[node], kwargs={}, serialize=False, delay=0)


