/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Stack;
import java.util.Vector;
import org.apache.jetspeed.services.statemanager.SessionStateBindingListener;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.Calendar;
import org.chefproject.core.CalendarEdit;
import org.chefproject.core.CalendarEvent;
import org.chefproject.core.CalendarEventEdit;
import org.chefproject.core.Edit;
import org.chefproject.core.Event;
import org.chefproject.core.Filter;
import org.chefproject.core.Resource;
import org.chefproject.core.ResourceProperties;
import org.chefproject.core.ResourcePropertiesEdit;
import org.chefproject.core.StorageUser;
import org.chefproject.core.component.BaseResourcePropertiesEdit;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.EventTrackingService;
import org.chefproject.service.IdService;
import org.chefproject.service.SecurityService;
import org.chefproject.service.ServerConfigurationService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.generic.GenericCalendarService;
import org.chefproject.util.Cache;
import org.chefproject.util.CacheRefresher;
import org.chefproject.util.CalendarEventVector;
import org.chefproject.util.Reference;
import org.chefproject.util.ReferenceVector;
import org.chefproject.util.Time;
import org.chefproject.util.TimeRange;
import org.chefproject.util.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseCalendarService
extends TurbineBaseService
implements GenericCalendarService,
StorageUser,
CacheRefresher {
    protected String m_accessPoint = null;
    protected String m_relativeAccessPoint = null;
    protected Cache m_calendarCache = null;
    protected Hashtable m_eventCaches = null;
    protected Storage m_storage = null;

    protected BaseCalendarService service() {
        return this;
    }

    protected abstract Storage newStorage();

    protected String getAccessPoint(boolean relative) {
        return relative ? this.m_relativeAccessPoint : this.m_accessPoint;
    }

    protected boolean unlockCheck(String lock, String reference) {
        return SecurityService.unlock(lock, reference);
    }

    protected void unlock(String lock, String reference) throws PermissionException {
        if (!SecurityService.unlock(lock, reference)) {
            throw new PermissionException(UsageSessionService.getSessionUser().getId(), lock, reference);
        }
    }

    public String calendarReference(String context, String id) {
        return this.getAccessPoint(true) + "/" + "calendar" + "/" + context + "/" + id;
    }

    public String eventReference(String context, String calendarId, String id) {
        return this.getAccessPoint(true) + "/" + "event" + "/" + context + "/" + calendarId + "/" + id;
    }

    public CalendarEventVector getEvents(List references, TimeRange range) {
        CalendarEventVector calendarEventVector = null;
        if (references != null && range != null) {
            ArrayList allEvents = new ArrayList();
            Iterator it = references.iterator();
            while (it.hasNext()) {
                String calendarReference = (String)it.next();
                Calendar calendarObj = null;
                try {
                    calendarObj = this.getCalendar(calendarReference);
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", this + ".getEvents getCalendar() caused IdUnusedException exception", (Throwable)e);
                    continue;
                }
                catch (PermissionException e) {
                    Log.warn("chef", this + ".getEvents getCalendar() caused PermissionException exception", (Throwable)e);
                    continue;
                }
                if (calendarObj == null) continue;
                Iterator calEvent = null;
                try {
                    calEvent = calendarObj.getEvents(range, null).iterator();
                }
                catch (PermissionException e1) {
                    Log.warn("chef", this + ".getEvents getCalendar() caused PermissionException exception", (Throwable)e1);
                    continue;
                }
                allEvents.addAll(new CalendarEventVector(calEvent));
            }
            Collections.sort(allEvents);
            calendarEventVector = new CalendarEventVector(allEvents.iterator());
        }
        return calendarEventVector;
    }

    public void init(RunData data) throws InitializationException {
        super.init(data);
        this.m_relativeAccessPoint = "/calendar";
        this.m_accessPoint = ServerConfigurationService.getAccessUrl() + this.m_relativeAccessPoint;
        Log.info("chef", this + ".init(RunData): access point: " + this.m_accessPoint);
    }

    public void init() throws InitializationException {
        super.init();
        Log.info("chef", this + ".init()");
        this.m_storage = this.newStorage();
        this.m_storage.open();
        this.m_calendarCache = new Cache((CacheRefresher)this, this.getAccessPoint(true) + "/" + "calendar" + "/");
        this.m_eventCaches = new Hashtable();
    }

    public void shutdown() {
        this.m_calendarCache.clear();
        this.m_calendarCache = null;
        this.m_eventCaches.clear();
        this.m_eventCaches = null;
        this.m_storage.close();
        this.m_storage = null;
        Log.info("chef", this + ".shutdown()");
        super.shutdown();
    }

    public boolean allowAddCalendar(String ref) {
        return this.unlockCheck("calendar.new", ref);
    }

    public CalendarEdit addCalendar(String ref) throws IdUsedException, IdInvalidException, PermissionException {
        Validator.checkResourceRef(ref);
        if (this.m_calendarCache.get(ref) != null || this.m_storage.checkCalendar(ref)) {
            throw new IdUsedException(ref);
        }
        this.unlock("calendar.new", ref);
        CalendarEdit calendar = this.m_storage.putCalendar(ref);
        ((BaseCalendarEdit)calendar).setEvent("calendar.new");
        return calendar;
    }

    public boolean allowGetCalendar(String ref) {
        return this.unlockCheck("calendar.read", ref);
    }

    protected Calendar findCalendar(String ref) {
        Calendar calendar = null;
        if (this.m_calendarCache.disabled()) {
            calendar = this.m_storage.getCalendar(ref);
        } else if (this.m_calendarCache.containsKey(ref)) {
            calendar = (Calendar)this.m_calendarCache.get(ref);
        } else {
            calendar = this.m_storage.getCalendar(ref);
            this.m_calendarCache.put(ref, calendar);
        }
        return calendar;
    }

    public Calendar getCalendar(String ref) throws IdUnusedException, PermissionException {
        Calendar c = this.findCalendar(ref);
        if (c == null) {
            throw new IdUnusedException(ref);
        }
        this.unlock("calendar.read", ref);
        return c;
    }

    public boolean allowRemoveCalendar(String ref) {
        return this.unlockCheck("calendar.delete", ref);
    }

    public void removeCalendar(CalendarEdit calendar) throws PermissionException {
        if (!calendar.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".removeCalendar(): closed CalendarEdit", (Throwable)e);
                return;
            }
        }
        this.unlock("calendar.delete", calendar.getReference());
        this.m_storage.removeCalendar(calendar);
        Event event = EventTrackingService.newEvent("calendar.delete", calendar.getReference(), true);
        EventTrackingService.post(event);
        ((BaseCalendarEdit)calendar).setRemoved(event);
        ((BaseCalendarEdit)calendar).closeEdit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCalendars() {
        List calendars = new Vector();
        if (this.m_calendarCache.disabled()) {
            calendars = this.m_storage.getCalendars();
        } else if (this.m_calendarCache.isComplete()) {
            calendars = this.m_calendarCache.getAll();
        } else {
            Cache cache = this.m_calendarCache;
            synchronized (cache) {
                block9: {
                    if (!this.m_calendarCache.isComplete()) break block9;
                    calendars = this.m_calendarCache.getAll();
                    List list = calendars;
                    return list;
                }
                this.m_calendarCache.holdEvents();
                calendars = this.m_storage.getCalendars();
                int i = 0;
                while (i < calendars.size()) {
                    Calendar calendar = (Calendar)calendars.get(i);
                    this.m_calendarCache.put(calendar.getReference(), calendar);
                    ++i;
                }
                this.m_calendarCache.setComplete();
                this.m_calendarCache.processEvents();
            }
        }
        return calendars;
    }

    public boolean allowUpdateCalendar(String ref) {
        return this.unlockCheck("calendar.revise", ref);
    }

    public CalendarEdit editCalendar(String ref) throws IdUnusedException, PermissionException, InUseException {
        if (this.m_calendarCache.get(ref) == null && !this.m_storage.checkCalendar(ref)) {
            throw new IdUnusedException(ref);
        }
        this.unlock("calendar.revise", ref);
        CalendarEdit edit = this.m_storage.editCalendar(ref);
        if (edit == null) {
            throw new InUseException(ref);
        }
        ((BaseCalendarEdit)edit).setEvent("calendar.revise");
        return edit;
    }

    public void commitCalendar(CalendarEdit edit) {
        if (!edit.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".commitEdit(): closed CalendarEdit", (Throwable)e);
                return;
            }
        }
        this.m_storage.commitCalendar(edit);
        Event event = EventTrackingService.newEvent(((BaseCalendarEdit)edit).getEvent(), edit.getReference(), true);
        EventTrackingService.post(event);
        ((BaseCalendarEdit)edit).closeEdit();
    }

    public void cancelCalendar(CalendarEdit edit) {
        if (!edit.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".cancelCalendarEdit(): closed CalendarEventEdit", (Throwable)e);
                return;
            }
        }
        this.m_storage.cancelCalendar(edit);
        ((BaseCalendarEdit)edit).closeEdit();
    }

    public Object refresh(Object key, Object oldValue, Event event) {
        Resource rv = null;
        Reference ref = new Reference((String)key);
        if ("event".equals(ref.getSubType())) {
            Calendar calendar;
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".refresh(): key " + key + " calendar id : " + ref.getContext() + "/" + ref.getContainer() + " event id : " + ref.getId());
            }
            if ((calendar = this.findCalendar(this.calendarReference(ref.getContext(), ref.getContainer()))) != null) {
                rv = this.m_storage.getEvent(calendar, ref.getId());
            }
        } else {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".refresh(): key " + key + " calendar id : " + ref.getReference());
            }
            rv = this.m_storage.getCalendar(ref.getReference());
        }
        return rv;
    }

    public Resource newContainer(String ref) {
        return new BaseCalendarEdit(ref);
    }

    public Resource newContainer(Element element) {
        return new BaseCalendarEdit(element);
    }

    public Resource newContainer(Resource other) {
        return new BaseCalendarEdit((Calendar)other);
    }

    public Resource newResource(Resource container, String id, Object[] others) {
        return new BaseCalendarEventEdit((Calendar)container, id);
    }

    public Resource newResource(Resource container, Element element) {
        return new BaseCalendarEventEdit((Calendar)container, element);
    }

    public Resource newResource(Resource container, Resource other) {
        return new BaseCalendarEventEdit((Calendar)container, (CalendarEvent)other);
    }

    public Edit newContainerEdit(String ref) {
        BaseCalendarEdit rv = new BaseCalendarEdit(ref);
        rv.activate();
        return rv;
    }

    public Edit newContainerEdit(Element element) {
        BaseCalendarEdit rv = new BaseCalendarEdit(element);
        rv.activate();
        return rv;
    }

    public Edit newContainerEdit(Resource other) {
        BaseCalendarEdit rv = new BaseCalendarEdit((Calendar)other);
        rv.activate();
        return rv;
    }

    public Edit newResourceEdit(Resource container, String id, Object[] others) {
        BaseCalendarEventEdit rv = new BaseCalendarEventEdit((Calendar)container, id);
        rv.activate();
        return rv;
    }

    public Edit newResourceEdit(Resource container, Element element) {
        BaseCalendarEventEdit rv = new BaseCalendarEventEdit((Calendar)container, element);
        rv.activate();
        return rv;
    }

    public Edit newResourceEdit(Resource container, Resource other) {
        BaseCalendarEventEdit rv = new BaseCalendarEventEdit((Calendar)container, (CalendarEvent)other);
        rv.activate();
        return rv;
    }

    public Object[] storageFields(Resource r) {
        Object[] rv = new Object[2];
        TimeRange range = ((CalendarEvent)r).getRange();
        rv[0] = range.firstTime();
        rv[1] = range.lastTime();
        return rv;
    }

    protected static interface Storage {
        public void open();

        public void close();

        public Calendar getCalendar(String var1);

        public boolean checkCalendar(String var1);

        public List getCalendars();

        public CalendarEdit putCalendar(String var1);

        public CalendarEdit editCalendar(String var1);

        public void commitCalendar(CalendarEdit var1);

        public void cancelCalendar(CalendarEdit var1);

        public void removeCalendar(CalendarEdit var1);

        public CalendarEvent getEvent(Calendar var1, String var2);

        public CalendarEventEdit editEvent(Calendar var1, String var2);

        public void commitEvent(Calendar var1, CalendarEventEdit var2);

        public void cancelEvent(Calendar var1, CalendarEventEdit var2);

        public boolean checkEvent(Calendar var1, String var2);

        public List getEvents(Calendar var1);

        public CalendarEventEdit putEvent(Calendar var1, String var2);

        public void removeEvent(Calendar var1, CalendarEventEdit var2);
    }

    public class BaseCalendarEventEdit
    implements CalendarEventEdit,
    SessionStateBindingListener {
        protected BaseCalendarEdit m_calendar = null;
        protected TimeRange m_range = null;
        protected ResourcePropertiesEdit m_properties = null;
        protected String m_id = null;
        protected ReferenceVector m_attachments = null;
        protected String m_event = null;
        protected boolean m_active = false;

        public BaseCalendarEventEdit(Calendar calendar, String id) {
            this.m_calendar = (BaseCalendarEdit)calendar;
            this.m_id = id;
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_attachments = new ReferenceVector();
        }

        public BaseCalendarEventEdit(Calendar calendar, CalendarEvent other) {
            this.m_calendar = (BaseCalendarEdit)calendar;
            this.set(other);
        }

        public BaseCalendarEventEdit(Calendar calendar, Element el) {
            this.m_calendar = (BaseCalendarEdit)calendar;
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_attachments = new ReferenceVector();
            this.m_id = el.getAttribute("id");
            try {
                this.m_range = new TimeRange(el.getAttribute("range"));
            }
            catch (TimeRange.Invalid e) {
                Log.warn("chef", this + ".construct from el(): invalid time range string: " + el.getAttribute("range"));
            }
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    Element element = (Element)child;
                    if (element.getTagName().equals("attachment")) {
                        this.m_attachments.add(new Reference(element.getAttribute("relative-url")));
                    } else if (element.getTagName().equals("properties")) {
                        this.m_properties = new BaseResourcePropertiesEdit(element);
                    }
                }
                ++i;
            }
        }

        protected void set(CalendarEvent other) {
            this.m_id = other.getId();
            this.m_range = other.getRange();
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_properties.addAll(other.getProperties());
            this.m_attachments = new ReferenceVector();
            this.replaceAttachments(other.getAttachments());
        }

        protected void finalize() {
            if (this.m_active) {
                this.m_calendar.cancelEvent(this);
            }
            this.m_calendar = null;
        }

        public TimeRange getRange() {
            if (this.m_range == null) {
                return new TimeRange(new Time(0L), new Time(0L));
            }
            return this.m_range.makeClone();
        }

        public void setRange(TimeRange range) {
            this.m_range = range.makeClone();
        }

        public String getDisplayName() {
            return this.m_properties.getPropertyFormatted("DAV:displayname");
        }

        public void setDisplayName(String name) {
            this.m_properties.addProperty("DAV:displayname", name);
        }

        public String getDescription() {
            return this.m_properties.getPropertyFormatted("CHEF:description");
        }

        public void setDescription(String description) {
            this.m_properties.addProperty("CHEF:description", description);
        }

        public String getType() {
            return this.m_properties.getPropertyFormatted("CHEF:calendar-type");
        }

        public void setType(String type) {
            this.m_properties.addProperty("CHEF:calendar-type", type);
        }

        public String getLocation() {
            return this.m_properties.getPropertyFormatted("CHEF:calendar-location");
        }

        public String getField(String name) {
            name = "CHEF:calendar-fields" + "." + name;
            return this.m_properties.getPropertyFormatted(name);
        }

        public void setField(String name, String value) {
            name = "CHEF:calendar-fields" + "." + name;
            if (value == null) {
                this.m_properties.removeProperty(name);
            } else {
                this.m_properties.addProperty(name, value);
            }
        }

        public void setLocation(String location) {
            this.m_properties.addProperty("CHEF:calendar-location", location);
        }

        public String getId() {
            return this.m_id;
        }

        public String getUrl() {
            return this.m_calendar.getUrl() + this.getId();
        }

        public String getReference() {
            return BaseCalendarService.this.eventReference(this.m_calendar.getContext(), this.m_calendar.getId(), this.getId());
        }

        public ResourceProperties getProperties() {
            return this.m_properties;
        }

        public void notify(Event event) {
            this.m_calendar.notify(event);
        }

        public int compareTo(Object o) {
            Time other;
            if (!(o instanceof CalendarEvent)) {
                throw new ClassCastException();
            }
            Time mine = this.getRange().firstTime();
            if (mine.before(other = ((CalendarEvent)o).getRange().firstTime())) {
                return -1;
            }
            if (mine.after(other)) {
                return 1;
            }
            return 0;
        }

        public Element toXml(Document doc, Stack stack) {
            Element event = doc.createElement("event");
            if (stack.isEmpty()) {
                doc.appendChild(event);
            } else {
                ((Element)stack.peek()).appendChild(event);
            }
            stack.push(event);
            event.setAttribute("id", this.getId());
            event.setAttribute("range", this.getRange().toString());
            this.m_properties.toXml(doc, stack);
            if (this.m_attachments != null && this.m_attachments.size() > 0) {
                int i = 0;
                while (i < this.m_attachments.size()) {
                    Reference attch = (Reference)this.m_attachments.elementAt(i);
                    Element attachment = doc.createElement("attachment");
                    event.appendChild(attachment);
                    attachment.setAttribute("relative-url", attch.getReference());
                    ++i;
                }
            }
            stack.pop();
            return event;
        }

        protected String getEvent() {
            return this.m_event;
        }

        protected void setEvent(String event) {
            this.m_event = event;
        }

        public ResourcePropertiesEdit getPropertiesEdit() {
            return this.m_properties;
        }

        protected void activate() {
            this.m_active = true;
        }

        public boolean isActiveEdit() {
            return this.m_active;
        }

        protected void closeEdit() {
            this.m_active = false;
        }

        public ReferenceVector getAttachments() {
            return (ReferenceVector)this.m_attachments.clone();
        }

        public void addAttachment(Reference ref) {
            this.m_attachments.add(ref);
        }

        public void removeAttachment(Reference ref) {
            this.m_attachments.remove(ref);
        }

        public void replaceAttachments(ReferenceVector attachments) {
            this.m_attachments.clear();
            if (attachments != null) {
                Iterator it = attachments.iterator();
                while (it.hasNext()) {
                    this.m_attachments.add(it.next());
                }
            }
        }

        public void clearAttachments() {
            this.m_attachments.clear();
        }

        public void valueBound(String sessionStateKey, String attributeName) {
        }

        public void valueUnbound(String sessionStateKey, String attributeName) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".valueUnbound()");
            }
            if (this.m_active) {
                this.m_calendar.cancelEvent(this);
            }
        }

        public String getCalendarReference() {
            return this.m_calendar.getReference();
        }
    }

    public class BaseCalendarEdit
    extends Observable
    implements CalendarEdit,
    SessionStateBindingListener {
        protected String m_context = null;
        protected String m_id = null;
        protected ResourcePropertiesEdit m_properties = null;
        protected boolean m_isRemoved = false;
        protected String m_event = null;
        protected boolean m_active = false;

        public BaseCalendarEdit(String ref) {
            Reference r = new Reference(ref);
            this.m_context = r.getContext();
            this.m_id = r.getId();
            this.m_properties = new BaseResourcePropertiesEdit();
        }

        public BaseCalendarEdit(Calendar other) {
            this.m_context = other.getContext();
            this.m_id = other.getId();
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_properties.addAll(other.getProperties());
        }

        public BaseCalendarEdit(Element el) {
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_id = el.getAttribute("id");
            this.m_context = el.getAttribute("context");
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Element element;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (element = (Element)child).getTagName().equals("properties")) {
                    this.m_properties = new BaseResourcePropertiesEdit(element);
                }
                ++i;
            }
        }

        protected void finalize() {
            this.deleteObservers();
            if (this.m_active) {
                BaseCalendarService.this.cancelCalendar(this);
            }
        }

        public void setRemoved(Event event) {
            this.m_isRemoved = true;
            this.notify(event);
            this.deleteObservers();
        }

        public String getContext() {
            return this.m_context;
        }

        public String getId() {
            return this.m_id;
        }

        public String getUrl() {
            return BaseCalendarService.this.getAccessPoint(false) + "/" + this.getId() + "/";
        }

        public String getReference() {
            return BaseCalendarService.this.calendarReference(this.m_context, this.m_id);
        }

        public ResourceProperties getProperties() {
            return this.m_properties;
        }

        public boolean allowGetEvents() {
            return BaseCalendarService.this.unlockCheck("calendar.read", this.getReference());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List getEvents(TimeRange range, Filter filter) throws PermissionException {
            BaseCalendarService.this.unlock("calendar.read", this.getReference());
            EventTrackingService.post(EventTrackingService.newEvent("calendar.read", this.getReference(), false));
            List events = new Vector();
            if (BaseCalendarService.this.m_calendarCache.disabled()) {
                events = BaseCalendarService.this.m_storage.getEvents(this);
            } else {
                Object object;
                Cache eventCache = (Cache)BaseCalendarService.this.m_eventCaches.get(this.getReference());
                if (eventCache == null) {
                    object = BaseCalendarService.this.m_eventCaches;
                    synchronized (object) {
                        eventCache = (Cache)BaseCalendarService.this.m_eventCaches.get(this.getReference());
                        if (eventCache == null) {
                            eventCache = new Cache((CacheRefresher)BaseCalendarService.this.service(), BaseCalendarService.this.eventReference(this.m_context, this.m_id, ""));
                            BaseCalendarService.this.m_eventCaches.put(this.getReference(), eventCache);
                        }
                    }
                }
                if (eventCache.isComplete()) {
                    events = eventCache.getAll();
                } else {
                    object = eventCache;
                    synchronized (object) {
                        if (eventCache.isComplete()) {
                            events = eventCache.getAll();
                        } else {
                            eventCache.holdEvents();
                            events = BaseCalendarService.this.m_storage.getEvents(this);
                            int i = 0;
                            while (i < events.size()) {
                                CalendarEvent event = (CalendarEvent)events.get(i);
                                eventCache.put(event.getReference(), event);
                                ++i;
                            }
                            eventCache.setComplete();
                            eventCache.processEvents();
                        }
                    }
                }
            }
            if (events.size() == 0) {
                return events;
            }
            events = this.filterEvents(events, range);
            if (filter != null) {
                Vector<Event> filtered = new Vector<Event>();
                int i = 0;
                while (i < events.size()) {
                    Event event = (Event)events.get(i);
                    if (filter.accept(event)) {
                        filtered.add(event);
                    }
                    ++i;
                }
                if (filtered.size() == 0) {
                    return filtered;
                }
                events = filtered;
            }
            Collections.sort(events);
            return events;
        }

        protected List filterEvents(List events, TimeRange range) {
            Vector<CalendarEvent> filtered = new Vector<CalendarEvent>();
            int i = 0;
            while (i < events.size()) {
                CalendarEvent event = (CalendarEvent)events.get(i);
                if (range.overlaps(event.getRange())) {
                    filtered.add(event);
                }
                ++i;
            }
            return filtered;
        }

        public CalendarEvent getEvent(String eventId) throws IdUnusedException, PermissionException {
            BaseCalendarService.this.unlock("calendar.read", this.getReference());
            CalendarEvent e = this.findEvent(eventId);
            if (e == null) {
                throw new IdUnusedException(eventId);
            }
            EventTrackingService.post(EventTrackingService.newEvent("calendar.read", e.getReference(), false));
            return e;
        }

        public boolean allowAddEvent() {
            return BaseCalendarService.this.unlockCheck("calendar.revise", this.getReference());
        }

        public CalendarEvent addEvent(TimeRange range, String displayName, String description, String type, String location, ReferenceVector attachments) throws PermissionException {
            CalendarEventEdit edit = this.addEvent();
            edit.setRange(range);
            edit.setDisplayName(displayName);
            edit.setDescription(description);
            edit.setType(type);
            edit.setLocation(location);
            edit.replaceAttachments(attachments);
            this.commitEvent(edit);
            return edit;
        }

        public CalendarEventEdit addEvent() throws PermissionException {
            BaseCalendarService.this.unlock("calendar.revise", this.getReference());
            String id = IdService.getUniqueId();
            CalendarEventEdit event = BaseCalendarService.this.m_storage.putEvent(this, id);
            ((BaseCalendarEventEdit)event).setEvent("calendar.revise");
            return event;
        }

        public CalendarEvent mergeEvent(Element el) throws PermissionException, IdUsedException {
            BaseCalendarService.this.unlock("calendar.revise", this.getReference());
            CalendarEvent eventFromXml = (CalendarEvent)BaseCalendarService.this.newResource((Resource)this, el);
            CalendarEventEdit event = BaseCalendarService.this.m_storage.putEvent(this, eventFromXml.getId());
            if (event == null) {
                throw new IdUsedException(eventFromXml.getId());
            }
            ((BaseCalendarEventEdit)event).set(eventFromXml);
            ((BaseCalendarEventEdit)event).setEvent("calendar.revise");
            return event;
        }

        public boolean allowRemoveEvent(CalendarEvent event) {
            return BaseCalendarService.this.unlockCheck("calendar.revise", this.getReference());
        }

        public void removeEvent(CalendarEventEdit edit) throws PermissionException {
            if (!edit.isActiveEdit()) {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    Log.warn("chef", this + ".removeEvent(): closed EventEdit", (Throwable)e);
                    return;
                }
            }
            BaseCalendarService.this.unlock("calendar.revise", this.getReference());
            BaseCalendarService.this.m_storage.removeEvent(this, edit);
            Event event = EventTrackingService.newEvent("calendar.revise", edit.getReference(), true);
            EventTrackingService.post(event);
            this.notify(event);
            ((BaseCalendarEventEdit)edit).closeEdit();
        }

        public boolean allowEditEvent(String eventId) {
            CalendarEvent e = this.findEvent(eventId);
            if (e == null) {
                return false;
            }
            return BaseCalendarService.this.unlockCheck("calendar.revise", this.getReference());
        }

        public CalendarEventEdit editEvent(String eventId) throws IdUnusedException, PermissionException, InUseException {
            CalendarEvent e = this.findEvent(eventId);
            if (e == null) {
                throw new IdUnusedException(eventId);
            }
            BaseCalendarService.this.unlock("calendar.revise", this.getReference());
            CalendarEventEdit edit = BaseCalendarService.this.m_storage.editEvent(this, eventId);
            if (edit == null) {
                throw new InUseException(eventId);
            }
            ((BaseCalendarEventEdit)edit).setEvent("calendar.revise");
            return edit;
        }

        public void commitEvent(CalendarEventEdit edit) {
            if (!edit.isActiveEdit()) {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    Log.warn("chef", this + ".commitEvent(): closed CalendarEventEdit", (Throwable)e);
                    return;
                }
            }
            BaseCalendarService.this.m_storage.commitEvent(this, edit);
            Event event = EventTrackingService.newEvent(((BaseCalendarEventEdit)edit).getEvent(), edit.getReference(), true);
            EventTrackingService.post(event);
            this.notify(event);
            ((BaseCalendarEventEdit)edit).closeEdit();
        }

        public void cancelEvent(CalendarEventEdit edit) {
            if (!edit.isActiveEdit()) {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    Log.warn("chef", this + ".cancelEvent(): closed CalendarEventEdit", (Throwable)e);
                    return;
                }
            }
            BaseCalendarService.this.m_storage.cancelEvent(this, edit);
            ((BaseCalendarEventEdit)edit).closeEdit();
        }

        public String getEventFields() {
            return this.m_properties.getPropertyFormatted("CHEF:calendar-fields");
        }

        public void setEventFields(String fields) {
            this.m_properties.addProperty("CHEF:calendar-fields", fields);
        }

        public void notify(Event event) {
            this.setChanged();
            this.notifyObservers(event);
        }

        public Element toXml(Document doc, Stack stack) {
            Element calendar = doc.createElement("calendar");
            if (stack.isEmpty()) {
                doc.appendChild(calendar);
            } else {
                ((Element)stack.peek()).appendChild(calendar);
            }
            stack.push(calendar);
            calendar.setAttribute("context", this.m_context);
            calendar.setAttribute("id", this.m_id);
            this.m_properties.toXml(doc, stack);
            stack.pop();
            return calendar;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CalendarEvent findEvent(String eventId) {
            CalendarEvent e = null;
            String key = BaseCalendarService.this.eventReference(this.m_context, this.m_id, eventId);
            if (BaseCalendarService.this.m_calendarCache.disabled()) {
                e = BaseCalendarService.this.m_storage.getEvent(this, eventId);
            } else {
                Cache eventCache = (Cache)BaseCalendarService.this.m_eventCaches.get(this.getReference());
                if (eventCache == null) {
                    Hashtable hashtable = BaseCalendarService.this.m_eventCaches;
                    synchronized (hashtable) {
                        eventCache = (Cache)BaseCalendarService.this.m_eventCaches.get(this.getReference());
                        if (eventCache == null) {
                            eventCache = new Cache((CacheRefresher)BaseCalendarService.this.service(), BaseCalendarService.this.eventReference(this.m_context, this.m_id, ""));
                            BaseCalendarService.this.m_eventCaches.put(this.getReference(), eventCache);
                        }
                    }
                }
                if (eventCache.containsKey(key)) {
                    e = (CalendarEvent)eventCache.get(key);
                } else {
                    e = BaseCalendarService.this.m_storage.getEvent(this, eventId);
                    eventCache.put(key, e);
                }
            }
            return e;
        }

        protected String getEvent() {
            return this.m_event;
        }

        protected void setEvent(String event) {
            this.m_event = event;
        }

        public ResourcePropertiesEdit getPropertiesEdit() {
            return this.m_properties;
        }

        protected void activate() {
            this.m_active = true;
        }

        public boolean isActiveEdit() {
            return this.m_active;
        }

        protected void closeEdit() {
            this.m_active = false;
        }

        public void valueBound(String sessionStateKey, String attributeName) {
        }

        public void valueUnbound(String sessionStateKey, String attributeName) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".valueUnbound()");
            }
            if (this.m_active) {
                BaseCalendarService.this.cancelCalendar(this);
            }
        }
    }
}

