/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.db;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.turbine.services.BaseService;
import org.apache.turbine.services.db.MapBrokerService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.db.AutoIncrementIdGenerator;
import org.apache.turbine.util.db.IDBroker;
import org.apache.turbine.util.db.SequenceIdGenerator;
import org.apache.turbine.util.db.adapter.DB;
import org.apache.turbine.util.db.adapter.DBFactory;
import org.apache.turbine.util.db.map.DatabaseMap;
import org.apache.turbine.util.db.map.TableMap;

public class TurbineMapBrokerService
extends BaseService
implements MapBrokerService {
    private Map dbMaps;

    public void init() {
        this.dbMaps = new HashMap();
        this.setInit(true);
    }

    public void shutdown() {
        Iterator maps = this.dbMaps.values().iterator();
        while (maps.hasNext()) {
            DatabaseMap map = (DatabaseMap)maps.next();
            IDBroker idBroker = map.getIDBroker();
            if (idBroker == null) continue;
            idBroker.stop();
        }
    }

    public DatabaseMap getDatabaseMap() throws TurbineException {
        return this.getDatabaseMap("default");
    }

    public DatabaseMap getDatabaseMap(String name) throws TurbineException {
        if (name == null) {
            throw new TurbineException("DatabaseMap name was null!");
        }
        DatabaseMap map = (DatabaseMap)this.dbMaps.get(name);
        if (map == null) {
            Map map2 = this.dbMaps;
            synchronized (map2) {
                map = (DatabaseMap)this.dbMaps.get(name);
                if (map == null) {
                    map = new DatabaseMap(name);
                    this.setupIdTable(map);
                    try {
                        DB db = DBFactory.create(TurbineMapBrokerService.getDatabaseProperty(name, "driver"));
                        map.addIdGenerator("autoincrement", new AutoIncrementIdGenerator(db));
                        map.addIdGenerator("sequence", new SequenceIdGenerator(db));
                    }
                    catch (InstantiationException e) {
                        throw new TurbineException(e);
                    }
                    this.dbMaps.put(name, map);
                }
            }
        }
        return map;
    }

    private static final String getDatabaseProperty(String db, String prop) {
        return TurbineResources.getString("database." + db + '.' + prop, "");
    }

    private void setupIdTable(DatabaseMap map) {
        map.setIdTable("ID_TABLE");
        TableMap tMap = map.getIdTable();
        tMap.addPrimaryKey("ID_TABLE_ID", new Integer(0));
        tMap.addColumn("TABLE_NAME", new String(""));
        tMap.addColumn("NEXT_ID", new Integer(0));
        tMap.addColumn("QUANTITY", new Integer(0));
    }
}

