import pipes

class CEProbeScript(object):
    """A class used to generate job-scripts for CE probes."""

    def __init__(self):
	self._required_files = []
	self._generated_files = []

    def require_file(self, fname, size = None, sha1sum = None):
	self._required_files.append((fname, size, sha1sum))

    def generate_file(self, fname, content = None):
	self._generated_files.append((fname, content))

    def write_to(self, fh):
	fh.write('#! /bin/sh\n'
		 'echo "Job started `date -Is`."\n'
		 'status=0\n'
		 'error() { echo 1>&2 "ERROR: $@"; status=1; }\n')
	for fname, size, sha1sum in self._required_files:
	    d = dict(fname = pipes.quote(fname), size = size, sha1sum = sha1sum)
	    fh.write('if test ! -e %(fname)s; then\n'
		     '    error "Missing file "%(fname)s\n'%d)
	    if not size is None:
		fh.write('elif test `stat -c %%s %(fname)s` -ne %(size)d; then\n'
			 '    error "Wrong size for "%(fname)s\n'%d)
	    if not sha1sum is None:
		fh.write('elif test `sha1sum %(fname)s` -ne %(sha1sum)d; then\n'
			 '    error "Wrong sha1sum for "%(fname)s\n'%d)
	    fh.write('fi\n')
	for fname, content in self._generated_files:
	    if content is None:
		fh.write('hostname >%s\n'%pipes.quote(fname))
	    else:
		fh.write('echo %s >%s\n'
			 % (pipes.quote(content), pipes.quote(content)))
	fh.write('echo "Present files before termination:"\n'
		 'ls -l\n'
		 'echo "Job finished `date -Is`, status = $status."\n'
		 'exit $status\n')

    def save_to(self, path):
	fh = open(path, 'w')
	self.write_to(fh)
	fh.close()
