# Mocha Code of Conduct

## Be friendly and patient

We understand that everyone has different levels of experience or knowledge in many diverse fields, be it technical or
non-technical in nature. We also have areas of knowledge we are eager to expand; we want to be a community where people
can not only contribute, but feel comfortable to ask questions as well and learn along the way. If someone says something
wrong, or says something accidentally offensive, respond with patience and try to keep it polite and civil. Remember that
we all were newbies at one point.

## Be welcoming

We strive to be a community that welcomes and supports people of all backgrounds and identities. This includes, but is not
limited to, members of any race, ethnicity, culture, national origin, color, immigration status, social and economic class,
educational level, sex, sexual orientation, gender identity and expression, age, size, family status, political belief,
religion, and mental and physical ability.

## Be considerate

Your work will be used by other people, and you in turn will depend on the work of others. Any decision you make will affect
users and colleagues, and you should take those consequences into account when making decisions. Remember that we’re a world-wide
community, so you might not be communicating in someone else’s primary language.

## Be respectful

Not all of us will agree all the time, but disagreement is no excuse for poor behavior and poor manners. We might all
experience some frustration now and then, but we cannot allow that frustration to turn into a personal attack. It’s important
to remember that a community where people feel uncomfortable or threatened is not a productive one. Members of the JS Foundation
community should be respectful when dealing with other members as well as with people outside the JS Foundation community.

## Be careful in the words that you choose

We are a community of professionals, and we conduct ourselves professionally. Be kind to others. Do not insult or put
down other participants. Harassment and other exclusionary behavior aren’t acceptable. This includes, but is not limited to:

- Violent threats or language directed against another person.
- Discriminatory jokes and language.
- Posting sexually explicit or violent material.
- Posting (or threatening to post) other people’s personally identifying information (“doxing”).
- Personal insults, especially those using racist or sexist terms.
- Unwelcome sexual attention.
- Advocating for, or encouraging, any of the above behavior.
- Repeated harassment of others. In general, if someone asks you to stop, then stop.

## When we disagree, try to understand why

Disagreements, both social and technical, happen all the time and JS Foundation projects are no exception. It is important
that we resolve disagreements and differing views constructively. Remember that we’re different. The strength of the JS
Foundation comes from its varied community, people from a wide range of backgrounds. Different people have different
perspectives on issues. Being unable to understand why someone holds a viewpoint doesn’t mean that they’re wrong. Don’t
forget that it is human to err and blaming each other doesn’t get us anywhere. Instead, focus on helping to resolve issues
and learning from mistakes.

Original text courtesy of the Speak Up! project and Django Project.

## QUESTIONS?

If you have questions, please see the FAQ. If that doesn’t answer your questions, feel free to email report@lists.openjsf.org.

# OpenJS Foundation Code of Conduct

The OpenJS Foundation and its member projects use the Contributor
Covenant v1.4.1 as its Code of Conduct. Refer to the following
for the full text:

- [english](https://www.contributor-covenant.org/version/1/4/code-of-conduct)
- [translations](https://www.contributor-covenant.org/translations)

Refer to the section on reporting and escalation in this document for the specific emails that can be used to report and escalate issues.

## Reporting

### Project Spaces

For reporting issues in spaces related to a member project please use the email provided by the project for reporting. Projects handle CoC issues related to the spaces that they maintain. Projects maintainers commit to:

- maintain the confidentiality with regard to the reporter of an incident
- to participate in the path for escalation as outlined in
  the section on Escalation when required.

### Foundation Spaces

For reporting issues in spaces managed by the OpenJS Foundation, for example, repositories within the OpenJS organization, use the email `report@lists.openjsf.org`. The Cross Project Council (CPC) is responsible for managing these reports and commits to:

- maintain the confidentiality with regard to the reporter of an incident
- to participate in the path for escalation as outlined in
  the section on Escalation when required.

## Escalation

The OpenJS Foundation maintains a Code of Conduct Panel (CoCP). This is a foundation-wide team established to manage escalation when a reporter believes that a report to a member project or the CPC has not been properly handled. In order to escalate to the CoCP send an email to `"coc-escalation@lists.openjsf.org`.

For more information, refer to the full
[Code of Conduct governance document](https://github.com/openjs-foundation/bootstrap/blob/master/proposals/stage-1/CODE_OF_CONDUCT/FOUNDATION_CODE_OF_CONDUCT_REQUIREMENTS.md).
