C
C	$Id: markl.f,v 1.6 2008-07-27 00:23:04 haley Exp $
C                                                                      
C                Copyright (C)  2000
C        University Corporation for Atmospheric Research
C                All Rights Reserved
C
C The use of this Software is governed by a License Agreement.
C
      SUBROUTINE MARKL (MX1,MY1,MX2,MY2)
C
C MARKL MARKS A LINE FROM POINT (MX1,MY1) TO POINT (MX2,MY2) IN THE
C MODEL PICTURE.
C
C ***********************************
C
C NOTE: LINES OF LENGTH LESS OR EQUAL 2 ARE NOT MARKED.
C       THE VERY FIRST POINT OF A LINE IS NOT MARKED, BUT IT WAS
C        MARKED WITH THE PRECEEDING LINE SEGMENT.
C
C ***********************************
C
C ISKIP IS USED TO ADJUST DASHSUPR TO THE SIZE OF THE MODEL PICTURE AS
C DEFINED IN THE SUBROUTINE REMOVE. ISKIP IS INITIALIZED IN DASHBDX.
C
      COMMON /DSUP1/ ISKIP
C
      LOGICAL LDUMMY
      SAVE
C
      DATA LDUMMY /.TRUE./
C
      DX = MX2-MX1
      DY = MY2-MY1
      IF (ABS(DX)-ABS(DY)) 60,50,10
C
C DX IS LONGER THAN DY.
C
   10 SLOPE = DY/DX
      IF (DX .LT. 0.) GO TO 30
      MX1S = MX1+2*ISKIP
      MX2S = MX2-1*ISKIP
      IF (MX1S .GT. MX2S) RETURN
C
      DO 20 MX=MX1S,MX2S,ISKIP
         MY = INT(REAL(MY1)+REAL(MX-MX1)*SLOPE+.5)
         CALL REMOVE (MX,MY,LDUMMY,2)
   20 CONTINUE
      RETURN
C
   30 MX1S = MX1-2*ISKIP
      MX2S = MX2+1*ISKIP
      IF (MX1S .LT. MX2S) RETURN
      DO 40 MX=MX2S,MX1S,ISKIP
         MY = INT(REAL(MY2)+REAL(MX-MX2)*SLOPE+.5)
         CALL REMOVE (MX,MY,LDUMMY,2)
   40 CONTINUE
      RETURN
C
C DX AND DY HAVE SAME LENGTH.
C
   50 IF (DX .NE. 0.) GO TO 10
      CALL REMOVE (MX2,MY2,LDUMMY,2)
      RETURN
C
C DY IS LONGER THAN DX.
C
   60 SLOPE = DX/DY
      IF (DY .LT. 0.) GO TO 80
      MY1S = MY1+2*ISKIP
      MY2S = MY2-1*ISKIP
      IF (MY1S .GT. MY2S) RETURN
C
      DO 70 MY=MY1S,MY2S,ISKIP
         MX = INT(REAL(MX1)+REAL(MY-MY1)*SLOPE+.5)
         CALL REMOVE (MX,MY,LDUMMY,2)
   70 CONTINUE
      RETURN
C
   80 MY1S = MY1-2*ISKIP
      MY2S = MY2+1*ISKIP
      IF (MY1S .LT. MY2S) RETURN
C
      DO 90 MY=MY2S,MY1S,ISKIP
         MX = INT(REAL(MX2)+REAL(MY-MY2)*SLOPE+.5)
         CALL REMOVE (MX,MY,LDUMMY,2)
   90 CONTINUE
C
      RETURN
      END
