<?php
/**
 * Internationalisation file for extension SyntaxHighlight.
 *
 * @file
 * @ingroup Extensions
 */

$messages = array();

/** English
 * @author Brion Vibber
 */
$messages['en'] = array(
	'syntaxhighlight-desc'         => 'Provides syntax highlighting <code>&lt;syntaxhighlight&gt;</code> using [http://qbnz.com/highlighter/ GeSHi - Generic Syntax Highlighter]',
	'syntaxhighlight-specify'      => 'You need to specify a language like this:',
	'syntaxhighlight-supported'    => 'Supported languages for syntax highlighting:',
	'syntaxhighlight-err-loading'  => '(error loading supported language list)',
	'syntaxhighlight-err-language' => 'Invalid language.',
	'geshi.css'                    => '/* CSS placed here will be applied to GeSHi syntax highlighting */',
);

/** Message documentation (Message documentation)
 * @author Meno25
 * @author The Evil IP address
 */
$messages['qqq'] = array(
	'syntaxhighlight-desc' => '{{desc}}',
);

/** Afrikaans (Afrikaans)
 * @author Naudefj
 * @author SPQRobin
 * @author පසිඳු කාවින්ද
 */
$messages['af'] = array(
	'syntaxhighlight-specify' => "U moet 'n taal as volg spesifiseer:",
	'syntaxhighlight-supported' => 'Ondersteunde tale vir accentuering:',
	'syntaxhighlight-err-loading' => '(fout met die laai van die lys van ondersteunde tale)',
	'syntaxhighlight-err-language' => 'Ongeldige taal.',
);

/** Aragonese (Aragonés)
 * @author Juanpabl
 */
$messages['an'] = array(
	'syntaxhighlight-desc' => 'Premite o resalte sintactico <code>&lt;syntaxhighlight&gt;</code> usando [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => "Ha d'endicar un lenguache asinas:",
	'syntaxhighlight-supported' => 'Lenguaches suportatos ta o resalte sintactico:',
	'syntaxhighlight-err-loading' => '(error en cargar a lista de luengaches suportatos)',
	'syntaxhighlight-err-language' => 'Luengache invalido.',
	'geshi.css' => "/* Iste codigo CSS s'aplicará ta destacar a sintaxi GeSHi*/",
);

/** Arabic (العربية)
 * @author Meno25
 */
$messages['ar'] = array(
	'syntaxhighlight-desc' => 'يوفر تعليم النص <code>&lt;syntaxhighlight&gt;</code> باستخدام [http://qbnz.com/highlighter/ معلم GeSHi]',
	'syntaxhighlight-specify' => 'يجب عليك تحديد لغة مثل هذه:',
	'syntaxhighlight-supported' => 'اللغات المدعومة لتظليل الصياغة:',
	'syntaxhighlight-err-loading' => '(خطأ في تحميل قائمة اللغات المدعومة)',
	'syntaxhighlight-err-language' => 'لغة غير صحيحة.',
	'geshi.css' => '/* الأنماط المتراصة CSS المعروضة هنا ستطبق على تظليل صياغة GeSHi */',
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Meno25
 * @author Ramsis II
 */
$messages['arz'] = array(
	'syntaxhighlight-desc' => 'بيوفر تظليل السينتاكس <code>&lt;syntaxhighlight&gt;</code> باستعمال [http://qbnz.com/highlighter/ GeSHi مظلل]',
	'syntaxhighlight-specify' => 'انت لازم تحدد لغة زى كدا:',
	'syntaxhighlight-supported' => 'اللغات المدعومة لتظليل السينتاكس:',
	'syntaxhighlight-err-loading' => '(غلط فى تحميل لستة اللغات المدعومة)',
	'syntaxhighlight-err-language' => 'لغة مش صحيحة',
	'geshi.css' => '/* CSS المحطوطة هنا ح تتطبق على تظليل سينتاكس الGeSHi */',
);

/** Asturian (Asturianu)
 * @author Esbardu
 */
$messages['ast'] = array(
	'syntaxhighlight-desc' => 'Proporciona resaltáu de sintaxis <code>&lt;syntaxhighlight&gt;</code> usando [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Necesites conseñar una llingua como esta:',
	'syntaxhighlight-supported' => 'Llingües sofitaes pa la sintaxis en colores:',
	'syntaxhighlight-err-loading' => '(error al cargar la llista de llingües sofitaes)',
	'syntaxhighlight-err-language' => 'Llingua non válida.',
	'geshi.css' => '/* El códigu CSS allugáu equí va ser aplicáu por GeSHi pa la sintaxis en colores */',
);

/** Bashkir (Башҡортса)
 * @author Assele
 */
$messages['ba'] = array(
	'syntaxhighlight-desc' => '[http://qbnz.com/highlighter/ GeSHi Highlighter] ярҙамында синтаксисты айырып күрһәтеү өсөн <code>&lt;syntaxhighlight&gt;</code> билдәһен ҡулланыу мөмкинлеген бирә',
	'syntaxhighlight-specify' => 'Һеҙ телде түбәндәгесә күрһәтергә тейешһегеҙ:',
	'syntaxhighlight-supported' => 'Синтаксисты айырып күрһәтеү мөмкин булған телдәр:',
	'syntaxhighlight-err-loading' => '(телдәр исемлеген сығарыу хатаһы)',
	'syntaxhighlight-err-language' => 'Тел дөрөҫ түгел.',
	'geshi.css' => '/* Бында ҡуйылған CSS-код систанксисты GeSHi ярҙамында айырып күрһәтеү өсөн ҡулланыласаҡ */',
);

/** Southern Balochi (بلوچی مکرانی)
 * @author Mostafadaneshvar
 */
$messages['bcc'] = array(
	'syntaxhighlight-desc' => 'ساختار پررنگی آریت <code>&lt;syntaxhighlight&gt;</code> گون استفاده چه[http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'لازمنت شما یک زبانی په داب شی مشخض کنیت:',
	'syntaxhighlight-supported' => 'حمایتی زبانان په ساختار پررنگی:',
	'syntaxhighlight-err-loading' => '(حطا ته بار کتن لیست زبان داشتگین)',
	'syntaxhighlight-err-language' => 'نامعتبرین زبان',
	'geshi.css' => '/* CSS که ادان هستن ته ساختار جی شی پررنگ کتن کارمرز بین */',
);

/** Belarusian (Taraškievica orthography) (‪Беларуская (тарашкевіца)‬)
 * @author EugeneZelenko
 * @author Jim-by
 */
$messages['be-tarask'] = array(
	'syntaxhighlight-desc' => 'Дазваляе выкарыстоўваць тэг  <code>&lt;syntaxhighlight&gt;</code> для падсьветкі сынтаксісу з дапамогай [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Вам неабходна пазначыць мову наступным чынам:',
	'syntaxhighlight-supported' => 'Мовы, якія падтрымліваюцца для праверкі сынтаксісу:',
	'syntaxhighlight-err-loading' => '(памылка загрузкі сьпісу моваў)',
	'syntaxhighlight-err-language' => 'Мова не падтрымліваецца.',
	'geshi.css' => '/* CSS, разьмешчаны тут, будзе выкарыстоўвацца для падсьветкі сынтаксісу GeSHi */',
);

/** Bulgarian (Български)
 * @author Borislav
 * @author DCLXVI
 * @author Turin
 */
$messages['bg'] = array(
	'syntaxhighlight-desc' => 'Осигурява синтактично осветяване на <code>&lt;syntaxhighlight&gt;</code> чрез [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Нужно е да укажете език по следния начин:',
	'syntaxhighlight-supported' => 'Поддържани езици за синтактично открояване:',
	'syntaxhighlight-err-loading' => '(грешка при зареждането на списъка на поддържаните езици)',
	'syntaxhighlight-err-language' => 'Невалиден език.',
	'geshi.css' => '/* Евентуален код на CSS, поставен тук, ще бъде използван за синтактичното открояване чрез GeSHi */',
);

/** Bengali (বাংলা)
 * @author Zaheen
 */
$messages['bn'] = array(
	'syntaxhighlight-desc' => '[http://qbnz.com/highlighter/ GeSHi হাইলাইটার] ব্যবহার করে <code>&lt;syntaxhighlight&gt;</code> সিনট্যাক্স হাইলাইটিং-এর ক্ষমতা দেয়',
	'syntaxhighlight-specify' => 'আপনাকে এভাবে একটি ভাষা নির্দিষ্ট করতে হবে:',
	'syntaxhighlight-supported' => 'যেসব ভাষার জন্য সিনট্যাক্স হাইলাইটিং সমর্থিত:',
	'syntaxhighlight-err-loading' => '(সমর্থিত ভাষার তালিকা আনতে ত্রুটি)',
	'syntaxhighlight-err-language' => 'অবৈধ ভাষা।',
	'geshi.css' => '/* এখানে স্থাপিত CSS কোড GeSHi সিনট্যাক্স হাইলাইটিং-এ ব্যবহার করা হবে */',
);

/** Breton (Brezhoneg)
 * @author Fulup
 */
$messages['br'] = array(
	'syntaxhighlight-desc' => 'Talvezout a ra da lakaat an ereadur war wel dre ar valizenn <code>&lt;syntaxhighlight&gt;</code> en ur ober gant [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => "Ret eo deoc'h spisaat ur yezh evel-henn :",
	'syntaxhighlight-supported' => 'Yezhoù skoret evit al livadur ereadurel :',
	'syntaxhighlight-err-loading' => '(fazi en ur gargañ roll ar yezhoù skoret)',
	'syntaxhighlight-err-language' => 'Yezh direizh.',
	'geshi.css' => "/* Talvezout a raio ar c'hod CSS lakaet amañ d'al livadur ereadurel GeSHi */",
);

/** Bosnian (Bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'syntaxhighlight-desc' => 'Omogućava isticanje sintakse <code>&lt;syntaxhighlight&gt;</code> uz pomoć [http://qbnz.com/highlighter/ GeSHi Highlightera]',
	'syntaxhighlight-specify' => 'Potrebno je da specificirate jezik ovako:',
	'syntaxhighlight-supported' => 'Podržani jezici za isticanje sintakse:',
	'syntaxhighlight-err-loading' => '(greška pri korištenju spiska podržanih jezika)',
	'syntaxhighlight-err-language' => 'Pogrešan jezik.',
	'geshi.css' => '/* CSS koji se ovdje postavi će biti korišten za isticanje GeSHi sintakse */',
);

/** Catalan (Català)
 * @author SMP
 * @author Solde
 */
$messages['ca'] = array(
	'syntaxhighlight-desc' => "Proveeix de ressaltat sintàctic amb l'etiqueta <code>&lt;syntaxhighlight&gt;</code> usant el programa [http://qbnz.com/highlighter/ GeSHi]",
	'syntaxhighlight-specify' => "Heu d'especificar un dels llenguatges:",
	'syntaxhighlight-supported' => 'Llenguatges admesos per al ressaltament sintàctic:',
	'syntaxhighlight-err-loading' => '(error en carregar la llista de llenguatges)',
	'syntaxhighlight-err-language' => 'Llenguatge invàlid.',
	'geshi.css' => '/* El CSS ubicat aquí serà aplicat al ressaltat de sintaxi de GeSHi */',
);

/** Chechen (Нохчийн)
 * @author Sasan700
 */
$messages['ce'] = array(
	'geshi.css' => '/* CSS-ишар, кху чу хlоттайахь, оцо болх бийра бу сизашдо беснашна хlокхуньца GeSHI */',
);

/** Czech (Česky)
 * @author Li-sung
 * @author Matěj Grabovský
 */
$messages['cs'] = array(
	'syntaxhighlight-desc' => 'Poskytuje zvýrazňování syntaxe <code>&lt;syntaxhighlight&gt;</code> pomocí [http://qnbz.com/higlighter zvýrazňovače GeSHi]',
	'syntaxhighlight-specify' => 'Musíte určit jazyk tímto způsobem:',
	'syntaxhighlight-supported' => 'Seznam jazyků, u kterých je podporováno zvýrazňování syntaxe:',
	'syntaxhighlight-err-loading' => '(chyba při načítání seznamu podporovaných jazyků)',
	'syntaxhighlight-err-language' => 'Neplatný jazyk.',
	'geshi.css' => '/* Zde uvedené CSS bude ovlivňovat zvýrazňování syntaxe GeSHi */',
);

/** Danish (Dansk)
 * @author Sarrus
 */
$messages['da'] = array(
	'syntaxhighlight-err-language' => 'Ugyldigt sprog.',
);

/** German (Deutsch)
 * @author Kghbln
 * @author Raimond Spekking
 */
$messages['de'] = array(
	'syntaxhighlight-desc' => 'Ergänzt das Tag <code>&lt;syntaxhighlight&gt;</code> zur Syntaxhervorhebung mit Hilfe des [http://qbnz.com/highlighter/ Generic Syntax Highlighter (GeSHi)]',
	'syntaxhighlight-specify' => 'Die gewünschte Sprache muss wie folgt definiert werden:',
	'syntaxhighlight-supported' => 'Unterstützte Sprachen für die Syntaxhervorhebung:',
	'syntaxhighlight-err-loading' => '(Fehler beim Laden der Sprachenliste)',
	'syntaxhighlight-err-language' => 'Ungültige Sprache.',
	'geshi.css' => '/* CSS in dieser MediaWiki-Systemnachricht wird auf die GeSHi-Syntaxhervorhebung angewendet */',
);

/** Zazaki (Zazaki)
 * @author Aspar
 */
$messages['diq'] = array(
	'syntaxhighlight-desc' => 'pê şuxulnayişê [http://qbnz.com/highlighter/ GeSHi Highlighter] i rêza <code>&lt;syntaxhighlight&gt;</code> i işaret beno',
	'syntaxhighlight-specify' => 'zey ıni yew zıwan bıvıcinê:',
	'syntaxhighlight-supported' => 'zıwanê ke rêzvateyê eyi destek beni',
	'syntaxhighlight-err-loading' => '(zıwanê ke destek geni, wexata bar biyene xeta da)',
	'syntaxhighlight-err-language' => 'zıwano nemeqbul',
	'geshi.css' => 'CSS o ke tiya /* de yo, işaretê rêzvateyê GeSHi tetbiq beno */',
);

/** Lower Sorbian (Dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'syntaxhighlight-desc' => 'Zmóžnja syntaksowe wuzwignjenje <code>&lt;syntaxhighlight&gt;</code> z pomocu [http://qbnz.com/highlighter/ rěda GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Musyš rěc kaž slědujo pódaś:',
	'syntaxhighlight-supported' => 'Pódpěrane rěcy za syntaksowe wuzwignjenje:',
	'syntaxhighlight-err-loading' => '(zmólka pśi zacytowanju lisćiny pódpěranych rěcow)',
	'syntaxhighlight-err-language' => 'Njepłaśiwa rěc.',
	'geshi.css' => '/* How pódaty CSS nałožujo se na syntaksowe wuzwignjenje GeSHi */',
);

/** Greek (Ελληνικά)
 * @author Badseed
 * @author Consta
 * @author Dead3y3
 * @author ZaDiak
 */
$messages['el'] = array(
	'syntaxhighlight-desc' => 'Παρέχει έμφαση σύνταξης <code>&lt;syntaxhighlight&gt;</code> χρησιμοποιώντας το [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Πρέπει να επιλέξετε μια γλώσσα σαν κι αυτήν:',
	'syntaxhighlight-supported' => 'Υποστηριζόμενες γλώσσες για επισημάνσεις συντακτικού',
	'syntaxhighlight-err-loading' => '(λάθος στη φόρτωση της λίστας των υποστηριζόμενων γλωσσών)',
	'syntaxhighlight-err-language' => 'Άκυρη γλώσσα.',
	'geshi.css' => '/* Το CSS τοποθετημένο εδώ θα εφαρμοστεί στo GeSHi syntax highlighting */',
);

/** Esperanto (Esperanto)
 * @author Michawiki
 * @author Yekrats
 */
$messages['eo'] = array(
	'syntaxhighlight-desc' => 'Provizas kolorigado de sintakso <code>&lt;syntaxhighlight&gt;</code> per [http://qbnz.com/highlighter/ GeSHi Kolorigilo de Sintakso]',
	'syntaxhighlight-specify' => 'Vi nepre specifu lingvon kiel ĉi tiu:',
	'syntaxhighlight-supported' => 'Subtenaj lingvoj por sintaksa emfazo',
	'syntaxhighlight-err-loading' => '(eraro ŝarĝante subtenitan lingvo-liston)',
	'syntaxhighlight-err-language' => 'Malvalida lingvo.',
	'geshi.css' => '/* CSS enigita ĉi tie estos sintakse emfazita de GeSHi */',
);

/** Spanish (Español)
 * @author Crazymadlover
 * @author Muro de Aguas
 * @author Remember the dot
 * @author Sanbec
 */
$messages['es'] = array(
	'syntaxhighlight-desc' => 'Permite resaltar el código fuente usando la etiqueta <code>&lt;syntaxhighlight&gt;</code>. Esta extensión usa [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Necesita especificar un idioma como esto:',
	'syntaxhighlight-supported' => 'lenguajes soportados para sintaxis remarcada:',
	'syntaxhighlight-err-loading' => '(error cargando lista de lenguajes soportados)',
	'syntaxhighlight-err-language' => 'Idioma no válido.',
	'geshi.css' => '/* El código CSS situado aquí afectará al resaltado de sintaxis de GeSHi */',
);

/** Estonian (Eesti)
 * @author Pikne
 * @author [[et:Kasutaja:M2s17]]
 */
$messages['et'] = array(
	'syntaxhighlight-desc' => 'Võimaldab [http://qbnz.com/highlighter/ GeSHi] abil <code>&lt;syntaxhighlight&gt;</code>-märgendit kasutades süntaksit esile tõsta.',
	'syntaxhighlight-specify' => 'Sa pead täpsustama keelt nõnda:',
	'syntaxhighlight-supported' => 'Süntaksi esiletoomise on toetatud järgnevates keeltes:',
	'syntaxhighlight-err-loading' => '(toetatud keelte loetelu laadimisel esines viga)',
	'syntaxhighlight-err-language' => 'antud keel on mittekehtiv',
	'geshi.css' => '/* CSS mis on asetatud siia, määrab GeSHi süntaksi esiletoomise stiili */',
);

/** Basque (Euskara)
 * @author An13sa
 */
$messages['eu'] = array(
	'syntaxhighlight-specify' => 'Hizkuntza bat zehaztu behar duzu honela:',
	'syntaxhighlight-err-language' => 'Baliogabeko hizkuntza.',
);

/** Persian (فارسی)
 * @author Ebraminio
 * @author Huji
 */
$messages['fa'] = array(
	'syntaxhighlight-desc' => 'امکان رنگین کردن دستورات <code>&lt;syntaxhighlight&gt;</code> با استفاده از [http://qbnz.com/highlighter/ GeSHi Highlighter] را فراهم می‌آورد',
	'syntaxhighlight-specify' => 'شما باید به این شکل زبانی را مشخص کنید:',
	'syntaxhighlight-supported' => 'زبان‌های پشتیبانی‌شده برای رنگین‌کردن دستورات:',
	'syntaxhighlight-err-loading' => '(خطا در بارگذاری فهرست زبان‌های پشتیبانی‌شده)',
	'syntaxhighlight-err-language' => 'زبان غیرمجاز.',
	'geshi.css' => '/* دستورات CSS اینجا توسط سامانه رنگین‌کردن دستورات GeSHi به کار گرفته می‌شوند */',
);

/** Finnish (Suomi)
 * @author Crt
 * @author Nike
 */
$messages['fi'] = array(
	'syntaxhighlight-desc' => 'Mahdollistaa syntaksin korostuksen [http://qbnz.com/highlighter/ GeSHillä] <code>&lt;syntaxhighlight&gt;</code>-elementtiä käyttämällä.',
	'syntaxhighlight-specify' => 'Kieli pitää määritellä seuraavasti:',
	'syntaxhighlight-supported' => 'Syntaksinkorostus on mahdollista seuraaville kielille:',
	'syntaxhighlight-err-loading' => '(tuettujen kielten luettelon lataaminen epäonnistui)',
	'syntaxhighlight-err-language' => 'Kelpaamaton kieli.',
	'geshi.css' => '/* Tänne lisätty CSS vaikuttaa GeSHi-syntaksinkorostukseen */',
);

/** French (Français)
 * @author Grondin
 * @author Sherbrooke
 * @author Verdy p
 */
$messages['fr'] = array(
	'syntaxhighlight-desc' => 'Fournit la mise en relief de la syntaxe par la balise <code>&lt;syntaxhighlight&gt;</code> en utilisant [http://qbnz.com/highlighter/ la coloration syntaxique GeSHi]',
	'syntaxhighlight-specify' => 'Vous devez spécifier un langage comme ceci :',
	'syntaxhighlight-supported' => 'Langages supportés pour la coloration syntaxique :',
	'syntaxhighlight-err-loading' => '(erreur en chargeant la liste des langages supportés)',
	'syntaxhighlight-err-language' => 'Langage invalide',
	'geshi.css' => '/* Le code CSS inséré ici sera appliqué à la coloration syntaxique GeSHi. */',
);

/** Franco-Provençal (Arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'syntaxhighlight-desc' => 'Balye la misa en èvidence de la sintaxa per la balisa <code>&lt;syntaxhighlight&gt;</code> en utilisent [http://qbnz.com/highlighter/ la coloracion sintaxica GeSHi].',
	'syntaxhighlight-specify' => 'Vos dête spècefiar un lengâjo d’ense :',
	'syntaxhighlight-supported' => 'Lengâjos recognus por la coloracion sintaxica :',
	'syntaxhighlight-err-loading' => '(èrror en chargient la lista des lengâjos recognus)',
	'syntaxhighlight-err-language' => 'Lengâjo envalido.',
	'geshi.css' => '/* Lo code CSS betâ ique serat aplicâ a la coloracion sintaxica GeSHi. */',
);

/** Friulian (Furlan)
 * @author Klenje
 */
$messages['fur'] = array(
	'syntaxhighlight-supported' => 'Lengaç par cui si pues colorâ la sintassi:',
);

/** Irish (Gaeilge)
 * @author Alison
 */
$messages['ga'] = array(
	'syntaxhighlight-err-language' => 'Teanga neamhbhailí.',
);

/** Galician (Galego)
 * @author Toliño
 * @author Xosé
 */
$messages['gl'] = array(
	'syntaxhighlight-desc' => 'Proporciona unha sintaxe resaltada <code>&lt;syntaxhighlight&gt;</code> usando [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Ten que especificar unha lingua, así:',
	'syntaxhighlight-supported' => 'Linguas soportadas para resaltar a sintaxe:',
	'syntaxhighlight-err-loading' => '(erro ao cargar a lista de linguas soportadas)',
	'syntaxhighlight-err-language' => 'A lingua non é válida.',
	'geshi.css' => '/* O CSS colocado aquí será aplicado ao resalte da sintaxe de GeSHi */',
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ)
 * @author Omnipaedista
 */
$messages['grc'] = array(
	'syntaxhighlight-err-language' => 'Ἄκυρος γλῶττα.',
);

/** Swiss German (Alemannisch)
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'syntaxhighlight-desc' => 'Syntax firihebe <code>&lt;syntaxhighlight&gt;</code> mit Hilf vum [http://qbnz.com/highlighter/ GeSHi-Highlighter]',
	'syntaxhighlight-specify' => 'Di gwinscht Sproch muess eso definiert wäre:',
	'syntaxhighlight-supported' => 'Unterstitzti Sproche fir s Fiirihebe vu dr Syntax:',
	'syntaxhighlight-err-loading' => '(Fehler bim Lade vu dr Sprochelischt)',
	'syntaxhighlight-err-language' => 'Nit giltigi Sproch.',
	'geshi.css' => '/* CSS in däre MediaWiki-Syschtemnochricht wird uf s GeSHi-Syntax-Firihebe aagwändet */',
);

/** Gujarati (ગુજરાતી)
 * @author Ashok modhvadia
 */
$messages['gu'] = array(
	'syntaxhighlight-supported' => 'વાક્યરચના સ્પષ્ટીકરણ માટે સહાયક ભાષાઓ:',
	'syntaxhighlight-err-loading' => '(સહાયક ભાષા યાદી લાદણમાં ત્રુટિ)',
	'syntaxhighlight-err-language' => 'અમાન્ય ભાષા.',
);

/** Hebrew (עברית)
 * @author Rotem Liss
 */
$messages['he'] = array(
	'syntaxhighlight-desc' => 'אפשרות לסימון קוד מקור בצבעים עם התגית <code>&lt;syntaxhighlight&gt;</code> באמצעות [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'עליכם לציין שפה באופן הבא:',
	'syntaxhighlight-supported' => 'שפות נתמכות:',
	'syntaxhighlight-err-loading' => '(שגיאה בטעינת הרשימה של השפות הנתמכות)',
	'syntaxhighlight-err-language' => 'שפה שגויה.',
	'geshi.css' => '/* סגנונות CSS שייכתבו כאן יפעלו על התגית source */',
);

/** Hindi (हिन्दी)
 * @author Kaustubh
 * @author Shyam
 */
$messages['hi'] = array(
	'syntaxhighlight-desc' => '[http://qbnz.com/highlighter/ GeSHi Highlighter] प्रयोग करके चिन्हांकित <code>&lt;syntaxhighlight&gt;</code> वाक्य विश्लेषण उपलब्ध करता है',
	'syntaxhighlight-specify' => 'आपने इसप्रकार भाषा देना जरूरी हैं:',
	'syntaxhighlight-supported' => 'सिन्टॅक्स हायलायटींग निम्नलिखित भाषाओंके लिये उपलब्ध हैं:',
	'syntaxhighlight-err-loading' => '(सपोर्टेड भाषाओंकी सूची नहीं दर्शा पा रहें हैं)',
	'syntaxhighlight-err-language' => 'अवैध भाषा।',
	'geshi.css' => '/* यहाँ पर उपस्थित CSS GeSHi चिन्हांकित वाक्य विश्लेषण पर प्रयोग किए जायेंगे */',
);

/** Croatian (Hrvatski)
 * @author Dalibor Bosits
 * @author SpeedyGonsales
 */
$messages['hr'] = array(
	'syntaxhighlight-desc' => 'Omogućava bojanje sintakse <code>&lt;syntaxhighlight&gt;</code> korištenjem [http://qbnz.com/highlighter/ GeSHi Highlighter-a]',
	'syntaxhighlight-specify' => 'Molimo navedite jezik na slijedeći način:',
	'syntaxhighlight-supported' => 'Jezici podržani za bojanje sintakse:',
	'syntaxhighlight-err-loading' => '(greška pri učitavanju popisa podržanih jezika)',
	'syntaxhighlight-err-language' => 'Nevaljani jezik.',
	'geshi.css' => '/* CSS kod napisan ovdje će biti primijenjen na GeSHi bojanje sintakse */',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'syntaxhighlight-desc' => 'Syntaksowe wuzběhnjenje <code>&lt;syntaxhighlight&gt;</code> z pomocu rozšěrjenja [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Dyrbiš rěč takle definować:',
	'syntaxhighlight-supported' => 'Podpěrowane rěče za syntaksowe wuzběhnjenje:',
	'syntaxhighlight-err-loading' => '(Zmylk při začitanju lisćiny rěčow)',
	'syntaxhighlight-err-language' => 'Njepłaćiwa rěč.',
	'geshi.css' => '/* CSS w tutej zdźělence so na syntaksowe wuzběhnjenje GeSHi nałoži */',
);

/** Hungarian (Magyar)
 * @author Dani
 */
$messages['hu'] = array(
	'syntaxhighlight-desc' => 'Lehetőséget nyújt szintaxiskiemelésre a <code>&lt;syntaxhighlight&gt;</code> tag-gel, a [http://qbnz.com/highlighter/ GeSHi Highlighter] használatával',
	'syntaxhighlight-specify' => 'Meg kell adnod egy nyelvet az alábbi módon:',
	'syntaxhighlight-supported' => 'Támogatott programozási nyelvek:',
	'syntaxhighlight-err-loading' => '(hiba történt a támogatott nyelvek listájának betöltése közben)',
	'syntaxhighlight-err-language' => 'Érvénytelen nyelv.',
	'geshi.css' => '/* Az itt elhelyezett CSS-t fogja alkalmazni a GeSHi szintaxiskiemelő */',
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'syntaxhighlight-desc' => 'Forni le coloration syntactic in <code>&lt;syntaxhighlight&gt;</code> per medio de [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Tu debe specificar un linguage in iste modo:',
	'syntaxhighlight-supported' => 'Linguages supportate pro le coloration syntactic:',
	'syntaxhighlight-err-loading' => '(error durante le cargamento del lista de linguages supportate)',
	'syntaxhighlight-err-language' => 'Linguage invalide.',
	'geshi.css' => '/* Omne CSS inserite hic se applicara al coloration syntactic con GeSHi */',
);

/** Indonesian (Bahasa Indonesia)
 * @author IvanLanin
 */
$messages['id'] = array(
	'syntaxhighlight-desc' => 'Memberikan penyorotan sintaks <code>&lt;syntaxhighlight&gt;</code> menggunakan [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Anda harus menentukan suatu bahasa seperti ini:',
	'syntaxhighlight-supported' => 'Bahasa-bahasa yang didukung oleh pewarnaan sintaks:',
	'syntaxhighlight-err-loading' => '(kesalahan pemuatan daftar bahasa yang didukung)',
	'syntaxhighlight-err-language' => 'Bahasa tak sah.',
	'geshi.css' => '/* CSS di sini akan diterapkan untuk penyorotan sintaks GeSHi */',
);

/** Interlingue (Interlingue)
 * @author Renan
 */
$messages['ie'] = array(
	'syntaxhighlight-desc' => 'Provide superation de sintaxe de li code fonte, che li element <code>&lt;syntaxhighlight&gt;</code>, usant li [http://qbnz.com/highlighter/ GeSHi - Generic Syntax Highlighter]',
	'syntaxhighlight-specify' => 'Vu besona specificar li lingue quam ti:',
	'syntaxhighlight-supported' => 'Lingues suportat por superation de sintaxe:',
	'syntaxhighlight-err-language' => 'Lingue ínvalid.',
);

/** Igbo (Igbo)
 * @author Ukabia
 */
$messages['ig'] = array(
	'syntaxhighlight-err-language' => 'Asụsụ ámághị.',
);

/** Ido (Ido)
 * @author Malafaya
 */
$messages['io'] = array(
	'syntaxhighlight-err-language' => 'Ne-valida linguo.',
);

/** Italian (Italiano)
 * @author BrokenArrow
 */
$messages['it'] = array(
	'syntaxhighlight-desc' => 'Evidenzia la sintassi dei linguaggi di programmazione <code>&lt;syntaxhighlight&gt;</code> tramite [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'È necessario specificare un linguaggio in questo modo:',
	'syntaxhighlight-supported' => 'Linguaggi di cui è possibile evidenziare la sintassi in colore:',
	'syntaxhighlight-err-loading' => "(errore nel caricamento dell'elenco dei linguaggi supportati)",
	'syntaxhighlight-err-language' => 'Linguaggio non riconosciuto.',
	'geshi.css' => "/* Gli stili CSS inseriti qui si applicano all'evidenziazione di sintassi con GeSHi */",
);

/** Japanese (日本語)
 * @author Aotake
 * @author Fryed-peach
 * @author JtFuruhata
 */
$messages['ja'] = array(
	'syntaxhighlight-desc' => '[http://qbnz.com/highlighter/ GeSHi 構文ハイライト機能] を利用したタグ <code>&lt;syntaxhighlight&gt;</code> を提供する',
	'syntaxhighlight-specify' => '以下のように言語を指定する必要があります:',
	'syntaxhighlight-supported' => '構文ハイライト機能に対応している言語は以下の通りです:',
	'syntaxhighlight-err-loading' => '(対応言語一覧の読み込み時にエラーが発生しました)',
	'syntaxhighlight-err-language' => '不正な言語名です。',
	'geshi.css' => '/* ここへ、GeShi 構文ハイライト機能に適用する CSS を記述してください */',
);

/** Jutish (Jysk)
 * @author Huslåke
 * @author Ælsån
 */
$messages['jut'] = array(
	'syntaxhighlight-desc' => 'Gäv syntaks highlighting <code>&lt;syntaxhighlight&gt;</code> via [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Du nødst til spæsifiær en språg als dette:',
	'syntaxhighlight-supported' => 'Understønde språg før syntaks highlighting:',
	'syntaxhighlight-err-loading' => '(fejl lægende understønde språg liste)',
	'syntaxhighlight-err-language' => 'Fejl språg.',
	'geshi.css' => '/* CSS platsk her hvil være appliærn til GeSHi syntaks highlighting */',
);

/** Javanese (Basa Jawa)
 * @author Meursault2004
 */
$messages['jv'] = array(
	'syntaxhighlight-desc' => 'Mènèhaké panyorotan sintaksis <code>&lt;syntaxhighlight&gt;</code> nganggo [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Panjenengan kudu nentokaké sawijining basa kaya iki:',
	'syntaxhighlight-supported' => 'Basa-basa sing disengkuyung déning panandhan werna sintaksis:',
	'syntaxhighlight-err-loading' => '(ana kaluputan ngunggahaké daftar basa sing disengkuyung)',
	'syntaxhighlight-err-language' => 'Basané ora absah.',
	'geshi.css' => '/* CSS ing kéné bakal ditrapaké kanggo panyorotan sintaksis GeSHi */',
);

/** Georgian (ქართული)
 * @author გიორგიმელა
 */
$messages['ka'] = array(
	'syntaxhighlight-desc' => 'გაძლევთ ნებართვას ფამოიყენოთ თეგი <code>&lt;syntaxhighlight&gt;</code> სინტაქსის გასანათებლად[http://qbnz.com/highlighter/ GeSHi Highlighter-ის] მეშვეობით',
	'syntaxhighlight-specify' => 'თქვენ უნდა წარადგინოთ სახელი შემდეგი სახით:',
	'syntaxhighlight-supported' => 'მხარდამჭერი ახელები',
	'syntaxhighlight-err-loading' => '(შეუძებელია მხარდამჭერი ენების სიის ატვირთვა)',
	'syntaxhighlight-err-language' => 'მოთხოვნილია მხარდაჭერის არმქონე ენა',
	'geshi.css' => '/* აქ წარმოდგენილი CSS-კოდი, გამოიყენება GeSHI სნტაქსის გასანათებლად*/',
);

/** Kazakh (Arabic script) (‫قازاقشا (تٴوتە)‬)
 * @author AlefZet
 */
$messages['kk-arab'] = array(
	'syntaxhighlight-specify' => 'ٴتىلدى بىلايشا كورسەتۋىڭىز قاجەت:',
	'syntaxhighlight-supported' => 'سىينتاكسىيسى كومەسكى جارىقتالاتىن سۇيەمەلدەنگەن تىلدەر:',
	'syntaxhighlight-err-loading' => '(سۇيەمەلدەنگەن تىلدەر ٴتىزىمىن جۇكتەۋ قاتەسى)',
	'syntaxhighlight-err-language' => 'جارامسىز ٴتىل.',
	'geshi.css' => '/* مىنداعى CSS امىرلەرى GeSHi سىينتاكسىيستى كومەسكى جارىقتاۋعا قولدانىلادى */',
);

/** Kazakh (Cyrillic script) (‪Қазақша (кирил)‬)
 * @author AlefZet
 */
$messages['kk-cyrl'] = array(
	'syntaxhighlight-specify' => 'Тілді былайша көрсетуіңіз қажет:',
	'syntaxhighlight-supported' => 'Синтаксисі көмескі жарықталатын сүйемелденген тілдер:',
	'syntaxhighlight-err-loading' => '(сүйемелденген тілдер тізімін жүктеу қатесі)',
	'syntaxhighlight-err-language' => 'Жарамсыз тіл.',
	'geshi.css' => '/* Мындағы CSS әмірлері GeSHi синтаксисті көмескі жарықтауға қолданылады */',
);

/** Kazakh (Latin script) (‪Qazaqşa (latın)‬)
 * @author AlefZet
 */
$messages['kk-latn'] = array(
	'syntaxhighlight-specify' => 'Tildi bılaýşa körsetwiñiz qajet:',
	'syntaxhighlight-supported' => 'Sïntaksïsi kömeski jarıqtalatın süýemeldengen tilder:',
	'syntaxhighlight-err-loading' => '(süýemeldengen tilder tizimin jüktew qatesi)',
	'syntaxhighlight-err-language' => 'Jaramsız til.',
	'geshi.css' => '/* Mındağı CSS ämirleri GeSHi sïntaksïsti kömeski jarıqtawğa qoldanıladı */',
);

/** Khmer (ភាសាខ្មែរ)
 * @author Chhorran
 * @author គីមស៊្រុន
 */
$messages['km'] = array(
	'syntaxhighlight-specify' => 'អ្នកចាំបាច់ សំដៅ មួយភាសា ដូច នេះ ៖',
	'syntaxhighlight-err-loading' => '(បញ្ហាក្នុងការរៀបចំបញ្ជីភាសាដែលប្រើបាន)',
	'syntaxhighlight-err-language' => 'ភាសា គ្មានសុពលភាព ។',
);

/** Korean (한국어)
 * @author Kwj2772
 * @author ToePeu
 */
$messages['ko'] = array(
	'syntaxhighlight-desc' => '<code>&lt;syntaxhighlight&gt;</code> 태그로 [http://qbnz.com/highlighter/ GeSHi Highlighter]를 이용해 문법 강조 기능을 지원합니다.',
	'syntaxhighlight-specify' => '오른쪽과 같이 언어를 설정해야 합니다:',
	'syntaxhighlight-supported' => '문법 강조가 지원되는 언어 목록',
	'syntaxhighlight-err-loading' => '(지원하는 언어 목록을 불러오는 중 오류 발생)',
	'syntaxhighlight-err-language' => '잘못된 언어 설정입니다.',
	'geshi.css' => '/* 이 문서에서 설정한 CSS는 GeSHi에 적용됩니다. */',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'syntaxhighlight-desc' => 'Deijt — en <code>&lt;syntaxhighlight&gt;</code>-Affschnedde — de Syntax fon beshtemmpte Computer-Shprooche makeere. Bruch dobei dä [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Mer moß en Shprooch aanjevve, esu en dä Aat wi hee:',
	'syntaxhighlight-supported' => 'Di Shprooche, dänne ier Syntax mer makeere könne, sin:',
	'syntaxhighlight-err-loading' => '(Enne Fääler es opjetrodde, wi mer de Leß met de Shprooch laade wollte)',
	'syntaxhighlight-err-language' => 'Di Shprooch kenne mer nit.',
	'geshi.css' => '/* Dat es dat CCS för de Afschnedde med däm GeSHi syntax highlighting */',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Les Meloures
 * @author Robby
 */
$messages['lb'] = array(
	'syntaxhighlight-desc' => "Syntax-Ervirhiewung <code>&lt;syntaxhighlight&gt;</code> mat Hëllef vu [http://qbnz.com/highlighter/ 'GeSHi Highlighter']",
	'syntaxhighlight-specify' => 'Déi gewënschte Sprooch muss esou definéiert ginn:',
	'syntaxhighlight-supported' => "Ënnerstëtzte Sprooche fir d'Syntax faarweg ze markéieren",
	'syntaxhighlight-err-loading' => '(Feeler beim Luede vun der Lëscht vun den ënnerstëtzte Sproochen)',
	'syntaxhighlight-err-language' => 'Net valabel Sprooch.',
	'geshi.css' => "/* Den CSS deen hei steet gëtt benotzt fir d'GeSHi Syntax faarweg ze markéieren. /*",
);

/** Limburgish (Limburgs)
 * @author Ooswesthoesbes
 */
$messages['li'] = array(
	'syntaxhighlight-desc' => 'Guf syntaxismarkering <code>&lt;syntaxhighlight&gt;</code> gebroekende [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => "Gaef 'ne taal es volg op:",
	'syntaxhighlight-supported' => 'Óngersteunde täöl veur syntaxismarkering:',
	'syntaxhighlight-err-loading' => "(fout bie 't laje vanne lies mit óngersteunde täöl)",
	'syntaxhighlight-err-language' => 'Ónzjuuste taal.',
	'geshi.css' => '/* Hiej geplaatste CBBS wuuertj toegepas op GeSHo syntax markering */',
);

/** Lithuanian (Lietuvių)
 * @author Garas
 * @author Homo
 * @author Matasg
 */
$messages['lt'] = array(
	'syntaxhighlight-desc' => 'Teikia sintaksės paryškinimus <code>&lt;syntaxhighlight&gt;</code> naudojant [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Jums reikia nurodyti kalbą kaip čia:',
	'syntaxhighlight-supported' => 'Palaikomos kalbos sintaksės paryškinimui:',
	'syntaxhighlight-err-loading' => '(klaida įkeliant palaikomų kalbų sąrašą)',
	'syntaxhighlight-err-language' => 'Neleistina kalba.',
	'geshi.css' => '/* Čia pateiktas CSS bus taikomas GeSHi sintaksės paryškinimams */',
);

/** Latvian (Latviešu)
 * @author Papuass
 */
$messages['lv'] = array(
	'syntaxhighlight-err-language' => 'Nederīga valoda.',
);

/** Malagasy (Malagasy)
 * @author Jagwar
 */
$messages['mg'] = array(
	'syntaxhighlight-err-loading' => "(nisy zavadiso tamin'ilay fampiasan'ny fiteny voazaha)",
	'syntaxhighlight-err-language' => 'Diso fiteny',
);

/** Macedonian (Македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'syntaxhighlight-desc' => 'Овозможува потцртување на синтакса <code>&lt;syntaxhighlight&gt;</code> со помош на [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Треба да наведете јазик на следниов начин:',
	'syntaxhighlight-supported' => 'Поддржани јазици за синтаксно потцртување:',
	'syntaxhighlight-err-loading' => '(грешка при вчитувањето на списокот на поддржани јазици)',
	'syntaxhighlight-err-language' => 'Неважечки јазик.',
	'geshi.css' => '/* Тука поставениот CSS-код ќе биде применет во GeSHi потцртување на синтаксата */',
);

/** Malayalam (മലയാളം)
 * @author Praveenp
 * @author Shijualex
 */
$messages['ml'] = array(
	'syntaxhighlight-desc' => '[http://qbnz.com/highlighter/ GeSHi പ്രമുഖമാക്കൽ ഉപകരണമുപയോഗിച്ച്] <code>&lt;syntaxhighlight&gt;</code> വിന്യാസം പ്രമുഖമാക്കിക്കാട്ടാൻ സഹായിക്കുന്നു',
	'syntaxhighlight-specify' => 'താങ്കൾ ഇപ്രകാരം ഒരു ഭാഷ തിരഞ്ഞെടുക്കണം:',
	'syntaxhighlight-supported' => 'സിറ്റാക്സ് ഹൈലൈറ്റിങ്ങ് അനുകൂലിക്കുന്ന ഭാഷകൾ:',
	'syntaxhighlight-err-loading' => '(പിന്തുണയുള്ള ഭാഷകളുടെ പട്ടിക ശേഖരിക്കുന്നതിൽ പിഴവ്)',
	'syntaxhighlight-err-language' => 'അസാധുവായ ഭാഷ.',
	'geshi.css' => '/* ഇവിടെ നൽകുന്ന സി.എസ്.എസ്.  GeSHi വിന്യാസം പ്രമുഖമാക്കിക്കാട്ടലിനു ബാധകമായിത്തീരും */',
);

/** Marathi (मराठी)
 * @author Kaustubh
 * @author Mahitgar
 */
$messages['mr'] = array(
	'syntaxhighlight-desc' => '[http://qbnz.com/highlighter/ GeSHi हायलायटर] वापरून सिन्टॅक्स हायलाईट करा <code>&lt;syntaxhighlight&gt;</code>',
	'syntaxhighlight-specify' => 'तुम्ही याप्रमाणे भाषा देणे गरजेचे आहे:',
	'syntaxhighlight-supported' => 'सिन्टॅक्स हायलायटींग खालील भाषांवर वापरता येते:',
	'syntaxhighlight-err-loading' => '(सहाय्य देणार्‍या भाषांची यादी दाखविण्यास असमर्थ)',
	'syntaxhighlight-err-language' => 'गैरलागू भाषा',
	'geshi.css' => '/* इथे लिहिलेले CSS GeSHi सिन्टॅक्स हायलायटींग साठी वापरले जाईल */',
);

/** Malay (Bahasa Melayu)
 * @author Aviator
 */
$messages['ms'] = array(
	'syntaxhighlight-desc' => 'Menyediakan tag <code>&lt;syntaxhighlight&gt;</code> untuk penonjolan sintaks menggunakan [http://qbnz.com/highlighter/ GeSHi]',
	'syntaxhighlight-specify' => 'Anda hendaklah menyatakan bahasa seperti ini:',
	'syntaxhighlight-supported' => 'Bahasa-bahasa yang disokong untuk penonjolan sintaks:',
	'syntaxhighlight-err-loading' => '(berlaku ralat ketika memuat senarai bahasa yang disokong)',
	'syntaxhighlight-err-language' => 'Bahasa tidak sah.',
	'geshi.css' => '/* CSS yang diletakkan di sini akan dikenakan kepada penonjolan sintaks GeSHi */',
);

/** Nahuatl (Nāhuatl)
 * @author Fluence
 * @author Teòtlalili
 */
$messages['nah'] = array(
	'syntaxhighlight-err-language' => 'Âmò kualli tlâtòlli',
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬)
 * @author Jon Harald Søby
 */
$messages['nb'] = array(
	'syntaxhighlight-desc' => 'Gir syntaks som framhever <code>&lt;syntaxhighlight&gt;</code> ved hjelp av [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Du må angi et språk slik:',
	'syntaxhighlight-supported' => 'Støttede språk for syntaksutheving:',
	'syntaxhighlight-err-loading' => '(feil under last av liste over støttede språk)',
	'syntaxhighlight-err-language' => 'Ugyldig språk.',
	'geshi.css' => '/* CSS plassert her gjelder GeSHi syntaksutheving */',
);

/** Low German (Plattdüütsch)
 * @author Slomox
 */
$messages['nds'] = array(
	'syntaxhighlight-desc' => 'Syntax-Rutheven <code>&lt;syntaxhighlight&gt;</code> mit Help vun’n [http://qbnz.com/highlighter/ GeSHi-Highlighter]',
	'syntaxhighlight-specify' => 'Du musst op disse Wies en Spraak angeven:',
	'syntaxhighlight-supported' => 'Ünnerstütt Spraken för dat Syntax-Rutheven:',
	'syntaxhighlight-err-loading' => '(Fehler bi dat Laden vun de Sprakenlist)',
	'syntaxhighlight-err-language' => 'Spraak gellt nich.',
	'geshi.css' => '/* CSS in disse MediaWiki-Systemnaricht warrt för dat GeSHi-Syntaxrutheven bruukt */',
);

/** Nedersaksisch (Nedersaksisch)
 * @author Servien
 */
$messages['nds-nl'] = array(
	'syntaxhighlight-err-language' => 'Niet de juuste taal.',
);

/** Dutch (Nederlands)
 * @author Siebrand
 * @author Tvdm
 */
$messages['nl'] = array(
	'syntaxhighlight-desc' => 'Voorziet in het markeren van syntaxis voor <code>&lt;syntaxhighlight&gt;</code> met [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Geef een taal als volgt op:',
	'syntaxhighlight-supported' => 'Ondersteunde talen voor syntaxismarkering:',
	'syntaxhighlight-err-loading' => '(fout bij het laden van de lijst met ondersteunde talen)',
	'syntaxhighlight-err-language' => 'Ongeldige taal.',
	'geshi.css' => '/* Hier geplaatste CSS wordt toegepast op GeSHi Syntax Highlighting */',
);

/** Norwegian Nynorsk (‪Norsk (nynorsk)‬)
 * @author Frokor
 */
$messages['nn'] = array(
	'syntaxhighlight-desc' => 'Gjev syntaks som framhevar <code>&lt;syntaxhighlight&gt;</code> ved hjelp av [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Du må gje eit språk slik:',
	'syntaxhighlight-supported' => 'Støtta språk for syntaksutheving:',
	'syntaxhighlight-err-loading' => '(feil under lasting av liste over støtta språk)',
	'syntaxhighlight-err-language' => 'Ugyldig språk.',
	'geshi.css' => '/* CSS plassert her gjeld GeSHi syntaksutheving */',
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'syntaxhighlight-desc' => 'Provesís la mesa en relèu de la sintaxi per la balisa <code>&lt;syntaxhighlight&gt;</code> en utilizant [http://qbnz.com/highlighter/ la coloracion sintaxica GeSHi]',
	'syntaxhighlight-specify' => 'Vos cal especificar un lengatge coma aquò :',
	'syntaxhighlight-supported' => 'Lengatges suportats per la coloracion sintaxica :',
	'syntaxhighlight-err-loading' => '(error en cargant la lista dels lengatges suportats)',
	'syntaxhighlight-err-language' => 'Lengatge invalid.',
	'geshi.css' => '/* Lo còde CSS inserit aicí serà aplicat per GeSHi per la coloracion sintaxica. */',
);

/** Ossetic (Ирон)
 * @author Amikeco
 */
$messages['os'] = array(
	'syntaxhighlight-err-language' => 'Раст æвзаг нæу.',
);

/** Deitsch (Deitsch)
 * @author Xqt
 */
$messages['pdc'] = array(
	'syntaxhighlight-err-language' => 'Falsch Schprooch',
);

/** Polish (Polski)
 * @author Derbeth
 * @author Sp5uhe
 */
$messages['pl'] = array(
	'syntaxhighlight-desc' => 'Zapewnia kolorowanie składni dla znacznika <code>&lt;syntaxhighlight&gt;</code> wykorzystując [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Musisz wybrać język w następujący sposób:',
	'syntaxhighlight-supported' => 'Języki obsługiwane w podświetlaniu składni:',
	'syntaxhighlight-err-loading' => '(błąd przy wczytywaniu listy obsługiwanych języków)',
	'syntaxhighlight-err-language' => 'Niepoprawny język.',
	'geshi.css' => '/* CSS umieszczony tutaj zostanie użyty do kolorowania składni GeSHi  */',
);

/** Piedmontese (Piemontèis)
 * @author Bèrto 'd Sèra
 * @author Dragonòt
 */
$messages['pms'] = array(
	'syntaxhighlight-desc' => 'A evidensia la sintassi <code>&lt;syntaxhighlight&gt;</code>an dovrand [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'A venta specifiché na lenga coma:',
	'syntaxhighlight-supported' => "Lenghe dont as peul fé l'evidensiassion dla sintassi:",
	'syntaxhighlight-err-loading' => '(eror ën cariand la lista dle lenghe dont sintassi as peul evidensié)',
	'syntaxhighlight-err-language' => 'Lenga nen bon-a',
	'geshi.css' => "/* ël CSS piassà ambelessì a sarà aplicà a l'evidensiassion ëd sintassi GeSHi */",
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'syntaxhighlight-specify' => 'تاسو ته پکار ده چې يوه ژبه په دې توګه ځانګړې کړی:',
	'syntaxhighlight-err-language' => 'ناسمه ژبه.',
);

/** Portuguese (Português)
 * @author Hamilton Abreu
 * @author Malafaya
 */
$messages['pt'] = array(
	'syntaxhighlight-desc' => 'Permite o realce sintáctico de código fonte, através do elemento <code>&lt;syntaxhighlight&gt;</code>, usando o [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Precisa de especificar uma linguagem assim:',
	'syntaxhighlight-supported' => 'Linguagens suportadas no realce de sintaxe:',
	'syntaxhighlight-err-loading' => '(erro ao carregar a lista de linguagens suportadas)',
	'syntaxhighlight-err-language' => 'Linguagem inválida.',
	'geshi.css' => '/* O código CSS aqui colocado será aplicado ao realce de sintaxe GeSHi */',
);

/** Brazilian Portuguese (Português do Brasil)
 * @author Helder.wiki
 * @author Heldergeovane
 */
$messages['pt-br'] = array(
	'syntaxhighlight-desc' => 'Providencia realce de sintaxe <code>&lt;syntaxhighlight&gt;</code> através do [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Você precisa especificar uma linguagem, tal como:',
	'syntaxhighlight-supported' => 'Linguagens suportadas no realce de sintaxe:',
	'syntaxhighlight-err-loading' => '(erro ao carregar a lista de linguagens suportadas)',
	'syntaxhighlight-err-language' => 'Linguagem inválida.',
	'geshi.css' => '/* O código CSS aqui colocado será aplicado ao realce de sintaxe GeSHi */',
);

/** Quechua (Runa Simi)
 * @author AlimanRuna
 */
$messages['qu'] = array(
	'syntaxhighlight-err-language' => 'Nisqayki rimayqa manam kanchu.',
);

/** Romanian (Română)
 * @author AdiJapan
 * @author KlaudiuMihaila
 * @author Stelistcristi
 */
$messages['ro'] = array(
	'syntaxhighlight-desc' => 'Produce evidențierea sintaxei prin baliza <code>&lt;syntaxhighlight&gt;</code> folosind [http://qbnz.com/highlighter/ GeSHi - Generic Syntax Highlighter]',
	'syntaxhighlight-specify' => 'Trebuie să specificați o limbă în acest mod:',
	'syntaxhighlight-supported' => 'Limbile suportate pentru evidențierea sintaxei:',
	'syntaxhighlight-err-loading' => '(eroare la încărcarea listei cu limbile suportate)',
	'syntaxhighlight-err-language' => 'Limbă incorectă.',
	'geshi.css' => '/* Codul CSS inserat aici se va aplica la evidențierea sintaxei prin GeSHi. */',
);

/** Tarandíne (Tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'syntaxhighlight-desc' => "Dè 'na sindasse evidenziate <code>&lt;syntaxhighlight&gt;</code> ausanne [http://qbnz.com/highlighter/ GeSHi l'Evidenziatore]",
	'syntaxhighlight-specify' => "Tu, abbesogne de 'na lènga specifiche cumme a queste:",
	'syntaxhighlight-supported' => 'Linguagge supportate pa sindasse evidenziate:',
	'syntaxhighlight-err-loading' => "(errore carecanne 'a liste de linguagge supportate)",
	'syntaxhighlight-err-language' => 'Lénghe invalide.',
	'geshi.css' => "/* CSS mise aqquà avène applicate 'a sindasse GeSHi evidenziate */",
);

/** Russian (Русский)
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'syntaxhighlight-desc' => 'Позволяет использовать тег <code>&lt;syntaxhighlight&gt;</code> для подсветки синтаксиса с помощью [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Вы должны указать язык следующим образом:',
	'syntaxhighlight-supported' => 'Поддерживаемые языки:',
	'syntaxhighlight-err-loading' => '(невозможно загрузить список языков)',
	'syntaxhighlight-err-language' => 'Указан неподдерживаемый язык.',
	'geshi.css' => '/* CSS-код, размещённый здесь, будет применён для подсветки синтаксиса GeSHI */',
);

/** Rusyn (Русиньскый)
 * @author Gazeb
 */
$messages['rue'] = array(
	'syntaxhighlight-desc' => 'Додавать звыразнїна сінтаксіс <code>&lt;syntaxhighlight&gt;</code> за помочі [http://qnbz.com/higlighter звыразнёвача GeSHi]',
	'syntaxhighlight-specify' => 'Мусите становити язык тым способом:',
	'syntaxhighlight-supported' => 'Список языків, у котрый є підпороване звыразнёваня сінтаксіс:',
	'syntaxhighlight-err-loading' => '(хыба при начітаню списка підпорованых языків)',
	'syntaxhighlight-err-language' => 'Неправилный язык.',
	'geshi.css' => '/* Гев зазначене CSS буде овпливнёвати звыразнёваня сінтаксісу GeSHi */',
);

/** Sakha (Саха тыла)
 * @author HalanTul
 */
$messages['sah'] = array(
	'syntaxhighlight-desc' => '[http://qbnz.com/highlighter/ GeSHi Highlighter] көмөтүнэн синтаксис подсветкатын холбуурга <code>&lt;syntaxhighlight&gt;</code> тиэги туһанар кыах биэрэр.',
	'syntaxhighlight-specify' => 'Омугун тылын маннык ыйыахтааххын:',
	'syntaxhighlight-supported' => 'Өйөнүллэр тыллара:',
	'syntaxhighlight-err-loading' => '(тылларын испииһэгэ кыайан көрдөрүллүбэтэ)',
	'syntaxhighlight-err-language' => 'Өйөнүллүбэт тыл эбит.',
	'geshi.css' => '/* манна баар CSS-куод GeSHI синтаксииһын сырдатарга туттуллуо */',
);

/** Sinhala (සිංහල)
 * @author Calcey
 * @author පසිඳු කාවින්ද
 */
$messages['si'] = array(
	'syntaxhighlight-specify' => 'ඔබට මෙවැනි භාෂාවක් විශේෂණය කල යුතු වේ:',
	'syntaxhighlight-supported' => 'වාග් රීති උද්දීපනය කිරීම සඳහා සහාය දක්වන භාෂා:',
	'syntaxhighlight-err-loading' => '(සහය දක්වන භාෂා ලැයිස්තුව පූරණය වීමේ දෝෂය)',
	'syntaxhighlight-err-language' => 'අවලංගු භාෂාව.',
	'geshi.css' => '/* මෙහි යොදන CSS GeSHi කාරකරීති තීව‍්‍රාලෝකය සඳහා යෙදේ */',
);

/** Slovak (Slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'syntaxhighlight-desc' => 'Poskytuje zvýazňovanie syntaxe <code>&lt;syntaxhighlight&gt;</code> pomocou [http://qbnz.com/highlighter/ zvýrazňovača GeSHi]',
	'syntaxhighlight-specify' => 'Musíte uviesť jazyk takto:',
	'syntaxhighlight-supported' => 'Jazyky, pre ktoré je zvýrazňovanie syntaxe podporované:',
	'syntaxhighlight-err-loading' => '(chyba pri načítaní zoznamu podporovaných jazykov)',
	'syntaxhighlight-err-language' => 'Neplatný jazyk.',
	'geshi.css' => '/* Tu umiestnené CSS sa použije pre zvýrazňovanie syntaxe GeSHi */',
);

/** Slovenian (Slovenščina)
 * @author Dbc334
 * @author Yerpo
 */
$messages['sl'] = array(
	'syntaxhighlight-desc' => 'Nudi označevanje skladnje <code>&lt;syntaxhighlight&gt;</code> z uporabo [http://qbnz.com/highlighter/ označevalnika GeSHi]',
	'syntaxhighlight-specify' => 'Morate navesti jezik tako:',
	'syntaxhighlight-supported' => 'Jeziki, ki jih podpira funkcija za označevanje sintakse:',
	'syntaxhighlight-err-loading' => '(napaka pri nalaganju podprtih jezikov)',
	'syntaxhighlight-err-language' => 'Neveljaven jezik.',
	'geshi.css' => '/* CSS placed here will be applied to GeSHi syntax highlighting */',
);

/** Serbian (Cyrillic script) (‪Српски (ћирилица)‬)
 * @author Millosh
 * @author Rancher
 * @author Sasa Stefanovic
 */
$messages['sr-ec'] = array(
	'syntaxhighlight-desc' => 'Омогућава визуелно означавање синтаксе <code>&lt;syntaxhighlight&gt;</code> коришћењем [http://qbnz.com/highlighter/ GeSHi хајлајтера].',
	'syntaxhighlight-specify' => 'Потребно је одредити језик као овај:',
	'syntaxhighlight-supported' => 'Подржани језици у визуелом означавању синтаксе:',
	'syntaxhighlight-err-loading' => '(грешка при учитавању подржаних језика)',
	'syntaxhighlight-err-language' => 'Неисправан језик.',
	'geshi.css' => '/* CSS постављен овде биће примењен на визуелно означавање синтксе GeSHi */',
);

/** Serbian (Latin script) (‪Srpski (latinica)‬)
 * @author Michaello
 */
$messages['sr-el'] = array(
	'syntaxhighlight-desc' => 'Omogućava vizuelno označavanje sintakse <code>&lt;syntaxhighlight&gt;</code> korišćenjem [<a href="http://qbnz.com/highlighter/">http://qbnz.com/highlighter/</a> GeSHi hajlajtera].',
	'syntaxhighlight-specify' => 'Potrebno je odrediti jezik kao ovaj:',
	'syntaxhighlight-supported' => 'Podržani jezici u vizuelom označavanju sintakse:',
	'syntaxhighlight-err-loading' => '(greška pri učitavanju podržanih jezika)',
	'syntaxhighlight-err-language' => 'Nepodoban jezik',
	'geshi.css' => '/* CSS postavljen ovde biće primenjen na vizuelno označavanje sintkse GeSHi */',
);

/** Seeltersk (Seeltersk)
 * @author Pyt
 */
$messages['stq'] = array(
	'syntaxhighlight-desc' => 'Syntax-Apljuchtenge <code>&lt;syntaxhighlight&gt;</code> mäd Hälpe fon dän [http://qbnz.com/highlighter/ GeSHi-Apljuchter]',
	'syntaxhighlight-specify' => 'Ju wonskede Sproake mout as foulget definierd wäide:',
	'syntaxhighlight-supported' => 'Unnerstöände Sproaken foar ju Syntax-Betoonenge:',
	'syntaxhighlight-err-loading' => '(Failer bie dät Leeden fon ju Sproakenlieste)',
	'syntaxhighlight-err-language' => 'Uungultige Sproake.',
	'geshi.css' => '/* CSS in disse MediaWiki-Systemättergjucht wäd ap ju GeSHi-Syntaxbetoonenge anwoand */',
);

/** Sundanese (Basa Sunda)
 * @author Kandar
 */
$messages['su'] = array(
	'syntaxhighlight-desc' => 'Nyadiakeun sorotan rumpaka <code>&lt;syntaxhighlight&gt;</code> migunakeun [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Anjeun kudu milih basa kawas kieu:',
	'syntaxhighlight-supported' => 'Basa nu dirojong ku sorotan rumpaka:',
	'syntaxhighlight-err-loading' => '(éror ngamuat daptar basa nu dirojong)',
	'syntaxhighlight-err-language' => 'Basana teu sah.',
	'geshi.css' => '/* CSS nu diperenahkeun di dieu bakal dilarapkeun ka sorotan rumpaka GeSHi */',
);

/** Swedish (Svenska)
 * @author Lejonel
 */
$messages['sv'] = array(
	'syntaxhighlight-desc' => 'Ger syntaxmarkering med [http://qbnz.com/highlighter/ GeSHi Highlighter] inuti <code>&lt;syntaxhighlight&gt;</code>-taggar',
	'syntaxhighlight-specify' => 'Du måste ange vilket språk som används, så här:',
	'syntaxhighlight-supported' => 'Det finns stöd för följande språk:',
	'syntaxhighlight-err-loading' => '(fel vid laddning av listan över stödda språk)',
	'syntaxhighlight-err-language' => 'Ogiltigt språk.',
	'geshi.css' => '/* CSS som skrivs här används för syntax highlighting med GeSHI */',
);

/** Telugu (తెలుగు)
 * @author Veeven
 */
$messages['te'] = array(
	'syntaxhighlight-specify' => 'భాషని ఈ విధంగా ఇవ్వాలి:',
	'syntaxhighlight-supported' => 'ఛందస్సు ఉద్దీపనకి తోడ్పాటు ఉన్న భాషలు:',
	'syntaxhighlight-err-loading' => '(తోడ్పాటున్న భాషల జాబితా లోడింగులో పొరపాటు జరిగింది)',
	'syntaxhighlight-err-language' => 'తప్పుడు భాష.',
);

/** Tajik (Cyrillic script) (Тоҷикӣ)
 * @author Ibrahim
 */
$messages['tg-cyrl'] = array(
	'syntaxhighlight-desc' => 'Имкони дастуроти рангин карданро <code>&lt;syntaxhighlight&gt;</code> бо истифода аз [http://qbnz.com/highlighter/ GeSHi Highlighter]-ро фароҳам меоварад',
	'syntaxhighlight-specify' => 'Шумо бояд бо ин шакл забонеро мушаххас кунед:',
	'syntaxhighlight-supported' => 'Забонҳои пуштибонишуда барои рангин кардани дастуроти наҳвӣ:',
	'syntaxhighlight-err-loading' => '(хато дар богузории забонҳои пуштибонишуда)',
	'syntaxhighlight-err-language' => 'Забони ғайри миҷоз.',
	'geshi.css' => '/* CSS инҷо гузошташуда ба дастуроти рангинкунии GeSHi ба кор бурда мешавад */',
);

/** Tajik (Latin script) (tojikī)
 * @author Liangent
 */
$messages['tg-latn'] = array(
	'syntaxhighlight-desc' => 'Imkoni dasturoti rangin kardanro <code>&lt;syntaxhighlight&gt;</code> bo istifoda az [http://qbnz.com/highlighter/ GeSHi Highlighter]-ro faroham meovarad',
	'syntaxhighlight-specify' => 'Şumo bojad bo in şakl zabonero muşaxxas kuned:',
	'syntaxhighlight-supported' => 'Zabonhoi puştibonişuda baroi rangin kardani dasturoti nahvī:',
	'syntaxhighlight-err-loading' => '(xato dar boguzoriji zabonhoi puştibonişuda)',
	'syntaxhighlight-err-language' => 'Zaboni ƣajri miçoz.',
	'geshi.css' => '/* CSS inço guzoştaşuda ba dasturoti ranginkuniji GeSHi ba kor burda meşavad */',
);

/** Turkmen (Türkmençe)
 * @author Hanberke
 */
$messages['tk'] = array(
	'syntaxhighlight-desc' => '[http://qbnz.com/highlighter/ GeSHi Highlighter] ulanyp <code>&lt;syntaxhighlight&gt;</code> sintaksis nygtamasyny üpjün edýär',
	'syntaxhighlight-specify' => 'Şunuň ýaly bir dil görkezmeli:',
	'syntaxhighlight-supported' => 'Sintaksis nygtamasy üçin goldanylýan diller:',
	'syntaxhighlight-err-loading' => '(goldanylýan diller sanawyny ýükleme säwligi)',
	'syntaxhighlight-err-language' => 'Nädogry dil.',
	'geshi.css' => '/* Bu ýere ýerleşdirilen CSS, GeSHi sintaksis nygtamasyna berjaý ediljekdir */',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'syntaxhighlight-desc' => "Nagbibigay ng pagbibigay ng liwanag sa palaugnayan <code>&lt;syntaxhighlight&gt;</code> na ginagamitan ng [http://qbnz.com/highlighter/ pambigay ng liwanag (''highlighter'') ng GeSHi]",
	'syntaxhighlight-specify' => 'Kinakailangan mong tumukoy ng isang wikang katulad nito:',
	'syntaxhighlight-supported' => 'Sinusuportahang mga wika para sa pagbibigay ng liwanag/pagtatampok ng palaugnayan:',
	'syntaxhighlight-err-loading' => '(kamalian sa pagkarga ng sinusuportahang talaan ng wika)',
	'syntaxhighlight-err-language' => 'Hindi tanggap na wika.',
	'geshi.css' => '/* Ang inilagay na CSS dito ay gagamitin para sa pang-GeSHi na pagbibigay ng liwanag sa/pagtatampok ng palaugnayan */',
);

/** Turkish (Türkçe)
 * @author Erkan Yilmaz
 * @author Joseph
 */
$messages['tr'] = array(
	'syntaxhighlight-desc' => '[http://qbnz.com/highlighter/ GeSHi Highlighter] kullanarak <code>&lt;syntaxhighlight&gt;</code> sözdizimi vurgulamasını sağlar',
	'syntaxhighlight-specify' => 'Bu gibi bir dil belirtmelisiniz:',
	'syntaxhighlight-supported' => 'Sözdizimi vurgulaması için desteklenen diller:',
	'syntaxhighlight-err-loading' => '(desteklenen diller listesi yüklenirken hata)',
	'syntaxhighlight-err-language' => 'Geçersiz dil.',
	'geshi.css' => '/* Buraya yerleştirilen CSS, GeSHi sözdizimi vurgulamasına uygulanacaktır */',
);

/** Ukrainian (Українська)
 * @author Ahonc
 */
$messages['uk'] = array(
	'syntaxhighlight-desc' => 'Дозволяє використовувати тег <code>&lt;syntaxhighlight&gt;</code> для підсвічування синтаксису за допомогою [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Ви повинні зазначити мову наступним чином:',
	'syntaxhighlight-supported' => 'Підтримувані мови:',
	'syntaxhighlight-err-loading' => '(неможливо завантажити список мов)',
	'syntaxhighlight-err-language' => 'Зазначена непідтримувана мова.',
	'geshi.css' => '/* CSS-код, розміщений тут, буде застосований для підсвічування синтаксису GeSHI */',
);

/** Vèneto (Vèneto)
 * @author Candalua
 */
$messages['vec'] = array(
	'syntaxhighlight-desc' => 'Evidensia la sintassi dei linguagi de programazion <code>&lt;syntaxhighlight&gt;</code> tramite [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Te ghè da specificar un linguagio in sta maniera:',
	'syntaxhighlight-supported' => 'Linguagi de cui se pol evidensiar la sintassi coi colori:',
	'syntaxhighlight-err-loading' => "(eror nel caricamento de l'elenco dei linguagi suportà)",
	'syntaxhighlight-err-language' => 'Linguagio mìa riconossiùo.',
	'geshi.css' => "/* I stili CSS inserìi qua i se àplica a l'evidenziazion de sintassi con GeSHi */",
);

/** Veps (Vepsan kel')
 * @author Игорь Бродский
 */
$messages['vep'] = array(
	'syntaxhighlight-err-language' => "Vär kel'",
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 */
$messages['vi'] = array(
	'syntaxhighlight-desc' => 'Tô màu cú pháp trong thẻ <code>&lt;syntaxhighlight&gt;</code> dùng [http://qbnz.com/highlighter/ GeSHi Highlighter]',
	'syntaxhighlight-specify' => 'Bạn cần phải định rõ một ngôn ngữ như vầy:',
	'syntaxhighlight-supported' => 'Các ngôn ngữ được tô màu cú pháp:',
	'syntaxhighlight-err-loading' => '(gặp lỗi khi nạp danh sách các ngôn ngữ được hỗ trợ)',
	'syntaxhighlight-err-language' => 'Ngôn ngữ không hợp lệ.',
	'geshi.css' => '/* Bộ tô màu cú pháp GeSHi sẽ áp dụng mã CSS ở đây */',
);

/** Volapük (Volapük)
 * @author Malafaya
 * @author Smeira
 */
$messages['vo'] = array(
	'syntaxhighlight-specify' => 'Nedol välön püki ön mod soik:',
	'syntaxhighlight-supported' => 'Püks lonöföl pro süntag pekölöl:',
	'syntaxhighlight-err-loading' => '(pöl pö lodam lised pükas lonöföl)',
	'syntaxhighlight-err-language' => 'Pük no dabinöl.',
);

/** Yiddish (ייִדיש)
 * @author פוילישער
 */
$messages['yi'] = array(
	'syntaxhighlight-specify' => 'איר דארפֿט ספעציפֿירן א שפראַך אזוי:',
	'syntaxhighlight-err-language' => 'אומגילטיקע שפראַך.',
);

/** Cantonese (粵語)
 * @author Shinjiman
 */
$messages['yue'] = array(
	'syntaxhighlight-desc' => '用[http://qbnz.com/highlighter/ GeSHi Highlighter]以<code>&lt;syntaxhighlight&gt;</code>提供醒目提示',
	'syntaxhighlight-specify' => '你需要指定一種語言，好似咁:',
	'syntaxhighlight-supported' => '語法醒目標示所支援嘅語言:',
	'syntaxhighlight-err-loading' => '(支援語言清單載入錯誤)',
	'syntaxhighlight-err-language' => '無效嘅語言。',
	'geshi.css' => '/* 放響呢度嘅CSS會以GeSHi語法醒目提示方式顯示 */',
);

/** Simplified Chinese (‪中文(简体)‬)
 * @author Shinjiman
 */
$messages['zh-hans'] = array(
	'syntaxhighlight-desc' => '使用[http://qbnz.com/highlighter/ GeSHi Highlighter]以<code>&lt;syntaxhighlight&gt;</code>提供高亮',
	'syntaxhighlight-specify' => '您需要指定一种语言，像这样:',
	'syntaxhighlight-supported' => '语法高亮所支持的语言:',
	'syntaxhighlight-err-loading' => '（支持语言列表载入错误）',
	'syntaxhighlight-err-language' => '无效的语言。',
	'geshi.css' => '/* 放在这里的CSS会以GeSHi语法高亮方式显示 */',
);

/** Traditional Chinese (‪中文(繁體)‬)
 * @author Mark85296341
 * @author Shinjiman
 */
$messages['zh-hant'] = array(
	'syntaxhighlight-desc' => '使用 [http://qbnz.com/highlighter/ GeSHi Highlighter] 以 <code>&lt;syntaxhighlight&gt;</code> 提供醒目提示',
	'syntaxhighlight-specify' => '您需要指定一種語言，像這樣：',
	'syntaxhighlight-supported' => '語法醒目標示所支援的語言：',
	'syntaxhighlight-err-loading' => '（支援語言清單載入錯誤）',
	'syntaxhighlight-err-language' => '無效的語言。',
	'geshi.css' => '/* 放在這裡的 CSS 會以 GeSHi 語法醒目提示方式顯示 */',
);

