/*
 * Copyright (C) 2004, 2005 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _TRANSLATE_GENERIC_SERVICE_H
#define _TRANSLATE_GENERIC_SERVICE_H

#include "translate-service.h"
#include "translate-generic-parser.h"

#define TRANSLATE_GENERIC_TYPE_SERVICE			(translate_generic_service_get_type())
#define TRANSLATE_GENERIC_SERVICE(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), TRANSLATE_GENERIC_TYPE_SERVICE, TranslateGenericService))
#define TRANSLATE_GENERIC_SERVICE_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), TRANSLATE_GENERIC_TYPE_SERVICE, TranslateGenericServiceClass))
#define TRANSLATE_GENERIC_IS_SERVICE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), TRANSLATE_GENERIC_TYPE_SERVICE))
#define TRANSLATE_GENERIC_IS_SERVICE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), TRANSLATE_GENERIC_TYPE_SERVICE))
#define TRANSLATE_GENERIC_SERVICE_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), TRANSLATE_GENERIC_TYPE_SERVICE, TranslateGenericServiceClass))

typedef struct _TranslateGenericService TranslateGenericService;
typedef struct _TranslateGenericServiceClass TranslateGenericServiceClass;
typedef struct _TranslateGenericServicePrivate TranslateGenericServicePrivate;

struct _TranslateGenericService
{
  TranslateService			parent;

  TranslateGenericServicePrivate	*priv;
};

struct _TranslateGenericServiceClass
{
  TranslateServiceClass			parent;
};

typedef enum
{
  TRANSLATE_GENERIC_SERVICE_ERROR_TRANSFER,
  TRANSLATE_GENERIC_SERVICE_ERROR_PARSE,
  TRANSLATE_GENERIC_SERVICE_ERROR_FAILED
} TranslateGenericServiceError;

#define TRANSLATE_GENERIC_SERVICE_ERROR translate_generic_service_error_quark()
GQuark translate_generic_service_error_quark (void);

GType translate_generic_service_get_type (void);
TranslateService *translate_generic_service_new (const char *name,
						 const char *nick,
						 unsigned int max_chunk_len,
						 const GSList *groups);

#endif /* _TRANSLATE_GENERIC_SERVICE_H */
