/**
 * @file:   MemberConstraint.h
 * @brief:  Implementation of the MemberConstraint class
 * @author: Generated by autocreate code
 *
 * <!--------------------------------------------------------------------------
 * This file is part of libSBML.  Please visit http://sbml.org for more
 * information about SBML, and the latest version of libSBML.
 *
 * Copyright (C) 2009-2013 jointly by the following organizations:
 *     1. California Institute of Technology, Pasadena, CA, USA
 *     2. EMBL European Bioinformatics Institute (EMBL-EBI), Hinxton, UK
 *
 * Copyright (C) 2006-2008 by the California Institute of Technology,
 *     Pasadena, CA, USA 
 *
 * Copyright (C) 2002-2005 jointly by the following organizations:
 *     1. California Institute of Technology, Pasadena, CA, USA
 *     2. Japan Science and Technology Agency, Japan
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.  A copy of the license agreement is provided
 * in the file named "LICENSE.txt" included with this software distribution
 * and also available online as http://sbml.org/software/libsbml/license.html
 * ------------------------------------------------------------------------ -->
 */


#ifndef MemberConstraint_H__
#define MemberConstraint_H__


#include <sbml/common/extern.h>
#include <sbml/common/sbmlfwd.h>
#include <sbml/packages/groups/common/groupsfwd.h>


#ifdef __cplusplus


#include <string>


#include <sbml/SBase.h>
#include <sbml/ListOf.h>
#include <sbml/packages/groups/extension/GroupsExtension.h>


LIBSBML_CPP_NAMESPACE_BEGIN


class LIBSBML_EXTERN MemberConstraint : public SBase
{

protected:

  std::string   mId;
  std::string   mName;
  std::string   mDistinctAttribute;
  std::string   mIdenticalAttribute;


public:

  /**
   * Creates a new MemberConstraint with the given level, version, and package version.
   *
   * @param level an unsigned int, the SBML Level to assign to this MemberConstraint
   *
   * @param version an unsigned int, the SBML Version to assign to this MemberConstraint
   *
   * @param pkgVersion an unsigned int, the SBML Groups Version to assign to this MemberConstraint
   */
  MemberConstraint(unsigned int level      = GroupsExtension::getDefaultLevel(),
                   unsigned int version    = GroupsExtension::getDefaultVersion(),
                   unsigned int pkgVersion = GroupsExtension::getDefaultPackageVersion());


  /**
   * Creates a new MemberConstraint with the given GroupsPkgNamespaces object.
   *
   * @param groupsns the GroupsPkgNamespaces object
   */
  MemberConstraint(GroupsPkgNamespaces* groupsns);


  /**
   * Copy constructor for MemberConstraint.
   *
   * @param orig; the MemberConstraint instance to copy.
   */
  MemberConstraint(const MemberConstraint& orig);


  /**
   * Assignment operator for MemberConstraint.
   *
   * @param rhs; the object whose values are used as the basis
   * of the assignment
   */
  MemberConstraint& operator=(const MemberConstraint& rhs);


  /**
   * Creates and returns a deep copy of this MemberConstraint object.
   *
   * @return a (deep) copy of this MemberConstraint object.
   */
  virtual MemberConstraint* clone () const;


  /**
   * Destructor for MemberConstraint.
   */
  virtual ~MemberConstraint();


  /**
   * Returns the value of the "id" attribute of this MemberConstraint.
   *
   * @return the value of the "id" attribute of this MemberConstraint as a string.
   */
  virtual const std::string& getId() const;


  /**
   * Predicate returning @c true or @c false depending on whether this
   * MemberConstraint's "id" attribute has been set.
   *
   * @return @c true if this MemberConstraint's "id" attribute has been set,
   * otherwise @c false is returned.
   */
  virtual bool isSetId() const;


  /**
   * Sets the value of the "id" attribute of this MemberConstraint.
   *
   * @param id; const std::string& value of the "id" attribute to be set
   *
   * @return integer value indicating success/failure of the
   * function.  @if clike The value is drawn from the
   * enumeration #OperationReturnValues_t. @endif The possible values
   * returned by this function are:
   * @li LIBSBML_OPERATION_SUCCESS
   * @li LIBSBML_INVALID_ATTRIBUTE_VALUE
   */
  virtual int setId(const std::string& id);


  /**
   * Unsets the value of the "id" attribute of this MemberConstraint.
   *
   * @return integer value indicating success/failure of the
   * function.  @if clike The value is drawn from the
   * enumeration #OperationReturnValues_t. @endif The possible values
   * returned by this function are:
   * @li LIBSBML_OPERATION_SUCCESS
   * @li LIBSBML_OPERATION_FAILED
   */
  virtual int unsetId();


  /**
   * Returns the value of the "name" attribute of this MemberConstraint.
   *
   * @return the value of the "name" attribute of this MemberConstraint as a string.
   */
  virtual const std::string& getName() const;


  /**
   * Predicate returning @c true or @c false depending on whether this
   * MemberConstraint's "name" attribute has been set.
   *
   * @return @c true if this MemberConstraint's "name" attribute has been set,
   * otherwise @c false is returned.
   */
  virtual bool isSetName() const;


  /**
   * Sets the value of the "name" attribute of this MemberConstraint.
   *
   * @param name; const std::string& value of the "name" attribute to be set
   *
   * @return integer value indicating success/failure of the
   * function.  @if clike The value is drawn from the
   * enumeration #OperationReturnValues_t. @endif The possible values
   * returned by this function are:
   * @li LIBSBML_OPERATION_SUCCESS
   * @li LIBSBML_INVALID_ATTRIBUTE_VALUE
   */
  virtual int setName(const std::string& name);


  /**
   * Unsets the value of the "name" attribute of this MemberConstraint.
   *
   * @return integer value indicating success/failure of the
   * function.  @if clike The value is drawn from the
   * enumeration #OperationReturnValues_t. @endif The possible values
   * returned by this function are:
   * @li LIBSBML_OPERATION_SUCCESS
   * @li LIBSBML_OPERATION_FAILED
   */
  virtual int unsetName();


  /**
   * Returns the value of the "distinctAttribute" attribute of this MemberConstraint.
   *
   * @return the value of the "distinctAttribute" attribute of this MemberConstraint as a string.
   */
  virtual const std::string& getDistinctAttribute() const;


  /**
   * Predicate returning @c true or @c false depending on whether this
   * MemberConstraint's "distinctAttribute" attribute has been set.
   *
   * @return @c true if this MemberConstraint's "distinctAttribute" attribute has been set,
   * otherwise @c false is returned.
   */
  virtual bool isSetDistinctAttribute() const;


  /**
   * Sets the value of the "distinctAttribute" attribute of this MemberConstraint.
   *
   * @param distinctAttribute; const std::string& value of the "distinctAttribute" attribute to be set
   *
   * @return integer value indicating success/failure of the
   * function.  @if clike The value is drawn from the
   * enumeration #OperationReturnValues_t. @endif The possible values
   * returned by this function are:
   * @li LIBSBML_OPERATION_SUCCESS
   * @li LIBSBML_INVALID_ATTRIBUTE_VALUE
   */
  virtual int setDistinctAttribute(const std::string& distinctAttribute);


  /**
   * Unsets the value of the "distinctAttribute" attribute of this MemberConstraint.
   *
   * @return integer value indicating success/failure of the
   * function.  @if clike The value is drawn from the
   * enumeration #OperationReturnValues_t. @endif The possible values
   * returned by this function are:
   * @li LIBSBML_OPERATION_SUCCESS
   * @li LIBSBML_OPERATION_FAILED
   */
  virtual int unsetDistinctAttribute();


  /**
   * Returns the value of the "identicalAttribute" attribute of this MemberConstraint.
   *
   * @return the value of the "identicalAttribute" attribute of this MemberConstraint as a string.
   */
  virtual const std::string& getIdenticalAttribute() const;


  /**
   * Predicate returning @c true or @c false depending on whether this
   * MemberConstraint's "identicalAttribute" attribute has been set.
   *
   * @return @c true if this MemberConstraint's "identicalAttribute" attribute has been set,
   * otherwise @c false is returned.
   */
  virtual bool isSetIdenticalAttribute() const;


  /**
   * Sets the value of the "identicalAttribute" attribute of this MemberConstraint.
   *
   * @param identicalAttribute; const std::string& value of the "identicalAttribute" attribute to be set
   *
   * @return integer value indicating success/failure of the
   * function.  @if clike The value is drawn from the
   * enumeration #OperationReturnValues_t. @endif The possible values
   * returned by this function are:
   * @li LIBSBML_OPERATION_SUCCESS
   * @li LIBSBML_INVALID_ATTRIBUTE_VALUE
   */
  virtual int setIdenticalAttribute(const std::string& identicalAttribute);


  /**
   * Unsets the value of the "identicalAttribute" attribute of this MemberConstraint.
   *
   * @return integer value indicating success/failure of the
   * function.  @if clike The value is drawn from the
   * enumeration #OperationReturnValues_t. @endif The possible values
   * returned by this function are:
   * @li LIBSBML_OPERATION_SUCCESS
   * @li LIBSBML_OPERATION_FAILED
   */
  virtual int unsetIdenticalAttribute();


  /**
   * Returns the XML element name of this object, which for MemberConstraint, is
   * always @c "memberConstraint".
   *
   * @return the name of this element, i.e. @c "memberConstraint".
   */
  virtual const std::string& getElementName () const;


  /**
   * Returns the libSBML type code for this SBML object.
   * 
   * @if clike LibSBML attaches an identifying code to every kind of SBML
   * object.  These are known as <em>SBML type codes</em>.  The set of
   * possible type codes is defined in the enumeration #SBMLTypeCode_t.
   * The names of the type codes all begin with the characters @c
   * SBML_. @endif@if java LibSBML attaches an identifying code to every
   * kind of SBML object.  These are known as <em>SBML type codes</em>.  In
   * other languages, the set of type codes is stored in an enumeration; in
   * the Java language interface for libSBML, the type codes are defined as
   * static integer constants in the interface class {@link
   * libsbmlConstants}.  The names of the type codes all begin with the
   * characters @c SBML_. @endif@if python LibSBML attaches an identifying
   * code to every kind of SBML object.  These are known as <em>SBML type
   * codes</em>.  In the Python language interface for libSBML, the type
   * codes are defined as static integer constants in the interface class
   * @link libsbml@endlink.  The names of the type codes all begin with the
   * characters @c SBML_. @endif@if csharp LibSBML attaches an identifying
   * code to every kind of SBML object.  These are known as <em>SBML type
   * codes</em>.  In the C# language interface for libSBML, the type codes
   * are defined as static integer constants in the interface class @link
   * libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
   * the characters @c SBML_. @endif
   *
   * @return the SBML type code for this object, or
   * @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
   *
   * @see getElementName()
   */
  virtual int getTypeCode () const;


  /**
   * Predicate returning @c true if all the required attributes
   * for this MemberConstraint object have been set.
   *
   * @note The required attributes for a MemberConstraint object are:
   *
   * @return a boolean value indicating whether all the required
   * attributes for this object have been defined.
   */
  virtual bool hasRequiredAttributes() const;


  /** @cond doxygenLibsbmlInternal */

  /**
   * Subclasses should override this method to write out their contained
   * SBML objects as XML elements.  Be sure to call your parents
   * implementation of this method as well.
   */
  virtual void writeElements (XMLOutputStream& stream) const;


  /** @endcond doxygenLibsbmlInternal */


  /** @cond doxygenLibsbmlInternal */

  /**
   * Accepts the given SBMLVisitor.
   */
  virtual bool accept (SBMLVisitor& v) const;


  /** @endcond doxygenLibsbmlInternal */


  /** @cond doxygenLibsbmlInternal */

  /**
   * Sets the parent SBMLDocument.
   */
  virtual void setSBMLDocument (SBMLDocument* d);


  /** @endcond doxygenLibsbmlInternal */


  /** @cond doxygenLibsbmlInternal */

  /**
   * Enables/Disables the given package with this element.
   */
  virtual void enablePackageInternal(const std::string& pkgURI,
               const std::string& pkgPrefix, bool flag);


  /** @endcond doxygenLibsbmlInternal */


protected:

  /** @cond doxygenLibsbmlInternal */

  /**
   * Get the list of expected attributes for this element.
   */
  virtual void addExpectedAttributes(ExpectedAttributes& attributes);


  /** @endcond doxygenLibsbmlInternal */


  /** @cond doxygenLibsbmlInternal */

  /**
   * Read values from the given XMLAttributes set into their specific fields.
   */
  virtual void readAttributes (const XMLAttributes& attributes,
                               const ExpectedAttributes& expectedAttributes);


  /** @endcond doxygenLibsbmlInternal */


  /** @cond doxygenLibsbmlInternal */

  /**
   * Write values of XMLAttributes to the output stream.
   */
  virtual void writeAttributes (XMLOutputStream& stream) const;


  /** @endcond doxygenLibsbmlInternal */



};

class LIBSBML_EXTERN ListOfMemberConstraints : public ListOf
{

public:

  /**
   * Creates a new ListOfMemberConstraints with the given level, version, and package version.
   *
   * @param level an unsigned int, the SBML Level to assign to this ListOfMemberConstraints
   *
   * @param version an unsigned int, the SBML Version to assign to this ListOfMemberConstraints
   *
   * @param pkgVersion an unsigned int, the SBML Groups Version to assign to this ListOfMemberConstraints
   */
  ListOfMemberConstraints(unsigned int level      = GroupsExtension::getDefaultLevel(),
                          unsigned int version    = GroupsExtension::getDefaultVersion(),
                          unsigned int pkgVersion = GroupsExtension::getDefaultPackageVersion());


  /**
   * Creates a new ListOfMemberConstraints with the given GroupsPkgNamespaces object.
   *
   * @param groupsns the GroupsPkgNamespaces object
   */
  ListOfMemberConstraints(GroupsPkgNamespaces* groupsns);


  /**
   * Creates and returns a deep copy of this ListOfMemberConstraints object.
   *
   * @return a (deep) copy of this ListOfMemberConstraints object.
   */
  virtual ListOfMemberConstraints* clone () const;


  /**
   * Get a MemberConstraint from the ListOfMemberConstraints.
   *
   * @param n the index number of the MemberConstraint to get.
   *
   * @return the nth MemberConstraint in this ListOfMemberConstraints.
   *
   * @see size()
   */
  virtual MemberConstraint* get(unsigned int n);


  /**
   * Get a MemberConstraint from the ListOfMemberConstraints.
   *
   * @param n the index number of the MemberConstraint to get.
   *
   * @return the nth MemberConstraint in this ListOfMemberConstraints.
   *
   * @see size()
   */
  virtual const MemberConstraint* get(unsigned int n) const;


  /**
   * Get a MemberConstraint from the ListOfMemberConstraints
   * based on its identifier.
   *
   * @param sid a string representing the identifier
   * of the MemberConstraint to get.
   *
   * @return MemberConstraint in this ListOfMemberConstraints
   * with the given id or NULL if no such
   * MemberConstraint exists.
   *
   * @see get(unsigned int n)   *
   * @see size()
   */
  virtual MemberConstraint* get(const std::string& sid);


  /**
   * Get a MemberConstraint from the ListOfMemberConstraints
   * based on its identifier.
   *
   * @param sid a string representing the identifier
   * of the MemberConstraint to get.
   *
   * @return MemberConstraint in this ListOfMemberConstraints
   * with the given id or NULL if no such
   * MemberConstraint exists.
   *
   * @see get(unsigned int n)   *
   * @see size()
   */
  virtual const MemberConstraint* get(const std::string& sid) const;


  /**
   * Removes the nth MemberConstraint from this ListOfMemberConstraints
   * and returns a pointer to it.
   *
   * The caller owns the returned item and is responsible for deleting it.
   *
   * @param n the index of the MemberConstraint to remove.
   *
   * @see size()
   */
  virtual MemberConstraint* remove(unsigned int n);


  /**
   * Removes the MemberConstraint from this ListOfMemberConstraints with the given identifier
   * and returns a pointer to it.
   *
   * The caller owns the returned item and is responsible for deleting it.
   * If none of the items in this list have the identifier @p sid, then
   * @c NULL is returned.
   *
   * @param sid the identifier of the MemberConstraint to remove.
   *
   * @return the MemberConstraint removed. As mentioned above, the caller owns the
   * returned item.
   */
  virtual MemberConstraint* remove(const std::string& sid);


  /**
   * Returns the value of the "id" attribute of this ListOfMemberConstraints.
   *
   * @return the value of the "id" attribute of this ListOfMemberConstraints as a string.
   */
  virtual const std::string& getId() const;


  /**
   * Predicate returning @c true or @c false depending on whether this
   * ListOfMemberConstraints' "id" attribute has been set.
   *
   * @return @c true if this ListOfMemberConstraints' "id" attribute has been set,
   * otherwise @c false is returned.
   */
  virtual bool isSetId() const;


  /**
   * Sets the value of the "id" attribute of this ListOfMemberConstraints.
   *
   * @param id; const std::string& value of the "id" attribute to be set
   *
   * @return integer value indicating success/failure of the
   * function.  @if clike The value is drawn from the
   * enumeration #OperationReturnValues_t. @endif The possible values
   * returned by this function are:
   * @li LIBSBML_OPERATION_SUCCESS
   * @li LIBSBML_INVALID_ATTRIBUTE_VALUE
   */
  virtual int setId(const std::string& id);


  /**
   * Unsets the value of the "id" attribute of this ListOfMemberConstraints.
   *
   * @return integer value indicating success/failure of the
   * function.  @if clike The value is drawn from the
   * enumeration #OperationReturnValues_t. @endif The possible values
   * returned by this function are:
   * @li LIBSBML_OPERATION_SUCCESS
   * @li LIBSBML_OPERATION_FAILED
   */
  virtual int unsetId();


  /**
   * Returns the value of the "name" attribute of this ListOfMemberConstraints.
   *
   * @return the value of the "name" attribute of this ListOfMemberConstraints as a string.
   */
  virtual const std::string& getName() const;


  /**
   * Predicate returning @c true or @c false depending on whether this
   * ListOfMemberConstraints' "name" attribute has been set.
   *
   * @return @c true if this ListOfMemberConstraints' "name" attribute has been set,
   * otherwise @c false is returned.
   */
  virtual bool isSetName() const;


  /**
   * Sets the value of the "name" attribute of this ListOfMemberConstraints.
   *
   * @param name; const std::string& value of the "name" attribute to be set
   *
   * @return integer value indicating success/failure of the
   * function.  @if clike The value is drawn from the
   * enumeration #OperationReturnValues_t. @endif The possible values
   * returned by this function are:
   * @li LIBSBML_OPERATION_SUCCESS
   * @li LIBSBML_INVALID_ATTRIBUTE_VALUE
   */
  virtual int setName(const std::string& name);


  /**
   * Unsets the value of the "name" attribute of this ListOfMemberConstraints.
   *
   * @return integer value indicating success/failure of the
   * function.  @if clike The value is drawn from the
   * enumeration #OperationReturnValues_t. @endif The possible values
   * returned by this function are:
   * @li LIBSBML_OPERATION_SUCCESS
   * @li LIBSBML_OPERATION_FAILED
   */
  virtual int unsetName();


  /**
   * Returns the value of the "membersShareType" attribute of this ListOfMemberConstraints.
   *
   * @return the value of the "membersShareType" attribute of this ListOfMemberConstraints as a string.
   */
  virtual bool getMembersShareType() const;


  /**
   * Predicate returning @c true or @c false depending on whether this
   * ListOfMemberConstraints's "membersShareType" attribute has been set.
   *
   * @return @c true if this ListOfMemberConstraints's "membersShareType" attribute has been set,
   * otherwise @c false is returned.
   */
  virtual bool isSetMembersShareType() const;


  /**
   * Sets the value of the "membersShareType" attribute of this ListOfMemberConstraints.
   *
   * @param membersShareType; const std::string& value of the "membersShareType" attribute to be set
   *
   * @return integer value indicating success/failure of the
   * function.  @if clike The value is drawn from the
   * enumeration #OperationReturnValues_t. @endif The possible values
   * returned by this function are:
   * @li LIBSBML_OPERATION_SUCCESS
   * @li LIBSBML_INVALID_ATTRIBUTE_VALUE
   */
  virtual int setMembersShareType(bool membersShareType);


  /**
   * Unsets the value of the "membersShareType" attribute of this ListOfMemberConstraints.
   *
   * @return integer value indicating success/failure of the
   * function.  @if clike The value is drawn from the
   * enumeration #OperationReturnValues_t. @endif The possible values
   * returned by this function are:
   * @li LIBSBML_OPERATION_SUCCESS
   * @li LIBSBML_OPERATION_FAILED
   */
  virtual int unsetMembersShareType();


  /**
   * Returns the XML element name of this object, which for ListOfMemberConstraints, is
   * always @c "listOfMemberConstraints".
   *
   * @return the name of this element, i.e. @c "listOfMemberConstraints".
   */
  virtual const std::string& getElementName () const;


  /**
   * Returns the libSBML type code for this SBML object.
   * 
   * @if clike LibSBML attaches an identifying code to every kind of SBML
   * object.  These are known as <em>SBML type codes</em>.  The set of
   * possible type codes is defined in the enumeration #SBMLTypeCode_t.
   * The names of the type codes all begin with the characters @c
   * SBML_. @endif@if java LibSBML attaches an identifying code to every
   * kind of SBML object.  These are known as <em>SBML type codes</em>.  In
   * other languages, the set of type codes is stored in an enumeration; in
   * the Java language interface for libSBML, the type codes are defined as
   * static integer constants in the interface class {@link
   * libsbmlConstants}.  The names of the type codes all begin with the
   * characters @c SBML_. @endif@if python LibSBML attaches an identifying
   * code to every kind of SBML object.  These are known as <em>SBML type
   * codes</em>.  In the Python language interface for libSBML, the type
   * codes are defined as static integer constants in the interface class
   * @link libsbml@endlink.  The names of the type codes all begin with the
   * characters @c SBML_. @endif@if csharp LibSBML attaches an identifying
   * code to every kind of SBML object.  These are known as <em>SBML type
   * codes</em>.  In the C# language interface for libSBML, the type codes
   * are defined as static integer constants in the interface class @link
   * libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
   * the characters @c SBML_. @endif
   *
   * @return the SBML type code for this object, or
   * @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
   *
   * @see getElementName()
   */
  virtual int getTypeCode () const;


  /**
   * Returns the libSBML type code for the SBML objects
   * contained in this ListOf object
   * 
   * @if clike LibSBML attaches an identifying code to every kind of SBML
   * object.  These are known as <em>SBML type codes</em>.  The set of
   * possible type codes is defined in the enumeration #SBMLTypeCode_t.
   * The names of the type codes all begin with the characters @c
   * SBML_. @endif@if java LibSBML attaches an identifying code to every
   * kind of SBML object.  These are known as <em>SBML type codes</em>.  In
   * other languages, the set of type codes is stored in an enumeration; in
   * the Java language interface for libSBML, the type codes are defined as
   * static integer constants in the interface class {@link
   * libsbmlConstants}.  The names of the type codes all begin with the
   * characters @c SBML_. @endif@if python LibSBML attaches an identifying
   * code to every kind of SBML object.  These are known as <em>SBML type
   * codes</em>.  In the Python language interface for libSBML, the type
   * codes are defined as static integer constants in the interface class
   * @link libsbml@endlink.  The names of the type codes all begin with the
   * characters @c SBML_. @endif@if csharp LibSBML attaches an identifying
   * code to every kind of SBML object.  These are known as <em>SBML type
   * codes</em>.  In the C# language interface for libSBML, the type codes
   * are defined as static integer constants in the interface class @link
   * libsbmlcs.libsbml@endlink.  The names of the type codes all begin with
   * the characters @c SBML_. @endif
   *
   * @return the SBML type code for the objects in this ListOf instance, or
   * @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
   *
   * @see getElementName()
   */
  virtual int getItemTypeCode () const;



protected:

  /** @cond doxygenLibsbmlInternal */

  /**
   * Creates a new MemberConstraint in this ListOfMemberConstraints
   */
  virtual SBase* createObject(XMLInputStream& stream);


  /** @endcond doxygenLibsbmlInternal */


  /** @cond doxygenLibsbmlInternal */

  /**
   * Write the namespace for the Groups package.
   */
  virtual void writeXMLNS(XMLOutputStream& stream) const;


  /** @endcond doxygenLibsbmlInternal */

  /** @cond doxygenLibsbmlInternal */
  /**
   * Subclasses should override this method to get the list of
   * expected attributes.
   * This function is invoked from corresponding readAttributes()
   * function.
   */
  virtual void addExpectedAttributes(ExpectedAttributes& attributes);
  /** @endcond */


  /** @cond doxygenLibsbmlInternal */
  /**
   * Reads the attributes of corresponding package in SBMLDocument element.
   */
  virtual void readAttributes (const XMLAttributes& attributes,
                               const ExpectedAttributes& expectedAttributes);
  /** @endcond */


  /** @cond doxygenLibsbmlInternal */
  /**
   * Writes the attributes of corresponding package in SBMLDocument element.
   */
  virtual void writeAttributes (XMLOutputStream& stream) const;  
  
  std::string mId;
  std::string mName;
  bool mMembersShareType;
  bool mIsSetMembersShareType;

  /** @endcond */


};



LIBSBML_CPP_NAMESPACE_END

#endif  /*  __cplusplus  */

#ifndef SWIG

LIBSBML_CPP_NAMESPACE_BEGIN
BEGIN_C_DECLS

LIBSBML_EXTERN
MemberConstraint_t *
MemberConstraint_create(unsigned int level, unsigned int version,
                        unsigned int pkgVersion);


LIBSBML_EXTERN
void
MemberConstraint_free(MemberConstraint_t * mc);


LIBSBML_EXTERN
MemberConstraint_t *
MemberConstraint_clone(MemberConstraint_t * mc);


LIBSBML_EXTERN
char *
MemberConstraint_getId(MemberConstraint_t * mc);


LIBSBML_EXTERN
char *
MemberConstraint_getName(MemberConstraint_t * mc);


LIBSBML_EXTERN
char *
MemberConstraint_getDistinctAttribute(MemberConstraint_t * mc);


LIBSBML_EXTERN
char *
MemberConstraint_getIdenticalAttribute(MemberConstraint_t * mc);


LIBSBML_EXTERN
int
MemberConstraint_isSetId(MemberConstraint_t * mc);


LIBSBML_EXTERN
int
MemberConstraint_isSetName(MemberConstraint_t * mc);


LIBSBML_EXTERN
int
MemberConstraint_isSetDistinctAttribute(MemberConstraint_t * mc);


LIBSBML_EXTERN
int
MemberConstraint_isSetIdenticalAttribute(MemberConstraint_t * mc);


LIBSBML_EXTERN
int
MemberConstraint_setId(MemberConstraint_t * mc, const char * id);


LIBSBML_EXTERN
int
MemberConstraint_setName(MemberConstraint_t * mc, const char * name);


LIBSBML_EXTERN
int
MemberConstraint_setDistinctAttribute(MemberConstraint_t * mc, const char * distinctAttribute);


LIBSBML_EXTERN
int
MemberConstraint_setIdenticalAttribute(MemberConstraint_t * mc, const char * identicalAttribute);


LIBSBML_EXTERN
int
MemberConstraint_unsetId(MemberConstraint_t * mc);


LIBSBML_EXTERN
int
MemberConstraint_unsetName(MemberConstraint_t * mc);


LIBSBML_EXTERN
int
MemberConstraint_unsetDistinctAttribute(MemberConstraint_t * mc);


LIBSBML_EXTERN
int
MemberConstraint_unsetIdenticalAttribute(MemberConstraint_t * mc);


LIBSBML_EXTERN
int
MemberConstraint_hasRequiredAttributes(MemberConstraint_t * mc);


LIBSBML_EXTERN
MemberConstraint_t *
ListOfMemberConstraints_getById(ListOf_t * lo, const char * sid);


LIBSBML_EXTERN
MemberConstraint_t *
ListOfMemberConstraints_removeById(ListOf_t * lo, const char * sid);




END_C_DECLS
LIBSBML_CPP_NAMESPACE_END

#endif  /*  !SWIG  */

#endif /*  MemberConstraint_H__  */

