/* ----- encode/1277x2627round, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_1277x2627round_checksums[] = {
  "7af347846154c277a241b9bf8749cd4eb0fc75ad481eca00cd86070ca14bc362",
  "564dec95c8bf481d887456b5847166e2cbfbbbf24a19ba1c110e3c0b0ef58661",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_1277x2627round_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_1277x2627round_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_1277x2627round_ITEMBYTES

static void *storage_encode_1277x2627round_s;
static unsigned char *test_encode_1277x2627round_s;
static void *storage_encode_1277x2627round_x;
static unsigned char *test_encode_1277x2627round_x;
static void *storage_encode_1277x2627round_s2;
static unsigned char *test_encode_1277x2627round_s2;
static void *storage_encode_1277x2627round_x2;
static unsigned char *test_encode_1277x2627round_x2;

#define precomputed_encode_1277x2627round_NUM 4

static const unsigned char precomputed_encode_1277x2627round_s[precomputed_encode_1277x2627round_NUM][crypto_encode_STRBYTES] = {
  {174,214,110,212,24,235,191,230,172,27,195,218,32,109,165,252,118,148,155,43,169,68,54,73,43,154,109,126,135,44,237,24,150,206,98,203,245,175,15,97,200,192,183,59,152,204,213,10,212,120,120,20,246,131,96,30,220,59,129,40,85,235,205,156,201,50,46,208,146,206,102,194,164,165,107,231,206,122,57,89,66,110,250,73,184,65,146,126,188,191,86,13,84,122,198,254,229,116,63,5,175,102,223,167,245,137,32,15,166,197,5,169,75,135,24,228,37,250,66,239,100,100,19,89,237,27,131,57,94,66,171,126,215,163,140,140,39,225,33,171,4,118,199,160,46,81,106,7,29,81,245,121,47,23,230,210,67,227,151,152,42,84,45,218,7,31,2,137,203,116,17,89,242,120,170,174,161,83,246,15,145,207,227,54,50,144,90,252,190,249,25,249,124,73,101,7,168,205,130,70,234,196,129,233,129,91,124,98,20,142,138,41,218,0,153,126,205,221,103,32,85,243,5,129,162,114,217,152,93,90,86,212,113,179,78,132,235,50,242,240,180,56,64,192,1,17,40,60,90,128,8,59,147,114,243,98,238,244,231,146,213,167,244,122,106,69,191,165,197,74,40,66,248,25,114,160,32,99,250,157,71,168,122,131,92,183,22,4,68,73,233,173,119,195,6,123,39,116,220,116,91,106,164,241,144,132,201,167,124,85,10,249,199,103,48,197,43,252,123,63,90,113,94,115,81,215,234,127,215,109,100,96,135,50,115,78,18,19,73,245,152,25,12,14,251,253,235,243,172,249,214,116,219,103,235,242,133,104,223,87,118,29,105,228,241,17,226,250,230,142,244,128,246,244,81,14,174,44,164,123,35,179,93,78,75,255,114,155,72,83,215,253,212,226,198,210,116,34,204,91,134,166,22,175,228,130,129,20,249,251,80,219,37,105,82,187,250,106,12,228,124,55,201,192,32,193,5,216,171,221,235,251,145,182,98,163,148,52,63,124,140,221,28,77,170,85,3,122,105,242,220,9,173,199,163,145,5,67,145,234,172,236,232,106,91,251,111,71,91,58,68,46,247,70,91,239,89,106,61,114,17,159,40,32,116,157,20,189,191,131,80,158,78,251,46,58,30,136,62,51,32,36,53,112,229,44,181,191,64,6,145,48,247,52,64,166,237,181,173,109,220,219,110,236,179,185,90,0,165,195,88,91,202,139,172,204,26,106,102,172,74,20,91,50,59,69,213,233,197,249,5,213,134,247,163,59,152,244,237,70,40,157,122,179,178,42,233,215,85,147,249,248,191,235,215,201,12,224,253,36,105,50,82,24,22,93,236,239,64,8,206,250,129,5,103,255,0,161,24,111,0,248,17,160,84,152,68,149,39,50,3,21,209,93,44,123,136,209,19,14,186,198,89,234,48,83,89,170,44,216,231,82,62,236,211,209,56,24,159,87,227,240,189,24,0,91,192,207,198,42,58,31,212,16,245,191,250,171,222,2,136,172,170,242,162,14,159,238,3,86,212,128,60,73,220,234,155,5,38,133,34,65,254,55,45,224,238,249,19,155,233,114,150,65,199,105,229,187,185,0,242,147,248,80,233,0,29,99,140,224,34,209,7,37,221,127,222,139,134,139,242,156,66,67,117,77,132,83,235,106,99,111,226,134,27,184,232,151,98,57,188,196,196,197,115,171,144,126,227,165,100,150,9,110,110,239,3,118,144,129,124,26,16,172,52,128,147,177,152,0,233,187,30,117,222,134,171,65,36,153,12,92,12,156,234,8,215,237,220,237,79,78,128,10,45,236,89,42,250,190,67,169,95,72,28,128,203,101,134,246,174,157,147,219,148,241,144,176,245,193,23,247,140,73,118,125,26,68,60,147,176,155,138,137,206,103,161,123,226,116,24,226,216,238,153,135,219,63,86,12,110,119,237,160,212,187,44,7,228,161,231,88,151,97,207,205,159,11,156,105,41,111,197,125,110,80,242,101,213,212,108,76,20,46,76,163,242,143,34,87,198,49,167,210,199,136,26,122,171,230,230,167,198,112,85,57,235,64,14,222,212,251,64,129,0,55,96,78,142,231,126,127,200,175,140,21,39,213,35,152,177,81,101,1,25,51,16,119,87,57,104,225,15,145,226,160,177,224,124,29,132,74,225,169,242,49,41,127,252,9,71,67,212,134,132,169,243,44,51,212,27,143,38,108,93,140,219,67,26,254,192,68,9,74,85,179,244,24,201,47,244,216,81,15,121,4,2,84,254,130,238,118,117,146,227,36,191,166,179,182,215,2,243,130,176,170,123,226,13,84,234,47,87,181,161,203,202,168,215,144,116,202,101,209,122,153,184,9,116,10,221,170,139,205,223,9,55,26,157,24,253,60,8,68,190,96,187,224,251,184,205,165,189,76,25,29,214,197,129,28,160,111,78,172,188,76,252,52,137,108,224,51,241,24,185,108,59,189,112,113,128,154,70,116,21,98,138,243,186,189,248,221,201,45,136,28,46,108,226,91,167,45,225,31,244,176,20,51,57,185,129,75,16,132,177,81,87,79,212,21,122,162,75,111,31,61,120,19,143,59,59,253,170,19,114,131,133,32,63,223,124,156,36,99,58,191,3,52,59,193,169,38,187,146,12,84,156,109,111,198,170,216,207,183,51,219,73,133,227,78,207,217,37,238,172,102,218,82,120,105,156,78,246,34,119,89,204,189,176,161,44,201,138,97,141,63,91,64,237,56,77,95,233,243,92,35,208,46,111,212,160,193,232,5,106,145,167,49,232,23,150,218,158,1,46,104,106,38,242,23,98,0,173,234,163,184,67,195,28,174,223,141,39,191,199,211,185,211,244,83,242,3,229,145,80,89,146,147,10,66,214,40,214,251,149,205,63,91,253,62,227,134,16,184,115,144,246,71,106,104,68,120,17,250,60,170,79,157,50,148,75,28,167,99,32,107,97,94,236,28,239,221,50,61,100,37,233,174,218,124,187,166,215,7,6,41,117,215,234,86,225,202,175,191,34,199,89,90,217,234,69,118,203,124,228,177,251,17,49,228,253,239,129,153,94,106,118,206,151,230,4,81,161,0,205,212,133,223,191,20,100,80,40,246,193,138,59,92,111,55,21,18,76,122,98,153,250,73,242,244,153,42,123,163,81,200,183,55,176,132,87,202,65,191,212,185,116,57,42,218,128,155,213,229,224,40,176,254,61,212,63,40,217,2,167,171,85,152,235,241,169,2,188,119,243,26,196,53,110,130,14,120,46,108,27,78,89,244,253,1,239,65,248,151,188,130,50,189,23,238,150,211,112,140,34,116,45,79,235,119,57,147,227,67,217,110,202,50,62,31,80,232,229,237,202,241,132,142,228,197,136,205,61,50,65,104,67,217,231,53,80,101,100,63,1,227,3,90,193,224,138,3,111,189,92,214,244,131,195,189,39,210,152,255,106,95,32,47,154,56,98,248,217,76,127,177,4,171,19,108,41,61,51,26,125,11,172,94,3,161,96,45,187,122,85,124,131,66,88,177,96,13,0,102,48,229,13,22,0,7,113,201,196,73,24,34,137,144,125,230,7,4,81,84,29,46,127,225,109,251,217,164,26,208,209,226,126,252,210,226,189,34,231,29,135,24,117,59,89,38,122,181,250,9,58,65,121,191,64,141,76,51,219,215,127,28,178,8,4,227,14,63,164,63,27,228,85,125,110,115,101,80,141,100,29,183,152,126,163,37,28,48,108,200,191,232,152,199,137,169,69,104,95,182,173,1,63,87,178,168,47,7,248,2,37,227,215,98,102,240,50,12,32,249,127,10,219,79,152,162,246,49,84,65,181,108,27,230,97,83,149,106,0,185,46,210,3,75,144,109,230,33,225,222,34,16,35,119,223,20,33,126,16,168,213,49,255,182,140,240,229,235,13,26,253,119,143,192,140,103,42,59,103,218,20,247,152,50,47,215,162,232,14,37,98,26,134,133,111,203,171,216,131,83,76,70,27,27,57,128,119,217,146,146,65,57,58,196,42,23,77,225,132,183,254,114,245,108,169,154,10,33,34,89,240,75,2,18,36,184,232,191,98,173,2,19,128,31,186,36,27,93,105,240,1},
  {253,76,1,154,74,131,34,138,242,63,250,212,123,140,73,120,103,164,32,132,165,169,233,47,231,0,83,39,81,99,118,200,10,50,130,235,242,33,249,200,135,229,48,251,148,41,26,13,147,161,99,238,254,105,76,140,25,200,69,215,235,51,101,65,44,222,228,14,248,216,72,158,155,247,4,19,176,254,149,223,172,63,72,174,113,180,106,79,107,192,30,193,178,175,215,10,212,215,180,153,251,205,38,79,226,11,156,29,50,196,254,98,95,25,0,41,153,241,59,170,143,138,101,81,179,113,108,79,98,208,167,253,14,99,202,25,97,67,99,193,167,106,141,50,163,48,112,228,28,177,113,233,191,230,218,103,48,41,202,92,22,132,255,56,162,220,180,67,216,109,78,108,26,126,243,114,188,76,209,215,206,135,172,152,56,34,128,251,35,198,31,234,104,141,246,114,238,121,143,34,99,28,136,27,112,173,164,121,130,110,151,132,101,142,50,232,180,244,148,73,254,219,233,71,253,210,131,109,81,216,111,229,81,30,67,231,39,221,82,98,189,136,55,7,122,11,148,57,118,115,255,237,142,204,60,223,161,176,153,90,164,252,39,51,63,148,189,161,30,0,139,87,252,105,101,106,39,45,115,147,248,65,244,187,161,152,221,37,205,231,39,172,172,248,35,164,99,48,119,16,101,37,170,60,173,222,177,252,247,57,135,67,134,77,177,89,170,139,141,206,28,50,91,1,54,55,151,135,134,118,160,182,141,151,205,248,9,72,12,194,175,66,188,77,191,199,164,40,222,244,126,89,159,113,211,157,102,158,245,205,232,191,122,123,39,92,84,137,152,24,186,1,95,42,22,31,245,240,248,188,35,80,73,46,253,97,191,191,118,134,31,17,242,107,128,50,142,133,32,173,73,157,239,71,192,136,250,27,215,178,153,44,240,31,180,133,193,117,200,230,169,37,139,236,172,168,202,51,68,245,44,232,170,164,55,152,231,25,134,30,94,0,217,194,144,117,184,80,128,200,127,254,102,152,239,164,212,115,247,46,140,168,216,56,223,99,93,209,83,94,62,110,251,24,38,121,37,198,33,14,114,15,15,13,146,245,133,60,187,105,72,6,159,138,28,62,51,195,252,134,209,130,250,217,126,128,249,30,203,221,30,127,249,86,205,65,243,252,64,192,2,178,233,225,205,41,26,146,143,166,36,89,237,251,36,79,178,239,216,55,236,245,172,114,219,73,178,197,174,199,240,141,181,133,29,231,221,226,70,201,2,221,15,191,199,96,122,192,44,213,93,225,84,230,48,241,12,224,208,119,243,219,154,36,179,164,84,160,119,128,195,144,251,24,58,55,123,224,156,240,139,172,224,181,103,6,219,76,170,94,51,131,35,239,233,8,115,215,170,251,44,25,70,188,39,97,55,20,164,183,73,170,125,30,85,93,154,224,186,19,0,133,232,144,219,68,10,200,170,96,26,128,116,32,47,60,115,128,176,64,210,172,116,151,63,151,194,217,219,243,129,167,193,140,162,8,143,231,216,76,220,200,205,240,238,105,12,66,58,107,186,123,226,59,205,103,223,229,181,53,63,224,78,130,241,35,17,89,181,97,190,0,185,59,151,232,183,87,159,104,30,59,123,211,72,48,124,52,93,61,247,105,131,238,147,40,125,103,22,87,180,2,168,1,124,176,38,84,220,136,97,18,251,207,181,69,222,173,66,187,177,210,7,23,152,13,220,109,197,224,3,165,156,228,154,68,68,138,47,21,169,157,6,132,236,80,137,170,152,165,139,159,79,193,194,138,234,67,252,95,196,123,199,31,65,68,118,132,20,195,164,51,247,64,245,226,144,192,232,245,221,16,102,57,210,109,207,18,132,230,182,179,199,101,37,243,205,250,56,234,206,128,150,238,238,51,19,251,193,119,111,50,66,219,104,155,244,185,248,18,129,29,30,212,139,142,223,228,1,248,225,13,250,151,160,166,122,244,252,65,28,76,159,83,52,148,58,43,163,222,248,68,81,33,61,183,236,66,247,10,122,90,199,196,16,66,191,225,100,154,6,96,184,192,215,48,108,234,85,183,1,162,26,75,194,176,0,39,102,236,243,0,109,113,130,153,103,190,77,51,79,62,168,193,153,163,18,65,78,91,87,181,184,171,203,149,72,190,230,95,87,198,20,51,95,69,165,32,136,65,189,242,108,78,112,195,22,46,221,179,240,220,114,70,143,131,155,116,91,219,14,234,61,78,133,116,26,227,201,132,119,241,156,241,201,169,72,190,67,19,154,223,165,217,170,238,131,2,122,153,205,161,226,205,196,187,253,183,25,28,179,128,251,197,52,79,148,70,238,79,14,47,7,94,20,182,68,238,143,42,137,208,206,34,229,164,150,166,87,252,14,111,159,83,135,250,80,79,106,51,113,250,174,31,179,85,129,141,159,108,15,226,3,44,53,228,86,15,63,12,142,30,69,149,110,196,81,100,48,138,229,218,149,211,17,83,153,68,59,61,91,143,232,195,28,117,87,147,167,81,116,220,36,233,204,241,35,17,181,7,79,62,60,79,218,91,127,126,169,115,233,59,179,123,236,201,70,5,206,174,98,203,15,111,81,157,218,242,145,93,194,193,69,246,56,109,22,169,37,211,243,153,21,209,190,212,8,58,130,218,23,239,122,125,40,158,135,241,13,163,180,50,85,95,73,186,202,222,137,186,192,138,34,144,150,230,234,66,130,120,45,171,177,23,204,110,155,246,212,186,113,233,194,170,105,213,69,163,234,125,82,120,224,133,161,189,29,75,172,182,217,170,117,97,112,217,15,254,87,174,112,165,140,209,30,196,10,99,110,215,115,24,217,215,89,210,51,175,242,223,232,169,213,158,147,25,163,129,229,91,183,212,135,72,76,219,101,145,60,73,81,237,28,184,49,95,206,173,7,2,148,158,54,90,36,106,32,115,74,245,127,157,50,22,251,218,192,146,110,62,56,204,228,129,105,134,57,143,240,186,246,109,234,194,139,118,141,111,31,78,153,132,6,40,124,4,68,229,5,4,64,67,126,239,112,71,16,51,73,102,38,244,193,22,207,69,68,116,151,19,63,86,54,129,44,213,19,224,81,88,109,29,181,111,195,101,138,177,24,79,23,181,231,31,237,226,247,92,244,21,64,32,115,190,19,64,180,152,222,97,182,4,67,254,220,65,196,11,110,92,209,185,9,181,168,14,226,236,3,104,211,36,148,210,169,162,104,189,70,228,108,139,50,246,213,233,232,177,114,132,51,222,216,65,4,16,40,73,255,187,171,213,22,168,194,102,33,108,102,196,164,21,217,255,193,188,190,189,217,0,192,234,46,232,40,211,237,108,102,34,53,39,99,174,68,20,180,206,110,19,17,103,74,74,222,172,107,39,184,137,184,197,172,117,123,63,79,87,177,179,114,251,83,124,108,218,23,234,124,178,242,10,20,146,4,184,81,150,16,134,203,155,199,137,185,181,145,108,199,121,248,148,83,24,55,71,54,1,98,245,216,234,221,184,207,243,53,56,55,88,48,130,69,247,53,53,27,91,71,132,219,201,112,231,181,199,115,184,165,167,138,9,202,115,132,236,172,227,102,32,103,103,153,252,144,23,254,241,183,86,178,218,35,122,52,29,46,140,21,29,157,247,50,115,175,152,201,119,33,45,192,22,187,127,100,77,33,102,42,112,167,200,156,67,104,236,202,161,96,185,247,190,218,209,41,165,85,0,144,49,83,31,246,101,250,99,234,218,92,218,166,192,209,240,252,79,128,74,77,193,76,83,61,26,156,34,148,208,229,163,24,103,164,84,198,154,119,26,28,103,166,216,44,77,131,97,111,2,122,6,50,247,4,254,44,70,80,126,61,187,170,28,37,247,254,20,126,32,190,77,75,114,52,24,145,193,238,87,141,35,32,238,112,60,43,113,221,241,69,133,206,183,100,17,177,98,181,7,186,77,175,170,49,16,4,140,139,37,32,205,74,134,248,192,33,52,113,163,173,59,91,103,54,47,93,72,228,101,81,163,253,208,53,48,22,4,17,24,196,94,186,16,25,68,109,142,201,226,103,22,35,190,150,102,1},
  {118,247,160,44,236,55,97,214,91,166,222,11,236,242,91,195,122,113,45,20,245,184,101,147,248,177,122,241,98,97,122,34,124,232,209,67,57,92,245,121,127,29,225,133,155,123,143,25,61,130,94,35,55,247,55,235,141,100,87,177,90,44,117,254,195,44,239,210,106,209,138,131,229,14,166,20,246,72,254,145,104,161,136,166,26,53,254,89,25,157,45,167,86,83,5,153,28,187,118,138,215,136,24,231,235,75,63,120,126,232,151,183,106,103,64,94,67,231,80,209,129,33,171,216,233,138,189,97,114,117,229,192,104,2,94,67,105,205,58,96,229,201,52,174,15,170,198,25,70,178,53,205,150,72,137,128,80,95,194,4,72,21,4,94,234,67,4,93,218,169,202,146,249,96,125,175,11,12,148,71,201,168,46,124,22,104,62,79,204,61,143,180,60,107,72,185,130,236,7,12,217,186,244,132,88,139,86,2,160,205,31,190,138,40,223,171,153,255,53,67,116,43,63,49,93,132,31,233,16,253,208,34,128,148,207,146,186,109,207,166,169,148,62,40,51,243,217,249,141,19,159,125,47,3,195,74,141,211,189,183,101,224,169,150,195,55,81,93,216,61,173,63,139,106,169,190,168,206,44,111,14,180,216,161,72,236,54,240,62,22,201,80,53,120,181,83,237,11,163,135,151,113,66,105,208,27,61,64,35,145,52,100,64,129,106,118,34,189,132,15,133,1,123,226,209,24,56,97,95,249,192,60,11,246,246,195,162,201,133,161,122,66,155,68,215,140,154,113,181,245,61,212,47,144,161,78,12,107,46,109,159,82,252,186,214,208,7,36,165,72,230,75,186,196,249,70,179,0,151,71,48,106,25,75,17,236,205,217,40,230,28,19,240,192,215,116,126,189,13,47,9,230,71,75,171,227,215,46,198,255,136,171,251,8,39,32,173,88,104,227,62,21,4,108,227,199,142,202,66,211,59,72,245,155,238,249,231,81,12,114,62,3,201,61,244,244,136,227,27,177,12,45,228,231,136,244,253,163,130,49,31,60,209,27,137,57,189,38,137,225,75,162,145,139,99,139,27,170,162,143,157,213,159,20,5,87,245,25,211,33,47,75,190,169,55,14,194,255,15,180,41,181,116,192,239,65,112,55,213,237,101,13,226,93,238,36,77,114,135,99,150,229,181,237,158,140,71,125,213,93,171,73,203,1,126,46,202,24,209,161,26,208,26,156,61,62,148,6,85,156,204,69,128,32,106,26,16,178,234,173,23,94,247,24,30,59,116,149,76,173,247,78,4,208,178,189,43,90,102,238,225,242,163,172,123,40,239,251,248,106,52,84,90,255,242,69,102,63,28,160,102,87,234,54,181,101,48,65,7,181,172,238,82,255,25,74,214,124,140,66,99,48,57,194,249,119,166,249,134,19,167,36,143,190,224,148,189,231,174,77,131,199,121,22,92,249,39,101,98,61,103,43,226,212,115,54,52,67,97,219,115,84,167,126,45,17,81,102,56,190,175,176,246,171,94,83,82,93,212,173,19,122,255,126,156,50,253,132,58,239,143,255,119,47,172,34,55,135,238,126,223,196,179,107,6,119,117,160,242,150,143,214,41,34,48,194,232,197,115,58,191,120,207,117,76,98,142,3,161,160,198,96,200,108,116,19,43,100,253,5,131,214,233,239,209,245,234,33,105,125,161,3,3,84,53,107,135,80,232,73,92,88,174,145,47,163,52,94,136,212,186,140,53,11,117,148,68,191,210,111,39,172,235,174,69,33,151,106,158,55,10,38,186,37,43,186,202,61,212,113,138,101,175,214,6,220,145,210,86,38,85,247,28,26,130,18,66,45,221,32,16,37,146,207,173,202,55,107,112,121,25,66,145,198,0,33,74,34,60,45,55,113,107,158,111,93,72,74,241,77,56,136,22,111,222,9,249,158,236,180,162,239,10,192,19,11,107,59,39,187,101,112,33,240,90,215,247,160,94,15,219,245,215,39,181,94,249,110,71,67,191,251,43,43,238,6,126,40,134,27,2,146,55,149,172,244,101,105,225,231,100,190,108,62,19,139,104,73,246,191,29,205,187,246,203,98,234,52,133,198,164,231,74,13,18,129,176,176,206,252,20,33,12,97,105,85,92,8,2,251,95,221,65,65,102,200,198,132,226,214,50,225,51,144,241,125,17,8,56,121,226,96,232,19,202,73,101,67,252,168,89,141,11,78,78,86,245,172,173,25,36,223,34,37,74,67,171,191,88,224,31,133,93,23,3,110,87,248,30,139,109,192,134,243,143,166,32,136,100,147,195,58,194,146,109,109,75,182,2,170,12,10,88,178,174,17,76,125,213,89,139,16,56,64,229,178,164,63,229,23,124,20,252,15,251,160,69,166,128,159,101,221,217,247,136,211,206,170,120,8,48,65,202,113,252,167,121,19,117,184,154,177,218,124,29,114,39,61,213,204,95,37,113,99,241,172,207,225,158,57,81,241,139,245,188,97,13,21,135,74,251,38,43,240,12,192,14,66,101,62,198,152,241,189,40,139,42,228,207,198,91,25,218,35,40,85,211,254,180,163,114,199,194,80,78,102,228,48,65,47,154,173,33,39,14,5,137,243,139,56,186,196,112,254,76,24,221,233,235,172,181,173,20,223,170,210,127,173,255,255,242,63,154,38,152,240,44,114,17,25,6,123,26,170,1,24,113,150,123,3,13,190,30,224,215,23,40,213,155,137,63,123,219,208,113,27,111,98,210,111,43,251,13,22,72,18,197,181,31,212,68,29,200,145,240,202,250,207,147,206,236,245,185,218,44,172,233,229,98,205,138,158,253,132,96,139,105,204,123,2,178,207,156,244,254,228,95,64,150,205,12,17,250,73,81,106,233,254,254,221,5,65,119,121,131,55,184,139,255,77,143,54,116,212,198,184,146,234,34,236,59,204,214,216,4,86,200,87,101,186,38,154,174,156,162,163,10,60,168,92,192,136,129,13,45,186,60,193,67,177,89,132,219,164,227,206,43,211,224,214,122,124,161,171,146,78,176,81,101,186,60,181,88,194,108,220,128,87,161,24,77,140,211,45,87,1,31,255,57,121,227,201,195,10,238,9,202,31,62,115,114,147,57,178,115,241,66,135,153,248,37,165,27,223,247,22,103,132,202,69,112,188,96,8,250,69,114,203,236,187,207,186,179,129,135,193,255,226,225,215,78,115,15,32,157,106,209,152,111,228,4,51,173,199,201,237,66,128,159,29,162,2,163,253,50,140,197,91,182,236,137,137,222,139,197,131,122,55,189,87,239,69,33,135,14,219,162,130,1,139,46,156,95,67,110,25,126,181,160,247,175,31,200,45,67,55,193,98,195,162,176,149,212,110,127,129,53,219,228,128,135,4,105,107,175,160,222,204,203,105,184,115,175,79,53,233,109,119,132,157,69,76,125,4,18,184,6,32,190,238,216,171,146,245,210,116,202,120,123,84,239,176,102,19,107,5,136,150,193,120,215,93,86,77,157,74,130,37,105,150,200,151,52,104,157,120,33,232,71,5,77,184,17,40,223,235,209,135,201,229,43,85,58,20,110,162,159,112,15,7,78,52,110,252,147,39,24,237,210,130,84,182,190,224,239,231,165,155,13,48,27,94,212,210,187,119,44,158,120,101,209,237,171,187,204,4,26,226,74,41,59,122,242,152,197,210,120,125,62,75,143,15,233,21,27,130,101,112,172,65,184,119,127,16,133,149,95,237,64,62,194,191,93,234,149,93,150,57,211,146,108,81,133,21,249,42,231,223,140,24,155,91,133,144,234,237,56,109,104,162,32,171,148,118,106,241,150,133,239,1,113,63,116,143,133,82,241,99,50,19,152,159,176,69,168,173,63,170,182,97,172,99,134,186,121,35,180,125,107,37,128,235,243,227,66,72,206,121,186,109,109,18,31,90,140,120,231,246,220,235,130,43,67,248,10,170,154,180,207,11,125,42,226,93,19,188,13,225,238,200,153,16,118,116,29,132,214,16,186,155,121,115,72,121,141,210,170,108,113,93,102,26,248,53,72,202,175,80,70,6,240,77,84,240,42,111,63,113,205,206,232,139,224,30,1},
  {136,186,195,162,51,72,168,64,69,235,185,217,248,226,234,50,1,136,166,208,129,7,166,221,123,245,211,237,139,247,7,245,75,95,180,30,209,63,213,145,140,13,168,213,17,197,226,114,88,10,50,187,178,202,39,163,69,57,40,178,194,170,148,175,120,14,119,247,111,159,19,241,198,80,219,244,248,231,132,200,89,156,174,160,140,154,14,155,174,54,183,220,205,230,122,133,215,223,15,132,26,25,185,249,160,199,122,21,168,161,134,213,126,49,119,202,62,175,213,103,15,88,172,238,76,244,73,42,56,188,94,95,21,240,253,45,55,130,213,19,135,2,103,23,50,176,147,182,135,126,31,104,80,90,229,157,173,35,69,89,18,114,101,237,96,45,137,204,11,145,159,126,65,223,233,108,235,253,88,27,49,224,86,239,200,40,62,241,90,15,49,68,142,114,251,180,96,178,61,104,226,172,207,126,72,69,206,35,196,169,16,47,232,183,2,194,235,224,1,147,16,135,224,173,156,66,71,18,112,2,211,72,18,48,84,185,87,193,126,209,192,193,112,17,247,40,174,120,116,233,66,140,120,194,145,94,56,241,237,214,56,66,25,206,230,46,166,186,44,233,25,56,133,194,231,30,223,139,35,113,126,192,85,167,204,232,88,40,116,6,217,13,39,234,224,217,36,238,38,237,208,2,232,91,28,71,255,142,176,229,40,232,86,141,181,197,228,201,160,141,192,194,160,200,96,167,31,74,125,115,173,14,190,222,128,22,148,193,142,201,225,7,99,1,220,58,81,66,209,191,111,105,162,62,165,135,170,251,251,19,12,163,244,255,239,22,104,173,38,66,120,56,181,13,168,78,27,251,234,136,94,171,254,174,249,128,36,215,190,35,62,149,1,130,178,224,172,148,31,254,127,148,135,74,49,184,6,132,144,34,153,6,102,218,57,225,116,8,93,177,104,103,221,161,0,225,5,36,167,95,138,192,43,209,218,178,207,103,136,203,169,165,76,24,80,240,149,238,13,144,200,187,59,68,24,72,243,117,207,59,123,209,211,227,93,183,120,12,161,62,57,246,58,76,52,21,18,189,172,95,82,65,176,125,60,138,191,42,158,119,30,105,124,103,226,62,135,177,93,98,178,234,147,198,190,43,59,153,65,192,48,77,193,182,160,157,10,41,75,9,144,149,252,241,220,43,32,162,136,164,71,110,108,108,61,150,34,12,19,252,129,203,228,239,75,223,191,35,95,29,92,22,36,88,206,42,159,60,182,66,248,188,89,196,85,15,212,74,153,243,193,38,6,136,190,64,186,152,162,48,134,2,11,16,248,165,182,4,244,230,192,154,68,105,10,15,225,224,131,218,210,170,182,109,49,98,20,145,170,134,22,12,108,197,220,210,17,230,250,76,228,164,221,154,116,208,157,197,110,172,12,112,210,130,197,16,36,41,254,17,63,151,134,230,123,122,159,212,12,185,40,120,6,111,134,142,143,172,230,110,239,38,88,223,50,102,19,15,178,1,84,163,59,103,235,80,122,163,34,23,32,116,253,130,4,172,194,143,175,214,151,1,30,134,93,150,184,213,184,121,165,184,96,129,24,0,20,35,180,62,204,196,140,120,103,199,221,78,215,248,52,102,27,104,115,207,123,251,182,112,48,232,224,99,120,17,244,165,188,251,151,148,30,83,68,212,188,14,165,7,169,205,233,10,241,232,255,81,108,40,75,111,251,68,21,238,16,101,67,194,190,234,13,98,245,195,194,232,114,109,137,241,133,120,143,197,46,114,11,34,154,101,204,134,131,236,53,126,118,142,76,77,99,223,21,99,7,185,38,131,195,210,156,254,252,108,165,16,154,127,214,66,59,180,181,118,65,112,72,90,91,219,231,215,54,102,111,9,221,195,179,91,162,236,167,149,225,68,228,20,68,31,239,136,120,150,232,127,116,200,206,5,8,185,212,102,30,139,20,199,118,4,49,223,21,221,197,86,34,23,158,196,69,127,219,20,81,148,47,56,50,100,251,230,60,250,56,236,129,41,145,131,135,64,172,94,44,21,185,105,55,21,178,70,231,149,28,93,169,67,10,114,87,255,87,157,148,240,237,58,68,224,206,44,93,192,99,51,94,93,253,33,154,88,228,145,5,38,86,190,242,132,131,93,129,79,255,35,124,14,192,77,224,191,6,173,96,108,66,196,130,235,69,162,40,171,11,246,93,1,221,47,47,122,92,137,175,178,44,23,173,178,103,187,158,249,168,69,167,73,186,150,142,92,132,48,239,147,70,178,168,200,106,187,57,44,3,186,246,35,33,159,41,234,245,145,8,197,57,210,176,132,135,152,133,43,15,248,173,178,133,22,36,180,26,231,68,94,160,90,228,179,9,189,40,117,105,113,170,211,86,229,134,189,24,119,217,226,40,30,191,193,100,136,169,243,25,159,189,44,189,212,113,75,110,158,188,12,237,210,101,172,77,117,69,86,126,129,79,210,43,20,237,212,138,183,187,198,1,201,53,114,29,138,103,161,13,199,212,85,30,172,48,215,35,217,236,159,51,155,187,185,74,119,145,113,129,17,113,141,166,210,1,86,0,179,245,219,2,12,1,53,213,234,80,116,57,104,109,74,130,54,129,178,54,37,54,158,61,61,146,78,221,53,168,9,139,151,146,29,190,26,5,179,86,177,131,102,245,201,149,88,39,160,243,152,67,159,108,91,25,104,84,203,55,226,247,231,102,175,60,81,74,253,77,80,106,176,231,254,165,182,246,249,18,235,59,94,104,111,14,52,229,38,241,173,203,68,187,191,229,148,161,243,53,92,184,241,36,40,234,138,212,55,149,4,163,7,239,23,11,226,83,104,241,59,38,86,194,214,254,182,92,221,224,39,184,23,154,246,31,120,237,197,32,220,216,250,41,93,29,223,162,248,11,19,250,78,48,166,17,186,125,63,61,121,211,232,244,182,98,70,230,90,50,169,177,17,33,126,168,135,20,168,145,232,208,132,251,37,78,141,215,180,38,14,4,184,177,63,177,64,140,160,228,198,25,125,164,6,153,231,148,167,70,99,180,107,238,116,60,76,143,160,189,242,123,47,109,133,137,15,16,201,255,16,35,65,247,139,94,131,123,125,13,244,153,41,234,98,120,58,228,59,124,95,176,143,67,115,17,144,19,247,237,117,151,125,129,157,178,118,106,240,156,208,62,134,14,110,253,4,1,190,82,207,255,11,210,20,61,165,55,43,76,1,104,19,3,99,75,117,248,152,246,196,190,154,185,103,23,226,76,228,143,40,44,103,239,129,91,101,67,94,114,45,51,102,203,252,189,45,17,251,148,34,112,122,26,56,120,64,145,136,194,246,193,192,35,225,77,33,202,182,51,237,73,4,238,86,25,162,34,15,210,145,20,166,101,143,23,46,69,61,6,58,155,178,201,116,245,223,3,110,61,248,90,29,20,26,62,166,188,249,181,52,29,28,156,195,197,51,219,224,198,189,95,73,74,66,101,62,208,108,48,96,210,208,119,43,61,198,181,154,235,11,162,188,206,42,233,43,151,127,186,99,136,20,64,218,44,224,195,31,54,79,29,5,136,219,81,247,157,92,243,134,10,52,98,51,85,26,149,145,229,29,213,48,131,238,56,173,178,76,27,94,249,112,10,202,81,183,225,67,137,88,198,18,75,124,97,43,224,229,93,27,13,208,74,163,148,120,254,237,51,136,250,68,8,155,151,40,238,200,43,105,87,55,6,152,151,177,58,44,176,233,46,230,205,197,249,90,224,117,241,99,45,89,46,150,167,221,220,203,197,193,156,193,181,92,254,35,213,85,119,213,185,9,36,251,204,31,65,138,89,166,227,188,46,5,241,51,142,75,105,35,94,138,83,164,67,219,14,55,153,185,247,183,205,177,71,133,221,22,1,168,248,105,126,164,207,5,187,169,45,126,220,196,184,23,103,251,27,224,77,244,158,216,163,33,210,146,201,113,37,53,70,168,19,110,4,167,160,134,131,239,36,89,138,86,21,50,159,208,174,72,149,78,186,40,195,178,187,195,18,75,238,152,46,78,30,102,110,241,152,220,8,237,123,122,49,25,85,17,2},
} ;

static const int16_t precomputed_encode_1277x2627round_x[precomputed_encode_1277x2627round_NUM][crypto_encode_ITEMS] = {
  {-14029,537,-31722,463,-24032,22839,-14865,13634,-30881,-17547,25086,-28563,12481,-6669,-26021,12891,-10007,-3674,3529,-9984,19640,-9303,-8006,8202,-28637,-20280,-22383,-28890,18204,-12379,-30488,-1615,7646,-12257,9023,607,-22162,6434,12433,15838,-22587,25219,-14034,-31000,-1221,-16595,-30597,-15682,-9091,-27691,-22403,-14410,20885,-6441,-1587,20462,6713,14555,29743,-25617,-30643,-2226,26785,23038,26386,-30782,-20725,-23551,-6705,-27594,25637,-20712,25069,32466,-20764,-19511,21859,-10711,6536,9329,5054,-13783,9967,18748,2621,-8180,-4806,-7044,24886,-3739,-22919,2497,-17276,-1733,-25681,12298,-28657,29383,-19673,-4156,20083,22428,-16450,-13389,-7569,-10632,-10837,-4380,5038,-15853,-12818,24543,15982,9870,8192,11240,1236,5636,23270,-7608,-22947,-10343,22390,-23360,-30268,31528,-31568,-21197,24051,-7583,12528,812,22437,16309,-12127,-13699,14733,17675,-25828,5014,12930,-31806,23125,25662,-32028,-19851,2168,-6252,31033,8282,-25022,-27616,-24990,5643,-20806,-3950,15225,11394,25889,30514,-19316,-30917,8878,29787,13799,-1312,-10050,25280,-4057,29307,-25012,-26504,-16006,3504,1144,-4181,4245,-2346,-23823,19407,-7317,26048,13276,21294,-28249,-11825,25819,10124,18854,9602,17482,-21590,30137,8805,-21559,-17780,31029,2857,-28508,23539,4849,-30887,-11915,27629,-7093,3491,-31288,-32561,9145,-12950,7778,21734,11935,-32368,-24627,16445,-26151,32108,-10369,-6320,-7451,-13071,-28521,-1733,-9054,27669,29418,4337,18751,-4730,1888,11613,19531,-1645,-22579,-23797,-8657,28696,-18042,4887,10583,-6615,18775,-26846,25502,-6177,-26198,13208,-9108,21086,-13684,16577,-32608,-164,-22761,-28373,19537,-31022,-12458,-22071,10409,14662,-21504,-20215,18551,7379,31068,19380,24040,2890,-29470,13212,8414,254,-21022,-16537,-22207,-12066,3380,-24686,-3220,-8522,32725,-22074,-13816,-25276,2490,27412,3916,6182,10572,10401,30039,10113,17525,3655,16128,15098,32427,5899,5977,-6001,-13005,-25858,6966,-1734,-26520,30371,31140,6038,-20165,-9997,7918,-12364,-31253,9587,-3506,-8198,2698,3637,18479,-32032,-6321,-24701,1592,762,18194,26251,-20072,23331,-31689,-31365,23562,23083,27702,-30025,31088,24576,-31382,696,1831,19188,-8077,19257,-30916,-15984,-23842,4808,-29639,32343,10773,24525,-31417,3797,-17359,-27727,29457,12628,-2467,28561,7259,20158,-25704,17973,28600,-122,24111,-14641,27577,-18864,-12109,25953,11725,23662,-10038,-26675,7107,30185,-31358,-3382,31216,25444,31509,4990,8278,-16958,-4273,-4567,16443,-28748,-19857,-7974,-5823,29263,29204,-31702,-20504,-9989,4721,-2717,-15655,27537,15061,24845,30276,8224,14348,17765,-30669,-6406,-12973,987,-10166,31625,5446,31800,9292,31325,-17146,20745,-5606,-16717,-21538,17959,13652,5548,-31340,-3354,-1746,-4242,24404,21048,21305,-27223,31669,-27378,-17430,1389,18506,2231,12756,2563,26004,27731,28696,2142,19165,-10334,-6743,27928,-1708,-8047,28106,-23255,-20888,19818,14126,-5710,21251,27703,-19988,1818,-22113,23174,-25594,4738,5135,17853,24026,-20824,23918,28912,20285,-29725,2541,-12472,21897,28264,-26949,-22680,30693,29248,-31606,32353,12904,2169,8296,20804,-25512,-23347,27864,-23268,26228,13564,-24589,3334,-32410,-27160,21900,-5044,22882,22631,12181,8660,-22573,13278,-19497,26048,-18900,-18300,-17051,-22097,-31347,-1831,14821,11527,25607,-21014,-5814,-4953,14795,-14422,-29805,-4464,-10058,-21385,-19679,-21212,-11886,25224,30302,20556,10722,-13551,29148,-1186,-972,283,21752,-25880,24272,-21883,-6172,-20977,4778,-17983,24818,14233,-25018,16555,20052,13628,1935,-18304,-8091,25556,2645,-3871,-51,-23363,2666,27308,-23337,30000,11295,632,7720,-10983,-26842,26780,3005,-16882,-30828,17079,7713,4871,16759,18573,-5928,23453,-26888,-10880,894,-15003,18720,-695,224,15134,-4483,27709,-30231,-25855,26012,2869,22076,-27202,-9846,-8453,-3937,-10634,20518,6234,1982,27832,-6082,-26712,14580,32089,22857,23158,-15027,-1988,-10943,13817,7632,-3976,26002,16321,-8056,-13511,-27860,-11436,31378,23141,-32322,-30246,13631,-28947,-29184,11837,-3980,-18882,-13315,-12995,-14756,27699,-20647,-2066,-6696,17854,21517,12143,25313,-25699,-30491,3271,2912,30832,-10159,22185,2820,3403,-6441,22174,8965,-15929,-6795,-8901,10855,5111,5887,23196,13879,24492,-15716,-22780,13649,-23762,-98,26464,-14539,4330,15524,-1449,6842,-8208,-12725,-5356,-14846,17124,17389,21968,24632,190,-17951,-31624,238,5787,-5350,26929,-7507,-8169,-26075,-8930,-23355,-27324,8678,-13612,492,5264,-26828,14132,17711,31995,9684,-8502,-13300,4245,3595,-28258,-31669,11314,-29286,5500,26414,13452,-16233,-18711,24903,-32403,20144,29322,25819,-32649,-12919,-12368,27629,-22241,-6678,13446,6840,-393,-20389,18243,-29914,-29468,-31085,-26632,-30538,17850,-15510,-27369,-22677,17437,22692,-9797,-29409,6573,-25059,13463,-3528,2617,-13377,26396,27613,6602,-8958,-2411,-3721,1189,-1406,-23599,-21859,23643,-31442,5750,32021,-18997,-1275,-27201,20406,22826,18159,-5173,30369,-6214,11341,23013,-28010,-12049,27927,-21115,16327,-28577,7869,29351,23892,-25711,18320,15957,-29395,17705,-19806,31600,14985,14910,-16572,-31530,11172,14892,13757,15789,3770,1843,22848,28271,21278,-1369,10923,4810,20706,27082,20120,10865,26803,-27133,21529,10329,-2342,32702,-11656,4588,1379,-31744,23108,-11983,-17811,-5710,17523,-31424,5710,-6209,-7306,16374,-14033,-22081,-22779,-15651,20481,-5622,8953,-29009,-2606,10425,11842,-3607,16868,20470,25921,1000,13847,6649,-7486,10322,25473,-15109,-15524,6090,9473,1865,14004,-24705,-15551,-1218,17682,18717,5066,-25404,28460,-7200,24757,-4353,14632,4555,1747,-17305,-26339,-9519,-31497,19690,752,-1298,-9870,14102,6217,24689,-7890,20191,29986,-12737,31525,21665,20399,-8213,-12688,-24842,-22574,29008,25180,-14795,1661,-15111,-9982,-8020,-21319,29737,-24462,5656,20734,31136,-32322,-10372,26935,-14976,-13319,-23293,15302,-700,22108,-14122,-17358,-23871,-25006,-16532,-25578,29804,13104,-21525,14574,-12419,-4493,30193,16392,-5279,30291,-5040,18528,23555,-23857,31610,-998,16179,7431,-17887,25253,12563,-9843,-9557,-2480,11186,-30060,-23363,-9447,596,-9485,-15373,-22029,10987,-27162,2797,23830,28179,23920,-6590,6737,-4486,12318,29286,-24144,21109,-20790,4479,-20740,-26051,3447,11292,-26625,792,12199,4212,17081,11796,26101,12319,-67,-10393,1798,17691,29000,-19408,4016,-13002,-3476,-491,-18140,10430,-8096,11124,796,28273,13714,28647,-8046,4183,10420,22030,-11020,16831,14529,-294,10166,-427,17147,-4495,20189,1271,24631,-23170,-6144,-14090,-12629,31234,24784,-20122,-14886,-7318,15898,15338,-9664,2834,-9699,-517,9887,-15102,27277,-14520,-6729,15587,13720,106,-649,-30667,-2453,26425,-5656,8931,-17785,18439,27175,10955,-16476,21593,-11527,-9677,-4489,-6978,5278,24857,-2485,10036,-23458,10924,28805,5133,22700,-1764,3346,-9863,-16196,7743,-6359,-22383,-10419,-1721,-31439,1469,4142,4754,-28241,3872,17718,17249,23635,-17474,6795,-14306,-16933,31727,27885,7538,6047,9947,-11671,-30685,-14048,-13561,13885,2568,20006,-21759,3989,-8061,-21891,29660,-32640,29211,30304,-26271,10543,-924,-29835,-23147,30040,-21203,17578,16165,3931,4530,-1337,-27145,-10373,-8853,31302,3956,-2457,-27101,-12221,17704,-29198,-32209,27684,11521,3681,5820,19688,-10354,19472,11630,29535,4162,-813,-15608,4033,15144,6900,15925,8692,6769,16352,-23542,20166,-18483,-1192,-7123,-24278,13994,-32246,20244,29699,-27142,1815,22408,10046,-23196,1228,-3984,-24581,22578,30654,-3731,-8962,6971,-22678,19753,11078,-11132,3390,11738,936,424,-6161,-18243,29917,-15911,11613,-11767,10903,-27928,-8170,-22906,-21201,-17910,-1567,-3779,-19208,-6749,-27254,5019,-12068,-30000,25543,8763,-18008,-3613,21304,418,-32689,19198,-17802,-32123,23922,7161,-21263,-31249,-31273,-31382,-8514,-17393,12887,32634,26419,7563,-18666,25695,531,18999,-27344,-31529,-25560,1603,28117,9290,-657,11252,24279,-31513,31352,-3331,-27862,29133,23287,20450,29213,20746,-2956,-13384,-6965,17212,32069,-28797,22325,8224,-32010,-11735,8549,12579,20012,6973,9915,13064,-2202,-18675,1860,-1802,23408,25639,-21029,2310,-2094,-8704,-32030,-15522,-14055,-17781,-2883,-21228,10943},
  {27161,11120,-28767,-6136,2526,-29632,10453,29763,-8156,13433,-19088,-15172,-8174,-8761,-30101,7244,-30788,-4336,25141,-3532,24725,-29625,7793,-14399,-31300,-11269,-6721,-22404,-14310,-14758,-1476,-739,14930,21740,-11585,-6336,28130,-5725,-25302,21181,-30309,-12400,-29768,-31543,30985,7075,-27105,-21062,-12366,-22888,21228,-878,6990,-24029,-32121,-26637,-13551,31204,-1738,32708,-13309,-17240,-5838,-20376,3062,2859,-25395,-32439,17664,30986,21166,-22066,20842,-17334,-26564,23150,-18912,-17928,-25117,-22050,26861,-1980,23947,9579,4455,24545,26147,26608,16028,5023,-15120,-22279,5689,-21240,-9163,14765,22542,-16370,6771,-25886,-6948,30831,15437,799,-16826,20530,-1884,8267,24684,-9566,4073,-23056,-1385,7594,-13352,-2358,1134,-4837,15084,24170,2898,-19385,20457,1619,-24442,-6822,1431,30347,5939,-22427,14895,-26153,-963,32076,-8983,-30938,-16278,28923,-17496,32403,-25600,22351,23039,13280,-31876,-30853,12336,-10084,-28114,15565,26895,-14720,14315,6380,-28459,-14531,-18131,9844,19031,9109,27153,11662,-1491,21293,-25548,-11655,-23031,-14844,-12355,-17896,17522,-32557,28187,19962,-10601,1704,-27811,-27705,-8070,10937,-20767,26924,20987,-21396,16415,-25620,-6350,9899,-6262,25970,25916,-20109,3497,-24166,23965,-21481,32150,-9736,-7585,32726,-13827,25099,-3146,-5347,-25890,29623,-1384,-21776,-5256,-16253,-28656,30137,11139,16674,-4122,-24517,-22614,30392,-23981,3935,-30543,2710,8545,10820,-26408,-8588,20407,-12286,-3853,-15917,4427,-27734,17171,-9913,14089,15807,24251,26725,12189,28785,8047,-16320,-17160,-26374,-21679,26887,-23634,13806,-28926,29235,-30644,10873,-17177,-20330,-13966,-6190,13246,14069,-25046,21448,27252,-5060,17494,-12749,-4546,-30381,25573,7553,32461,-30269,5999,14264,-7314,24746,2252,11058,7387,16645,-24250,-6437,-10523,-12973,30650,4723,-31989,-679,13877,21661,30550,13037,-19419,-12264,29831,-20098,15619,16160,-1432,20092,8120,18209,-20578,17540,-6926,26903,-6927,12508,14490,9382,-14418,13733,-28419,13211,-10534,-23514,-4646,-16410,12293,2531,23880,8390,4145,-16270,-12444,3318,-11738,-29207,5745,5976,-24156,-1140,13096,-28567,-22057,217,-296,24942,18355,-2125,-32077,30756,-24899,26607,-12330,21746,-18702,-7168,13762,29962,-9736,-8204,32343,15690,25897,-7046,-2240,-4486,6291,-11597,1995,-19815,-4459,-21536,4991,-19015,15167,29752,-1261,23860,7691,-13358,4850,-3867,9458,-4148,1671,29286,15111,-26532,18508,16242,-13572,-21190,-1877,22711,-30754,-5029,-14464,8763,-12340,-10257,-30437,20756,-26108,16963,-15732,2212,11477,-4648,-25506,-12568,27034,-19606,27825,-21047,-8996,-7712,20421,20534,-29663,-1718,-18763,7598,13248,-1085,-23967,7995,-24455,-13331,-8583,-3876,5840,28619,14266,20748,-21297,-20420,-17533,-1530,8246,-9852,26210,-26913,-18121,4267,1417,-7331,-6935,-10664,-30485,3403,32110,-9545,3009,-22356,-24433,30131,-25380,28630,24319,21031,-1092,999,17818,31939,-13746,-29248,-20388,14197,-13153,21886,-20559,-4187,-18406,21369,-14554,-6151,-6895,16319,-10098,-22684,-19346,-25894,13243,17169,27593,7241,6336,-18845,26380,3994,11255,9606,-14092,-4081,10817,-18758,7760,7974,-29644,6567,-29715,-9397,19786,9645,1602,-11325,-9016,-18023,-29111,-11528,14586,-21848,-4366,14227,18933,-16468,19011,-29364,10901,-24297,-25810,13902,-111,23772,-15282,-10725,25698,1742,-16161,-7244,7800,-16234,14566,-1403,20237,21063,4769,-13022,-11248,-13092,178,-20889,-28827,-30198,-24714,-11547,-14705,-130,11717,5202,7293,-16662,3774,-26495,-9,32667,-28651,4948,-32466,-29688,-1179,30966,-27632,-10558,-21378,26053,3912,-20924,9821,-29766,28188,32480,30032,-8293,18716,27516,28458,7037,8285,15648,25779,14303,364,-2601,-19191,-24810,-2878,-57,4220,-17969,-20443,-21977,25962,15071,12381,-11824,30364,-4110,-17485,10467,31964,-30003,-27985,15745,29252,-17013,6670,11016,-27383,-3497,-29873,10179,19775,30001,27869,-27277,7757,30269,-29846,-26275,-19680,-15044,19635,2340,10242,-32366,-7684,-30434,-2642,7958,-32761,11558,-12793,-30441,-27976,-8473,327,14473,-8305,-5603,15252,3518,5464,7068,15404,-27174,-13330,28893,-20972,-11940,-22627,16970,-19993,-13095,13203,-27328,-28769,32401,15044,6116,14544,-20801,6096,-7744,5375,26157,-13788,11215,-2381,-22391,730,22747,-1877,-13918,31522,-29028,15807,11391,5372,29719,-13814,-30296,-3882,-30002,-10693,-25927,16776,-32371,-24603,11571,22760,10634,-14526,8477,-32120,-21483,9504,24808,-29415,-6821,-14160,-17070,-10860,-3027,-31251,29457,25779,-29980,13452,10371,-10935,20517,-21281,27670,11155,-18070,-6379,-16185,-24089,3045,-32383,25915,23285,-14023,25321,21040,-18257,2148,11652,-18576,30403,-11026,-3771,-18015,-21393,-29961,-24503,-9609,4951,31464,-26796,429,-26787,-26758,-22516,-23749,12074,28928,4605,5138,28533,31967,-375,-13662,-10463,-6203,1346,-21787,2883,-6888,-14964,14022,14012,-32303,28159,15007,-32150,9356,20821,3448,-2000,-30582,7947,26219,-8633,-6401,-15720,-15877,-21579,6000,15663,-25806,-21216,-7090,-16968,9177,-3877,8077,32337,-9541,4765,-7181,-28968,-25516,4958,-14988,24785,12567,-18031,13691,7793,-4638,-5879,-2466,10095,11288,3098,23390,18067,-17976,24892,30955,-28104,-2511,-11314,5284,31690,1114,25410,-23405,-16357,-19559,20014,29369,4861,10270,-15170,-4550,-21441,-13146,-17171,21280,6155,-7138,-3037,-1662,40,15743,-16378,319,23408,-32241,-24548,14419,-22726,-13295,7662,-14640,-8697,5105,23465,-7341,-18518,18202,3248,-8785,32634,-26753,-12709,17718,30950,-182,-18728,28302,-21641,-14295,-23617,-26102,3161,-22632,-23470,-10141,344,-14424,27304,-2482,-27351,15504,-4865,9149,6717,-6178,20873,-2851,-7819,-31497,4763,-27130,-7508,16427,-25583,-21118,-11520,-11769,-8542,-22594,18666,-19713,16263,12810,-13013,-19181,-17668,186,-17868,-31637,-10874,14333,-10944,-26976,9504,-18728,13748,-17419,23318,30341,11979,-28186,4296,-6134,-2541,-30764,-9795,-13984,-499,-18437,12467,-22716,-9539,2472,17690,522,-678,-17606,22766,1646,25260,559,20656,-7534,13174,10207,-19110,-2635,12581,25140,16818,-20266,29237,26532,-24254,-31752,-17287,-16748,-9725,-31571,29971,22642,-13958,-10269,20448,-13687,-6407,-14663,-31208,11519,-16048,26646,-12681,-18350,-8228,13624,-2906,-19108,-27339,24587,30966,-32580,22531,26757,24650,10421,6499,-22091,-28885,-22429,21734,-23522,-22540,8457,-4718,2555,-3713,8579,-1564,-24616,-27256,-4499,-13275,28749,-32712,-9927,-22112,-27107,26956,-9665,-16039,-1628,1797,-5841,9206,17974,8317,-8955,14198,-4256,-27965,-443,6432,5342,30050,29791,-9834,-26914,2638,29495,11915,18427,6808,32537,26750,13836,25409,-6945,2867,-16825,-8661,3819,-3922,9839,-11967,14576,-10008,22380,20274,-25758,-25366,-15440,-8765,14338,25022,-9011,1305,2447,21221,9731,21342,-26608,21320,1759,29986,613,-7146,-27193,2397,10627,20039,-4336,-17922,18582,-13386,25123,8326,32515,27004,6832,23569,12915,8984,29363,10764,32489,10840,26893,-3006,-30693,-8599,-9958,20601,-13858,1210,-4166,1173,31160,-3937,-29227,13257,-30488,-4538,-11568,-17164,-23149,13790,-18331,-27165,22304,-14291,-17451,-12022,24384,-16422,25008,-3653,-5291,1686,-548,-22635,-2652,-32629,-28978,-14056,590,-6931,-14059,15444,4626,20686,-23493,-735,2519,-12764,-6788,-29575,19322,-12591,-19431,-4409,-31542,-1523,18735,-22505,12015,10335,194,3386,-30991,2472,-9660,9494,-9590,-1422,-8255,-2095,20715,20282,26198,17328,-6327,-13423,26863,-20615,-9267,-30055,20933,-23009,-230,-23579,-6111,17877,-4132,-32009,2179,-4569,28895,23688,30577,-20022,-15408,12523,-25939,3248,-10251,-19075,30610,-24686,-23623,-31503,-23967,30724,12586,3504,22916,-24237,-164,-5690,3960,-29389,4061,7361,-27530,16565,9396,8726,9779,17239,1129,-20344,29787,32688,11233,32061,-2328,11306,-18714,8443,30164,30094,-8477,26059,357,17687,374,26178,6765,19101,11582,19325,29122,28665,24021,-15757,-804,-10356,-18329,6632,5251,24876,-15565,-23066,-16698,-18109,-30384,-15540,-31802,1046,13698,16882,-31370,15506,8013,3010,20652,-12068,3795,-13704,-11281,29921,6912,21075,26489,-7979,20349,16257,7346,-3560,-962,-30445,128,1512,-26314,-29563,27268,-7836,-28936,-18774,-9933,-13409,-10096,16387,-4243,-15222,226,-19306,21472,-26199,10433,-25968},
  {-12953,18427,-30830,-30181,-9482,1835,10337,-13080,32200,24918,20473,-11641,-1974,29497,12325,19531,11321,16889,28650,-32588,32059,21853,32483,-21244,-29834,9508,16385,-11721,-31260,-17749,-29619,-9761,-7736,-4616,26331,-4965,22934,2669,-11643,8517,-26812,-9541,3764,437,7801,-28813,2470,-24425,7722,10538,-29768,-25994,-16521,-28701,-5055,6002,23367,-24778,-14476,-296,-11448,6250,17433,14167,14757,16798,31787,18419,-22029,-31633,-25292,29387,-20144,28615,4411,-21209,-5903,-32047,26325,-8310,-10910,12420,3241,12941,-24028,6775,-21135,-5034,1787,27457,-19528,-11517,3144,-17156,-15601,9276,-12308,30601,-3933,1042,-4757,-8462,1785,-2751,32173,19501,32398,10614,-12109,21866,14962,24624,-20045,7468,-67,-1518,-25349,23960,-19442,18568,-4224,-792,25271,-362,22888,12783,-27944,7987,-2517,-19912,-30295,-10388,9248,5338,10855,-2953,404,-24670,-15723,-19173,-23760,-28117,-25342,-1721,22748,10626,-10077,-3635,6670,3219,-19887,25154,-18532,-19102,-29059,-28810,-14339,13222,-2496,17086,-10612,-22780,-19214,1775,-5611,32734,-1890,55,-8092,-3894,-26049,-2553,19577,-31665,22041,7261,27572,-8650,5829,26235,8305,-22665,29211,28940,29371,-14528,27060,-29800,-16272,-27481,12299,-20343,10155,-28671,-21840,-822,-17068,-19355,31810,13572,1994,5245,-31713,-18412,-20427,23108,6862,16485,-32359,-16746,1340,156,29564,-32650,-25218,-12793,-9499,31071,-3283,-24711,29717,-32276,21078,-31453,-8445,18692,-4742,29939,-1151,24269,-20108,9317,-19862,-8378,17487,5531,20989,-28743,-8386,13540,12447,16007,31378,-15223,26841,-11949,27569,30916,10196,28164,31275,5901,-24961,-12093,5690,-1003,15295,-8585,8947,-4331,-6819,-23697,1223,-13170,-29783,3933,22941,19206,22371,20619,-3117,-23814,-31231,-21556,10095,-17725,19083,-27739,5008,32675,-16850,-3738,-28958,-6431,-3657,7431,-1557,-5957,28193,-871,19613,-16110,-16863,15699,-24874,-30099,30689,4446,-3310,-11602,-26528,7091,-8496,-14981,-18395,-24723,13327,7606,27,14807,10050,-25378,-24467,23856,1813,-14900,-9463,12573,-19790,-14031,21036,-18826,1367,20144,-9104,8788,11346,-18128,-2152,-30869,15107,11045,4551,30170,905,-18169,-11415,24550,7312,-23488,-16389,20922,25604,16728,8779,-18713,-8010,21681,19428,14014,28125,31279,-16505,23188,-23312,269,5255,-22158,-986,-5772,-23416,9326,15399,27842,32593,-28336,-28843,-26069,-4061,-16042,-30038,18902,-25269,5620,12993,-21342,-30332,-23608,14679,31244,-21999,-20438,-27318,1917,31157,2791,-5044,-14202,30539,12812,-32579,2201,30434,1206,15860,27971,-4058,5166,-32512,26677,-31545,-13522,13463,9106,-22393,13031,-11791,28697,-14117,4816,-8,30600,-7881,-27801,3779,25400,-19314,-9669,-21221,-26466,-28689,12525,-26305,-23655,32308,-10312,-23880,11831,-7402,26574,-3257,-2572,-3254,-18704,18083,14837,-6000,30494,18676,-4276,7849,-28474,-10194,26231,-11918,16480,32526,1365,-24865,17806,-6159,-16646,977,-29602,26611,4659,-22974,19897,21235,-30033,13040,-7881,11999,-5203,-30924,-28382,13130,11191,-17201,-5288,2026,-21016,-25049,-15870,26170,-22747,2648,-2845,-32182,29467,-2174,-210,17897,-22106,-27711,-30544,-5934,-31462,30077,21136,11059,27206,-9885,-2171,-10616,-7373,-1457,-28697,24172,11752,32021,22750,21686,29705,-6672,-17911,28418,14404,18717,32263,27152,-15460,-4306,31843,11329,20460,3991,-29413,-23774,-2417,21555,11990,-5808,-18385,17861,16751,24967,-25896,31463,1476,3891,-12968,-11775,-26678,15332,11866,-32139,8564,25470,-17284,30571,-18765,-21693,-8532,-18601,-4961,-2265,-1918,4872,15483,-12379,29969,7093,-28542,-3626,14624,6464,4641,7824,21622,-11611,15389,5142,705,-18245,-13944,26812,27677,-32711,15863,-20927,-1526,-30693,5324,-2990,-23403,-12497,27738,-23120,21716,-22350,-4913,32273,901,15597,-31678,12284,-15316,-27692,-32036,2226,-19700,-24279,24267,30924,-30248,-29672,-30625,5356,-3296,26899,-22989,4626,29216,-9514,32447,14641,-30922,28214,14814,16732,-28554,-14259,28235,-3990,-8780,-19188,-30981,4427,-3325,-13728,22187,-12894,22378,24524,-20067,20952,-9998,-21297,-22633,4193,16046,3426,27541,13862,15783,-7894,-21074,-6408,-32719,-12711,10936,-25245,9834,2470,-351,-2731,1330,-5290,-30929,452,-25840,23155,910,-24579,20615,6263,7751,-13923,23211,10420,22944,-27838,11962,-1342,3623,-29057,-22531,25098,-10468,-5514,-14140,-26984,9579,-28307,28110,-1993,-21335,-14923,-8599,30386,16300,14195,-7339,1025,22787,28223,31631,-8186,-10677,-1568,-30118,-15438,-21126,-4121,12080,-10219,-22673,30237,-11529,-12319,-17199,1881,-14978,-22397,24899,13707,10925,31708,-12719,-27711,-28487,25586,-12310,-14838,680,-25530,19384,-18635,-20446,20739,-28589,19190,8291,25387,-25454,30600,16861,-4252,-27309,6623,22499,20223,5444,-24892,20081,16736,30577,-25769,-10146,-486,24483,-15210,24862,31054,6985,8803,11184,9394,10985,24531,20676,-31565,28785,-25006,-32487,-31697,-5857,31754,23544,-12051,-11018,-7852,21839,8508,14361,15826,-16402,7416,28446,-32166,-27983,-11551,-28248,19127,6879,-9035,25521,24265,-29041,25193,29098,9555,17207,-742,-24196,21832,-10115,-6798,17697,-4413,27568,18069,16645,-21784,22748,8360,6626,-30973,-7043,-8602,22949,-9020,-364,22928,30461,3825,-18092,16784,19789,21927,-18979,-30957,19263,32618,14323,-26426,-6018,6787,9988,-1286,-711,395,-24371,-28162,-27219,-25709,-20219,-32716,-613,-13012,23090,30630,16919,-17954,-31158,-8376,-27043,26544,23232,-25608,24675,21232,-18407,-24578,-25980,-3101,3342,28850,-249,-1817,30290,6234,14646,-15329,32122,15237,4787,-4096,-8151,-10376,22541,-31909,-20118,30241,-21283,-882,-11250,7274,19307,25249,-17001,-618,4587,-29435,-17341,-4991,29919,-18903,12899,3987,11622,-14787,-14401,32510,19207,-23910,-11538,-24232,-13273,29022,5341,2443,3704,6511,5041,20984,-14850,29534,-16645,-29108,12862,-32486,11670,-20635,-32671,-20728,4917,-118,11844,-2248,-30512,9014,17324,957,5904,-29826,-15662,10969,2922,-20828,-29616,10079,10646,-16132,23924,21098,11715,24258,27842,18046,1590,-6532,-31692,-3850,-25965,-18685,15341,-11437,5336,4033,26898,30304,-2115,13950,3345,-24572,32044,-17692,-14411,-10013,-3504,8230,2886,-3487,9517,-7464,-8537,-24292,9365,20145,-14645,3768,-14520,9092,-9512,18015,-13136,-11292,5524,16630,-16178,23771,-12536,-4725,29143,2075,46,13585,28510,-2508,-16612,-23097,-26957,2628,9631,16719,25668,-10237,15593,-9034,25678,-15408,-7591,30092,-12669,-3604,-5222,28786,26350,14105,19220,-1091,17990,-31903,11809,5524,28898,-2680,-12649,28792,-7997,31547,17307,-22251,-29026,5864,-30980,6094,22514,615,-8782,-4436,-14224,-18304,-26194,-12840,2922,12663,-16680,8403,7958,5014,-27823,-31344,7439,30482,26627,21807,23172,19603,1303,23403,2960,-12863,-373,23166,-6387,-2479,22555,20130,-31013,13090,13125,1102,-23860,13085,-32241,-1578,4938,19602,-27213,-27496,-26756,-27283,-6942,25906,7333,-6190,-28175,-2913,-777,7766,18986,9859,23266,32151,-3261,-13347,22526,19534,22972,2503,5076,22648,-27021,-24726,17325,-5332,11758,-30605,2956,30936,-19694,-30650,4715,18489,3533,20374,4007,-16880,3314,31972,13266,-31449,128,-29796,-32209,5,-29948,24908,-20831,22553,-32223,-20981,-27150,-3458,-20595,26171,18597,31197,-1649,25929,15043,20576,-3154,7163,-26987,-29340,-15403,-24904,-13283,29175,-12604,-8880,13665,12210,24937,-20774,22291,-17556,4724,-5963,8878,23004,9709,23640,-29136,-23891,-11855,17590,12870,-12455,2880,-3020,12153,-25763,3687,-11425,32209,28052,-11514,8660,-26457,1543,23302,-16601,-22043,15400,29553,-29313,-8972,14889,28675,-22155,26199,-3879,13771,-12655,19554,10809,24285,-23031,3177,18834,-5211,-2906,-7567,22978,26745,12356,3051,16609,25293,-2100,12603,-2491,27308,17870,1225,3455,29706,-16207,10719,3734,-11337,-26538,-20405,-28513,-3378,15823,13306,-7536,24851,24094,-26521,-6980,-19024,-16592,-21929,27706,32489,21497,-22556,-21914,-17628,19693,13620,-23160,-2536,-28700,-7817,-27993,8972,23563,9363,15303,31582,12434,12576,18799,29124,-712,31585,-4476,-12119,-27303,-19957,16979,-31782,-30411,1268,-23391,28422,28869,26033,13438,11388,26024,-8278,20550,12803,-19145,-19278,24854,13556,1465,-18059,30098,-28338,-23239,-21211,13678,12544,-15442,27669,-11752},
  {-31846,-10988,9895,-3746,-23039,-26359,-25871,-11925,3574,19547,-31827,1213,25593,3831,-12663,7375,-32666,-5091,-9238,20886,32506,-3564,9249,-28261,18958,23967,-15186,-6782,28962,10429,-12614,11547,24373,22048,8799,14396,19340,-29129,-7566,16153,15926,-26972,20455,-32679,10344,18711,21487,-23875,-4914,-3866,23107,-7698,12039,7042,26870,443,11647,18967,19376,-20413,21574,12347,-2616,25145,-26388,25320,-29959,25612,25515,5833,4737,2339,13933,-6603,7890,-8429,20927,13260,21539,17292,18807,28656,-9300,-23565,-589,-5235,1055,29546,-27987,-17166,11619,14676,-32458,-4764,-30100,15553,14683,27404,-53,-20577,-2218,633,26512,2566,-13081,-1714,-15879,13199,-18971,29700,-26214,10939,-82,-15595,-22530,-26847,9595,-24833,9418,-5552,20695,-18129,-21532,-31925,-21508,22240,-15664,-21801,8512,19233,-14884,-13785,6684,-23841,-14067,13431,-174,-19984,26342,15515,31395,-29744,-479,-22779,-1390,-2692,26526,-18850,-22387,23105,8096,-25902,-11093,9704,-30280,24615,27626,18886,-515,-5778,-16906,26173,26760,-22046,-29795,-31678,4652,26423,31429,16454,-22774,24603,16025,6453,-28955,26097,29063,4218,-3039,-13878,-3100,-2826,-5185,-27585,-6601,2056,29878,-1924,17144,27865,-8859,4833,11898,-7346,-22599,-2694,6457,15415,31616,-32707,-391,20128,-25298,-16172,-17402,15834,6628,7592,9058,10101,-12450,-18066,-4385,-2618,-23313,-7248,-13546,-18761,7966,-29856,-6662,14503,-11672,-19075,9852,-21498,26690,-13286,-2525,-2443,-27687,-18957,-1214,2211,-28769,-22433,-21408,27913,-23509,13550,-29013,15194,3532,-16427,-20507,-9091,4133,9864,1470,31815,-29689,-25664,-15372,14374,7640,-17829,25777,-29829,30432,27701,-6788,9846,22365,-10610,-5697,-12232,-5993,27165,-23091,25232,-12351,-27561,9011,9286,-18525,24879,-25147,-18639,-1491,4177,-4632,-12115,-21825,25810,27984,-12177,14948,21813,23072,-15683,7612,7213,-20628,-9258,-28789,-15695,-11649,-5961,-16579,11173,12520,-22184,14018,1402,-6033,31838,-12663,16677,-1422,15431,31906,-14268,29085,29918,31305,-18918,-15677,21109,24304,-27762,12690,26572,-13899,-6496,15645,31571,21415,21071,18116,28794,5413,21277,-9545,2258,-15552,-1688,-2968,13551,-32067,28962,-4764,13567,-9375,14913,12409,-12303,2706,6854,-27079,-6872,-11696,18387,15763,26160,27302,809,-26441,-17108,19034,14022,-9648,-18108,-32738,17385,3830,22702,27322,-1050,-14346,-19331,12532,1018,15885,30105,20896,32516,-16160,-23983,23147,5977,18084,5989,-16402,20353,-4878,4025,-7630,-9860,15918,-25319,-22791,-25664,16674,19742,-28640,20817,29715,-18333,-13719,-28249,-12566,-16763,3425,-17009,8254,-11216,27981,-6294,-21043,32202,11134,-24358,-10004,-13228,17788,-2079,-30090,5939,-5202,9355,23098,7014,27965,-32697,-645,-27435,27057,-13730,-18247,13972,12036,26266,13216,18570,2901,-27374,-25409,-22983,11889,-26997,-27443,18104,-2084,-13055,-20278,24416,9870,18873,1316,10770,-13880,-4028,-5203,8424,-1240,26162,-23719,-19094,-27552,21889,4238,-20554,3401,30689,17456,18486,-26088,-29820,15553,19124,9273,-22044,29994,17108,21222,27940,-3260,-30513,25874,23245,11781,-5639,25910,-16698,-271,30290,-7386,-23225,31666,-11383,12282,-12963,-11401,-2565,8202,-18061,-6661,6809,-20914,29675,26062,-10155,-21264,2325,-20583,30557,13957,13539,5941,-1792,-15335,8654,-22363,-25356,23500,-17510,-154,-8261,22751,-31615,26981,-7936,-1443,-19878,-13204,-5644,15448,25815,-24973,1119,5735,8138,19570,20484,24163,25432,1708,-8345,-11537,3839,8074,-24898,26136,31215,-32551,18497,27807,31005,26410,-26673,23819,9834,-26306,-2120,32222,13505,11508,-6239,1216,-21344,20261,29481,-26225,-32683,11629,-24657,-27317,8953,-8917,3612,11519,-29889,9662,10989,4252,-2126,3186,-11822,-31506,19643,14382,-6177,-10171,32047,1970,27236,-28626,-499,-23877,-10530,14454,5759,32447,-1365,16072,-21135,-5945,22535,-24758,-9262,6950,12867,632,30430,13594,-19693,25495,-20425,17250,23112,28356,-22338,16161,-12108,18183,4354,14168,24112,-25288,-20229,24410,-13841,-11597,-10401,18962,32406,-12998,32177,17314,-29321,1801,-11536,9129,-26641,21864,-31838,-9035,9616,-27893,27491,18268,28872,-11703,-21970,18650,24006,-8813,-23548,8327,-19598,-17445,-12728,18275,19660,-31660,6355,1653,-22360,-6625,16814,30834,16050,19098,-13299,17081,27144,15263,28166,-13601,9230,-13145,11673,-5174,-27998,1621,-14388,6354,24690,-28486,-20018,-25579,-1216,-25507,20038,24043,-29174,-12411,13908,-5685,-17345,21130,-3866,31627,-12200,32388,-8679,12084,30008,-16745,-9810,-25247,32471,24236,28197,-5406,-950,7905,1605,-14409,-8480,8385,21855,-9891,-5548,25478,7115,-18551,6637,16910,26214,-22515,-5928,-7211,-18200,-8992,7119,-22246,6982,32202,20336,30848,-19731,207,-7273,2680,-14856,253,-17955,31472,-26453,-21539,-12427,12191,-20229,-17091,-659,-16886,28832,29152,17686,-28832,7495,10777,22622,28053,-27138,27465,-11698,19384,-21052,-25415,-8394,22261,-5487,7317,22092,18295,26769,28744,-31191,4127,31515,-694,-26574,-3186,-22503,-16822,-29228,16020,-22228,-4830,8249,-4907,-6446,-12334,3524,-31538,9489,-5355,9386,-8679,27216,-25501,4178,18993,11994,29263,21315,-20660,27823,31107,4913,28511,8469,-5653,27738,-29541,-32237,-30055,-25443,-12825,-1635,28806,-22866,-20347,-31663,-22588,23521,19959,14578,11778,-8258,-15716,4568,15046,-12878,-26261,-27321,20566,-28523,-11814,-27738,-28013,-9035,-16342,-11163,-29460,28829,-30101,6369,-13990,-13039,29508,19550,-12596,-30152,-18087,-1900,135,8114,14274,19266,-21318,18692,12379,-235,28943,3806,30494,-2010,-19867,5268,12068,12494,19693,-23804,32550,-11676,30520,19838,-32737,-10517,-3244,4133,7353,-20928,-26943,30573,27876,4968,-28604,-29391,32581,20864,-32614,-26072,-16710,-7556,15311,-4589,-22512,16662,-20063,29569,-12284,25763,10933,3385,5999,-24272,7493,29386,-4417,-2131,15850,27740,-28328,-6173,30753,-21033,-8368,2499,-32075,6407,892,8825,-233,18984,9993,5730,-13178,-7269,-28458,-24134,18901,-26033,27497,31065,13626,16132,27936,25078,-1553,15378,-22782,4568,27307,-15898,-7579,14566,-22236,29506,-8987,-10121,3689,-26412,-22602,1605,5715,12130,12055,20860,-5884,-32042,18835,23692,18741,2730,-23579,31298,-32284,349,-14655,4571,13893,8384,3817,-6747,-26463,22155,-26799,-1480,-11205,-30075,18255,8757,18893,-20026,-14772,-18303,25099,11711,-24600,-22004,30740,22589,25538,16384,31196,-1163,15694,-3889,28228,-7175,-3920,30774,-7108,-2353,1087,16058,-13191,-7856,24565,-1822,-19507,-8108,-11709,-4266,1042,-19224,-14291,9962,22737,31650,12717,-707,-15237,-18172,9665,-9315,-22367,13462,17270,9150,-6219,-16841,-32746,-16448,-6988,-4999,5474,-6515,-22059,-2477,29308,1986,-7490,-31621,22027,-10096,5266,3174,-10323,-30592,18927,-56,27255,7833,15494,18759,-10098,-14287,25523,19233,25404,5670,-31380,-20581,26639,22158,-13322,23063,-17917,-18621,28517,23177,-4642,15501,-32685,-1911,1371,9139,6193,28049,-14374,-8952,3201,-31571,-10401,25329,30877,25904,-2168,-14463,25408,27756,4211,-23681,-19369,15952,9412,-20126,14130,11960,26829,-3097,27329,8443,-8713,18192,28808,8634,18809,25154,22510,4043,-29107,-27594,14575,27098,249,1183,27610,12412,-30131,26485,2735,-30212,17481,-25753,17160,601,4161,25154,-31025,987,-10923,18701,-19638,-26705,-18165,-26995,22787,-7120,-28298,-6147,-19515,18963,-15651,-27907,10851,1281,-21611,-8327,19526,-31641,22540,-23696,5405,22324,8536,11040,-31698,-26383,-135,-17670,6924,-9295,-25373,19273,-18949,4757,23605,-28198,-19307,-30332,-28951,15934,-2985,13663,25459,13886,-13983,2361,-25577,29575,7907,12862,-30177,26671,22600,-3485,15161,8984,-12562,21401,27669,13967,8013,14147,29222,-5327,17978,15185,24747,-29105,-25103,25286,-1361,29677,-26813,25047,-1653,9591,-26766,-24217,-19809,-16662,-31429,13094,-20852,15158,21372,18954,-1148,-23284,-25608,8533,14062,-21588,-14445,28955,16645,-26979,10632,-21000,-19633,-8844,11106,-22606,-7784,-4070,31721,13056,-32132,13020,-18906,-23213,-14101,26495,15336,22592,-21521,2936,15961,32446,-20364,-4017,-12846,-16121,-4582,32457,-4885,14554,-13803,6837,12099,2719,-29502,9386,30253,-21295,4250,-14458,16822,18524,15561,12471,13546,9969,-23137,-18700,-31662,22313,-26929,32579,-4462},
} ;

static void test_encode_1277x2627round_impl(long long impl)
{
  unsigned char *s = test_encode_1277x2627round_s;
  unsigned char *x = test_encode_1277x2627round_x;
  unsigned char *s2 = test_encode_1277x2627round_s2;
  unsigned char *x2 = test_encode_1277x2627round_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_1277x2627round_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_1277x2627round(impl);
    printf("encode_1277x2627round %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1277x2627round_implementation(impl),ntruprime_dispatch_encode_1277x2627round_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_1277x2627round;
    printf("encode_1277x2627round selected implementation %s compiler %s\n",ntruprime_encode_1277x2627round_implementation(),ntruprime_encode_1277x2627round_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_1277x2627round_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_1277x2627round_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_1277x2627round_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_1277x2627round_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_1277x2627round_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_1277x2627round_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_1277x2627round(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1277x2627round")) return;
  storage_encode_1277x2627round_s = callocplus(crypto_encode_STRBYTES);
  test_encode_1277x2627round_s = aligned(storage_encode_1277x2627round_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_1277x2627round_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_1277x2627round_x = aligned(storage_encode_1277x2627round_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_1277x2627round_s2 = callocplus(maxalloc);
  test_encode_1277x2627round_s2 = aligned(storage_encode_1277x2627round_s2,crypto_encode_STRBYTES);
  storage_encode_1277x2627round_x2 = callocplus(maxalloc);
  test_encode_1277x2627round_x2 = aligned(storage_encode_1277x2627round_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_1277x2627round offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_1277x2627round();++impl)
      forked(test_encode_1277x2627round_impl,impl);
    ++test_encode_1277x2627round_s;
    ++test_encode_1277x2627round_x;
    ++test_encode_1277x2627round_s2;
    ++test_encode_1277x2627round_x2;
  }
  free(storage_encode_1277x2627round_x2);
  free(storage_encode_1277x2627round_s2);
  free(storage_encode_1277x2627round_x);
  free(storage_encode_1277x2627round_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

