#ifndef BASETEST_H_
#define BASETEST_H_

#include <stdio.h>

class BaseTest
{
public:
	BaseTest();
	~BaseTest();
	
	/** abstract method. Every subClass needs to implement this */
	void executeTests();

protected:
	/** A test method needs to inform that his test is beggining. This is because we not using any reflection here */
	void startTest(char * testName);
	/** A test method needs to inform that his test finished  */
	void stopTest();
    /** Inform that the result of a test */
	short assert(short booleanClause, char * message);
	void fail(char * failMessage);

private:
    char * currentTestName;
    short currentStatus;
    time_t startTime;
    
};

#endif /*BASETEST_H_*/
