/*******************************************************************************/
/* Permission is hereby granted, free of charge, to any person or organization */
/* obtaining a copy of the software and accompanying documentation covered by  */
/* this license (the "Software") to use, reproduce, display, distribute,       */
/* execute, and transmit the Software, and to prepare derivative works of the  */
/* Software, and to permit third-parties to whom the Software is furnished to  */
/* do so, all subject to the following:                                        */
/*                                                                             */
/* The copyright notices in the Software and this entire statement, including  */
/* the above license grant, this restriction and the following disclaimer,     */
/* must be included in all copies of the Software, in whole or in part, and    */
/* all derivative works of the Software, unless such copies or derivative      */
/* works are solely in the form of machine-executable object code generated by */
/* a source language processor.                                                */
/*                                                                             */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR  */
/* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,    */
/* FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT   */
/* SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE   */
/* FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, */
/* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER */
/* DEALINGS IN THE SOFTWARE.                                                   */
/*******************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <inttypes.h>

#include "bitset.h"

#define NBITS (sizeof(int) * 8)

int
bitset_alloc(int **bitset, size_t size)
{
    size_t alloc_size = (size / 8) + ((size % 8) ? 1 : 0);
    if (posix_memalign((void**)bitset, sizeof(uint64_t), alloc_size) < 0 )
        return -1;
    memset(*bitset, 0, alloc_size);
    return 0;
}

int
bitset_insert(int *bitset, int i)
{
    bitset[i / NBITS] |= (1 << (i % NBITS));
    return 0;
}

int
bitset_delete(int *bitset, int i)
{
    bitset[i / NBITS] &= ~(1 << (i % NBITS));
    return 0;
}

bool
bitset_contains(int *bitset, int i)
{
    return bitset[i / NBITS] & (1 << (i % NBITS)) ? true : false;
}
