/* desktop-files-backend.c generated by valac 0.26.0, the Vala compiler
 * generated from desktop-files-backend.vala, do not modify */

/* 
    Copyright 2012 Julien Lavergne <gilir@ubuntu.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <stdio.h>
#include <glib/gstdio.h>


#define LXSESSION_TYPE_DB_DEFAULT_APPS (lxsession_db_default_apps_get_type ())
#define LXSESSION_DB_DEFAULT_APPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LXSESSION_TYPE_DB_DEFAULT_APPS, LxsessionDBDefaultApps))
#define LXSESSION_DB_DEFAULT_APPS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LXSESSION_TYPE_DB_DEFAULT_APPS, LxsessionDBDefaultAppsClass))
#define LXSESSION_IS_DB_DEFAULT_APPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LXSESSION_TYPE_DB_DEFAULT_APPS))
#define LXSESSION_IS_DB_DEFAULT_APPS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LXSESSION_TYPE_DB_DEFAULT_APPS))
#define LXSESSION_DB_DEFAULT_APPS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LXSESSION_TYPE_DB_DEFAULT_APPS, LxsessionDBDefaultAppsClass))

typedef struct _LxsessionDBDefaultApps LxsessionDBDefaultApps;
typedef struct _LxsessionDBDefaultAppsClass LxsessionDBDefaultAppsClass;
typedef struct _LxsessionDBDefaultAppsPrivate LxsessionDBDefaultAppsPrivate;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _LxsessionDbDefaultAppsListDesktopFilesData LxsessionDbDefaultAppsListDesktopFilesData;

struct _LxsessionDBDefaultApps {
	GObject parent_instance;
	LxsessionDBDefaultAppsPrivate * priv;
	GList* webbrowser_installed;
	GList* webbrowser_available;
	gchar* webbrowser_installed_blacklist;
	GList* email_installed;
	GList* email_available;
	gchar* email_installed_blacklist;
	GList* file_manager_installed;
	GList* file_manager_available;
	gchar* file_manager_blacklist;
	gchar* screensaver_blacklist;
	GList* screensaver_installed;
	GList* screensaver_available;
	gchar* composite_manager_blacklist;
	GList* composite_manager_installed;
	GList* composite_manager_available;
	gchar* desktop_manager_blacklist;
	GList* desktop_manager_installed;
	GList* desktop_manager_available;
	gchar* power_manager_blacklist;
	GList* power_manager_installed;
	GList* power_manager_available;
	gchar* polkit_blacklist;
	GList* polkit_installed;
	GList* polkit_available;
	gchar* im_blacklist;
	GList* im_installed;
	GList* im_available;
	gchar* widget_blacklist;
	GList* widget_installed;
	GList* widget_available;
	gchar* terminal_manager_blacklist;
	GList* terminal_manager_installed;
	GList* terminal_manager_available;
	gchar* audio_blacklist;
	GList* audio_installed;
	GList* audio_available;
	gchar* video_blacklist;
	GList* video_installed;
	GList* video_available;
	gchar* audio_video_blacklist;
	gchar* viewer_blacklist;
	GList* image_display_installed;
	GList* pdf_reader_installed;
	GList* image_display_available;
	GList* pdf_reader_available;
	gchar* text_editor_blacklist;
	GList* text_editor_installed;
	GList* text_editor_available;
	gchar* archive_blacklist;
	GList* archive_installed;
	GList* archive_available;
	gchar* spreadsheet_blacklist;
	GList* spreadsheet_installed;
	GList* spreadsheet_available;
	gchar* bittorent_blacklist;
	GList* bittorent_installed;
	GList* bittorent_available;
	gchar* document_blacklist;
	GList* document_installed;
	GList* document_available;
	gchar* burn_blacklist;
	GList* burn_installed;
	GList* burn_available;
	gchar* tasks_blacklist;
	GList* tasks_installed;
	GList* tasks_available;
	gboolean state_installed;
	gboolean state_available;
};

struct _LxsessionDBDefaultAppsClass {
	GObjectClass parent_class;
};

struct _LxsessionDBDefaultAppsPrivate {
	gchar** MimeFoldersInstalledGet;
	gint MimeFoldersInstalledGet_length1;
	gint _MimeFoldersInstalledGet_size_;
	gchar** MimeFoldersAvailableGet;
	gint MimeFoldersAvailableGet_length1;
	gint _MimeFoldersAvailableGet_size_;
	gchar* mode;
	GKeyFile* kf;
	gchar* config_path;
};

struct _LxsessionDbDefaultAppsListDesktopFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	LxsessionDBDefaultApps* self;
	gchar* path;
	gchar* mode;
	GFile* dir;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GKeyFile* kf;
	GKeyFile* _tmp2_;
	GFileEnumerator* e;
	GFile* _tmp3_;
	GFileEnumerator* _tmp4_;
	GList* files;
	GFileEnumerator* _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
	GList* _tmp8_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp9_;
	GFileInfo* info;
	gchar* desktop_path;
	const gchar* _tmp10_;
	GFileInfo* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GKeyFile* _tmp14_;
	const gchar* _tmp15_;
	gboolean _tmp16_;
	GKeyFile* _tmp17_;
	gboolean _tmp18_;
	GKeyFile* _tmp19_;
	const gchar* _tmp20_;
	GFileInfo* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	GError* err;
	GError* _vala1_err;
	GError* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	GError* _vala2_err;
	FILE* _tmp28_;
	GError* _tmp29_;
	const gchar* _tmp30_;
	GError * _inner_error_;
};


static gpointer lxsession_db_default_apps_parent_class = NULL;
extern LxsessionDBDefaultApps* lxsession_global_db;

GType lxsession_db_default_apps_get_type (void) G_GNUC_CONST;
#define LXSESSION_DB_DEFAULT_APPS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), LXSESSION_TYPE_DB_DEFAULT_APPS, LxsessionDBDefaultAppsPrivate))
enum  {
	LXSESSION_DB_DEFAULT_APPS_DUMMY_PROPERTY
};
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
LxsessionDBDefaultApps* lxsession_db_default_apps_new (const gchar* mode_argument);
LxsessionDBDefaultApps* lxsession_db_default_apps_construct (GType object_type, const gchar* mode_argument);
void lxsession_db_default_apps_init (LxsessionDBDefaultApps* self);
void lxsession_db_default_apps_on_finish_scanning_installed (LxsessionDBDefaultApps* self);
void lxsession_db_default_apps_print_values_installed (LxsessionDBDefaultApps* self);
void lxsession_db_default_apps_save_values_installed (LxsessionDBDefaultApps* self);
void lxsession_db_default_apps_on_finish_scanning_available (LxsessionDBDefaultApps* self);
void lxsession_db_default_apps_print_values_available (LxsessionDBDefaultApps* self);
void lxsession_db_default_apps_save_values_available (LxsessionDBDefaultApps* self);
void lxsession_db_default_apps_update_installed (LxsessionDBDefaultApps* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void lxsession_db_default_apps_list_desktop_files (LxsessionDBDefaultApps* self, const gchar* path, const gchar* mode, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void lxsession_db_default_apps_list_desktop_files_finish (LxsessionDBDefaultApps* self, GAsyncResult* _res_);
void lxsession_db_default_apps_update_available (LxsessionDBDefaultApps* self);
static gchar** _vala_array_dup2 (gchar** self, int length);
void lxsession_db_default_apps_update (LxsessionDBDefaultApps* self);
static void _lxsession_db_default_apps_on_finish_scanning_installed_lxsession_db_default_apps_finish_scanning_installed (LxsessionDBDefaultApps* _sender, gpointer self);
static void _lxsession_db_default_apps_on_finish_scanning_available_lxsession_db_default_apps_finish_scanning_available (LxsessionDBDefaultApps* _sender, gpointer self);
static void lxsession_db_default_apps_list_desktop_files_data_free (gpointer _data);
static gboolean lxsession_db_default_apps_list_desktop_files_co (LxsessionDbDefaultAppsListDesktopFilesData* _data_);
static void lxsession_db_default_apps_list_desktop_files_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void lxsession_db_default_apps_find_list (LxsessionDBDefaultApps* self, GKeyFile* kf, const gchar* desktop_path, const gchar* name, const gchar* mode);
gchar* lxsession_db_default_apps_create_entry (LxsessionDBDefaultApps* self, GKeyFile* kf, const gchar* desktop_path);
gchar* lxsession_db_default_apps_create_exec_string (LxsessionDBDefaultApps* self, GKeyFile* kf);
void lxsession_db_default_apps_keyfile_set_list_string (LxsessionDBDefaultApps* self, GKeyFile* kf, const gchar* categorie, const gchar* key1, GList* list);
void lxsession_db_default_apps_save_keyfile (LxsessionDBDefaultApps* self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void lxsession_db_default_apps_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


LxsessionDBDefaultApps* lxsession_db_default_apps_construct (GType object_type, const gchar* mode_argument) {
	LxsessionDBDefaultApps * self = NULL;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (mode_argument != NULL, NULL);
	self = (LxsessionDBDefaultApps*) g_object_new (object_type, NULL);
	lxsession_db_default_apps_init (self);
	_tmp0_ = mode_argument;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup ("display");
		_g_free0 (self->priv->mode);
		self->priv->mode = _tmp1_;
	} else {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = mode_argument;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (self->priv->mode);
		self->priv->mode = _tmp3_;
	}
	return self;
}


LxsessionDBDefaultApps* lxsession_db_default_apps_new (const gchar* mode_argument) {
	return lxsession_db_default_apps_construct (LXSESSION_TYPE_DB_DEFAULT_APPS, mode_argument);
}


void lxsession_db_default_apps_init (LxsessionDBDefaultApps* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	GKeyFile* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("lxde-x-www-browser.desktop;");
	_g_free0 (self->webbrowser_installed_blacklist);
	self->webbrowser_installed_blacklist = _tmp0_;
	_tmp1_ = g_strdup ("");
	_g_free0 (self->email_installed_blacklist);
	self->email_installed_blacklist = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->file_manager_blacklist);
	self->file_manager_blacklist = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->screensaver_blacklist);
	self->screensaver_blacklist = _tmp3_;
	_tmp4_ = g_strdup ("");
	_g_free0 (self->composite_manager_blacklist);
	self->composite_manager_blacklist = _tmp4_;
	_tmp5_ = g_strdup ("");
	_g_free0 (self->desktop_manager_blacklist);
	self->desktop_manager_blacklist = _tmp5_;
	_tmp6_ = g_strdup ("");
	_g_free0 (self->power_manager_blacklist);
	self->power_manager_blacklist = _tmp6_;
	_tmp7_ = g_strdup ("");
	_g_free0 (self->polkit_blacklist);
	self->polkit_blacklist = _tmp7_;
	_tmp8_ = g_strdup ("");
	_g_free0 (self->im_blacklist);
	self->im_blacklist = _tmp8_;
	_tmp9_ = g_strdup ("");
	_g_free0 (self->widget_blacklist);
	self->widget_blacklist = _tmp9_;
	_tmp10_ = g_strdup ("");
	_g_free0 (self->terminal_manager_blacklist);
	self->terminal_manager_blacklist = _tmp10_;
	_tmp11_ = g_strdup ("");
	_g_free0 (self->audio_blacklist);
	self->audio_blacklist = _tmp11_;
	_tmp12_ = g_strdup ("");
	_g_free0 (self->video_blacklist);
	self->video_blacklist = _tmp12_;
	_tmp13_ = g_strdup ("");
	_g_free0 (self->audio_video_blacklist);
	self->audio_video_blacklist = _tmp13_;
	_tmp14_ = g_strdup ("");
	_g_free0 (self->viewer_blacklist);
	self->viewer_blacklist = _tmp14_;
	_tmp15_ = g_strdup ("");
	_g_free0 (self->text_editor_blacklist);
	self->text_editor_blacklist = _tmp15_;
	_tmp16_ = g_strdup ("");
	_g_free0 (self->archive_blacklist);
	self->archive_blacklist = _tmp16_;
	_tmp17_ = g_strdup ("");
	_g_free0 (self->spreadsheet_blacklist);
	self->spreadsheet_blacklist = _tmp17_;
	_tmp18_ = g_strdup ("");
	_g_free0 (self->bittorent_blacklist);
	self->bittorent_blacklist = _tmp18_;
	_tmp19_ = g_strdup ("");
	_g_free0 (self->document_blacklist);
	self->document_blacklist = _tmp19_;
	_tmp20_ = g_strdup ("");
	_g_free0 (self->burn_blacklist);
	self->burn_blacklist = _tmp20_;
	_tmp21_ = g_strdup ("");
	_g_free0 (self->tasks_blacklist);
	self->tasks_blacklist = _tmp21_;
	_tmp22_ = g_get_user_config_dir ();
	_tmp23_ = g_build_filename (_tmp22_, "lxsession-default-apps", "settings.conf", NULL);
	_g_free0 (self->priv->config_path);
	self->priv->config_path = _tmp23_;
	_tmp24_ = g_key_file_new ();
	_g_key_file_free0 (self->priv->kf);
	self->priv->kf = _tmp24_;
	_tmp25_ = self->priv->config_path;
	g_message ("desktop-files-backend.vala:171: test config_path: %s", _tmp25_);
	{
		GKeyFile* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		_tmp26_ = self->priv->kf;
		_tmp27_ = self->priv->config_path;
		g_key_file_load_from_file (_tmp26_, _tmp27_, G_KEY_FILE_NONE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError* err = NULL;
		GError* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp28_ = err;
		_tmp29_ = _tmp28_->message;
		g_warning ("desktop-files-backend.vala:179: %s", _tmp29_);
		_g_error_free0 (err);
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* err = NULL;
		GError* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = err;
		_tmp31_ = _tmp30_->message;
		g_warning ("desktop-files-backend.vala:183: %s", _tmp31_);
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void lxsession_db_default_apps_on_finish_scanning_installed (LxsessionDBDefaultApps* self) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mode;
	g_message ("desktop-files-backend.vala:189: Signal finish scanning installed with " \
"mode: %s", _tmp0_);
	_tmp1_ = self->priv->mode;
	if (g_strcmp0 (_tmp1_, "display") == 0) {
		lxsession_db_default_apps_print_values_installed (self);
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = self->priv->mode;
		if (g_strcmp0 (_tmp2_, "write") == 0) {
			lxsession_db_default_apps_save_values_installed (self);
		}
	}
	self->state_installed = TRUE;
	_tmp3_ = self->state_available;
	if (_tmp3_ == TRUE) {
		g_signal_emit_by_name (self, "exit-now");
	}
}


void lxsession_db_default_apps_on_finish_scanning_available (LxsessionDBDefaultApps* self) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mode;
	g_message ("desktop-files-backend.vala:209: Signal finish scanning available with " \
"mode: %s", _tmp0_);
	_tmp1_ = self->priv->mode;
	if (g_strcmp0 (_tmp1_, "display") == 0) {
		LxsessionDBDefaultApps* _tmp2_ = NULL;
		_tmp2_ = lxsession_global_db;
		lxsession_db_default_apps_print_values_available (_tmp2_);
	} else {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = self->priv->mode;
		if (g_strcmp0 (_tmp3_, "write") == 0) {
			LxsessionDBDefaultApps* _tmp4_ = NULL;
			_tmp4_ = lxsession_global_db;
			lxsession_db_default_apps_save_values_available (_tmp4_);
		}
	}
	self->state_available = TRUE;
	_tmp5_ = self->state_installed;
	if (_tmp5_ == TRUE) {
		g_signal_emit_by_name (self, "exit-now");
	}
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void lxsession_db_default_apps_update_installed (LxsessionDBDefaultApps* self) {
	gchar** default_install = NULL;
	gint default_install_length1 = 0;
	gint _default_install_size_ = 0;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	g_return_if_fail (self != NULL);
	default_install = NULL;
	default_install_length1 = 0;
	_default_install_size_ = default_install_length1;
	_tmp0_ = self->priv->MimeFoldersInstalledGet;
	_tmp0__length1 = self->priv->MimeFoldersInstalledGet_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	default_install = (_vala_array_free (default_install, default_install_length1, (GDestroyNotify) g_free), NULL);
	default_install = _tmp1_;
	default_install_length1 = _tmp1__length1;
	_default_install_size_ = default_install_length1;
	_tmp2_ = default_install;
	_tmp2__length1 = default_install_length1;
	if (_tmp2_ != NULL) {
		gchar** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		_tmp3_ = default_install;
		_tmp3__length1 = default_install_length1;
		{
			gchar** folder_collection = NULL;
			gint folder_collection_length1 = 0;
			gint _folder_collection_size_ = 0;
			gint folder_it = 0;
			folder_collection = _tmp3_;
			folder_collection_length1 = _tmp3__length1;
			for (folder_it = 0; folder_it < _tmp3__length1; folder_it = folder_it + 1) {
				gchar* _tmp4_ = NULL;
				gchar* folder = NULL;
				_tmp4_ = g_strdup (folder_collection[folder_it]);
				folder = _tmp4_;
				{
					const gchar* _tmp5_ = NULL;
					const gchar* _tmp6_ = NULL;
					_tmp5_ = folder;
					g_message ("desktop-files-backend.vala:237: Scanning folder: %s", _tmp5_);
					_tmp6_ = folder;
					lxsession_db_default_apps_list_desktop_files (self, _tmp6_, "installed", NULL, NULL);
					_g_free0 (folder);
				}
			}
		}
	} else {
		g_message ("desktop-files-backend.vala:243: No folders installed set. Abort");
	}
	default_install = (_vala_array_free (default_install, default_install_length1, (GDestroyNotify) g_free), NULL);
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void lxsession_db_default_apps_update_available (LxsessionDBDefaultApps* self) {
	gchar** default_available = NULL;
	gint default_available_length1 = 0;
	gint _default_available_size_ = 0;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	g_return_if_fail (self != NULL);
	default_available = NULL;
	default_available_length1 = 0;
	_default_available_size_ = default_available_length1;
	_tmp0_ = self->priv->MimeFoldersAvailableGet;
	_tmp0__length1 = self->priv->MimeFoldersAvailableGet_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup2 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	default_available = (_vala_array_free (default_available, default_available_length1, (GDestroyNotify) g_free), NULL);
	default_available = _tmp1_;
	default_available_length1 = _tmp1__length1;
	_default_available_size_ = default_available_length1;
	_tmp2_ = default_available;
	_tmp2__length1 = default_available_length1;
	if (_tmp2_ != NULL) {
		gchar** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		_tmp3_ = default_available;
		_tmp3__length1 = default_available_length1;
		{
			gchar** folder_collection = NULL;
			gint folder_collection_length1 = 0;
			gint _folder_collection_size_ = 0;
			gint folder_it = 0;
			folder_collection = _tmp3_;
			folder_collection_length1 = _tmp3__length1;
			for (folder_it = 0; folder_it < _tmp3__length1; folder_it = folder_it + 1) {
				gchar* _tmp4_ = NULL;
				gchar* folder = NULL;
				_tmp4_ = g_strdup (folder_collection[folder_it]);
				folder = _tmp4_;
				{
					GFile* dir_log = NULL;
					const gchar* _tmp5_ = NULL;
					GFile* _tmp6_ = NULL;
					GFile* _tmp7_ = NULL;
					gboolean _tmp8_ = FALSE;
					_tmp5_ = folder;
					_tmp6_ = g_file_new_for_path (_tmp5_);
					dir_log = _tmp6_;
					_tmp7_ = dir_log;
					_tmp8_ = g_file_query_exists (_tmp7_, NULL);
					if (_tmp8_) {
						const gchar* _tmp9_ = NULL;
						const gchar* _tmp10_ = NULL;
						_tmp9_ = folder;
						g_message ("desktop-files-backend.vala:260: Scanning folder: %s", _tmp9_);
						_tmp10_ = folder;
						lxsession_db_default_apps_list_desktop_files (self, _tmp10_, "available", NULL, NULL);
					} else {
						const gchar* _tmp11_ = NULL;
						_tmp11_ = folder;
						g_message ("desktop-files-backend.vala:265: %s doesn't exist. Pass", _tmp11_);
						g_signal_emit_by_name (self, "finish-scanning-available");
					}
					_g_object_unref0 (dir_log);
					_g_free0 (folder);
				}
			}
		}
	} else {
		g_message ("desktop-files-backend.vala:272: No folders available set. Abort");
	}
	default_available = (_vala_array_free (default_available, default_available_length1, (GDestroyNotify) g_free), NULL);
}


static void _lxsession_db_default_apps_on_finish_scanning_installed_lxsession_db_default_apps_finish_scanning_installed (LxsessionDBDefaultApps* _sender, gpointer self) {
	lxsession_db_default_apps_on_finish_scanning_installed ((LxsessionDBDefaultApps*) self);
}


static void _lxsession_db_default_apps_on_finish_scanning_available_lxsession_db_default_apps_finish_scanning_available (LxsessionDBDefaultApps* _sender, gpointer self) {
	lxsession_db_default_apps_on_finish_scanning_available ((LxsessionDBDefaultApps*) self);
}


void lxsession_db_default_apps_update (LxsessionDBDefaultApps* self) {
	g_return_if_fail (self != NULL);
	g_signal_connect_object (self, "finish-scanning-installed", (GCallback) _lxsession_db_default_apps_on_finish_scanning_installed_lxsession_db_default_apps_finish_scanning_installed, self, 0);
	g_signal_connect_object (self, "finish-scanning-available", (GCallback) _lxsession_db_default_apps_on_finish_scanning_available_lxsession_db_default_apps_finish_scanning_available, self, 0);
	lxsession_db_default_apps_update_installed (self);
	lxsession_db_default_apps_update_available (self);
}


static void lxsession_db_default_apps_list_desktop_files_data_free (gpointer _data) {
	LxsessionDbDefaultAppsListDesktopFilesData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_free0 (_data_->mode);
	_g_object_unref0 (_data_->self);
	g_slice_free (LxsessionDbDefaultAppsListDesktopFilesData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void lxsession_db_default_apps_list_desktop_files (LxsessionDBDefaultApps* self, const gchar* path, const gchar* mode, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LxsessionDbDefaultAppsListDesktopFilesData* _data_;
	LxsessionDBDefaultApps* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	_data_ = g_slice_new0 (LxsessionDbDefaultAppsListDesktopFilesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, lxsession_db_default_apps_list_desktop_files);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, lxsession_db_default_apps_list_desktop_files_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = path;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->path);
	_data_->path = _tmp2_;
	_tmp3_ = mode;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->mode);
	_data_->mode = _tmp4_;
	lxsession_db_default_apps_list_desktop_files_co (_data_);
}


static void lxsession_db_default_apps_list_desktop_files_finish (LxsessionDBDefaultApps* self, GAsyncResult* _res_) {
	LxsessionDbDefaultAppsListDesktopFilesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void lxsession_db_default_apps_list_desktop_files_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	LxsessionDbDefaultAppsListDesktopFilesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	lxsession_db_default_apps_list_desktop_files_co (_data_);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean lxsession_db_default_apps_list_desktop_files_co (LxsessionDbDefaultAppsListDesktopFilesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_message ("desktop-files-backend.vala:287: Start scanning\n");
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->path;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_file_new_for_path (_data_->_tmp0_);
	_data_->dir = _data_->_tmp1_;
	{
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = g_key_file_new ();
		_data_->kf = _data_->_tmp2_;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->dir;
		_data_->_state_ = 1;
		g_file_enumerate_children_async (_data_->_tmp3_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, G_PRIORITY_DEFAULT, NULL, lxsession_db_default_apps_list_desktop_files_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = g_file_enumerate_children_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
		_data_->e = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_key_file_free0 (_data_->kf);
			goto __catch2_g_error;
		}
		while (TRUE) {
			_data_->_tmp5_ = NULL;
			_data_->_tmp5_ = _data_->e;
			_data_->_state_ = 2;
			g_file_enumerator_next_files_async (_data_->_tmp5_, 10, G_PRIORITY_DEFAULT, NULL, lxsession_db_default_apps_list_desktop_files_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = g_file_enumerator_next_files_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
			_data_->files = _data_->_tmp6_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_object_unref0 (_data_->e);
				_g_key_file_free0 (_data_->kf);
				goto __catch2_g_error;
			}
			_data_->_tmp7_ = NULL;
			_data_->_tmp7_ = _data_->files;
			if (_data_->_tmp7_ == NULL) {
				__g_list_free__g_object_unref0_0 (_data_->files);
				break;
			}
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = _data_->files;
			{
				_data_->info_collection = _data_->_tmp8_;
				for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
					_data_->_tmp9_ = NULL;
					_data_->_tmp9_ = _g_object_ref0 ((GFileInfo*) _data_->info_it->data);
					_data_->info = _data_->_tmp9_;
					{
						{
							_data_->_tmp10_ = NULL;
							_data_->_tmp10_ = _data_->path;
							_data_->_tmp11_ = NULL;
							_data_->_tmp11_ = _data_->info;
							_data_->_tmp12_ = NULL;
							_data_->_tmp12_ = g_file_info_get_name (_data_->_tmp11_);
							_data_->_tmp13_ = NULL;
							_data_->_tmp13_ = g_build_filename (_data_->_tmp10_, _data_->_tmp12_, NULL);
							_data_->desktop_path = _data_->_tmp13_;
							_data_->_tmp14_ = NULL;
							_data_->_tmp14_ = _data_->kf;
							_data_->_tmp15_ = NULL;
							_data_->_tmp15_ = _data_->desktop_path;
							g_key_file_load_from_file (_data_->_tmp14_, _data_->_tmp15_, G_KEY_FILE_NONE, &_data_->_inner_error_);
							if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
								_g_free0 (_data_->desktop_path);
								if (_data_->_inner_error_->domain == G_KEY_FILE_ERROR) {
									goto __catch3_g_key_file_error;
								}
								if (_data_->_inner_error_->domain == G_FILE_ERROR) {
									goto __catch3_g_file_error;
								}
								_g_free0 (_data_->desktop_path);
								_g_object_unref0 (_data_->info);
								__g_list_free__g_object_unref0_0 (_data_->files);
								_g_object_unref0 (_data_->e);
								_g_key_file_free0 (_data_->kf);
								_g_object_unref0 (_data_->dir);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
								g_clear_error (&_data_->_inner_error_);
								return FALSE;
							}
							_data_->_tmp17_ = NULL;
							_data_->_tmp17_ = _data_->kf;
							_data_->_tmp18_ = FALSE;
							_data_->_tmp18_ = g_key_file_has_key (_data_->_tmp17_, "Desktop Entry", "Categories", &_data_->_inner_error_);
							_data_->_tmp16_ = _data_->_tmp18_;
							if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
								_g_free0 (_data_->desktop_path);
								if (_data_->_inner_error_->domain == G_KEY_FILE_ERROR) {
									goto __catch3_g_key_file_error;
								}
								if (_data_->_inner_error_->domain == G_FILE_ERROR) {
									goto __catch3_g_file_error;
								}
								_g_free0 (_data_->desktop_path);
								_g_object_unref0 (_data_->info);
								__g_list_free__g_object_unref0_0 (_data_->files);
								_g_object_unref0 (_data_->e);
								_g_key_file_free0 (_data_->kf);
								_g_object_unref0 (_data_->dir);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
								g_clear_error (&_data_->_inner_error_);
								return FALSE;
							}
							if (_data_->_tmp16_ == TRUE) {
								_data_->_tmp19_ = NULL;
								_data_->_tmp19_ = _data_->kf;
								_data_->_tmp20_ = NULL;
								_data_->_tmp20_ = _data_->desktop_path;
								_data_->_tmp21_ = NULL;
								_data_->_tmp21_ = _data_->info;
								_data_->_tmp22_ = NULL;
								_data_->_tmp22_ = g_file_info_get_name (_data_->_tmp21_);
								_data_->_tmp23_ = NULL;
								_data_->_tmp23_ = _data_->mode;
								lxsession_db_default_apps_find_list (_data_->self, _data_->_tmp19_, _data_->_tmp20_, _data_->_tmp22_, _data_->_tmp23_);
							}
							_g_free0 (_data_->desktop_path);
						}
						goto __finally3;
						__catch3_g_key_file_error:
						{
							_data_->err = _data_->_inner_error_;
							_data_->_inner_error_ = NULL;
							_g_error_free0 (_data_->err);
						}
						goto __finally3;
						__catch3_g_file_error:
						{
							_data_->_vala1_err = _data_->_inner_error_;
							_data_->_inner_error_ = NULL;
							_data_->_tmp24_ = NULL;
							_data_->_tmp24_ = _data_->_vala1_err;
							_data_->_tmp25_ = NULL;
							_data_->_tmp25_ = _data_->_tmp24_->message;
							g_warning ("desktop-files-backend.vala:323: %s", _data_->_tmp25_);
							_g_error_free0 (_data_->_vala1_err);
						}
						__finally3:
						if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
							_g_object_unref0 (_data_->info);
							__g_list_free__g_object_unref0_0 (_data_->files);
							_g_object_unref0 (_data_->e);
							_g_key_file_free0 (_data_->kf);
							goto __catch2_g_error;
						}
						_g_object_unref0 (_data_->info);
					}
				}
			}
			__g_list_free__g_object_unref0_0 (_data_->files);
		}
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _data_->mode;
		if (g_strcmp0 (_data_->_tmp26_, "installed") == 0) {
			g_signal_emit_by_name (_data_->self, "finish-scanning-installed");
		} else {
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = _data_->mode;
			if (g_strcmp0 (_data_->_tmp27_, "available") == 0) {
				g_signal_emit_by_name (_data_->self, "finish-scanning-available");
			}
		}
		_g_object_unref0 (_data_->e);
		_g_key_file_free0 (_data_->kf);
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->_vala2_err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = stderr;
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = _data_->_vala2_err;
		_data_->_tmp30_ = NULL;
		_data_->_tmp30_ = _data_->_tmp29_->message;
		fprintf (_data_->_tmp28_, "Error: list_files failed: %s\n", _data_->_tmp30_);
		_g_error_free0 (_data_->_vala2_err);
	}
	__finally2:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	g_message ("desktop-files-backend.vala:342: Finishing scanning\n");
	_g_object_unref0 (_data_->dir);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


gchar* lxsession_db_default_apps_create_entry (LxsessionDBDefaultApps* self, GKeyFile* kf, const gchar* desktop_path) {
	gchar* result = NULL;
	gchar* entry = NULL;
	gchar* _tmp0_ = NULL;
	gchar* tmp_name = NULL;
	gchar* _tmp1_ = NULL;
	gchar* tmp_icon = NULL;
	gchar* _tmp2_ = NULL;
	gchar* tmp_install_package = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	GKeyFile* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (kf != NULL, NULL);
	g_return_val_if_fail (desktop_path != NULL, NULL);
	_tmp0_ = g_strdup ("");
	entry = _tmp0_;
	_tmp1_ = g_strdup ("");
	tmp_name = _tmp1_;
	_tmp2_ = g_strdup ("");
	tmp_icon = _tmp2_;
	_tmp3_ = g_strdup ("");
	tmp_install_package = _tmp3_;
	{
		gchar* _tmp4_ = NULL;
		GKeyFile* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp5_ = kf;
		_tmp6_ = g_key_file_get_locale_string (_tmp5_, "Desktop Entry", "Name", NULL, &_inner_error_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch4_g_key_file_error;
			}
			_g_free0 (tmp_install_package);
			_g_free0 (tmp_icon);
			_g_free0 (tmp_name);
			_g_free0 (entry);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_g_free0 (tmp_name);
		tmp_name = _tmp7_;
		_g_free0 (_tmp4_);
	}
	goto __finally4;
	__catch4_g_key_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (tmp_install_package);
		_g_free0 (tmp_icon);
		_g_free0 (tmp_name);
		_g_free0 (entry);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		gchar* _tmp8_ = NULL;
		GKeyFile* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp9_ = kf;
		_tmp10_ = g_key_file_get_value (_tmp9_, "Desktop Entry", "Icon", &_inner_error_);
		_tmp8_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch5_g_key_file_error;
			}
			_g_free0 (tmp_install_package);
			_g_free0 (tmp_icon);
			_g_free0 (tmp_name);
			_g_free0 (entry);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp11_ = _tmp8_;
		_tmp8_ = NULL;
		_g_free0 (tmp_icon);
		tmp_icon = _tmp11_;
		_g_free0 (_tmp8_);
	}
	goto __finally5;
	__catch5_g_key_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (tmp_install_package);
		_g_free0 (tmp_icon);
		_g_free0 (tmp_name);
		_g_free0 (entry);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		gchar* _tmp12_ = NULL;
		GKeyFile* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp13_ = kf;
		_tmp14_ = g_key_file_get_value (_tmp13_, "Desktop Entry", "X-AppInstall-Package", &_inner_error_);
		_tmp12_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch6_g_key_file_error;
			}
			_g_free0 (tmp_install_package);
			_g_free0 (tmp_icon);
			_g_free0 (tmp_name);
			_g_free0 (entry);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp12_;
		_tmp12_ = NULL;
		_g_free0 (tmp_install_package);
		tmp_install_package = _tmp15_;
		_g_free0 (_tmp12_);
	}
	goto __finally6;
	__catch6_g_key_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (tmp_install_package);
		_g_free0 (tmp_icon);
		_g_free0 (tmp_name);
		_g_free0 (entry);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp16_ = tmp_name;
	_tmp17_ = g_strconcat (_tmp16_, ",", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = kf;
	_tmp20_ = lxsession_db_default_apps_create_exec_string (self, _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp18_, _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp23_, ",", NULL);
	_tmp25_ = _tmp24_;
	_tmp26_ = tmp_icon;
	_tmp27_ = g_strconcat (_tmp25_, _tmp26_, NULL);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strconcat (_tmp28_, ",", NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = desktop_path;
	_tmp32_ = g_strconcat (_tmp30_, _tmp31_, NULL);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strconcat (_tmp33_, ",", NULL);
	_tmp35_ = _tmp34_;
	_tmp36_ = tmp_install_package;
	_tmp37_ = g_strconcat (_tmp35_, _tmp36_, NULL);
	_g_free0 (entry);
	entry = _tmp37_;
	_g_free0 (_tmp35_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp18_);
	result = entry;
	_g_free0 (tmp_install_package);
	_g_free0 (tmp_icon);
	_g_free0 (tmp_name);
	return result;
}


gchar* lxsession_db_default_apps_create_exec_string (LxsessionDBDefaultApps* self, GKeyFile* kf) {
	gchar* result = NULL;
	gchar* tmp_string = NULL;
	gchar* _tmp0_ = NULL;
	gchar** tmp_value = NULL;
	const gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint tmp_value_length1 = 0;
	gint _tmp_value_size_ = 0;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (kf != NULL, NULL);
	_tmp0_ = g_strdup ("");
	tmp_string = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		GKeyFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp2_ = kf;
		_tmp3_ = g_key_file_get_value (_tmp2_, "Desktop Entry", "Exec", &_inner_error_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch7_g_key_file_error;
			}
			_g_free0 (tmp_string);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		_g_free0 (tmp_string);
		tmp_string = _tmp4_;
		_g_free0 (_tmp1_);
	}
	goto __finally7;
	__catch7_g_key_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (tmp_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp5_ = tmp_string;
	_tmp7_ = _tmp6_ = g_strsplit_set (_tmp5_, " ", 0);
	tmp_value = _tmp7_;
	tmp_value_length1 = _vala_array_length (_tmp6_);
	_tmp_value_size_ = tmp_value_length1;
	_tmp8_ = tmp_value[0];
	_tmp9_ = g_strdup (_tmp8_);
	result = _tmp9_;
	tmp_value = (_vala_array_free (tmp_value, tmp_value_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (tmp_string);
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


void lxsession_db_default_apps_find_list (LxsessionDBDefaultApps* self, GKeyFile* kf, const gchar* desktop_path, const gchar* name, const gchar* mode) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (kf != NULL);
	g_return_if_fail (desktop_path != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (mode != NULL);
	{
		gchar* categories = NULL;
		GKeyFile* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		_tmp0_ = kf;
		_tmp1_ = g_key_file_get_value (_tmp0_, "Desktop Entry", "Categories", &_inner_error_);
		categories = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch8_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		if (categories != NULL) {
			gboolean _tmp2_ = FALSE;
			gboolean _tmp15_ = FALSE;
			gboolean _tmp28_ = FALSE;
			gboolean _tmp41_ = FALSE;
			gboolean _tmp54_ = FALSE;
			gboolean _tmp67_ = FALSE;
			gboolean _tmp80_ = FALSE;
			gboolean _tmp93_ = FALSE;
			gboolean _tmp106_ = FALSE;
			gboolean _tmp119_ = FALSE;
			gboolean _tmp132_ = FALSE;
			gboolean _tmp145_ = FALSE;
			gboolean _tmp188_ = FALSE;
			gboolean _tmp205_ = FALSE;
			gboolean _tmp218_ = FALSE;
			gboolean _tmp231_ = FALSE;
			gboolean _tmp244_ = FALSE;
			gboolean _tmp257_ = FALSE;
			gboolean _tmp270_ = FALSE;
			gboolean _tmp283_ = FALSE;
			_tmp2_ = string_contains (categories, "WebBrowser");
			if (_tmp2_) {
				const gchar* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				_tmp3_ = self->webbrowser_installed_blacklist;
				_tmp4_ = name;
				_tmp5_ = string_contains (_tmp3_, _tmp4_);
				if (_tmp5_) {
				} else {
					gchar* new_entry = NULL;
					GKeyFile* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					gchar* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					_tmp6_ = kf;
					_tmp7_ = desktop_path;
					_tmp8_ = lxsession_db_default_apps_create_entry (self, _tmp6_, _tmp7_);
					new_entry = _tmp8_;
					_tmp9_ = mode;
					if (g_strcmp0 (_tmp9_, "installed") == 0) {
						const gchar* _tmp10_ = NULL;
						gchar* _tmp11_ = NULL;
						_tmp10_ = new_entry;
						_tmp11_ = g_strdup (_tmp10_);
						self->webbrowser_installed = g_list_append (self->webbrowser_installed, _tmp11_);
					} else {
						const gchar* _tmp12_ = NULL;
						_tmp12_ = mode;
						if (g_strcmp0 (_tmp12_, "available") == 0) {
							const gchar* _tmp13_ = NULL;
							gchar* _tmp14_ = NULL;
							_tmp13_ = new_entry;
							_tmp14_ = g_strdup (_tmp13_);
							self->webbrowser_available = g_list_append (self->webbrowser_available, _tmp14_);
						}
					}
					_g_free0 (new_entry);
				}
			}
			_tmp15_ = string_contains (categories, "Email");
			if (_tmp15_) {
				const gchar* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				gboolean _tmp18_ = FALSE;
				_tmp16_ = self->email_installed_blacklist;
				_tmp17_ = name;
				_tmp18_ = string_contains (_tmp16_, _tmp17_);
				if (_tmp18_) {
				} else {
					gchar* new_entry = NULL;
					GKeyFile* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					_tmp19_ = kf;
					_tmp20_ = desktop_path;
					_tmp21_ = lxsession_db_default_apps_create_entry (self, _tmp19_, _tmp20_);
					new_entry = _tmp21_;
					_tmp22_ = mode;
					if (g_strcmp0 (_tmp22_, "installed") == 0) {
						const gchar* _tmp23_ = NULL;
						gchar* _tmp24_ = NULL;
						_tmp23_ = new_entry;
						_tmp24_ = g_strdup (_tmp23_);
						self->email_installed = g_list_append (self->email_installed, _tmp24_);
					} else {
						const gchar* _tmp25_ = NULL;
						_tmp25_ = mode;
						if (g_strcmp0 (_tmp25_, "available") == 0) {
							const gchar* _tmp26_ = NULL;
							gchar* _tmp27_ = NULL;
							_tmp26_ = new_entry;
							_tmp27_ = g_strdup (_tmp26_);
							self->email_available = g_list_append (self->email_available, _tmp27_);
						}
					}
					_g_free0 (new_entry);
				}
			}
			_tmp28_ = string_contains (categories, "FileManager");
			if (_tmp28_) {
				const gchar* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				gboolean _tmp31_ = FALSE;
				_tmp29_ = self->file_manager_blacklist;
				_tmp30_ = name;
				_tmp31_ = string_contains (_tmp29_, _tmp30_);
				if (_tmp31_) {
				} else {
					gchar* new_entry = NULL;
					GKeyFile* _tmp32_ = NULL;
					const gchar* _tmp33_ = NULL;
					gchar* _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					_tmp32_ = kf;
					_tmp33_ = desktop_path;
					_tmp34_ = lxsession_db_default_apps_create_entry (self, _tmp32_, _tmp33_);
					new_entry = _tmp34_;
					_tmp35_ = mode;
					if (g_strcmp0 (_tmp35_, "installed") == 0) {
						const gchar* _tmp36_ = NULL;
						gchar* _tmp37_ = NULL;
						_tmp36_ = new_entry;
						_tmp37_ = g_strdup (_tmp36_);
						self->file_manager_installed = g_list_append (self->file_manager_installed, _tmp37_);
					} else {
						const gchar* _tmp38_ = NULL;
						_tmp38_ = mode;
						if (g_strcmp0 (_tmp38_, "available") == 0) {
							const gchar* _tmp39_ = NULL;
							gchar* _tmp40_ = NULL;
							_tmp39_ = new_entry;
							_tmp40_ = g_strdup (_tmp39_);
							self->file_manager_available = g_list_append (self->file_manager_available, _tmp40_);
						}
					}
					_g_free0 (new_entry);
				}
			}
			_tmp41_ = string_contains (categories, "Screensaver");
			if (_tmp41_) {
				const gchar* _tmp42_ = NULL;
				const gchar* _tmp43_ = NULL;
				gboolean _tmp44_ = FALSE;
				_tmp42_ = self->screensaver_blacklist;
				_tmp43_ = name;
				_tmp44_ = string_contains (_tmp42_, _tmp43_);
				if (_tmp44_) {
				} else {
					gchar* new_entry = NULL;
					GKeyFile* _tmp45_ = NULL;
					const gchar* _tmp46_ = NULL;
					gchar* _tmp47_ = NULL;
					const gchar* _tmp48_ = NULL;
					_tmp45_ = kf;
					_tmp46_ = desktop_path;
					_tmp47_ = lxsession_db_default_apps_create_entry (self, _tmp45_, _tmp46_);
					new_entry = _tmp47_;
					_tmp48_ = mode;
					if (g_strcmp0 (_tmp48_, "installed") == 0) {
						const gchar* _tmp49_ = NULL;
						gchar* _tmp50_ = NULL;
						_tmp49_ = new_entry;
						_tmp50_ = g_strdup (_tmp49_);
						self->screensaver_installed = g_list_append (self->screensaver_installed, _tmp50_);
					} else {
						const gchar* _tmp51_ = NULL;
						_tmp51_ = mode;
						if (g_strcmp0 (_tmp51_, "available") == 0) {
							const gchar* _tmp52_ = NULL;
							gchar* _tmp53_ = NULL;
							_tmp52_ = new_entry;
							_tmp53_ = g_strdup (_tmp52_);
							self->screensaver_available = g_list_append (self->screensaver_available, _tmp53_);
						}
					}
					_g_free0 (new_entry);
				}
			}
			_tmp54_ = string_contains (categories, "Composite");
			if (_tmp54_) {
				const gchar* _tmp55_ = NULL;
				const gchar* _tmp56_ = NULL;
				gboolean _tmp57_ = FALSE;
				_tmp55_ = self->composite_manager_blacklist;
				_tmp56_ = name;
				_tmp57_ = string_contains (_tmp55_, _tmp56_);
				if (_tmp57_) {
				} else {
					gchar* new_entry = NULL;
					GKeyFile* _tmp58_ = NULL;
					const gchar* _tmp59_ = NULL;
					gchar* _tmp60_ = NULL;
					const gchar* _tmp61_ = NULL;
					_tmp58_ = kf;
					_tmp59_ = desktop_path;
					_tmp60_ = lxsession_db_default_apps_create_entry (self, _tmp58_, _tmp59_);
					new_entry = _tmp60_;
					_tmp61_ = mode;
					if (g_strcmp0 (_tmp61_, "installed") == 0) {
						const gchar* _tmp62_ = NULL;
						gchar* _tmp63_ = NULL;
						_tmp62_ = new_entry;
						_tmp63_ = g_strdup (_tmp62_);
						self->composite_manager_installed = g_list_append (self->composite_manager_installed, _tmp63_);
					} else {
						const gchar* _tmp64_ = NULL;
						_tmp64_ = mode;
						if (g_strcmp0 (_tmp64_, "available") == 0) {
							const gchar* _tmp65_ = NULL;
							gchar* _tmp66_ = NULL;
							_tmp65_ = new_entry;
							_tmp66_ = g_strdup (_tmp65_);
							self->composite_manager_available = g_list_append (self->composite_manager_available, _tmp66_);
						}
					}
					_g_free0 (new_entry);
				}
			}
			_tmp67_ = string_contains (categories, "Desktop");
			if (_tmp67_) {
				const gchar* _tmp68_ = NULL;
				const gchar* _tmp69_ = NULL;
				gboolean _tmp70_ = FALSE;
				_tmp68_ = self->desktop_manager_blacklist;
				_tmp69_ = name;
				_tmp70_ = string_contains (_tmp68_, _tmp69_);
				if (_tmp70_) {
				} else {
					gchar* new_entry = NULL;
					GKeyFile* _tmp71_ = NULL;
					const gchar* _tmp72_ = NULL;
					gchar* _tmp73_ = NULL;
					const gchar* _tmp74_ = NULL;
					_tmp71_ = kf;
					_tmp72_ = desktop_path;
					_tmp73_ = lxsession_db_default_apps_create_entry (self, _tmp71_, _tmp72_);
					new_entry = _tmp73_;
					_tmp74_ = mode;
					if (g_strcmp0 (_tmp74_, "installed") == 0) {
						const gchar* _tmp75_ = NULL;
						gchar* _tmp76_ = NULL;
						_tmp75_ = new_entry;
						_tmp76_ = g_strdup (_tmp75_);
						self->desktop_manager_installed = g_list_append (self->desktop_manager_installed, _tmp76_);
					} else {
						const gchar* _tmp77_ = NULL;
						_tmp77_ = mode;
						if (g_strcmp0 (_tmp77_, "available") == 0) {
							const gchar* _tmp78_ = NULL;
							gchar* _tmp79_ = NULL;
							_tmp78_ = new_entry;
							_tmp79_ = g_strdup (_tmp78_);
							self->desktop_manager_available = g_list_append (self->desktop_manager_available, _tmp79_);
						}
					}
					_g_free0 (new_entry);
				}
			}
			_tmp80_ = string_contains (categories, "Power");
			if (_tmp80_) {
				const gchar* _tmp81_ = NULL;
				const gchar* _tmp82_ = NULL;
				gboolean _tmp83_ = FALSE;
				_tmp81_ = self->power_manager_blacklist;
				_tmp82_ = name;
				_tmp83_ = string_contains (_tmp81_, _tmp82_);
				if (_tmp83_) {
				} else {
					gchar* new_entry = NULL;
					GKeyFile* _tmp84_ = NULL;
					const gchar* _tmp85_ = NULL;
					gchar* _tmp86_ = NULL;
					const gchar* _tmp87_ = NULL;
					_tmp84_ = kf;
					_tmp85_ = desktop_path;
					_tmp86_ = lxsession_db_default_apps_create_entry (self, _tmp84_, _tmp85_);
					new_entry = _tmp86_;
					_tmp87_ = mode;
					if (g_strcmp0 (_tmp87_, "installed") == 0) {
						const gchar* _tmp88_ = NULL;
						gchar* _tmp89_ = NULL;
						_tmp88_ = new_entry;
						_tmp89_ = g_strdup (_tmp88_);
						self->power_manager_installed = g_list_append (self->power_manager_installed, _tmp89_);
					} else {
						const gchar* _tmp90_ = NULL;
						_tmp90_ = mode;
						if (g_strcmp0 (_tmp90_, "available") == 0) {
							const gchar* _tmp91_ = NULL;
							gchar* _tmp92_ = NULL;
							_tmp91_ = new_entry;
							_tmp92_ = g_strdup (_tmp91_);
							self->power_manager_available = g_list_append (self->power_manager_available, _tmp92_);
						}
					}
					_g_free0 (new_entry);
				}
			}
			_tmp93_ = string_contains (categories, "Polkit");
			if (_tmp93_) {
				const gchar* _tmp94_ = NULL;
				const gchar* _tmp95_ = NULL;
				gboolean _tmp96_ = FALSE;
				_tmp94_ = self->polkit_blacklist;
				_tmp95_ = name;
				_tmp96_ = string_contains (_tmp94_, _tmp95_);
				if (_tmp96_) {
				} else {
					gchar* new_entry = NULL;
					GKeyFile* _tmp97_ = NULL;
					const gchar* _tmp98_ = NULL;
					gchar* _tmp99_ = NULL;
					const gchar* _tmp100_ = NULL;
					_tmp97_ = kf;
					_tmp98_ = desktop_path;
					_tmp99_ = lxsession_db_default_apps_create_entry (self, _tmp97_, _tmp98_);
					new_entry = _tmp99_;
					_tmp100_ = mode;
					if (g_strcmp0 (_tmp100_, "installed") == 0) {
						const gchar* _tmp101_ = NULL;
						gchar* _tmp102_ = NULL;
						_tmp101_ = new_entry;
						_tmp102_ = g_strdup (_tmp101_);
						self->polkit_installed = g_list_append (self->polkit_installed, _tmp102_);
					} else {
						const gchar* _tmp103_ = NULL;
						_tmp103_ = mode;
						if (g_strcmp0 (_tmp103_, "available") == 0) {
							const gchar* _tmp104_ = NULL;
							gchar* _tmp105_ = NULL;
							_tmp104_ = new_entry;
							_tmp105_ = g_strdup (_tmp104_);
							self->polkit_available = g_list_append (self->polkit_available, _tmp105_);
						}
					}
					_g_free0 (new_entry);
				}
			}
			_tmp106_ = string_contains (categories, "InstantMessaging");
			if (_tmp106_) {
				const gchar* _tmp107_ = NULL;
				const gchar* _tmp108_ = NULL;
				gboolean _tmp109_ = FALSE;
				_tmp107_ = self->im_blacklist;
				_tmp108_ = name;
				_tmp109_ = string_contains (_tmp107_, _tmp108_);
				if (_tmp109_) {
				} else {
					gchar* new_entry = NULL;
					GKeyFile* _tmp110_ = NULL;
					const gchar* _tmp111_ = NULL;
					gchar* _tmp112_ = NULL;
					const gchar* _tmp113_ = NULL;
					_tmp110_ = kf;
					_tmp111_ = desktop_path;
					_tmp112_ = lxsession_db_default_apps_create_entry (self, _tmp110_, _tmp111_);
					new_entry = _tmp112_;
					_tmp113_ = mode;
					if (g_strcmp0 (_tmp113_, "installed") == 0) {
						const gchar* _tmp114_ = NULL;
						gchar* _tmp115_ = NULL;
						_tmp114_ = new_entry;
						_tmp115_ = g_strdup (_tmp114_);
						self->im_installed = g_list_append (self->im_installed, _tmp115_);
					} else {
						const gchar* _tmp116_ = NULL;
						_tmp116_ = mode;
						if (g_strcmp0 (_tmp116_, "available") == 0) {
							const gchar* _tmp117_ = NULL;
							gchar* _tmp118_ = NULL;
							_tmp117_ = new_entry;
							_tmp118_ = g_strdup (_tmp117_);
							self->im_available = g_list_append (self->im_available, _tmp118_);
						}
					}
					_g_free0 (new_entry);
				}
			}
			_tmp119_ = string_contains (categories, "Widget");
			if (_tmp119_) {
				const gchar* _tmp120_ = NULL;
				const gchar* _tmp121_ = NULL;
				gboolean _tmp122_ = FALSE;
				_tmp120_ = self->widget_blacklist;
				_tmp121_ = name;
				_tmp122_ = string_contains (_tmp120_, _tmp121_);
				if (_tmp122_) {
				} else {
					gchar* new_entry = NULL;
					GKeyFile* _tmp123_ = NULL;
					const gchar* _tmp124_ = NULL;
					gchar* _tmp125_ = NULL;
					const gchar* _tmp126_ = NULL;
					_tmp123_ = kf;
					_tmp124_ = desktop_path;
					_tmp125_ = lxsession_db_default_apps_create_entry (self, _tmp123_, _tmp124_);
					new_entry = _tmp125_;
					_tmp126_ = mode;
					if (g_strcmp0 (_tmp126_, "installed") == 0) {
						const gchar* _tmp127_ = NULL;
						gchar* _tmp128_ = NULL;
						_tmp127_ = new_entry;
						_tmp128_ = g_strdup (_tmp127_);
						self->widget_installed = g_list_append (self->widget_installed, _tmp128_);
					} else {
						const gchar* _tmp129_ = NULL;
						_tmp129_ = mode;
						if (g_strcmp0 (_tmp129_, "available") == 0) {
							const gchar* _tmp130_ = NULL;
							gchar* _tmp131_ = NULL;
							_tmp130_ = new_entry;
							_tmp131_ = g_strdup (_tmp130_);
							self->widget_available = g_list_append (self->widget_available, _tmp131_);
						}
					}
					_g_free0 (new_entry);
				}
			}
			_tmp132_ = string_contains (categories, "Terminal");
			if (_tmp132_) {
				const gchar* _tmp133_ = NULL;
				const gchar* _tmp134_ = NULL;
				gboolean _tmp135_ = FALSE;
				_tmp133_ = self->terminal_manager_blacklist;
				_tmp134_ = name;
				_tmp135_ = string_contains (_tmp133_, _tmp134_);
				if (_tmp135_) {
				} else {
					gchar* new_entry = NULL;
					GKeyFile* _tmp136_ = NULL;
					const gchar* _tmp137_ = NULL;
					gchar* _tmp138_ = NULL;
					const gchar* _tmp139_ = NULL;
					_tmp136_ = kf;
					_tmp137_ = desktop_path;
					_tmp138_ = lxsession_db_default_apps_create_entry (self, _tmp136_, _tmp137_);
					new_entry = _tmp138_;
					_tmp139_ = mode;
					if (g_strcmp0 (_tmp139_, "installed") == 0) {
						const gchar* _tmp140_ = NULL;
						gchar* _tmp141_ = NULL;
						_tmp140_ = new_entry;
						_tmp141_ = g_strdup (_tmp140_);
						self->terminal_manager_installed = g_list_append (self->terminal_manager_installed, _tmp141_);
					} else {
						const gchar* _tmp142_ = NULL;
						_tmp142_ = mode;
						if (g_strcmp0 (_tmp142_, "available") == 0) {
							const gchar* _tmp143_ = NULL;
							gchar* _tmp144_ = NULL;
							_tmp143_ = new_entry;
							_tmp144_ = g_strdup (_tmp143_);
							self->terminal_manager_available = g_list_append (self->terminal_manager_available, _tmp144_);
						}
					}
					_g_free0 (new_entry);
				}
			}
			_tmp145_ = string_contains (categories, "AudioVideo");
			if (_tmp145_) {
				const gchar* _tmp146_ = NULL;
				const gchar* _tmp147_ = NULL;
				gboolean _tmp148_ = FALSE;
				_tmp146_ = self->audio_video_blacklist;
				_tmp147_ = name;
				_tmp148_ = string_contains (_tmp146_, _tmp147_);
				if (_tmp148_) {
				} else {
					gchar* new_entry = NULL;
					GKeyFile* _tmp149_ = NULL;
					const gchar* _tmp150_ = NULL;
					gchar* _tmp151_ = NULL;
					const gchar* _tmp152_ = NULL;
					_tmp149_ = kf;
					_tmp150_ = desktop_path;
					_tmp151_ = lxsession_db_default_apps_create_entry (self, _tmp149_, _tmp150_);
					new_entry = _tmp151_;
					_tmp152_ = mode;
					if (g_strcmp0 (_tmp152_, "installed") == 0) {
						const gchar* _tmp153_ = NULL;
						gchar* _tmp154_ = NULL;
						const gchar* _tmp155_ = NULL;
						gchar* _tmp156_ = NULL;
						_tmp153_ = new_entry;
						_tmp154_ = g_strdup (_tmp153_);
						self->audio_installed = g_list_append (self->audio_installed, _tmp154_);
						_tmp155_ = new_entry;
						_tmp156_ = g_strdup (_tmp155_);
						self->video_installed = g_list_append (self->video_installed, _tmp156_);
					} else {
						const gchar* _tmp157_ = NULL;
						_tmp157_ = mode;
						if (g_strcmp0 (_tmp157_, "available") == 0) {
							const gchar* _tmp158_ = NULL;
							gchar* _tmp159_ = NULL;
							const gchar* _tmp160_ = NULL;
							gchar* _tmp161_ = NULL;
							_tmp158_ = new_entry;
							_tmp159_ = g_strdup (_tmp158_);
							self->audio_installed = g_list_append (self->audio_installed, _tmp159_);
							_tmp160_ = new_entry;
							_tmp161_ = g_strdup (_tmp160_);
							self->video_available = g_list_append (self->video_available, _tmp161_);
						}
					}
					_g_free0 (new_entry);
				}
			} else {
				gboolean _tmp162_ = FALSE;
				_tmp162_ = string_contains (categories, "Audio");
				if (_tmp162_) {
					const gchar* _tmp163_ = NULL;
					const gchar* _tmp164_ = NULL;
					gboolean _tmp165_ = FALSE;
					_tmp163_ = self->audio_blacklist;
					_tmp164_ = name;
					_tmp165_ = string_contains (_tmp163_, _tmp164_);
					if (_tmp165_) {
					} else {
						gchar* new_entry = NULL;
						GKeyFile* _tmp166_ = NULL;
						const gchar* _tmp167_ = NULL;
						gchar* _tmp168_ = NULL;
						const gchar* _tmp169_ = NULL;
						_tmp166_ = kf;
						_tmp167_ = desktop_path;
						_tmp168_ = lxsession_db_default_apps_create_entry (self, _tmp166_, _tmp167_);
						new_entry = _tmp168_;
						_tmp169_ = mode;
						if (g_strcmp0 (_tmp169_, "installed") == 0) {
							const gchar* _tmp170_ = NULL;
							gchar* _tmp171_ = NULL;
							_tmp170_ = new_entry;
							_tmp171_ = g_strdup (_tmp170_);
							self->audio_installed = g_list_append (self->audio_installed, _tmp171_);
						} else {
							const gchar* _tmp172_ = NULL;
							_tmp172_ = mode;
							if (g_strcmp0 (_tmp172_, "available") == 0) {
								const gchar* _tmp173_ = NULL;
								gchar* _tmp174_ = NULL;
								_tmp173_ = new_entry;
								_tmp174_ = g_strdup (_tmp173_);
								self->audio_available = g_list_append (self->audio_available, _tmp174_);
							}
						}
						_g_free0 (new_entry);
					}
				} else {
					gboolean _tmp175_ = FALSE;
					_tmp175_ = string_contains (categories, "Video");
					if (_tmp175_) {
						const gchar* _tmp176_ = NULL;
						const gchar* _tmp177_ = NULL;
						gboolean _tmp178_ = FALSE;
						_tmp176_ = self->video_blacklist;
						_tmp177_ = name;
						_tmp178_ = string_contains (_tmp176_, _tmp177_);
						if (_tmp178_) {
						} else {
							gchar* new_entry = NULL;
							GKeyFile* _tmp179_ = NULL;
							const gchar* _tmp180_ = NULL;
							gchar* _tmp181_ = NULL;
							const gchar* _tmp182_ = NULL;
							_tmp179_ = kf;
							_tmp180_ = desktop_path;
							_tmp181_ = lxsession_db_default_apps_create_entry (self, _tmp179_, _tmp180_);
							new_entry = _tmp181_;
							_tmp182_ = mode;
							if (g_strcmp0 (_tmp182_, "installed") == 0) {
								const gchar* _tmp183_ = NULL;
								gchar* _tmp184_ = NULL;
								_tmp183_ = new_entry;
								_tmp184_ = g_strdup (_tmp183_);
								self->video_installed = g_list_append (self->video_installed, _tmp184_);
							} else {
								const gchar* _tmp185_ = NULL;
								_tmp185_ = mode;
								if (g_strcmp0 (_tmp185_, "available") == 0) {
									const gchar* _tmp186_ = NULL;
									gchar* _tmp187_ = NULL;
									_tmp186_ = new_entry;
									_tmp187_ = g_strdup (_tmp186_);
									self->video_available = g_list_append (self->video_available, _tmp187_);
								}
							}
							_g_free0 (new_entry);
						}
					}
				}
			}
			_tmp188_ = string_contains (categories, "Viewer");
			if (_tmp188_) {
				const gchar* _tmp189_ = NULL;
				const gchar* _tmp190_ = NULL;
				gboolean _tmp191_ = FALSE;
				_tmp189_ = self->viewer_blacklist;
				_tmp190_ = name;
				_tmp191_ = string_contains (_tmp189_, _tmp190_);
				if (_tmp191_) {
				} else {
					gchar* new_entry = NULL;
					GKeyFile* _tmp192_ = NULL;
					const gchar* _tmp193_ = NULL;
					gchar* _tmp194_ = NULL;
					const gchar* _tmp195_ = NULL;
					_tmp192_ = kf;
					_tmp193_ = desktop_path;
					_tmp194_ = lxsession_db_default_apps_create_entry (self, _tmp192_, _tmp193_);
					new_entry = _tmp194_;
					_tmp195_ = mode;
					if (g_strcmp0 (_tmp195_, "installed") == 0) {
						const gchar* _tmp196_ = NULL;
						gchar* _tmp197_ = NULL;
						const gchar* _tmp198_ = NULL;
						gchar* _tmp199_ = NULL;
						_tmp196_ = new_entry;
						_tmp197_ = g_strdup (_tmp196_);
						self->image_display_installed = g_list_append (self->image_display_installed, _tmp197_);
						_tmp198_ = new_entry;
						_tmp199_ = g_strdup (_tmp198_);
						self->pdf_reader_installed = g_list_append (self->pdf_reader_installed, _tmp199_);
					} else {
						const gchar* _tmp200_ = NULL;
						_tmp200_ = mode;
						if (g_strcmp0 (_tmp200_, "available") == 0) {
							const gchar* _tmp201_ = NULL;
							gchar* _tmp202_ = NULL;
							const gchar* _tmp203_ = NULL;
							gchar* _tmp204_ = NULL;
							_tmp201_ = new_entry;
							_tmp202_ = g_strdup (_tmp201_);
							self->image_display_available = g_list_append (self->image_display_available, _tmp202_);
							_tmp203_ = new_entry;
							_tmp204_ = g_strdup (_tmp203_);
							self->pdf_reader_available = g_list_append (self->pdf_reader_available, _tmp204_);
						}
					}
					_g_free0 (new_entry);
				}
			}
			_tmp205_ = string_contains (categories, "TextEditor");
			if (_tmp205_) {
				const gchar* _tmp206_ = NULL;
				const gchar* _tmp207_ = NULL;
				gboolean _tmp208_ = FALSE;
				_tmp206_ = self->text_editor_blacklist;
				_tmp207_ = name;
				_tmp208_ = string_contains (_tmp206_, _tmp207_);
				if (_tmp208_) {
				} else {
					gchar* new_entry = NULL;
					GKeyFile* _tmp209_ = NULL;
					const gchar* _tmp210_ = NULL;
					gchar* _tmp211_ = NULL;
					const gchar* _tmp212_ = NULL;
					_tmp209_ = kf;
					_tmp210_ = desktop_path;
					_tmp211_ = lxsession_db_default_apps_create_entry (self, _tmp209_, _tmp210_);
					new_entry = _tmp211_;
					_tmp212_ = mode;
					if (g_strcmp0 (_tmp212_, "installed") == 0) {
						const gchar* _tmp213_ = NULL;
						gchar* _tmp214_ = NULL;
						_tmp213_ = new_entry;
						_tmp214_ = g_strdup (_tmp213_);
						self->text_editor_installed = g_list_append (self->text_editor_installed, _tmp214_);
					} else {
						const gchar* _tmp215_ = NULL;
						_tmp215_ = mode;
						if (g_strcmp0 (_tmp215_, "available") == 0) {
							const gchar* _tmp216_ = NULL;
							gchar* _tmp217_ = NULL;
							_tmp216_ = new_entry;
							_tmp217_ = g_strdup (_tmp216_);
							self->text_editor_available = g_list_append (self->text_editor_available, _tmp217_);
						}
					}
					_g_free0 (new_entry);
				}
			}
			_tmp218_ = string_contains (categories, "Archiving");
			if (_tmp218_) {
				const gchar* _tmp219_ = NULL;
				const gchar* _tmp220_ = NULL;
				gboolean _tmp221_ = FALSE;
				_tmp219_ = self->archive_blacklist;
				_tmp220_ = name;
				_tmp221_ = string_contains (_tmp219_, _tmp220_);
				if (_tmp221_) {
				} else {
					gchar* new_entry = NULL;
					GKeyFile* _tmp222_ = NULL;
					const gchar* _tmp223_ = NULL;
					gchar* _tmp224_ = NULL;
					const gchar* _tmp225_ = NULL;
					_tmp222_ = kf;
					_tmp223_ = desktop_path;
					_tmp224_ = lxsession_db_default_apps_create_entry (self, _tmp222_, _tmp223_);
					new_entry = _tmp224_;
					_tmp225_ = mode;
					if (g_strcmp0 (_tmp225_, "installed") == 0) {
						const gchar* _tmp226_ = NULL;
						gchar* _tmp227_ = NULL;
						_tmp226_ = new_entry;
						_tmp227_ = g_strdup (_tmp226_);
						self->archive_installed = g_list_append (self->archive_installed, _tmp227_);
					} else {
						const gchar* _tmp228_ = NULL;
						_tmp228_ = mode;
						if (g_strcmp0 (_tmp228_, "available") == 0) {
							const gchar* _tmp229_ = NULL;
							gchar* _tmp230_ = NULL;
							_tmp229_ = new_entry;
							_tmp230_ = g_strdup (_tmp229_);
							self->archive_available = g_list_append (self->archive_available, _tmp230_);
						}
					}
					_g_free0 (new_entry);
				}
			}
			_tmp231_ = string_contains (categories, "Spreadsheet");
			if (_tmp231_) {
				const gchar* _tmp232_ = NULL;
				const gchar* _tmp233_ = NULL;
				gboolean _tmp234_ = FALSE;
				_tmp232_ = self->spreadsheet_blacklist;
				_tmp233_ = name;
				_tmp234_ = string_contains (_tmp232_, _tmp233_);
				if (_tmp234_) {
				} else {
					gchar* new_entry = NULL;
					GKeyFile* _tmp235_ = NULL;
					const gchar* _tmp236_ = NULL;
					gchar* _tmp237_ = NULL;
					const gchar* _tmp238_ = NULL;
					_tmp235_ = kf;
					_tmp236_ = desktop_path;
					_tmp237_ = lxsession_db_default_apps_create_entry (self, _tmp235_, _tmp236_);
					new_entry = _tmp237_;
					_tmp238_ = mode;
					if (g_strcmp0 (_tmp238_, "installed") == 0) {
						const gchar* _tmp239_ = NULL;
						gchar* _tmp240_ = NULL;
						_tmp239_ = new_entry;
						_tmp240_ = g_strdup (_tmp239_);
						self->spreadsheet_installed = g_list_append (self->spreadsheet_installed, _tmp240_);
					} else {
						const gchar* _tmp241_ = NULL;
						_tmp241_ = mode;
						if (g_strcmp0 (_tmp241_, "available") == 0) {
							const gchar* _tmp242_ = NULL;
							gchar* _tmp243_ = NULL;
							_tmp242_ = new_entry;
							_tmp243_ = g_strdup (_tmp242_);
							self->spreadsheet_available = g_list_append (self->spreadsheet_available, _tmp243_);
						}
					}
					_g_free0 (new_entry);
				}
			}
			_tmp244_ = string_contains (categories, "P2P");
			if (_tmp244_) {
				const gchar* _tmp245_ = NULL;
				const gchar* _tmp246_ = NULL;
				gboolean _tmp247_ = FALSE;
				_tmp245_ = self->bittorent_blacklist;
				_tmp246_ = name;
				_tmp247_ = string_contains (_tmp245_, _tmp246_);
				if (_tmp247_) {
				} else {
					gchar* new_entry = NULL;
					GKeyFile* _tmp248_ = NULL;
					const gchar* _tmp249_ = NULL;
					gchar* _tmp250_ = NULL;
					const gchar* _tmp251_ = NULL;
					_tmp248_ = kf;
					_tmp249_ = desktop_path;
					_tmp250_ = lxsession_db_default_apps_create_entry (self, _tmp248_, _tmp249_);
					new_entry = _tmp250_;
					_tmp251_ = mode;
					if (g_strcmp0 (_tmp251_, "installed") == 0) {
						const gchar* _tmp252_ = NULL;
						gchar* _tmp253_ = NULL;
						_tmp252_ = new_entry;
						_tmp253_ = g_strdup (_tmp252_);
						self->bittorent_installed = g_list_append (self->bittorent_installed, _tmp253_);
					} else {
						const gchar* _tmp254_ = NULL;
						_tmp254_ = mode;
						if (g_strcmp0 (_tmp254_, "available") == 0) {
							const gchar* _tmp255_ = NULL;
							gchar* _tmp256_ = NULL;
							_tmp255_ = new_entry;
							_tmp256_ = g_strdup (_tmp255_);
							self->bittorent_available = g_list_append (self->bittorent_available, _tmp256_);
						}
					}
					_g_free0 (new_entry);
				}
			}
			_tmp257_ = string_contains (categories, "WordProcessor");
			if (_tmp257_) {
				const gchar* _tmp258_ = NULL;
				const gchar* _tmp259_ = NULL;
				gboolean _tmp260_ = FALSE;
				_tmp258_ = self->document_blacklist;
				_tmp259_ = name;
				_tmp260_ = string_contains (_tmp258_, _tmp259_);
				if (_tmp260_) {
				} else {
					gchar* new_entry = NULL;
					GKeyFile* _tmp261_ = NULL;
					const gchar* _tmp262_ = NULL;
					gchar* _tmp263_ = NULL;
					const gchar* _tmp264_ = NULL;
					_tmp261_ = kf;
					_tmp262_ = desktop_path;
					_tmp263_ = lxsession_db_default_apps_create_entry (self, _tmp261_, _tmp262_);
					new_entry = _tmp263_;
					_tmp264_ = mode;
					if (g_strcmp0 (_tmp264_, "installed") == 0) {
						const gchar* _tmp265_ = NULL;
						gchar* _tmp266_ = NULL;
						_tmp265_ = new_entry;
						_tmp266_ = g_strdup (_tmp265_);
						self->document_installed = g_list_append (self->document_installed, _tmp266_);
					} else {
						const gchar* _tmp267_ = NULL;
						_tmp267_ = mode;
						if (g_strcmp0 (_tmp267_, "available") == 0) {
							const gchar* _tmp268_ = NULL;
							gchar* _tmp269_ = NULL;
							_tmp268_ = new_entry;
							_tmp269_ = g_strdup (_tmp268_);
							self->document_available = g_list_append (self->document_available, _tmp269_);
						}
					}
					_g_free0 (new_entry);
				}
			}
			_tmp270_ = string_contains (categories, "DiscBurning");
			if (_tmp270_) {
				const gchar* _tmp271_ = NULL;
				const gchar* _tmp272_ = NULL;
				gboolean _tmp273_ = FALSE;
				_tmp271_ = self->burn_blacklist;
				_tmp272_ = name;
				_tmp273_ = string_contains (_tmp271_, _tmp272_);
				if (_tmp273_) {
				} else {
					gchar* new_entry = NULL;
					GKeyFile* _tmp274_ = NULL;
					const gchar* _tmp275_ = NULL;
					gchar* _tmp276_ = NULL;
					const gchar* _tmp277_ = NULL;
					_tmp274_ = kf;
					_tmp275_ = desktop_path;
					_tmp276_ = lxsession_db_default_apps_create_entry (self, _tmp274_, _tmp275_);
					new_entry = _tmp276_;
					_tmp277_ = mode;
					if (g_strcmp0 (_tmp277_, "installed") == 0) {
						const gchar* _tmp278_ = NULL;
						gchar* _tmp279_ = NULL;
						_tmp278_ = new_entry;
						_tmp279_ = g_strdup (_tmp278_);
						self->burn_installed = g_list_append (self->burn_installed, _tmp279_);
					} else {
						const gchar* _tmp280_ = NULL;
						_tmp280_ = mode;
						if (g_strcmp0 (_tmp280_, "available") == 0) {
							const gchar* _tmp281_ = NULL;
							gchar* _tmp282_ = NULL;
							_tmp281_ = new_entry;
							_tmp282_ = g_strdup (_tmp281_);
							self->burn_available = g_list_append (self->burn_available, _tmp282_);
						}
					}
					_g_free0 (new_entry);
				}
			}
			_tmp283_ = string_contains (categories, "Monitor");
			if (_tmp283_) {
				const gchar* _tmp284_ = NULL;
				const gchar* _tmp285_ = NULL;
				gboolean _tmp286_ = FALSE;
				_tmp284_ = self->tasks_blacklist;
				_tmp285_ = name;
				_tmp286_ = string_contains (_tmp284_, _tmp285_);
				if (_tmp286_) {
				} else {
					gchar* new_entry = NULL;
					GKeyFile* _tmp287_ = NULL;
					const gchar* _tmp288_ = NULL;
					gchar* _tmp289_ = NULL;
					const gchar* _tmp290_ = NULL;
					_tmp287_ = kf;
					_tmp288_ = desktop_path;
					_tmp289_ = lxsession_db_default_apps_create_entry (self, _tmp287_, _tmp288_);
					new_entry = _tmp289_;
					_tmp290_ = mode;
					if (g_strcmp0 (_tmp290_, "installed") == 0) {
						const gchar* _tmp291_ = NULL;
						gchar* _tmp292_ = NULL;
						_tmp291_ = new_entry;
						_tmp292_ = g_strdup (_tmp291_);
						self->tasks_installed = g_list_append (self->tasks_installed, _tmp292_);
					} else {
						const gchar* _tmp293_ = NULL;
						_tmp293_ = mode;
						if (g_strcmp0 (_tmp293_, "available") == 0) {
							const gchar* _tmp294_ = NULL;
							gchar* _tmp295_ = NULL;
							_tmp294_ = new_entry;
							_tmp295_ = g_strdup (_tmp294_);
							self->tasks_available = g_list_append (self->tasks_available, _tmp295_);
						}
					}
					_g_free0 (new_entry);
				}
			}
		}
		_g_free0 (categories);
	}
	goto __finally8;
	__catch8_g_key_file_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void lxsession_db_default_apps_print_values_available (LxsessionDBDefaultApps* self) {
	GList* _tmp0_ = NULL;
	GList* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_message ("desktop-files-backend.vala:863: Printing available webbrowser");
	_tmp0_ = self->webbrowser_available;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp0_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			gchar* _tmp1_ = NULL;
			gchar* entry = NULL;
			_tmp1_ = g_strdup ((const gchar*) entry_it->data);
			entry = _tmp1_;
			{
				const gchar* _tmp2_ = NULL;
				_tmp2_ = entry;
				g_message ("desktop-files-backend.vala:866: %s", _tmp2_);
				_g_free0 (entry);
			}
		}
	}
	g_message ("desktop-files-backend.vala:869: Printing available email");
	_tmp3_ = self->email_available;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp3_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			gchar* _tmp4_ = NULL;
			gchar* entry = NULL;
			_tmp4_ = g_strdup ((const gchar*) entry_it->data);
			entry = _tmp4_;
			{
				const gchar* _tmp5_ = NULL;
				_tmp5_ = entry;
				g_message ("desktop-files-backend.vala:872: %s", _tmp5_);
				_g_free0 (entry);
			}
		}
	}
}


void lxsession_db_default_apps_print_values_installed (LxsessionDBDefaultApps* self) {
	GList* _tmp0_ = NULL;
	GList* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_message ("desktop-files-backend.vala:878: Printing installed webbrowser");
	_tmp0_ = self->webbrowser_installed;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp0_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			gchar* _tmp1_ = NULL;
			gchar* entry = NULL;
			_tmp1_ = g_strdup ((const gchar*) entry_it->data);
			entry = _tmp1_;
			{
				const gchar* _tmp2_ = NULL;
				_tmp2_ = entry;
				g_message ("desktop-files-backend.vala:881: %s", _tmp2_);
				_g_free0 (entry);
			}
		}
	}
	g_message ("desktop-files-backend.vala:884: Printing installed email");
	_tmp3_ = self->email_installed;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp3_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			gchar* _tmp4_ = NULL;
			gchar* entry = NULL;
			_tmp4_ = g_strdup ((const gchar*) entry_it->data);
			entry = _tmp4_;
			{
				const gchar* _tmp5_ = NULL;
				_tmp5_ = entry;
				g_message ("desktop-files-backend.vala:887: %s", _tmp5_);
				_g_free0 (entry);
			}
		}
	}
}


void lxsession_db_default_apps_save_values_installed (LxsessionDBDefaultApps* self) {
	GKeyFile* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GKeyFile* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GKeyFile* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GKeyFile* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	GKeyFile* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	GKeyFile* _tmp10_ = NULL;
	GList* _tmp11_ = NULL;
	GKeyFile* _tmp12_ = NULL;
	GList* _tmp13_ = NULL;
	GKeyFile* _tmp14_ = NULL;
	GList* _tmp15_ = NULL;
	GKeyFile* _tmp16_ = NULL;
	GList* _tmp17_ = NULL;
	GKeyFile* _tmp18_ = NULL;
	GList* _tmp19_ = NULL;
	GKeyFile* _tmp20_ = NULL;
	GList* _tmp21_ = NULL;
	GKeyFile* _tmp22_ = NULL;
	GList* _tmp23_ = NULL;
	GKeyFile* _tmp24_ = NULL;
	GList* _tmp25_ = NULL;
	GKeyFile* _tmp26_ = NULL;
	GList* _tmp27_ = NULL;
	GKeyFile* _tmp28_ = NULL;
	GList* _tmp29_ = NULL;
	GKeyFile* _tmp30_ = NULL;
	GList* _tmp31_ = NULL;
	GKeyFile* _tmp32_ = NULL;
	GList* _tmp33_ = NULL;
	GKeyFile* _tmp34_ = NULL;
	GList* _tmp35_ = NULL;
	GKeyFile* _tmp36_ = NULL;
	GList* _tmp37_ = NULL;
	GKeyFile* _tmp38_ = NULL;
	GList* _tmp39_ = NULL;
	GKeyFile* _tmp40_ = NULL;
	GList* _tmp41_ = NULL;
	GKeyFile* _tmp42_ = NULL;
	GList* _tmp43_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->kf;
	_tmp1_ = self->webbrowser_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp0_, "Mime", "webbrowser/installed", _tmp1_);
	_tmp2_ = self->priv->kf;
	_tmp3_ = self->email_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp2_, "Mime", "email/installed", _tmp3_);
	_tmp4_ = self->priv->kf;
	_tmp5_ = self->file_manager_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp4_, "Mime", "file_manager/installed", _tmp5_);
	_tmp6_ = self->priv->kf;
	_tmp7_ = self->screensaver_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp6_, "Mime", "screensaver/installed", _tmp7_);
	_tmp8_ = self->priv->kf;
	_tmp9_ = self->composite_manager_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp8_, "Mime", "composite_manager/installed", _tmp9_);
	_tmp10_ = self->priv->kf;
	_tmp11_ = self->desktop_manager_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp10_, "Mime", "desktop_manager/installed", _tmp11_);
	_tmp12_ = self->priv->kf;
	_tmp13_ = self->power_manager_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp12_, "Mime", "power_manager/installed", _tmp13_);
	_tmp14_ = self->priv->kf;
	_tmp15_ = self->polkit_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp14_, "Mime", "polkit/installed", _tmp15_);
	_tmp16_ = self->priv->kf;
	_tmp17_ = self->im_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp16_, "Mime", "im/installed", _tmp17_);
	_tmp18_ = self->priv->kf;
	_tmp19_ = self->widget_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp18_, "Mime", "widget/installed", _tmp19_);
	_tmp20_ = self->priv->kf;
	_tmp21_ = self->terminal_manager_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp20_, "Mime", "terminal_manager/installed", _tmp21_);
	_tmp22_ = self->priv->kf;
	_tmp23_ = self->audio_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp22_, "Mime", "audio_player/installed", _tmp23_);
	_tmp24_ = self->priv->kf;
	_tmp25_ = self->video_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp24_, "Mime", "video_player/installed", _tmp25_);
	_tmp26_ = self->priv->kf;
	_tmp27_ = self->pdf_reader_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp26_, "Mime", "pdf_reader/installed", _tmp27_);
	_tmp28_ = self->priv->kf;
	_tmp29_ = self->image_display_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp28_, "Mime", "image_display/installed", _tmp29_);
	_tmp30_ = self->priv->kf;
	_tmp31_ = self->text_editor_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp30_, "Mime", "text_editor/installed", _tmp31_);
	_tmp32_ = self->priv->kf;
	_tmp33_ = self->archive_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp32_, "Mime", "archive/installed", _tmp33_);
	_tmp34_ = self->priv->kf;
	_tmp35_ = self->spreadsheet_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp34_, "Mime", "spreadsheet/installed", _tmp35_);
	_tmp36_ = self->priv->kf;
	_tmp37_ = self->bittorent_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp36_, "Mime", "bittorent/installed", _tmp37_);
	_tmp38_ = self->priv->kf;
	_tmp39_ = self->document_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp38_, "Mime", "document/installed", _tmp39_);
	_tmp40_ = self->priv->kf;
	_tmp41_ = self->burn_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp40_, "Mime", "burn/installed", _tmp41_);
	_tmp42_ = self->priv->kf;
	_tmp43_ = self->tasks_installed;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp42_, "Mime", "tasks/installed", _tmp43_);
	lxsession_db_default_apps_save_keyfile (self);
}


void lxsession_db_default_apps_save_values_available (LxsessionDBDefaultApps* self) {
	GKeyFile* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GKeyFile* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GKeyFile* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GKeyFile* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	GKeyFile* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	GKeyFile* _tmp10_ = NULL;
	GList* _tmp11_ = NULL;
	GKeyFile* _tmp12_ = NULL;
	GList* _tmp13_ = NULL;
	GKeyFile* _tmp14_ = NULL;
	GList* _tmp15_ = NULL;
	GKeyFile* _tmp16_ = NULL;
	GList* _tmp17_ = NULL;
	GKeyFile* _tmp18_ = NULL;
	GList* _tmp19_ = NULL;
	GKeyFile* _tmp20_ = NULL;
	GList* _tmp21_ = NULL;
	GKeyFile* _tmp22_ = NULL;
	GList* _tmp23_ = NULL;
	GKeyFile* _tmp24_ = NULL;
	GList* _tmp25_ = NULL;
	GKeyFile* _tmp26_ = NULL;
	GList* _tmp27_ = NULL;
	GKeyFile* _tmp28_ = NULL;
	GList* _tmp29_ = NULL;
	GKeyFile* _tmp30_ = NULL;
	GList* _tmp31_ = NULL;
	GKeyFile* _tmp32_ = NULL;
	GList* _tmp33_ = NULL;
	GKeyFile* _tmp34_ = NULL;
	GList* _tmp35_ = NULL;
	GKeyFile* _tmp36_ = NULL;
	GList* _tmp37_ = NULL;
	GKeyFile* _tmp38_ = NULL;
	GList* _tmp39_ = NULL;
	GKeyFile* _tmp40_ = NULL;
	GList* _tmp41_ = NULL;
	GKeyFile* _tmp42_ = NULL;
	GList* _tmp43_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->kf;
	_tmp1_ = self->webbrowser_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp0_, "Mime", "webbrowser/available", _tmp1_);
	_tmp2_ = self->priv->kf;
	_tmp3_ = self->email_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp2_, "Mime", "email/available", _tmp3_);
	_tmp4_ = self->priv->kf;
	_tmp5_ = self->file_manager_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp4_, "Mime", "file_manager/available", _tmp5_);
	_tmp6_ = self->priv->kf;
	_tmp7_ = self->screensaver_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp6_, "Mime", "screensaver/available", _tmp7_);
	_tmp8_ = self->priv->kf;
	_tmp9_ = self->composite_manager_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp8_, "Mime", "composite_manager/available", _tmp9_);
	_tmp10_ = self->priv->kf;
	_tmp11_ = self->desktop_manager_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp10_, "Mime", "desktop_manager/available", _tmp11_);
	_tmp12_ = self->priv->kf;
	_tmp13_ = self->power_manager_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp12_, "Mime", "power_manager/available", _tmp13_);
	_tmp14_ = self->priv->kf;
	_tmp15_ = self->polkit_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp14_, "Mime", "polkit/available", _tmp15_);
	_tmp16_ = self->priv->kf;
	_tmp17_ = self->im_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp16_, "Mime", "im/available", _tmp17_);
	_tmp18_ = self->priv->kf;
	_tmp19_ = self->widget_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp18_, "Mime", "widget/available", _tmp19_);
	_tmp20_ = self->priv->kf;
	_tmp21_ = self->terminal_manager_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp20_, "Mime", "terminal_manager/available", _tmp21_);
	_tmp22_ = self->priv->kf;
	_tmp23_ = self->audio_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp22_, "Mime", "audio_player/available", _tmp23_);
	_tmp24_ = self->priv->kf;
	_tmp25_ = self->video_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp24_, "Mime", "video_player/available", _tmp25_);
	_tmp26_ = self->priv->kf;
	_tmp27_ = self->pdf_reader_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp26_, "Mime", "pdf_reader/available", _tmp27_);
	_tmp28_ = self->priv->kf;
	_tmp29_ = self->image_display_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp28_, "Mime", "image_display/available", _tmp29_);
	_tmp30_ = self->priv->kf;
	_tmp31_ = self->text_editor_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp30_, "Mime", "text_editor/available", _tmp31_);
	_tmp32_ = self->priv->kf;
	_tmp33_ = self->archive_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp32_, "Mime", "archive/available", _tmp33_);
	_tmp34_ = self->priv->kf;
	_tmp35_ = self->spreadsheet_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp34_, "Mime", "spreadsheet/available", _tmp35_);
	_tmp36_ = self->priv->kf;
	_tmp37_ = self->bittorent_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp36_, "Mime", "bittorent/available", _tmp37_);
	_tmp38_ = self->priv->kf;
	_tmp39_ = self->document_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp38_, "Mime", "document/available", _tmp39_);
	_tmp40_ = self->priv->kf;
	_tmp41_ = self->burn_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp40_, "Mime", "burn/available", _tmp41_);
	_tmp42_ = self->priv->kf;
	_tmp43_ = self->tasks_available;
	lxsession_db_default_apps_keyfile_set_list_string (self, _tmp42_, "Mime", "tasks/available", _tmp43_);
	lxsession_db_default_apps_save_keyfile (self);
}


void lxsession_db_default_apps_save_keyfile (LxsessionDBDefaultApps* self) {
	gchar* str = NULL;
	GKeyFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->kf;
	_tmp1_ = g_key_file_to_data (_tmp0_, NULL, NULL);
	str = _tmp1_;
	{
		const gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		_tmp2_ = self->priv->config_path;
		_tmp3_ = strlen (str);
		_tmp4_ = _tmp3_;
		g_file_set_contents (_tmp2_, str, (gssize) _tmp4_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch9_g_file_error;
			}
			_g_free0 (str);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally9;
	__catch9_g_file_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = err;
		_tmp6_ = _tmp5_->message;
		g_warning ("desktop-files-backend.vala:956: %s", _tmp6_);
		_g_error_free0 (err);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (str);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (str);
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void lxsession_db_default_apps_keyfile_set_list_string (LxsessionDBDefaultApps* self, GKeyFile* kf, const gchar* categorie, const gchar* key1, GList* list) {
	gchar** tmp_array = NULL;
	gchar** _tmp0_ = NULL;
	gint tmp_array_length1 = 0;
	gint _tmp_array_size_ = 0;
	GList* _tmp1_ = NULL;
	GKeyFile* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (kf != NULL);
	g_return_if_fail (categorie != NULL);
	g_return_if_fail (key1 != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	tmp_array = _tmp0_;
	tmp_array_length1 = 0;
	_tmp_array_size_ = tmp_array_length1;
	_tmp1_ = list;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp1_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			gchar* _tmp2_ = NULL;
			gchar* entry = NULL;
			_tmp2_ = g_strdup ((const gchar*) entry_it->data);
			entry = _tmp2_;
			{
				const gchar* _tmp3_ = NULL;
				_tmp3_ = entry;
				if (_tmp3_ != NULL) {
					gchar** _tmp4_ = NULL;
					gint _tmp4__length1 = 0;
					const gchar* _tmp5_ = NULL;
					gchar* _tmp6_ = NULL;
					_tmp4_ = tmp_array;
					_tmp4__length1 = tmp_array_length1;
					_tmp5_ = entry;
					_tmp6_ = g_strdup (_tmp5_);
					_vala_array_add1 (&tmp_array, &tmp_array_length1, &_tmp_array_size_, _tmp6_);
				}
				_g_free0 (entry);
			}
		}
	}
	_tmp7_ = kf;
	_tmp8_ = categorie;
	_tmp9_ = key1;
	_tmp10_ = tmp_array;
	_tmp10__length1 = tmp_array_length1;
	g_key_file_set_string_list (_tmp7_, _tmp8_, _tmp9_, (const gchar* const*) _tmp10_, _tmp10__length1);
	tmp_array = (_vala_array_free (tmp_array, tmp_array_length1, (GDestroyNotify) g_free), NULL);
}


static void lxsession_db_default_apps_class_init (LxsessionDBDefaultAppsClass * klass) {
	lxsession_db_default_apps_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LxsessionDBDefaultAppsPrivate));
	G_OBJECT_CLASS (klass)->finalize = lxsession_db_default_apps_finalize;
	g_signal_new ("finish_scanning_installed", LXSESSION_TYPE_DB_DEFAULT_APPS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("finish_scanning_available", LXSESSION_TYPE_DB_DEFAULT_APPS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("exit_now", LXSESSION_TYPE_DB_DEFAULT_APPS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void lxsession_db_default_apps_instance_init (LxsessionDBDefaultApps * self) {
	gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	self->priv = LXSESSION_DB_DEFAULT_APPS_GET_PRIVATE (self);
	self->webbrowser_installed = NULL;
	self->webbrowser_available = NULL;
	self->email_installed = NULL;
	self->email_available = NULL;
	self->file_manager_installed = NULL;
	self->file_manager_available = NULL;
	self->screensaver_installed = NULL;
	self->screensaver_available = NULL;
	self->composite_manager_installed = NULL;
	self->composite_manager_available = NULL;
	self->desktop_manager_installed = NULL;
	self->desktop_manager_available = NULL;
	self->power_manager_installed = NULL;
	self->power_manager_available = NULL;
	self->polkit_installed = NULL;
	self->polkit_available = NULL;
	self->im_installed = NULL;
	self->im_available = NULL;
	self->widget_installed = NULL;
	self->widget_available = NULL;
	self->terminal_manager_installed = NULL;
	self->terminal_manager_available = NULL;
	self->audio_installed = NULL;
	self->audio_available = NULL;
	self->video_installed = NULL;
	self->video_available = NULL;
	self->image_display_installed = NULL;
	self->pdf_reader_installed = NULL;
	self->image_display_available = NULL;
	self->pdf_reader_available = NULL;
	self->text_editor_installed = NULL;
	self->text_editor_available = NULL;
	self->archive_installed = NULL;
	self->archive_available = NULL;
	self->spreadsheet_installed = NULL;
	self->spreadsheet_available = NULL;
	self->bittorent_installed = NULL;
	self->bittorent_available = NULL;
	self->document_installed = NULL;
	self->document_available = NULL;
	self->burn_installed = NULL;
	self->burn_available = NULL;
	self->tasks_installed = NULL;
	self->tasks_available = NULL;
	self->state_installed = FALSE;
	self->state_available = FALSE;
	_tmp0_ = g_strdup ("/usr/share/applications");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	self->priv->MimeFoldersInstalledGet = _tmp1_;
	self->priv->MimeFoldersInstalledGet_length1 = 1;
	self->priv->_MimeFoldersInstalledGet_size_ = self->priv->MimeFoldersInstalledGet_length1;
	_tmp2_ = g_strdup ("/usr/share/app-install/desktop");
	_tmp3_ = g_new0 (gchar*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	self->priv->MimeFoldersAvailableGet = _tmp3_;
	self->priv->MimeFoldersAvailableGet_length1 = 1;
	self->priv->_MimeFoldersAvailableGet_size_ = self->priv->MimeFoldersAvailableGet_length1;
}


static void lxsession_db_default_apps_finalize (GObject* obj) {
	LxsessionDBDefaultApps * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LXSESSION_TYPE_DB_DEFAULT_APPS, LxsessionDBDefaultApps);
	__g_list_free__g_free0_0 (self->webbrowser_installed);
	__g_list_free__g_free0_0 (self->webbrowser_available);
	_g_free0 (self->webbrowser_installed_blacklist);
	__g_list_free__g_free0_0 (self->email_installed);
	__g_list_free__g_free0_0 (self->email_available);
	_g_free0 (self->email_installed_blacklist);
	__g_list_free__g_free0_0 (self->file_manager_installed);
	__g_list_free__g_free0_0 (self->file_manager_available);
	_g_free0 (self->file_manager_blacklist);
	_g_free0 (self->screensaver_blacklist);
	__g_list_free__g_free0_0 (self->screensaver_installed);
	__g_list_free__g_free0_0 (self->screensaver_available);
	_g_free0 (self->composite_manager_blacklist);
	__g_list_free__g_free0_0 (self->composite_manager_installed);
	__g_list_free__g_free0_0 (self->composite_manager_available);
	_g_free0 (self->desktop_manager_blacklist);
	__g_list_free__g_free0_0 (self->desktop_manager_installed);
	__g_list_free__g_free0_0 (self->desktop_manager_available);
	_g_free0 (self->power_manager_blacklist);
	__g_list_free__g_free0_0 (self->power_manager_installed);
	__g_list_free__g_free0_0 (self->power_manager_available);
	_g_free0 (self->polkit_blacklist);
	__g_list_free__g_free0_0 (self->polkit_installed);
	__g_list_free__g_free0_0 (self->polkit_available);
	_g_free0 (self->im_blacklist);
	__g_list_free__g_free0_0 (self->im_installed);
	__g_list_free__g_free0_0 (self->im_available);
	_g_free0 (self->widget_blacklist);
	__g_list_free__g_free0_0 (self->widget_installed);
	__g_list_free__g_free0_0 (self->widget_available);
	_g_free0 (self->terminal_manager_blacklist);
	__g_list_free__g_free0_0 (self->terminal_manager_installed);
	__g_list_free__g_free0_0 (self->terminal_manager_available);
	_g_free0 (self->audio_blacklist);
	__g_list_free__g_free0_0 (self->audio_installed);
	__g_list_free__g_free0_0 (self->audio_available);
	_g_free0 (self->video_blacklist);
	__g_list_free__g_free0_0 (self->video_installed);
	__g_list_free__g_free0_0 (self->video_available);
	_g_free0 (self->audio_video_blacklist);
	_g_free0 (self->viewer_blacklist);
	__g_list_free__g_free0_0 (self->image_display_installed);
	__g_list_free__g_free0_0 (self->pdf_reader_installed);
	__g_list_free__g_free0_0 (self->image_display_available);
	__g_list_free__g_free0_0 (self->pdf_reader_available);
	_g_free0 (self->text_editor_blacklist);
	__g_list_free__g_free0_0 (self->text_editor_installed);
	__g_list_free__g_free0_0 (self->text_editor_available);
	_g_free0 (self->archive_blacklist);
	__g_list_free__g_free0_0 (self->archive_installed);
	__g_list_free__g_free0_0 (self->archive_available);
	_g_free0 (self->spreadsheet_blacklist);
	__g_list_free__g_free0_0 (self->spreadsheet_installed);
	__g_list_free__g_free0_0 (self->spreadsheet_available);
	_g_free0 (self->bittorent_blacklist);
	__g_list_free__g_free0_0 (self->bittorent_installed);
	__g_list_free__g_free0_0 (self->bittorent_available);
	_g_free0 (self->document_blacklist);
	__g_list_free__g_free0_0 (self->document_installed);
	__g_list_free__g_free0_0 (self->document_available);
	_g_free0 (self->burn_blacklist);
	__g_list_free__g_free0_0 (self->burn_installed);
	__g_list_free__g_free0_0 (self->burn_available);
	_g_free0 (self->tasks_blacklist);
	__g_list_free__g_free0_0 (self->tasks_installed);
	__g_list_free__g_free0_0 (self->tasks_available);
	self->priv->MimeFoldersInstalledGet = (_vala_array_free (self->priv->MimeFoldersInstalledGet, self->priv->MimeFoldersInstalledGet_length1, (GDestroyNotify) g_free), NULL);
	self->priv->MimeFoldersAvailableGet = (_vala_array_free (self->priv->MimeFoldersAvailableGet, self->priv->MimeFoldersAvailableGet_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->mode);
	_g_key_file_free0 (self->priv->kf);
	_g_free0 (self->priv->config_path);
	G_OBJECT_CLASS (lxsession_db_default_apps_parent_class)->finalize (obj);
}


GType lxsession_db_default_apps_get_type (void) {
	static volatile gsize lxsession_db_default_apps_type_id__volatile = 0;
	if (g_once_init_enter (&lxsession_db_default_apps_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LxsessionDBDefaultAppsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lxsession_db_default_apps_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LxsessionDBDefaultApps), 0, (GInstanceInitFunc) lxsession_db_default_apps_instance_init, NULL };
		GType lxsession_db_default_apps_type_id;
		lxsession_db_default_apps_type_id = g_type_register_static (G_TYPE_OBJECT, "LxsessionDBDefaultApps", &g_define_type_info, 0);
		g_once_init_leave (&lxsession_db_default_apps_type_id__volatile, lxsession_db_default_apps_type_id);
	}
	return lxsession_db_default_apps_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



