/*
 * Copyright (C) 2025 UBports Foundation
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License 3 as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 */

import QtQuick 2.12
import Lomiri.Components 1.3

Rectangle {
    id: rootItem

    property Action action
    property bool show: false

    opacity: show ? 1 : 0
    visible: opacity > 0
    height: parent.height * 0.6
    width: height
    radius: width / 2
    color: action.enabled ? theme.palette.normal.foreground : theme.palette.disabled.foreground
    border {
        width: units.dp(1)
        color: action.enabled ? theme.palette.normal.activity : "transparent"
    }

    Behavior on opacity { LomiriNumberAnimation {} }

    Icon {
        anchors.centerIn: parent
        name: rootItem.action.iconName
        height: parent.height * 0.6
        width: height
        color: rootItem.action.enabled ? theme.palette.normal.foregroundText : theme.palette.disabled.foregroundText
    }
}
