/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Yee ole includes (I put this all in one file for my sanity) */
#include "includes.h"

/* a wrapper for gethostbyaddr() for my own sanity      */
char *get_host(char *ip_addr) {
	
#ifdef NO_RESOLVER
	return NULL;
#else
        in_addr_t ad;   /* our network byte order storage spot  */
	
	if(cf.resolv == FALSE) return NULL;
        
	h = NULL;       /* null out our global variable */
        ad = inet_addr(ip_addr); /* crunch input into network byte order        */
        /* see if we can get a hostname on it   */
        h = gethostbyaddr((char *)&ad, sizeof(ad) ,AF_INET);
        /* if we couldn't, return NULL  */
        if(h == NULL) return NULL;
        /* else wise, return the name we got    */
        if(h->h_name != NULL) {
                return (h->h_name);
        }
        /* if we made it this far and didn't return, things are bad; so return now      */
        return NULL;
#endif
}

